/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.headers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import oracle.dbtools.common.headers.HttpHeaderSegmentParser;
import oracle.dbtools.common.headers.HttpHeaderValue;
import oracle.dbtools.common.headers.QualityValue;
import oracle.dbtools.common.util.NullOrEmpty;

public class QualityValuesParser<T> {
    private final QualityValue.Factory<T> factory;

    public QualityValuesParser(QualityValue.Factory<T> factory) {
        this.factory = factory;
    }

    public Iterable<T> ordered(Iterable<String> headerValues) {
        TreeSet<QualityValue<T>> weightings = new TreeSet<QualityValue<T>>();
        if (!NullOrEmpty.nullOrEmpty(headerValues)) {
            for (String text : headerValues) {
                HttpHeaderSegmentParser httpHeaderSegmentParser = new HttpHeaderSegmentParser(text, ",");
                for (String segment : httpHeaderSegmentParser) {
                    HttpHeaderValue value = HttpHeaderValue.parse(segment);
                    Iterator<HttpHeaderValue.HeaderParameter> params = value.parameters().iterator();
                    if (!params.hasNext()) continue;
                    HttpHeaderValue.HeaderParameter param = params.next();
                    String target = param.name().toString();
                    Double quality = 1.0;
                    if (params.hasNext()) {
                        param = params.next();
                        try {
                            quality = Double.valueOf(param.value().toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    T instance = this.factory.apply(target);
                    QualityValue<T> weighting = new QualityValue<T>(instance, quality, weightings.size());
                    weightings.add(weighting);
                }
            }
        }
        ArrayList ordered = new ArrayList();
        for (QualityValue qualityValue : weightings) {
            ordered.add(qualityValue.value);
        }
        return ordered;
    }
}

