/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.IteratorState;
import oracle.dbtools.common.util.Transform;

public class TransformIterator<X, Y>
implements Iterator<Y>,
IteratorState,
Closeable {
    private final Iterator<X> items;
    private int nextCount;
    private final Transform<X, Y> transform;

    public TransformIterator(Iterator<X> items, Transform<X, Y> transform) {
        if (items == null) {
            throw new NullPointerException();
        }
        this.items = items;
        this.transform = transform;
    }

    @Override
    public boolean beforeNext() {
        return this.nextCount == 0;
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.items);
    }

    @Override
    public boolean hasNext() {
        return this.items.hasNext();
    }

    @Override
    public Y next() {
        ++this.nextCount;
        return this.transform.apply(this.items.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.items.toString();
    }
}

