/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ComparatorBase;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.x3p.impl.ForceXMLInputFactory;
import oracle.dbtools.common.x3p.impl.X3PParseException;

public class XMLCompare {
    private final Iterable<XMLEvent> expected;
    private static final Comparator<Attribute> ATTRIBUTE_COMPARATOR = new AttributeComparator();
    private static final Comparator<QName> QNAME_COMPARATOR = new QNameComparator();
    private static final Comparator<String> STRING_COMPARATOR = new ComparatorBase<String>();

    private XMLCompare(Iterable<XMLEvent> expected) {
        this.expected = XMLCompare.canonicalize(expected);
    }

    public XMLDifference compare(Iterable<XMLEvent> xml) {
        Iterator<XMLEvent> expected = this.expected.iterator();
        Iterator<XMLEvent> actual = XMLCompare.canonicalize(xml).iterator();
        while (expected.hasNext()) {
            XMLEvent v1 = expected.next();
            if (!actual.hasNext()) {
                return new XMLDifference(v1, null);
            }
            XMLEvent v2 = actual.next();
            boolean equal = this.compare(v1, v2);
            if (equal) continue;
            return new XMLDifference(v1, v2);
        }
        if (actual.hasNext()) {
            return new XMLDifference(null, actual.next());
        }
        return null;
    }

    private boolean compare(XMLEvent expected, XMLEvent actual) {
        if (expected.getEventType() == actual.getEventType()) {
            if (expected.isStartElement()) {
                StartElement se = expected.asStartElement();
                if (se.getName().equals(actual.asStartElement().getName())) {
                    Iterable<Attribute> actualAttributes;
                    Iterable<Attribute> expectedAttributes = this.attributes(se);
                    int diff = Iterables.compare(expectedAttributes, actualAttributes = this.attributes(actual.asStartElement()), ATTRIBUTE_COMPARATOR);
                    return diff == 0;
                }
            } else {
                if (expected.isEndElement()) {
                    EndElement ee = expected.asEndElement();
                    return ee.getName().equals(actual.asEndElement().getName());
                }
                if (expected.isCharacters()) {
                    Characters ce = expected.asCharacters();
                    return ce.getData().trim().equals(actual.asCharacters().getData().trim());
                }
            }
        }
        return false;
    }

    private Iterable<Attribute> attributes(StartElement element) {
        return Iterables.sort(Iterables.iterable(element.getAttributes()), ATTRIBUTE_COMPARATOR);
    }

    public static XMLDifference compare(String expected, String actual) {
        XMLCompare comparsion = new XMLCompare(XMLCompare.parse(expected));
        return comparsion.compare(XMLCompare.parse(actual));
    }

    private static Iterable<XMLEvent> canonicalize(final Iterable<XMLEvent> events) {
        return new Iterable<XMLEvent>(){

            @Override
            public Iterator<XMLEvent> iterator() {
                InfoSetEventIterator canonicalized = new InfoSetEventIterator(events.iterator());
                return canonicalized;
            }
        };
    }

    private static Iterable<XMLEvent> parse(final String xml) {
        return new Iterable<XMLEvent>(){

            @Override
            public Iterator<XMLEvent> iterator() {
                Iterator events;
                try {
                    events = XMLCompare.read(StreamCopy.toInputStream(xml));
                }
                catch (IOException e) {
                    throw XMLCompare.wrap(e);
                }
                return events;
            }
        };
    }

    private static Iterator<XMLEvent> read(InputStream s) {
        try {
            XMLInputFactory inputFactory = ForceXMLInputFactory.newInstance();
            inputFactory.setXMLResolver(DontResolveExternals.INSTANCE);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            return new XMLEventIterator(inputFactory.createXMLEventReader(s));
        }
        catch (XMLStreamException e) {
            throw XMLCompare.wrap(e);
        }
        catch (FactoryConfigurationError e) {
            throw XMLCompare.wrap(e);
        }
    }

    private static RuntimeException wrap(Throwable t) {
        return new X3PParseException(new TranslatableMessage(t.getMessage()), t);
    }

    private static class XMLEventIterator
    extends AbstractIterator<XMLEvent>
    implements Closeable {
        private boolean empty = false;
        private final XMLEventReader r;

        XMLEventIterator(XMLEventReader r) {
            this.r = r;
        }

        @Override
        public void close() throws IOException {
            try {
                this.r.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }

        @Override
        protected XMLEvent advance() {
            XMLEvent event = null;
            if (!this.empty && this.r.hasNext()) {
                try {
                    event = this.r.nextEvent();
                }
                catch (XMLStreamException e) {
                    Location l = e.getLocation();
                    if (l.getLineNumber() == 1 && l.getColumnNumber() == 1 && e.getMessage().indexOf("Premature end of file") != -1) {
                        this.empty = true;
                        event = null;
                    }
                    throw XMLCompare.wrap(e);
                }
            }
            return event;
        }
    }

    private static final class QNameComparator
    extends ComparatorBase<QName> {
        private QNameComparator() {
            super(true);
        }

        @Override
        protected int manualCompare(QName expected, QName actual) {
            String ens = expected.getNamespaceURI();
            String ans = actual.getNamespaceURI();
            int diff = STRING_COMPARATOR.compare(ens, ans);
            if (diff == 0) {
                String elp = expected.getLocalPart();
                String alp = actual.getLocalPart();
                diff = STRING_COMPARATOR.compare(elp, alp);
            }
            return diff;
        }
    }

    private static class InfoSetEventIterator
    extends M2NIterator<XMLEvent, XMLEvent> {
        protected InfoSetEventIterator(Iterator<XMLEvent> src) {
            super(src);
        }

        @Override
        protected void process(XMLEvent e) {
            e.getEventType();
            if (e.isStartElement() || e.isEndElement() || e.isCharacters() && !this.ignorableWhitespace(e)) {
                this.add(e);
            }
        }

        private boolean ignorableWhitespace(XMLEvent e) {
            Characters chars = e.asCharacters();
            return chars.isIgnorableWhiteSpace() || NullOrEmpty.nullOrEmpty(chars.getData().trim());
        }
    }

    private static class DontResolveExternals
    implements XMLResolver {
        static final DontResolveExternals INSTANCE = new DontResolveExternals();

        private DontResolveExternals() {
        }

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            return StreamCopy.emptyStream();
        }
    }

    private static final class AttributeComparator
    extends ComparatorBase<Attribute> {
        private AttributeComparator() {
            super(true);
        }

        @Override
        protected int manualCompare(Attribute expected, Attribute actual) {
            QName expectedName = expected.getName();
            QName actualName = actual.getName();
            int diff = QNAME_COMPARATOR.compare(expectedName, actualName);
            if (diff == 0) {
                String expectedValue = expected.getValue();
                String actualValue = actual.getValue();
                diff = STRING_COMPARATOR.compare(expectedValue, actualValue);
            }
            return diff;
        }
    }

    public static class XMLDifference {
        private final XMLEvent actual;
        private final XMLEvent expected;

        private XMLDifference(XMLEvent expected, XMLEvent actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public XMLEvent actual() {
            return this.actual;
        }

        public XMLEvent expected() {
            return this.expected;
        }

        public String toString() {
            return "expected: " + this.expected + ", but was: " + this.actual;
        }
    }
}

