/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.io.File;
import java.net.URL;
import javax.ide.util.MetaClass;
import javax.ide.util.MetaResource;
import javax.swing.Icon;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.externaltools.ExternalProgramToolProperties;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.LazyExternalTool;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.externaltools.program.ExternalProgramType;
import oracle.javatools.data.HashStructure;

public class LazyExternalToolType
extends ExternalToolType {
    private HashStructure _hash;
    private ExternalToolType _instance;
    private static final String ID = "id";
    private static final String SHORT_NAME = "name";
    private static final String LONG_NAME = "description";
    private static final String TOOLTIP = "tooltip";
    private static final String DEFAULT_ICON_URL = "defaultIconURL";
    private static final String EXTERNAL_TOOL_CLASS = "externalToolClass";

    public LazyExternalToolType(HashStructure hash) {
        this._hash = hash;
    }

    @Override
    public ExternalTool createExternalTool() {
        LazyExternalTool lazyTool = new LazyExternalTool(this._hash);
        return lazyTool;
    }

    @Override
    public ExternalToolOptionsPage[] getOptionsPages() {
        ExternalToolType etype = this.getInstance();
        if (etype != null) {
            return etype.getOptionsPages();
        }
        return new ExternalToolOptionsPage[0];
    }

    @Override
    public URL getDefaultIconURL(ExternalTool tool) {
        LazyResourceAdapter lra = LazyResourceAdapter.getInstance((HashStructure)this._hash);
        MetaResource mr = lra.getMetaResource(DEFAULT_ICON_URL);
        if (mr != null) {
            return mr.toURL();
        }
        String cname = null;
        cname = tool instanceof LazyExternalTool ? ((LazyExternalTool)tool).getClassName() : tool.getClass().getName();
        if (cname.equals("oracle.ideimpl.externaltools.program.ExternalProgramTool")) {
            ExternalProgramToolProperties props = ExternalProgramToolProperties.getInstance(tool);
            String exe = props.getExecutable();
            File f = new File(exe);
            if (f.exists() && f.getName().toLowerCase().endsWith(".exe")) {
                return URLFactory.newIdeURL((String)"ide.fileicon", (URL)URLFactory.newFileURL((File)f));
            }
            return ExternalProgramType.class.getResource("programtool.gif");
        }
        return tool.getIconURL();
    }

    @Override
    public String getShortLabel() {
        return this._hash.getString(SHORT_NAME);
    }

    @Override
    public String getLongLabel() {
        return this._hash.getString(LONG_NAME);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return this._hash.getString(TOOLTIP);
    }

    @Override
    public String getId() {
        return this._hash.getString(ID);
    }

    @Override
    public String getClassName() {
        return this._hash.getString("#text");
    }

    public MetaClass getExternalToolMetaClass() {
        LazyClassAdapter lazyAdapter = LazyClassAdapter.getInstance((HashStructure)this._hash);
        return lazyAdapter.getMetaClass(EXTERNAL_TOOL_CLASS);
    }

    private ExternalToolType getInstance() {
        if (this._instance == null) {
            this._instance = (ExternalToolType)LazyClassAdapter.getInstance((HashStructure)this._hash).createInstance(ExternalToolType.class, "#text");
        }
        return this._instance;
    }
}

