/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLIndexColumnsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLPartitionsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableAccessor;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLIndexAccessor
extends XMLSchemaObjAccessor {
    protected static String INDEX = "INDEX";
    private static String TABLE_INDEX = "TABLE_INDEX";
    private static String BITMAP_JOIN_INDEX = "BITMAP_JOIN_INDEX";
    private static String CLUSTER_INDEX = "CLUSTER_INDEX";
    private static String DOMAIN_IDX = "DOMAIN_INDEX";
    public static final int DOMAIN_INDEX = 102;
    private Vector m_columns = null;
    private XMLSegmentAccessor m_segment = null;
    private XMLPartitionsAccessor m_partitions = null;
    private CMConnection m_dbConn = null;
    private static String X_INDEX_SCHEMA_PATH = "/sxml:" + INDEX + "/sxml:" + "SCHEMA";
    private static String X_INDEX_NAME_PATH = "/sxml:" + INDEX + "/sxml:" + "NAME";
    private static String X_TABLE_INDEX = "/sxml:" + INDEX + "/sxml:" + TABLE_INDEX;
    private static String X_BITMAP_JOIN_INDEX = "/sxml:" + INDEX + "/sxml:" + BITMAP_JOIN_INDEX;
    private static String X_CLUSTER_INDEX = "/sxml:" + INDEX + "/sxml:" + CLUSTER_INDEX;
    private static String X_DOMAIN_INDEX_PROPERTIES = X_TABLE_INDEX + "/sxml:" + "DOMAIN_INDEX_PROPERTIES";
    private static String X_DOMAIN_INDEXTYPE = X_DOMAIN_INDEX_PROPERTIES + "/sxml:" + "INDEXTYPE";
    private static String X_DOMAIN_INDEXTYPE_SCHEMA = X_DOMAIN_INDEXTYPE + "/sxml:" + "SCHEMA";
    private static String X_DOMAIN_INDEXTYPE_NAME = X_DOMAIN_INDEXTYPE + "/sxml:" + "NAME";
    private static final String X_INDEX_ATTRIBUTES = "sxml:INDEX_ATTRIBUTES";
    private static final String X_ON_TABLE = "sxml:ON_TABLE";
    private static final String X_ON_TABLE_SCHEMA = "sxml:ON_TABLE/sxml:SCHEMA";
    private static final String X_ON_TABLE_NAME = "sxml:ON_TABLE/sxml:NAME";
    private static final String X_ON_CLUSTER = "sxml:ON_CLUSTER";
    private static final String X_CLUSTER_SCHEMA = "sxml:ON_CLUSTER/sxml:SCHEMA";
    private static final String X_CLUSTER_NAME = "sxml:ON_CLUSTER/sxml:NAME";
    private static final String X_UNIQUE = "../sxml:UNIQUE";
    private static final String X_BITMAP = "../sxml:BITMAP";
    private static final String X_UNUSABLE = "sxml:UNUSABLE";
    private static final String X_KEYCOMPRESS = "sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS";
    private static final String X_COLUMN_EXPRESSION = "sxml:COL_LIST/sxml:COL_LIST_ITEM/sxml:COLUMN_EXPRESSION";
    private static final String X_GLOBAL_PARTITIONING = "sxml:GLOBAL_PARTITIONING";
    private static final String X_LOCAL_PARTITIONING = "sxml:LOCAL_PARTITIONING";
    private static final String X_REVERSE = "sxml:INDEX_ATTRIBUTES/sxml:REVERSE";
    private static final String X_PARALLEL_DEGREE = "sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE";
    private static final String X_PARALLEL = "sxml:INDEX_ATTRIBUTES/sxml:PARALLEL";
    private static final String X_BJI_JOIN_TABLE_LIST_ITEM = "sxml:JOIN_TABLE_LIST/sxml:JOIN_TABLE_LIST_ITEM";
    private static final String X_BJI_COL_LIST_ITEM = "sxml:COL_LIST/sxml:COL_LIST_ITEM";
    private static final String X_BJI_JOIN_LIST_ITEM = "sxml:WHERE_LIST/sxml:WHERE_LIST_ITEM/sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM";
    private static final String X_STATS = "/sxml:" + INDEX + "/sxml:" + "STATISTICS";
    private static final String X_STATS_LASTANALYZED = X_STATS + "/sxml:" + "ANALYZETIME";
    private static final String X_STATS_ROWCNT = X_STATS + "/sxml:" + "ROWCNT";
    private static final String X_STATS_BLEVEL = X_STATS + "/sxml:" + "BLEVEL";
    private static final String X_STATS_LEAFCNT = X_STATS + "/sxml:" + "LEAFCNT";
    private static final String X_STATS_CLUFAC = X_STATS + "/sxml:" + "CLUFAC";
    private static final String X_STATS_DISTKEY = X_STATS + "/sxml:" + "DISTKEY";
    private static final String X_STATS_LBLKKEY = X_STATS + "/sxml:" + "LBLKKEY";
    private static final String X_STATS_DBLKKEY = X_STATS + "/sxml:" + "DBLKKEY";
    private static final String X_STATS_SAMPLESIZE = X_STATS + "/sxml:" + "SAMPLESIZE";

    protected XMLIndexAccessor() {
    }

    protected XMLIndexAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    protected String getTypePathElement() {
        return INDEX;
    }

    @Override
    public void setXmlDoc(XMLNode xmlDoc) throws XMLAccessorException {
        XMLNode n = XMLIndexAccessor.getNode(this.getXmlRoot(), X_TABLE_INDEX);
        if (n == null) {
            n = XMLIndexAccessor.getNode(this.getXmlRoot(), X_BITMAP_JOIN_INDEX);
        }
        if (n == null) {
            n = XMLIndexAccessor.getNode(this.getXmlRoot(), X_CLUSTER_INDEX);
        }
        if (n != null) {
            this.setXmlNode(n);
        } else {
            System.out.println("Unable to find INDEX subnode!");
        }
    }

    @Override
    public void initFromDatabase(CMConnection dbConn, String objSchema, String objName) throws SQLException, XMLAccessorException {
        super.initFromDatabase(dbConn, objSchema, objName);
        this.m_dbConn = dbConn;
    }

    @Override
    public void initFromDatabase(CMConnection dbConn, String objSchema, String objName, boolean forDiffing) throws SQLException, XMLAccessorException {
        super.initFromDatabase(dbConn, objSchema, objName, forDiffing);
        this.m_dbConn = dbConn;
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.initializeColumns();
        this.initializeSegments();
        this.initializePartitions();
    }

    @Override
    public XMLSegmentAccessor getSegment() {
        return this.m_segment;
    }

    private void initializeColumns() throws XMLAccessorException {
        this.m_columns = new Vector();
        NodeList cols = this.selectNodes(XMLIndexColumnsAccessor.getColumnItemsPath());
        int len = 0;
        if (cols != null && (len = cols.getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                XMLNode colNode = (XMLNode)cols.item(i);
                XMLAccessor accessor = XMLIndexAccessor.getXMLAccessorForType(300, colNode, this.getAccessorClient());
                this.m_columns.add(accessor);
            }
        } else {
            System.out.println("No column list found.");
        }
    }

    private void initializeSegments() throws XMLAccessorException {
        this.m_segment = (XMLSegmentAccessor)XMLIndexAccessor.getXMLAccessorForType(301, this.getXmlRoot(), this.getAccessorClient());
    }

    private void initializePartitions() throws XMLAccessorException {
        if (this.getIsPartition()) {
            this.m_partitions = (XMLPartitionsAccessor)XMLIndexAccessor.getXMLAccessorForType(200, this.getXmlRoot(), this.getAccessorClient());
        }
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        super.applySchemaMap(schemaMap, changeMode);
        String onSchema = this.getOnSchemaName();
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setOnSchemaName((String)schemaMap.get(onSchema), changeMode);
        }
        if ((onSchema = this.getClusterSchemaName()) != null && schemaMap.containsKey(onSchema)) {
            this.setClusterSchemaName((String)schemaMap.get(onSchema), changeMode);
        }
    }

    @Override
    public String getSchemaPath() {
        return X_INDEX_SCHEMA_PATH;
    }

    @Override
    protected String getNamePath() {
        return X_INDEX_NAME_PATH;
    }

    public int getIndexType() {
        int iType = -1;
        if (this.nodeExists(X_DOMAIN_INDEX_PROPERTIES)) {
            iType = 102;
        } else if (this.nodeExists(X_TABLE_INDEX)) {
            iType = 19;
        } else if (this.nodeExists(X_BITMAP_JOIN_INDEX)) {
            iType = 21;
        } else if (this.nodeExists(X_CLUSTER_INDEX)) {
            iType = 20;
        }
        return iType;
    }

    public String[] getColumns() {
        int numCols = this.m_columns.size();
        String[] cols = new String[numCols];
        for (int i = 0; i < this.m_columns.size(); ++i) {
            XMLIndexColumnsAccessor ca = (XMLIndexColumnsAccessor)this.m_columns.elementAt(i);
            cols[i] = ca.getColumnName();
        }
        return cols;
    }

    public String getOnSchemaName() {
        return this.selectTextValue(X_ON_TABLE_SCHEMA);
    }

    public void setOnSchemaName(String schemaName) {
        this.setTextValue(X_ON_TABLE_SCHEMA, schemaName);
    }

    private void setOnSchemaName(String schemaName, int changeMode) {
        this.setTextValue(X_ON_TABLE_SCHEMA, schemaName, changeMode);
    }

    public String getOnObjectName() {
        return this.selectTextValue(X_ON_TABLE_NAME);
    }

    public String getOnObject() {
        return this.getOnObjectName();
    }

    public void setOnObjectName(String name) {
        this.setTextValue(X_ON_TABLE_NAME, name);
    }

    public String getClusterSchemaName() {
        return this.selectTextValue(X_CLUSTER_SCHEMA);
    }

    public void setClusterSchemaName(String name) {
        this.setTextValue(X_CLUSTER_SCHEMA, name);
    }

    private void setClusterSchemaName(String name, int changeMode) {
        this.setTextValue(X_CLUSTER_SCHEMA, name, changeMode);
    }

    public String getClusterObjectName() {
        return this.selectTextValue(X_CLUSTER_NAME);
    }

    public boolean getIsOnCluster() {
        return this.nodeExists(X_ON_CLUSTER);
    }

    public boolean getIsUnique() {
        return this.nodeExists(X_UNIQUE);
    }

    public boolean getIsBitmap() {
        return this.nodeExists(X_BITMAP);
    }

    public String getStatus() {
        String status = this.nodeExists(X_UNUSABLE) ? "INVALID" : "VALID";
        return status;
    }

    public boolean getIsBitmapJoin() {
        return this.getXmlNode().getNodeName().equals(BITMAP_JOIN_INDEX);
    }

    public boolean getIsCompress() {
        String sn = this.selectTextValue(X_KEYCOMPRESS);
        return sn != null && !"N".equals(sn);
    }

    public boolean getIsFunctional() {
        return this.nodeExists(X_COLUMN_EXPRESSION);
    }

    public boolean getIsFunctionalEnabled() {
        return true;
    }

    public boolean getIsPartition() {
        return this.nodeExists(X_GLOBAL_PARTITIONING) || this.nodeExists(X_LOCAL_PARTITIONING);
    }

    @Override
    public boolean getPartitioned() {
        return this.getIsPartition();
    }

    @Override
    public XMLPartitionsAccessor getPartitions() {
        return this.m_partitions;
    }

    public boolean getIsReverse() {
        return this.nodeExists(X_REVERSE);
    }

    public String getKeyCompress() {
        if (this.getIsCompress()) {
            return this.selectTextValue(X_KEYCOMPRESS);
        }
        return null;
    }

    public void setOuterJoinTableName(String owner, String origName, String newName) {
        this.changeTableName(X_ON_TABLE, owner, origName, newName);
        this.changeTableName(X_BJI_JOIN_TABLE_LIST_ITEM, owner, origName, newName);
        this.changeTableName(X_BJI_COL_LIST_ITEM, owner, origName, newName);
        this.changeTableName(X_BJI_JOIN_LIST_ITEM, owner, origName, newName);
    }

    private void changeTableName(String path, String owner, String origName, String newName) {
        NodeList items = this.selectNodes(path);
        if (items != null) {
            for (int i = 0; i < items.getLength(); ++i) {
                XMLNode item = (XMLNode)items.item(i);
                String itemOwner = XMLIndexAccessor.selectTextValue(item, X_SCHEMA);
                String itemName = XMLIndexAccessor.selectTextValue(item, X_NAME);
                if (!owner.equals(itemOwner) || !origName.equals(itemName)) continue;
                XMLIndexAccessor.setTextValue(item, X_NAME, newName, this.getChangeMode());
            }
        }
    }

    public void setOnlineEnabled(boolean onlineEnabled) {
    }

    public String getLastAnalyzed() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_LASTANALYZED);
    }

    public String getBlevel() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_BLEVEL);
    }

    public String getDistinctKeys() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_DISTKEY);
    }

    public String getClusteringFactor() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_CLUFAC);
    }

    public String getLeafBlocks() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_LEAFCNT);
    }

    public String getAvgLeafBlocksPerKey() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_LBLKKEY);
    }

    public String getAvgDataBlocksPerKey() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_DBLKKEY);
    }

    public String getNumRows() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_ROWCNT);
    }

    public String getSampleSize() {
        return XMLTableAccessor.getSafeString((Node)this.getXmlNode(), X_STATS_SAMPLESIZE);
    }

    public static Node getPartitionsTreeNode(Node xml) {
        XMLNode n = XMLIndexAccessor.getNode((XMLNode)xml, "//sxml:GLOBAL_PARTITIONING");
        if (n == null) {
            n = XMLIndexAccessor.getNode((XMLNode)xml, "//sxml:LOCAL_PARTITIONING");
        }
        return n;
    }

    @Override
    public String generateDDL(int transform, int transformParams) {
        if (transform != 4 || !this.isTextIndex()) {
            return super.generateDDL(transform, transformParams);
        }
        return this.generateTextIndexScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateTextIndexScript() {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String script = null;
        String sql = "select ctx_report.create_index_script( ? ) as idxscript from dual";
        try {
            stmt = this.m_dbConn.prepareStatement(sql);
            String idxName = "\"" + this.getSchema() + "\"" + "." + "\"" + this.getName() + "\"";
            stmt.setString(1, idxName);
            rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                script = this.processText(rs.getString("idxscript"));
            }
            CMConnection.close(stmt, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            CMConnection.close(stmt, rs);
        }
        return script;
    }

    private String processText(String output) {
        output = output.replaceAll("end;\n", "exception when others then null;\nend;\n");
        try {
            String regexp = "(ctx_ddl[^\\(]*\\()('\"" + this.getName() + "[^\"]*\"')" + "([^;]*)";
            Pattern cr_pref = Pattern.compile(regexp);
            Matcher m_ind = cr_pref.matcher(output);
            String match = "";
            while (m_ind.find()) {
                match = m_ind.group(2);
                output = output.replaceAll(match, "'\"" + this.getSchema() + "\"." + match.substring(1, match.length() - 1) + "'");
            }
            Pattern p = Pattern.compile("(create index[^/]*)");
            Matcher m = p.matcher(output);
            String idxSQL = "";
            if (m.find()) {
                idxSQL = m.group(1);
                idxSQL = XMLIndexAccessor.addEscapeChars(idxSQL, false, false);
                idxSQL = "begin\n execute immediate '\n" + idxSQL + "';\nend;\n";
                output = output.replaceAll("(create index[^/]*)", idxSQL);
            } else {
                System.out.println("Parsing error: 'create index' statement is not found in generated script");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output = output.replaceAll("/\n", "");
        output = "begin\n" + output + "\n" + "end;\n";
        return output;
    }

    private static String addEscapeChars(String text, boolean checkDouble, boolean skipFirstQuote) {
        String escapedText = text;
        int minLen = text.length();
        StringBuffer buf = new StringBuffer(minLen);
        boolean charInserted = false;
        int textIndex = 0;
        int lineLength = 0;
        int bufIndex = 0;
        int lastSpacePos = -1;
        boolean inDQuotedString = false;
        boolean inSQuotedString = false;
        for (int i = 0; i < minLen; ++i) {
            char ch = text.charAt(i);
            if (ch == '\'') {
                if (checkDouble && i < minLen - 1 && text.charAt(i + 1) == '\'') {
                    ++i;
                    continue;
                }
                if (!skipFirstQuote || inSQuotedString) {
                    buf.append("'");
                    ++bufIndex;
                    ++lineLength;
                    charInserted = true;
                    inSQuotedString = !inSQuotedString;
                }
            } else if (ch == '\"') {
                inDQuotedString = !inDQuotedString;
            } else if (ch == ' ') {
                lastSpacePos = bufIndex;
            }
            buf.append(ch);
            ++lineLength;
            ++bufIndex;
            ++textIndex;
            if (ch == '\n') {
                lineLength = 0;
            }
            if (lineLength < 2400) continue;
            if (lastSpacePos >= 0 && text.lastIndexOf(32, bufIndex) >= bufIndex - 2400) {
                buf.insert(lastSpacePos, "'||\n'");
                charInserted = true;
                lineLength = bufIndex - lastSpacePos;
                lastSpacePos = -1;
                continue;
            }
            if (text.lastIndexOf(32, bufIndex) >= bufIndex - 2400) continue;
            buf.insert(bufIndex, "'||\n'");
            charInserted = true;
            lineLength = 0;
            lastSpacePos = -1;
        }
        if (charInserted) {
            escapedText = new String(buf);
        }
        return escapedText;
    }

    @Override
    protected boolean canHaveStats() {
        return true;
    }

    private boolean isTextIndex() {
        boolean isText = false;
        if (this.getIndexType() == 102) {
            String iTypeName = this.selectTextValue(X_DOMAIN_INDEXTYPE_NAME);
            isText = iTypeName.equals("CONTEXT") || iTypeName.equals("CTXCAT") || iTypeName.equals("CTXRULE") || iTypeName.equals("CTXPATH");
        }
        return isText;
    }

    @Override
    protected String getParallelDegreePath() {
        return X_PARALLEL_DEGREE;
    }

    @Override
    protected String getParallelDegreeDegreePath() {
        return "sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE/sxml:DEGREE";
    }

    @Override
    protected String getParallelPath() {
        return X_PARALLEL;
    }

    @Override
    public String toString() {
        int it = this.getIndexType();
        String iType = null;
        switch (it) {
            case 102: {
                iType = DOMAIN_IDX;
                break;
            }
            case 19: {
                iType = TABLE_INDEX;
                break;
            }
            case 21: {
                iType = BITMAP_JOIN_INDEX;
                break;
            }
            case 20: {
                iType = CLUSTER_INDEX;
            }
        }
        String isText = "";
        if (iType.equals(DOMAIN_IDX)) {
            isText = "   Text index: " + XMLIndexAccessor.YorN(this.isTextIndex()) + "\n";
        }
        String onObject = "";
        if (iType.equals(TABLE_INDEX) || iType.equals(BITMAP_JOIN_INDEX) || iType.equals(DOMAIN_IDX)) {
            onObject = "  On table: " + this.getOnSchemaName() + "." + this.getOnObjectName() + "\n";
        } else if (iType.equals(CLUSTER_INDEX)) {
            onObject = "  On cluster: " + this.getClusterSchemaName() + "." + this.getClusterObjectName() + "\n";
        }
        String columns = "None\n";
        if (this.m_columns != null && this.m_columns.size() > 0) {
            columns = "\n";
            for (int i = 0; i < this.m_columns.size(); ++i) {
                XMLIndexColumnsAccessor ca = (XMLIndexColumnsAccessor)this.m_columns.elementAt(i);
                columns = columns + ca.toString();
            }
        }
        String segment = "No index attributes found\n";
        if (this.m_segment != null) {
            segment = this.m_segment.toString();
        }
        String partitions = "";
        if (this.m_partitions != null) {
            partitions = "  Partitioning: " + this.m_partitions.toString();
        }
        return super.toString() + "  Index type: " + iType + "\n" + isText + onObject + "  Unique: " + XMLIndexAccessor.YorN(this.getIsUnique()) + "\n" + "  Bitmap: " + XMLIndexAccessor.YorN(this.getIsBitmap()) + "\n" + "  Status: " + this.getStatus() + "\n" + "  Columns: " + columns + segment + partitions;
    }
}

