/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.io.IO;

public class AbstractResponse
implements IResponse {
    private String content = null;
    private int statusCode = 0;

    protected AbstractResponse() {
        this(0);
    }

    protected AbstractResponse(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public String readContent() {
        if (this.content != null) {
            return this.content;
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            this.content = "";
            return this.content;
        }
        this.content = IO.read(inputStream).toString();
        return this.content;
    }

    @Override
    public String getErrorContent() {
        int statusCode = this.getStatus();
        if (statusCode < 400) {
            return null;
        }
        String error = null;
        try {
            error = this.readContent();
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            error = error == null ? cause.getMessage() : error + ": " + cause.getMessage();
        }
        return error;
    }

    @Override
    public void close() {
    }

    @Override
    public Future<String> getFutureMd5() {
        return null;
    }
}

