/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.help.Parameter;
import oracle.jdeveloper.help.ParameterProvider;
import oracle.jdevimpl.help.BaseInfo;
import oracle.jdevimpl.help.ComponentInfo;
import oracle.jdevimpl.help.ParameterInfo;
import oracle.jdevimpl.help.StartPageDefinition;
import oracle.jdevimpl.help.StartPageHook;

public class BaseInfoWithParameters
extends BaseInfo
implements ParameterProvider {
    private List<Parameter> _parameterList;

    public BaseInfoWithParameters(HashStructure hash) {
        super(hash);
    }

    @Override
    public List<Parameter> getParameters() {
        if (this._parameterList == null) {
            List hashList;
            this._parameterList = Collections.EMPTY_LIST;
            if (this._hash != null && (hashList = this._hash.getAsList("param")) != null && hashList.size() > 0) {
                this._parameterList = new ArrayList<Parameter>(hashList.size());
                for (HashStructure h : hashList) {
                    this._parameterList.add(new ParameterInfo(h));
                }
            }
        }
        return this._parameterList;
    }

    @Override
    public MetaClass getMetaClass(String parameterName) {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter != null) {
            return parameter.getMetaClass("value");
        }
        parameter = this.getParameterFromComponent(parameterName);
        if (parameter != null) {
            return parameter.getMetaClass("default");
        }
        return null;
    }

    @Override
    public Icon getIcon(String parameterName) {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter != null) {
            return parameter.getIcon("value");
        }
        return null;
    }

    @Override
    public String getParameterValue(String parameterName) {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter != null) {
            return parameter.getValue();
        }
        parameter = this.getParameterFromComponent(parameterName);
        if (parameter != null) {
            return parameter.getDefaultValue();
        }
        return null;
    }

    private Parameter getParameterFromComponent(String parameterName) {
        StartPageDefinition definition = StartPageHook.getStartPageDefinition();
        ComponentInfo compInfo = definition.getComponentInfo(this._hash.getString("compId"));
        return compInfo.getParameter(parameterName);
    }

    @Override
    public Parameter getParameter(String parameterName) {
        List<Parameter> parameters = this.getParameters();
        if (parameters != Collections.EMPTY_LIST) {
            for (Parameter pInfo : parameters) {
                if (!pInfo.getName().equals(parameterName)) continue;
                return pInfo;
            }
        }
        return null;
    }

    @Override
    public void setParameter(String parameterName, String value) {
        Parameter p = this.getParameter(parameterName);
        if (p == null) {
            HashStructure h = HashStructure.newInstance();
            h.putString("name", parameterName);
            h.putString("value", value);
            this._parameterList.add(new ParameterInfo(h));
        } else {
            p.setValue(value);
        }
    }
}

