/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Color;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.EmptyBorder;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevNavigator;

public final class JDevTOCNavigator
extends TOCNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;
    private boolean _isInitialized = false;
    private List<View> _initialViews;
    private HelpNavigatorToolbar _toolbar;
    private FocusTraversalPolicy _focusTraversalPolicy;
    private JDevTreePaneListener _listener;

    public JDevTOCNavigator(HelpWindow helpWindow, Library library) throws NavigatorException {
        this._helpWindow = helpWindow;
        this.label = "Contents";
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevTOCNavigator";
        View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), this.label);
            if (initialViews != null) {
                for (iter = 0; iter < initialViews.length; ++iter) {
                    this.views.add(initialViews[iter]);
                }
            }
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_helpnav_html");
        this.initNavigator(initialViews);
        Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBackground(transparentColor);
    }

    protected void doInitializationNow() {
        super.initNavigator(this._initialViews.toArray(new View[0]));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._focusTraversalPolicy = new LayoutFocusTraversalPolicy();
    }

    protected void addViewNow(View view) {
        super.addView(view);
    }

    protected void removeViewNow(View view) {
        super.removeView(view);
    }

    public void initNavigator(View[] initalViewsArray) {
        if (initalViewsArray != null) {
            this._initialViews = new ArrayList<View>(initalViewsArray.length);
            for (int i = 0; i < initalViewsArray.length; ++i) {
                this._initialViews.add(initalViewsArray[i]);
            }
        } else {
            this._initialViews = new ArrayList<View>(0);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(visible);
        } else {
            if (visible && !this.isInitialized()) {
                this.initializeLazyNavigator();
            }
            super.setVisible(visible);
        }
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void addView(View view) {
        if (this.isInitialized()) {
            this.addViewNow(view);
        } else {
            this._initialViews.add(view);
        }
    }

    public void removeView(View view) {
        if (this.isInitialized()) {
            this.removeViewNow(view);
        } else {
            this._initialViews.remove(view);
        }
    }

    public void initializeLazyNavigator() {
        this._isInitialized = true;
        this.doInitializationNow();
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this._focusTraversalPolicy;
    }

    protected View[] getInitialViewsArray() {
        if (this._initialViews.size() > 0) {
            View[] initialViewsArray = new View[this._initialViews.size()];
            this._initialViews.toArray(initialViewsArray);
            return initialViewsArray;
        }
        return null;
    }

    protected void addTopicTreeListener(TopicTreePane treePane) {
        this._listener = new JDevTreePaneListener();
        treePane.addTopicTreeListener((TopicTreeListener)this._listener);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._listener != null) {
            this.getTopicTreePane().removeTopicTreeListener((TopicTreeListener)this._listener);
            this._listener = null;
        }
        this.getTopicTreePane().removeAll();
        if (this.library != null) {
            this.library.removeLibraryListener((LibraryListener)this);
        }
        this.views = null;
        this.library = null;
        this.type = null;
        this._toolbar = null;
        this._focusTraversalPolicy = null;
        this._helpWindow = null;
        this._isInitialized = false;
        this.removeAll();
    }

    @Override
    public void setActive(boolean active) {
        if (this._toolbar != null) {
            this._toolbar.setActiveToolbar(active);
        }
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    private class JDevTreePaneListener
    implements TopicTreeListener {
        private JDevTreePaneListener() {
        }

        public void topicActivated(TopicTreeItem item, boolean newWindow) {
            int mode = newWindow ? 2 : 1;
            JDevTOCNavigator.this.fireTopicActivated(item.getTopic(), mode);
        }

        public void topicSelected(TopicTreeItem item) {
            Topic selectedTopic = item == null ? null : item.getTopic();
            JDevTOCNavigator.this.fireTopicSelected(selectedTopic);
        }

        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            JDevTOCNavigator.this.getTopicTreePane().getTopicTreeComponent().selectTopicTreeNode(item.getTopicTreeNode());
            JDevTOCNavigator.this._helpWindow.addMenuItems(popup, item.getTopic());
        }
    }
}

