/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.Log;
import oracle.jdeveloper.library.AddinJDK;
import oracle.jdeveloper.library.AddinLibrary;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.library.LibrariesHook;

public final class AddinLibraryList
implements LibraryList {
    private final Map<String, JLibrary> extraLibraries = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = new Log("library-init");
    private AddinJDK jdk;

    AddinLibraryList() {
        LOG.trace("creating AddinLibraryList");
    }

    private String resolveAlias(String name) {
        LOG.trace("resolving alias {0}", (Object)name);
        return LibrariesHook.getInstance().resolveAlias(name);
    }

    public void registerLibrary(JLibrary library) {
        LOG.trace("explicitly registering library {0} with AddingLibraryList", (Object)library.getLongLabel());
        if (library == null) {
            throw new NullPointerException("library is null");
        }
        this.extraLibraries.put(library.getName(), library);
    }

    @Deprecated
    public synchronized JDK loadJDK(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        AddinJDK jdk;
        this.jdk = jdk = new AddinJDK(name, clsPath, srcPath, docPath, exeURL, version, sdkBinDir);
        return jdk;
    }

    @Override
    public JDK findJDK(Object id) {
        LOG.trace("finding JDK in AddinLibraryList");
        if (id == null) {
            return null;
        }
        JDK jdk = this.getJDK();
        if (jdk.getID().equals(id)) {
            return jdk;
        }
        String resolvedId = id.toString();
        LibrariesHook hook = LibrariesHook.getInstance();
        jdk = hook.getJDK(resolvedId);
        if (jdk == null) {
            LibraryList list;
            Iterator<LibraryList> iterator = hook.getExtensionLibraryLists().iterator();
            while (iterator.hasNext() && (jdk = (list = iterator.next()).findJDK(resolvedId)) == null) {
            }
        }
        LOG.trace("completed finding JDK in AddinLibraryList");
        return jdk;
    }

    private synchronized JDK getJDK() {
        return this.jdk;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        LOG.trace("finding library {0} in AddinLibraryList", id);
        if (id == null) {
            return null;
        }
        String resolvedId = this.resolveAlias(id.toString());
        LibrariesHook librariesHook = LibrariesHook.getInstance();
        JLibrary lib = librariesHook.getLibrary(resolvedId);
        if (lib == null) {
            LibraryList list;
            Iterator<LibraryList> iterator = librariesHook.getExtensionLibraryLists().iterator();
            while (iterator.hasNext() && (lib = (list = iterator.next()).findLibrary(resolvedId)) == null) {
            }
        }
        if (lib == null) {
            lib = this.extraLibraries.get(resolvedId);
        }
        LOG.trace("completed finding library {0} in AddinLibraryList", id);
        return lib;
    }

    @Override
    public List getJdkList() {
        LOG.trace("getting JDK list from AddinLibraryList");
        ArrayList<AddinJDK> jdks = new ArrayList<AddinJDK>(LibrariesHook.getInstance().getJDKs());
        for (LibraryList list : LibrariesHook.getInstance().getExtensionLibraryLists()) {
            for (Object o : list.getJdkList()) {
                jdks.add((AddinJDK)((JDK)o));
            }
        }
        JDK jdk = this.getJDK();
        if (jdk != null) {
            jdks.add((AddinJDK)jdk);
        }
        LOG.trace("completed getting JDK list from AddinLibraryList");
        return jdks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLibraryList() {
        LOG.trace("getting library list from AddinLibraryList");
        ArrayList<JLibrary> libraries = new ArrayList<JLibrary>();
        LibrariesHook librariesHook = LibrariesHook.getInstance();
        for (JLibrary jLibrary : librariesHook.getLibraries()) {
            if (jLibrary instanceof AddinLibrary && ((AddinLibrary)jLibrary).isHidden()) continue;
            libraries.add(jLibrary);
        }
        for (LibraryList libraryList : librariesHook.getExtensionLibraryLists()) {
            for (Object o : libraryList.getLibraryList()) {
                JLibrary library = (JLibrary)o;
                if (this.isHidden(library)) continue;
                libraries.add(library);
            }
        }
        Map<String, JLibrary> map = this.extraLibraries;
        synchronized (map) {
            for (JLibrary library : this.extraLibraries.values()) {
                if (this.isHidden(library)) continue;
                libraries.add(library);
            }
        }
        LOG.trace("completed getting library list from AddinLibraryList");
        String log = System.getProperty("libraries.write.list");
        if (log != null) {
            URL uRL = URLFactory.newDirURL((String)IdeBootProperties.getMiddlewareHome());
            System.out.println("###################################################");
            System.out.println("## Writing libraries to " + log);
            System.out.println("###################################################");
            System.clearProperty("libraries.write.list");
            File directory = new File(log);
            directory.mkdirs();
            for (JLibrary library : libraries) {
                String name = library.getName();
                StringBuilder builder = new StringBuilder();
                boolean boundary = true;
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (Character.isUpperCase(c)) {
                        builder.append(Character.toLowerCase(c));
                        boundary = false;
                        continue;
                    }
                    if (Character.isLetterOrDigit(c)) {
                        builder.append(c);
                        boundary = false;
                        continue;
                    }
                    if (!boundary) {
                        builder.append('-');
                    }
                    boundary = true;
                }
                int last = builder.length() - 1;
                if (builder.charAt(last) == '-') {
                    builder.setLength(last);
                }
                builder.append(".lis");
                File file = new File(directory, builder.toString());
                try {
                    PrintWriter writer = new PrintWriter(file);
                    Throwable throwable = null;
                    try {
                        writer.print("Library \"");
                        writer.print(library.getName());
                        writer.print("\" deployed=");
                        writer.print(library.getDeployedByDefault());
                        writer.print("\" locked=");
                        writer.println(library.isLocked());
                        URLPath path = library.getClassPath();
                        if (path == null) continue;
                        for (URL url : path.getEntries()) {
                            writer.print("    ");
                            String entry = "";
                            if (JarUtil.isJarURL((URL)url)) {
                                entry = JarUtil.getJarEntry((URL)url);
                                if (!entry.isEmpty()) {
                                    entry = '!' + entry;
                                }
                                url = JarUtil.getJarFileURL((URL)url);
                            }
                            writer.println(URLFileSystem.toRelativeSpec((URL)url, (URL)uRL) + entry);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        return libraries;
    }

    @Override
    public String getListName() {
        return LibraryArb.getString(4);
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(13);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    private boolean isHidden(JLibrary library) {
        return library instanceof ExtensionLibrary && ((ExtensionLibrary)library).isHidden();
    }
}

