/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.ExportLibraryWriter;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.FileExportSpecificationReader;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import org.xml.sax.SAXException;

public class JLibraryNode
extends ExternalLibrary
implements JLibrary,
ExportLibrary {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jlibrarynode");
    public static final String ROOT_TAG = "JLibraryNode";
    private FileExportLibrary exportLibrary;
    private boolean exportFormat;
    private String id = "";
    private boolean idSynthetic;
    private String description = "";
    private Boolean deployed;
    private Collection<ClassPathEntry> suppliedClassPath = Collections.emptyList();
    private Map<ClassPathEntry, ClassPathEntry> resolvedClassPath = Collections.emptyMap();
    private Collection<LibraryDependency> dependencies = Collections.emptyList();
    private Map<String, List<URL>> exportSpecificationPaths = Collections.emptyMap();
    private static final Logger LOGGER;

    public JLibraryNode() {
        this.exportFormat = true;
    }

    public JLibraryNode(URL url) {
        super(url);
        this.exportFormat = true;
    }

    public JLibraryNode(URL url, boolean exportFormat) {
        super(url);
        this.exportFormat = exportFormat;
    }

    public JLibraryNode(FileExportLibrary library) {
        super(library.getOrigin());
        this.exportLibrary = library;
        this.exportFormat = true;
        try {
            this.open();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        this.exportLibrary = null;
    }

    @Override
    protected void openImpl() throws IOException {
        try {
            if (!this.exportFormat) {
                throw new ExportLibraryReader.LegacyFormatException();
            }
            if (this.exportLibrary == null) {
                ArrayList issues = new ArrayList();
                this.exportLibrary = new ExportLibraryReader().read(this.getURL(), Collections.emptyMap(), issues);
                this.exportLibrary.resolveDependencies((ExportSpecificationReader)new FileExportSpecificationReader(), id -> JLibraryManager.getAddinLibraries().findLibrary(id), issues);
                for (String issue : issues) {
                    LOGGER.log(issue.startsWith("Error: ") ? Level.SEVERE : Level.WARNING, issue);
                }
            }
            this.exportFormat = true;
            this.id = this.exportLibrary.getId();
            this.idSynthetic = this.exportLibrary.isIdSynthetic();
            this.setName(this.exportLibrary.getName());
            this.description = this.exportLibrary.getDescription();
            this.setDeployedByDefault(this.exportLibrary.isSet(FileExportLibrary.LibraryFlag.DEPLOYED));
            this.setLocked(this.exportLibrary.isSet(FileExportLibrary.LibraryFlag.LOCKED));
            URLPath classPath = new URLPath();
            this.suppliedClassPath = this.exportLibrary.getSuppliedClassPath();
            this.resolvedClassPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            for (ClassPathEntry entry : this.exportLibrary.getResolvedClassPath()) {
                this.resolvedClassPath.put(entry, entry);
                classPath.add(entry.getUrl());
            }
            super.setClassPath(classPath);
            this.dependencies = this.exportLibrary.getDependencies();
            this.exportSpecificationPaths = this.exportLibrary.getExportSpecificationPaths();
            URLPath sourcePath = new URLPath();
            sourcePath.add((Collection)this.exportLibrary.getSourcePath());
            this.setSourcePath(sourcePath);
            URLPath docPath = new URLPath();
            docPath.add((Collection)this.exportLibrary.getDocPath());
            this.setDocPath(docPath);
            this.markDirty(false);
        }
        catch (NoSuchFileException e) {
            this.exportFormat = false;
            super.openImpl();
            this.id = "";
            this.idSynthetic = false;
            this.description = "";
            this.suppliedClassPath = new ArrayList<ClassPathEntry>();
            this.resolvedClassPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            this.dependencies = Collections.emptyList();
            this.exportSpecificationPaths = Collections.emptyMap();
        }
        catch (ExportLibraryReader.LegacyFormatException e) {
            this.exportFormat = false;
            super.openImpl();
            this.id = ExportLibrary.syntheticId((URL)this.getURL(), (String)this.getName());
            this.idSynthetic = true;
            this.description = "";
            this.suppliedClassPath = new ArrayList<ClassPathEntry>();
            this.resolvedClassPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            for (URL url : this.getClassPath().getEntries()) {
                ClassPathEntry entry = new ClassPathEntry(url, ClassPathEntry.EntryType.SUPPLIED_ABSENT, null, false);
                this.resolvedClassPath.put(entry, entry);
                this.suppliedClassPath.add(entry);
            }
            this.dependencies = Collections.emptyList();
            this.exportSpecificationPaths = Collections.emptyMap();
        }
        catch (IllegalArgumentException | ParserConfigurationException | SAXException e) {
            this.exportLibrary = null;
            throw new IOException("exception opening " + this.getURL() + ": " + e, e);
        }
    }

    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (this.isOpen()) {
            this.exportFormat = true;
        }
    }

    @Override
    protected void saveImpl() throws IOException {
        if (this.exportFormat) {
            boolean mutated;
            EnumSet<FileExportLibrary.LibraryFlag> flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
            if (Boolean.TRUE.equals(this.getDeployedByDefault())) {
                flags.add(FileExportLibrary.LibraryFlag.DEPLOYED);
            }
            if (this.isLocked()) {
                flags.add(FileExportLibrary.LibraryFlag.LOCKED);
            }
            ArrayList classPath = new ArrayList();
            URLPath maybeMutatedClassPath = this.getClassPath();
            if (maybeMutatedClassPath != null) {
                Iterator left = maybeMutatedClassPath.iterator();
                Iterator<ClassPathEntry> right = this.suppliedClassPath.iterator();
                boolean bl = mutated = maybeMutatedClassPath.size() != this.suppliedClassPath.size();
                while (!mutated && left.hasNext()) {
                    mutated = !URLFileSystem.equals((URL)((URL)left.next()), (URL)right.next().getUrl());
                }
            } else {
                boolean bl = mutated = !this.suppliedClassPath.isEmpty();
            }
            if (mutated) {
                this.setClassPath(maybeMutatedClassPath);
            }
            URLPath sourcePath = this.getSourcePath();
            URLPath docPath = this.getDocPath();
            ExportLibraryWriter.write((URL)this.getURL(), (String)"UTF-8", (String)this.id, (String)this.getName(), (String)this.description, flags, this.suppliedClassPath, this.exportSpecificationPaths, this.dependencies, (List)(sourcePath != null ? sourcePath.asList() : Collections.emptyList()), (List)(docPath != null ? docPath.asList() : Collections.emptyList()));
        } else {
            super.saveImpl();
        }
    }

    @Override
    public boolean equivalent(Library library) {
        if (!(library instanceof JLibrary)) {
            return false;
        }
        JLibrary jLibrary = (JLibrary)library;
        if (!super.equivalent(jLibrary)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)this.deployed, (Object)jLibrary.getDeployedByDefault())) {
            return false;
        }
        if (library instanceof ExportLibrary) {
            ExportLibrary xLibrary = (ExportLibrary)library;
            if (ModelUtil.areDifferent((Object)this.id, (Object)xLibrary.getId())) {
                return false;
            }
            if (ModelUtil.areDifferent((Object)this.description, (Object)xLibrary.getDescription())) {
                return false;
            }
            if (ModelUtil.areDifferent(this.dependencies, (Object)xLibrary.getDependencies())) {
                return false;
            }
            if (this.areDifferent(this.suppliedClassPath, xLibrary.getSuppliedClassPath())) {
                return false;
            }
            if (ModelUtil.areDifferent(this.exportSpecificationPaths, (Object)xLibrary.getExportSpecificationPaths())) {
                return false;
            }
        }
        return true;
    }

    private boolean areDifferent(Collection<ClassPathEntry> c0, Collection<ClassPathEntry> c1) {
        if (c0.size() != c1.size()) {
            return true;
        }
        Iterator<ClassPathEntry> i0 = c0.iterator();
        Iterator<ClassPathEntry> i1 = c1.iterator();
        while (i0.hasNext()) {
            ClassPathEntry e1;
            ClassPathEntry e0 = i0.next();
            if (e0.equals((Object)(e1 = i1.next())) && e0.getType() == e1.getType() && e0.getKey().equals(e1.getKey()) && e0.isManifest() == e1.isManifest()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JLibrary) {
            JLibrary jlib = (JLibrary)lib;
            Boolean deployed = jlib.getDeployedByDefault();
            super.initFromLibrary(jlib);
            if (ModelUtil.areDifferent((Object)deployed, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(deployed);
            }
            if (lib instanceof ExportLibrary) {
                ExportLibrary xlib = (ExportLibrary)lib;
                if (ModelUtil.areDifferent((Object)xlib.getId(), (Object)this.getId())) {
                    this.setId(xlib.getId());
                }
                if (ModelUtil.areDifferent((Object)xlib.getDescription(), (Object)this.getDescription())) {
                    this.setDescription(xlib.getDescription());
                }
                if (ModelUtil.areDifferent((Object)xlib.getDependencies(), this.getDependencies())) {
                    this.setDependencies(xlib.getDependencies());
                }
                if (this.areDifferent(xlib.getSuppliedClassPath(), this.getSuppliedClassPath())) {
                    this.setSuppliedClassPath(xlib.getSuppliedClassPath());
                }
                if (this.areDifferent(xlib.getResolvedClassPath(), this.getResolvedClassPath())) {
                    this.setResolvedClassPath(xlib.getResolvedClassPath());
                }
                if (ModelUtil.areDifferent((Object)xlib.getExportSpecificationPaths(), this.getExportSpecificationPaths())) {
                    this.setExportSpecificationPaths(xlib.getExportSpecificationPaths());
                }
            }
        }
    }

    public URL getOrigin() {
        return this.getURL();
    }

    public String getId() throws TransientMarker {
        return this.ensureOpen() ? this.id : "";
    }

    public void setId(String newId) {
        String oldId = this.id;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldId, (Object)newId)) {
            this.id = newId;
            this.idSynthetic = false;
            this.markDirty(true);
            this.fireChangeEvent("id", oldId, newId);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.idSynthetic) {
            String newId = ExportLibrary.syntheticId((URL)this.getURL(), (String)this.getName());
            String oldId = this.id;
            if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldId, (Object)newId)) {
                this.id = newId;
                this.markDirty(true);
                this.fireChangeEvent("id", oldId, newId);
            }
        }
    }

    public String getDescription() throws TransientMarker {
        return this.ensureOpen() ? this.description : "";
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldDescription, (Object)newDescription)) {
            this.description = newDescription;
            this.markDirty(true);
            this.fireChangeEvent("description", oldDescription, newDescription);
        }
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this.ensureOpen() ? this.deployed : Boolean.FALSE;
    }

    @Override
    public void setDeployedByDefault(Boolean newDeployed) {
        Boolean oldDeployed = this.deployed;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)newDeployed, (Object)oldDeployed)) {
            this.deployed = newDeployed;
            this.markDirty(true);
            this.fireChangeEvent("deployedByDefault", oldDeployed, newDeployed);
        }
    }

    @Override
    public void setClassPath(URLPath classPath) {
        if (this.ensureOpen()) {
            super.setClassPath(classPath);
            LinkedHashSet<ClassPathEntry> suppliedClassPath = new LinkedHashSet<ClassPathEntry>();
            if (classPath != null) {
                for (URL url : this.getClassPath().getEntries()) {
                    ClassPathEntry entry = new ClassPathEntry(url, ClassPathEntry.EntryType.SUPPLIED_ABSENT, null, false);
                    suppliedClassPath.add(entry);
                }
            }
            this.setSuppliedClassPath(suppliedClassPath);
            this.setResolvedClassPath(suppliedClassPath);
            this.setDependencies(Collections.emptyList());
            this.setExportSpecificationPaths(Collections.emptyMap());
        }
    }

    public Collection<ClassPathEntry> getSuppliedClassPath() {
        return this.ensureOpen() ? this.suppliedClassPath : Collections.emptyList();
    }

    private void setSuppliedClassPath(Collection<ClassPathEntry> newSuppliedClassPath) {
        Collection<ClassPathEntry> oldSuppliedClassPath = this.suppliedClassPath;
        if (this.ensureOpen() && this.areDifferent(oldSuppliedClassPath, newSuppliedClassPath)) {
            this.suppliedClassPath = newSuppliedClassPath;
        }
    }

    public Set<ClassPathEntry> getResolvedClassPath() {
        return this.ensureOpen() ? this.resolvedClassPath.keySet() : Collections.emptySet();
    }

    private void setResolvedClassPath(Set<ClassPathEntry> newResolvedClassPath) {
        Map<ClassPathEntry, ClassPathEntry> oldResolvedClassPath = this.resolvedClassPath;
        if (this.ensureOpen() && this.areDifferent(oldResolvedClassPath.keySet(), newResolvedClassPath)) {
            LinkedHashMap<ClassPathEntry, ClassPathEntry> map = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            for (ClassPathEntry entry : newResolvedClassPath) {
                map.put(entry, entry);
            }
            this.resolvedClassPath = map;
        }
    }

    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.ensureOpen() ? this.exportSpecificationPaths : Collections.emptyMap();
    }

    private void setExportSpecificationPaths(Map<String, List<URL>> newExportSpecificationPaths) {
        Map<String, List<URL>> oldExportSpecificationPaths = this.exportSpecificationPaths;
        if (this.ensureOpen() && ModelUtil.areDifferent(oldExportSpecificationPaths, newExportSpecificationPaths)) {
            this.exportSpecificationPaths = newExportSpecificationPaths;
        }
    }

    public Collection<LibraryDependency> getDependencies() throws TransientMarker {
        return this.ensureOpen() ? this.dependencies : Collections.emptyList();
    }

    private void setDependencies(Collection<LibraryDependency> newDependencies) {
        Collection<LibraryDependency> oldDependencies = this.dependencies;
        if (this.ensureOpen() && ModelUtil.areDifferent(oldDependencies, newDependencies)) {
            this.dependencies = newDependencies;
        }
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    protected String getExtension() {
        return ".library";
    }

    static {
        Object2Dom.registerNamespaceElem(JLibraryNode.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
        LOGGER = Logger.getLogger(JLibraryNode.class.getName());
    }
}

