/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLRecognizer;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.jdeveloper.library.LibraryDataNode;

public final class LegacyLibraryList
extends LibraryDataNode {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jlibrary-list");
    public static final String ROOT_TAG = "JLibraryList";
    private static final Attributes ATTRIBUTES = new ElementAttributes(ElementAttributes.NON_RELOADABLE | ElementAttributes.OPEN_AS_TEXT | ElementAttributes.READ_ONLY);
    private HashMap _aliasMap = new HashMap();
    private List _libraries = new ArrayList();
    private List _jdks = new ArrayList();

    public List getLibraryList() {
        if (this.ensureOpen()) {
            ArrayList list = new ArrayList();
            list.addAll(this._libraries);
            return list;
        }
        return new ArrayList();
    }

    public void setLibraryList(List libraries) {
        if (ModelUtil.areDifferent((Object)libraries, (Object)this._libraries)) {
            LegacyLibraryList.populateList(libraries, this._libraries);
            this.markDirty(true);
        }
    }

    public List getJdkList() {
        if (this.ensureOpen()) {
            ArrayList list = new ArrayList();
            list.addAll(this._jdks);
            return list;
        }
        return new ArrayList();
    }

    public void setJdkList(List jdks) {
        if (ModelUtil.areDifferent((Object)jdks, (Object)this._jdks)) {
            LegacyLibraryList.populateList(jdks, this._jdks);
            this.markDirty(true);
        }
    }

    public Map getAliasMap() {
        HashMap map = new HashMap();
        map.putAll(this._aliasMap);
        return map;
    }

    public void setAliasMap(Map aliasMap) {
        if (ModelUtil.areDifferent((Object)aliasMap, (Object)this._aliasMap)) {
            this._aliasMap.clear();
            if (aliasMap != null) {
                this._aliasMap.putAll(aliasMap);
            }
            this.markDirty(true);
        }
    }

    public Iterator getChildren() {
        return null;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Attributes getAttributes() {
        return ATTRIBUTES;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected ObjectStore newObjectStore() {
        return super.newObjectStore();
    }

    private static void populateList(List src, List target) {
        Iterator i;
        target.clear();
        Iterator iterator = i = src != null ? src.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                Object lib = i.next();
                if (target.contains(lib)) continue;
                target.add(lib);
            }
        }
    }

    static {
        Object2Dom.registerNamespaceElem(LegacyLibraryList.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
        XMLRecognizer.mapRootElementToClass((String)ROOT_TAG, LegacyLibraryList.class);
    }
}

