/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer,
Serializable {
    private Color unselectedForeground;
    private Color unselectedBackground;
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public BooleanTableCellRenderer() {
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setBorder(noFocusBorder);
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(value);
        this.setEnabled(true);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void setValue(Object value) {
        boolean selected = value instanceof Boolean ? (Boolean)value : false;
        this.setSelected(selected);
    }
}

