/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProxySettingsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.HttpPing;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.SystemProxySettings;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.util.ModelUtil;

public final class ProxySettingsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_useProxy;
    private JRadioButton radio_noProxy;
    private JRadioButton radio_systemProxy;
    private JRadioButton radio_autoConfigScript;
    private JRadioButton radio_manualProxy;
    private JTextField textfield_autoConfigScript;
    private JTextField textfield_proxyHost;
    private WholeNumberField textfield_proxyPort;
    private JTextField textfield_proxyExceptions;
    private JCheckBox checkbox_useProxyAuth;
    private JLabel label_proxyUserName;
    private JTextField textfield_proxyUserName;
    private JLabel label_proxyPassword;
    private JPasswordField textfield_proxyPassword;
    private boolean _suppressUseProxy;
    private JButton _testProxy;
    private JLabel _testProxyStatus;
    private Thread _testThread;
    private JLabel _warningLabel;
    private static String DEFAULT_PROXY_EXCEPTIONS = "";

    public ProxySettingsPanel() {
        this(false);
    }

    public ProxySettingsPanel(boolean suppressUseProxy) {
        this._suppressUseProxy = suppressUseProxy;
        this.initializeComponent();
    }

    private void initializeComponent() {
        this.setHelpID("f1_prefweb_proxy_html");
        String useProxyText = ProxySettingsArb.getString((int)0);
        this.checkbox_useProxy = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxy, (String)useProxyText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.checkbox_useProxy, (String)"checkbox_useProxy");
        String noProxyText = ProxySettingsArb.getString((int)1);
        String proxyHostText = ProxySettingsArb.getString((int)6);
        String proxyPortText = ProxySettingsArb.getString((int)7);
        String proxyExceptionsText = ProxySettingsArb.getString((int)8);
        String exceptionsHintText = ProxySettingsArb.getString((int)9);
        this.radio_noProxy = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_noProxy, (String)noProxyText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.radio_noProxy, (String)"radio_noProxy");
        String systemProxyText = ProxySettingsArb.getString((int)2);
        this.radio_systemProxy = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_systemProxy, (String)systemProxyText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.radio_systemProxy, (String)"radio_systemProxy");
        String proxySettingsTooltip = SystemProxySettings.isDirectConnectionType() ? StringUtils.stripMnemonic((String)noProxyText) : (SystemProxySettings.isProxyAutoConfigurationType() ? SystemProxySettings.getSystemProxyAutoConfigUrl() : StringUtils.stripMnemonic((String)proxyHostText) + " " + SystemProxySettings.getSystemProxyHost() + ", " + StringUtils.stripMnemonic((String)proxyPortText) + " " + SystemProxySettings.getSystemProxyPort() + ", " + StringUtils.stripMnemonic((String)proxyExceptionsText) + " " + SystemProxySettings.getSystemProxyExceptions());
        this.radio_systemProxy.setToolTipText(proxySettingsTooltip);
        String autoConfigScriptText = ProxySettingsArb.getString((int)3);
        this.radio_autoConfigScript = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_autoConfigScript, (String)autoConfigScriptText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.radio_autoConfigScript, (String)"radio_autoConfigScript");
        JLabel label_script = new JLabel();
        this.textfield_autoConfigScript = new JTextField();
        String scriptText = ProxySettingsArb.getString((int)5);
        ResourceUtils.resLabel((JLabel)label_script, (Component)this.textfield_autoConfigScript, (String)scriptText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_autoConfigScript, (String)"textfield_autoConfigScript");
        String manualProxyText = ProxySettingsArb.getString((int)4);
        this.radio_manualProxy = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_manualProxy, (String)manualProxyText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.radio_manualProxy, (String)"radio_manualProxy");
        ButtonGroup proxyBtGroups = new ButtonGroup();
        proxyBtGroups.add(this.radio_noProxy);
        proxyBtGroups.add(this.radio_systemProxy);
        proxyBtGroups.add(this.radio_autoConfigScript);
        proxyBtGroups.add(this.radio_manualProxy);
        JLabel label_proxyHost = new JLabel();
        JLabel label_proxyPort = new JLabel();
        JLabel label_proxyExceptions = new JLabel();
        RichHintLabel label_exceptionsHint = new RichHintLabel();
        label_exceptionsHint.setHtmlText(exceptionsHintText);
        this.textfield_proxyHost = new JTextField();
        this.textfield_proxyPort = new WholeNumberField(8);
        this.textfield_proxyExceptions = new JTextField();
        this.textfield_proxyExceptions.setText(DEFAULT_PROXY_EXCEPTIONS);
        ResourceUtils.resLabel((JLabel)label_proxyHost, (Component)this.textfield_proxyHost, (String)proxyHostText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_proxyHost, (String)"textfield_proxyHost");
        ResourceUtils.resLabel((JLabel)label_proxyPort, (Component)this.textfield_proxyPort, (String)proxyPortText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_proxyPort, (String)"textfield_proxyPort");
        ResourceUtils.resLabel((JLabel)label_proxyExceptions, (Component)this.textfield_proxyExceptions, (String)proxyExceptionsText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_proxyExceptions, (String)"textfield_proxyExceptions");
        String useProxyAuthText = ProxySettingsArb.getString((int)10);
        this.checkbox_useProxyAuth = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxyAuth, (String)useProxyAuthText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.checkbox_useProxyAuth, (String)"checkbox_useProxyAuth");
        String proxyUserNameText = ProxySettingsArb.getString((int)11);
        String proxyPasswordText = ProxySettingsArb.getString((int)12);
        this.label_proxyUserName = new JLabel();
        this.label_proxyPassword = new JLabel();
        this.textfield_proxyUserName = new JTextField();
        this.textfield_proxyPassword = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this.label_proxyUserName, (Component)this.textfield_proxyUserName, (String)proxyUserNameText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_proxyUserName, (String)"textfield_proxyUserName");
        ResourceUtils.resLabel((JLabel)this.label_proxyPassword, (Component)this.textfield_proxyPassword, (String)proxyPasswordText);
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this.textfield_proxyPassword, (String)"textfield_proxyPassword");
        Component[] manualDependents = new Component[]{label_proxyHost, this.textfield_proxyHost, label_proxyPort, this.textfield_proxyPort, label_proxyExceptions, this.textfield_proxyExceptions, label_exceptionsHint, this.checkbox_useProxyAuth};
        new ItemSelectableTracker((ItemSelectable)this.radio_manualProxy, manualDependents);
        Component[] autoDependents = new Component[]{label_script, this.textfield_autoConfigScript};
        new ItemSelectableTracker((ItemSelectable)this.radio_autoConfigScript, autoDependents);
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent event) {
                boolean manualEnabled = ProxySettingsPanel.this.radio_manualProxy.isSelected();
                if (manualEnabled) {
                    String proxyExceptions = ProxySettingsPanel.this.textfield_proxyExceptions.getText();
                    if (!ModelUtil.hasLength((String)proxyExceptions)) {
                        proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(proxyExceptions);
                    }
                    ProxySettingsPanel.this.textfield_proxyExceptions.setText(proxyExceptions);
                }
                ProxySettingsPanel.this.updateProxyAuthFields();
            }
        };
        this.radio_noProxy.addActionListener(listener);
        this.radio_systemProxy.addActionListener(listener);
        this.radio_autoConfigScript.addActionListener(listener);
        this.radio_manualProxy.addActionListener(listener);
        this.checkbox_useProxyAuth.addActionListener(listener);
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 29, 2, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        if (!this._suppressUseProxy) {
            constraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
            this.add(this.radio_noProxy, constraints);
            constraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
            this.add(this.radio_systemProxy, constraints);
            constraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
            this.add(this.radio_autoConfigScript, constraints);
            constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
            this.add(label_script, constraints);
            constraints = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.add(this.textfield_autoConfigScript, constraints);
            constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
            this.add(this.radio_manualProxy, constraints);
        }
        constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyHost, constraints);
        constraints = new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyHost, constraints);
        constraints = new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyPort, constraints);
        constraints = new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add((Component)this.textfield_proxyPort, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 7, 3, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_exceptionsHint, constraints);
        constraints = new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 29, 2, 5), 0, 0);
        this.add(this.checkbox_useProxyAuth, constraints);
        JPanel authPanel = new JPanel();
        authPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyUserName, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyUserName, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyPassword, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyPassword, constraints);
        constraints = new GridBagConstraints(0, 10, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0);
        this.add(authPanel, constraints);
        this._testProxy = new JButton();
        this._testProxyStatus = new JLabel();
        JPanel testProxyPanel = new JPanel();
        testProxyPanel.setLayout(new BorderLayout(5, 0));
        testProxyPanel.add((Component)this._testProxy, "West");
        testProxyPanel.add((Component)this._testProxyStatus, "Center");
        constraints = new GridBagConstraints(0, 11, 4, 1, 1.0, 0.0, 17, 2, new Insets(15, 24, 0, 0), 0, 0);
        this.add(testProxyPanel, constraints);
        ResourceUtils.resButton((AbstractButton)this._testProxy, (String)BrowserArb.getString(55));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._testProxy, (String)"_testProxy");
        this._testProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProxySettingsPanel.this.startProxyTest();
            }
        });
        class ChangeListener
        implements ActionListener,
        DocumentListener {
            ChangeListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }
        }
        ChangeListener cl = new ChangeListener();
        this.radio_noProxy.addActionListener(cl);
        this.radio_systemProxy.addActionListener(cl);
        this.radio_autoConfigScript.addActionListener(cl);
        this.textfield_autoConfigScript.getDocument().addDocumentListener(cl);
        this.radio_manualProxy.addActionListener(cl);
        this.checkbox_useProxy.addActionListener(cl);
        this.checkbox_useProxyAuth.addActionListener(cl);
        this.textfield_proxyExceptions.getDocument().addDocumentListener(cl);
        this.textfield_proxyHost.getDocument().addDocumentListener(cl);
        this.textfield_proxyPassword.getDocument().addDocumentListener(cl);
        this.textfield_proxyPort.getDocument().addDocumentListener(cl);
        this.textfield_proxyUserName.getDocument().addDocumentListener(cl);
        this._warningLabel = new JLabel();
        constraints = new GridBagConstraints(0, 12, 4, 1, 1.0, 0.0, 17, 2, new Insets(20, 15, 0, 0), 0, 0);
        this.add(this._warningLabel, constraints);
        this.updateProxyAuthFields();
    }

    public void setScript(String script) {
        this.textfield_autoConfigScript.setText(script);
    }

    public void setHost(String host) {
        this.textfield_proxyHost.setText(host);
    }

    public void setPort(String port) {
        this.textfield_proxyPort.setText(port);
    }

    public void setExceptions(String exceptions) {
        this.textfield_proxyExceptions.setText(exceptions);
    }

    public void setProxyType(ProxyOptions.ProxyType proxyType) {
        if (ProxyOptions.ProxyType.SYSTEM_PROXY.equals((Object)proxyType)) {
            this.radio_systemProxy.setSelected(true);
        } else if (ProxyOptions.ProxyType.PAC.equals((Object)proxyType)) {
            this.radio_autoConfigScript.setSelected(true);
        } else if (ProxyOptions.ProxyType.MANUAL_PROXY.equals((Object)proxyType)) {
            this.radio_manualProxy.setSelected(true);
        } else {
            this.radio_noProxy.setSelected(true);
        }
    }

    public void setUseProxyAuthentication(boolean useProxyAuthentication) {
        this.checkbox_useProxyAuth.setSelected(useProxyAuthentication);
    }

    public void setUserName(String userName) {
        this.textfield_proxyUserName.setText(userName);
    }

    public void setPassword(char[] password) {
        String passwordString = new String(password);
        this.textfield_proxyPassword.setText(passwordString);
    }

    public void setAutoConfigScript(String autoConfigScript) {
        this.textfield_autoConfigScript.setText(autoConfigScript);
    }

    public String getHost() {
        return this.textfield_proxyHost.getText();
    }

    public String getPort() {
        try {
            int value = Integer.parseInt(this.textfield_proxyPort.getText());
            if (value >= 0 && value <= 65535) {
                return Integer.toString(value);
            }
            this.textfield_proxyPort.setText("");
            return "";
        }
        catch (NumberFormatException e) {
            return "";
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public String getExceptions() {
        return this.textfield_proxyExceptions.getText();
    }

    public ProxyOptions.ProxyType getProxyType() {
        if (this.radio_noProxy.isSelected()) {
            return ProxyOptions.ProxyType.DIRECT_CONNECTION;
        }
        if (this.radio_systemProxy.isSelected()) {
            return ProxyOptions.ProxyType.SYSTEM_PROXY;
        }
        if (this.radio_autoConfigScript.isSelected()) {
            return ProxyOptions.ProxyType.PAC;
        }
        return ProxyOptions.ProxyType.MANUAL_PROXY;
    }

    @Deprecated
    public boolean[] getUseProxyAndUseSystemDefaultProxy() {
        ProxyOptions.ProxyType useProxyType = this.getProxyType();
        boolean useManualProxy = false;
        boolean useSystemDefaultProxy = false;
        if (useProxyType.equals((Object)ProxyOptions.ProxyType.SYSTEM_PROXY)) {
            useSystemDefaultProxy = true;
        } else if (useProxyType.equals((Object)ProxyOptions.ProxyType.MANUAL_PROXY)) {
            useManualProxy = true;
            useSystemDefaultProxy = false;
        }
        return new boolean[]{useManualProxy, useSystemDefaultProxy};
    }

    public boolean getUseProxyAuthentication() {
        return this.checkbox_useProxyAuth.isSelected();
    }

    public String getUserName() {
        return this.textfield_proxyUserName.getText();
    }

    public char[] getPassword() {
        return this.textfield_proxyPassword.getPassword();
    }

    public String getAutoConfigScript() {
        return this.textfield_autoConfigScript.getText();
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.setHost(proxyOptions.getUnfilteredProxyHost());
        this.setPort(proxyOptions.getUnfilteredProxyPort());
        this.setProxyType(proxyOptions.getUnfilteredProxyType());
        this.setExceptions(proxyOptions.getUnfilteredProxyExceptions());
        this.setUseProxyAuthentication(ProxySettingsPanel.valueOf(proxyOptions.getUnfilteredUseProxyAuthentication()));
        this.setUserName(proxyOptions.getUnfilteredProxyUserName());
        this.setPassword(proxyOptions.getUnfilteredProxyPassword());
        this.setAutoConfigScript(proxyOptions.getUnfilteredAutoConfigScript());
    }

    private static boolean valueOf(Boolean b) {
        return b == null ? false : b;
    }

    public ProxyOptions getProxyOptions() {
        ProxyOptions po = new ProxyOptions();
        po.setProxyHost(this.getHost());
        po.setProxyPort(this.getPort());
        po.setProxyExceptions(this.getExceptions());
        po.setProxyType(this.getProxyType());
        po.setUseProxyAuthentication(this.getUseProxyAuthentication());
        po.setProxyUserName(this.getUserName());
        po.setProxyPassword(this.getPassword());
        po.setAutoConfigScript(this.getAutoConfigScript());
        return po;
    }

    public void updateProxyAuthFields() {
        boolean enabled = this.radio_manualProxy.isSelected() && this.checkbox_useProxyAuth.isSelected();
        this.label_proxyUserName.setEnabled(enabled);
        this.label_proxyPassword.setEnabled(enabled);
        this.textfield_proxyUserName.setEnabled(enabled);
        this.textfield_proxyPassword.setEnabled(enabled);
    }

    public void onEntry(TraversableContext tc) {
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        ProxyOptions.ProxyType proxyType = proxyOptions.getUnfilteredProxyType();
        Boolean useProxyAuthBoolean = proxyOptions.getUnfilteredUseProxyAuthentication();
        boolean useProxyAuth = useProxyAuthBoolean != null ? useProxyAuthBoolean : false;
        String proxyHost = proxyOptions.getUnfilteredProxyHost() != null ? proxyOptions.getUnfilteredProxyHost() : SystemProxySettings.getSystemProxyHost();
        this.setHost(proxyHost);
        String proxyPort = proxyOptions.getUnfilteredProxyPort() != null ? proxyOptions.getUnfilteredProxyPort() : SystemProxySettings.getSystemProxyPort();
        this.setPort(proxyPort);
        String proxyExceptions = proxyOptions.getUnfilteredProxyExceptions() != null ? proxyOptions.getUnfilteredProxyExceptions() : SystemProxySettings.getSystemProxyExceptions();
        this.setExceptions(proxyExceptions);
        this.setProxyType(proxyType);
        this.setUseProxyAuthentication(useProxyAuth);
        this.setUserName(proxyOptions.getUnfilteredProxyUserName());
        this.setPassword(proxyOptions.getUnfilteredProxyPassword());
        this.updateProxyAuthFields();
        this.setAutoConfigScript(proxyOptions.getUnfilteredAutoConfigScript());
        this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        if (proxyOptions.getIsIdeProxy() && !proxyOptions.isDefaultFilter()) {
            this._warningLabel.setText(ProxySettingsArb.format((int)15, (Object)proxyOptions.getFilter().getLabel()));
            this._warningLabel.setForeground(Color.RED);
            this._warningLabel.setVisible(true);
        } else {
            this._warningLabel.setVisible(false);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        String authenticationError;
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        ProxyOptions.ProxyType proxyType = this.getProxyType();
        proxyOptions.setProxyType(proxyType);
        if (proxyType.equals((Object)ProxyOptions.ProxyType.MANUAL_PROXY)) {
            if (this.getHost().contains(" ")) {
                throw new TraversalException(ProxySettingsArb.getString((int)17));
            }
            String portString = this.textfield_proxyPort.getText();
            if (ModelUtil.hasLength((String)portString)) {
                try {
                    int portNum = Integer.parseInt(portString);
                    if (portNum > 65535) {
                        throw new TraversalException(ProxySettingsArb.getString((int)18));
                    }
                }
                catch (NumberFormatException e) {
                    throw new TraversalException(ProxySettingsArb.getString((int)19));
                }
                catch (RuntimeException e) {
                    throw new TraversalException(ProxySettingsArb.getString((int)19));
                }
            }
        } else if (proxyType.equals((Object)ProxyOptions.ProxyType.PAC)) {
            String scriptString = this.textfield_autoConfigScript.getText();
            try {
                URL e = new URL(scriptString);
            }
            catch (MalformedURLException ex) {
                throw new TraversalException(ProxySettingsArb.getString((int)20));
            }
        }
        proxyOptions.setProxyHost(this.getHost());
        proxyOptions.setProxyExceptions(ProxyOptions.normalizeExceptions(this.getExceptions()));
        proxyOptions.setProxyPort(this.getPort());
        proxyOptions.setUseProxyAuthentication(this.getUseProxyAuthentication());
        proxyOptions.setProxyUserName(this.getUserName());
        proxyOptions.setProxyPassword(this.getPassword());
        proxyOptions.setAutoConfigScript(this.getAutoConfigScript());
        if (proxyType.equals((Object)ProxyOptions.ProxyType.MANUAL_PROXY) && (authenticationError = this.authenticationIsValid(proxyOptions)) != null) {
            throw new TraversalException(authenticationError);
        }
        if (proxyOptions.getIsIdeProxy() && !proxyOptions.isDefaultFilter()) {
            MessageDialog.optionalInformation((String)"oracle.ide.webbrowser.ProxySettingsPanel", (Component)((Object)this), (Object)ProxySettingsArb.format((int)15, (Object)proxyOptions.getFilter().getLabel()), (String)ProxySettingsArb.getString((int)16), null);
        }
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private ProxyOptions findProxyOptions(TraversableContext tc) {
        return ProxyOptions.getInstance(tc.getPropertyStorage());
    }

    private void setProxyTestProgress(final URL url) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ProxySettingsPanel.this._testProxyStatus.setText(BrowserArb.format(57, url.getProtocol(), url.getHost()));
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void setProxyTestStatus(final ProxyTestStatus status) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (status == ProxyTestStatus.NOT_STARTED) {
                    ProxySettingsPanel.this._testProxyStatus.setVisible(false);
                    ProxySettingsPanel.this._testProxy.setToolTipText(null);
                } else {
                    Icon icon = null;
                    String label = null;
                    String buttonToolTip = null;
                    switch (status) {
                        case TESTING: {
                            icon = OracleIcons.getIcon((String)"throbber.gif");
                            label = BrowserArb.getString(56);
                            break;
                        }
                        case SUCCESSFUL: {
                            icon = OracleIcons.getIcon((String)"check.png");
                            label = BrowserArb.getString(58);
                            buttonToolTip = BrowserArb.getString(60);
                            break;
                        }
                        case FAILED: {
                            icon = OracleIcons.getIcon((String)"error.png");
                            label = BrowserArb.getString(59);
                            buttonToolTip = BrowserArb.getString(61);
                        }
                    }
                    ProxySettingsPanel.this._testProxyStatus.setVisible(true);
                    ProxySettingsPanel.this._testProxyStatus.setIcon(icon);
                    ProxySettingsPanel.this._testProxyStatus.setText(label);
                    ProxySettingsPanel.this._testProxy.setToolTipText(buttonToolTip);
                }
                ProxySettingsPanel.this._testProxy.setEnabled(status != ProxyTestStatus.TESTING);
                ProxySettingsPanel.this.revalidate();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void resetProxyTest() {
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private String authenticationIsValid(ProxyOptions options) {
        if (!this.getUseProxyAuthentication()) {
            return null;
        }
        String proxyUserName = options.getProxyUserName();
        char[] proxyPassword = options.getProxyPassword();
        String string = proxyUserName = proxyUserName != null ? proxyUserName.trim() : "";
        if (proxyUserName.length() == 0) {
            return ProxySettingsArb.getString((int)21);
        }
        if (proxyPassword == null || !this.isNonEmpty(proxyPassword)) {
            return ProxySettingsArb.getString((int)22);
        }
        return null;
    }

    private boolean isNonEmpty(char[] buffer) {
        int st;
        int len = buffer.length;
        for (st = 0; st < len && buffer[st] <= ' '; ++st) {
        }
        while (st < len && buffer[len - 1] <= ' ') {
            --len;
        }
        return st < len;
    }

    private void startProxyTest() {
        String authenticationError;
        final ProxyOptions options = this.getProxyOptions();
        ProxyOptions.ProxyType proxyType = this.getProxyType();
        if (proxyType.equals((Object)ProxyOptions.ProxyType.PAC)) {
            String scriptString = this.textfield_autoConfigScript.getText();
            try {
                URL uRL = new URL(scriptString);
            }
            catch (MalformedURLException ex) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProxySettingsArb.getString((int)20), (String)BrowserArb.getString(68), null);
                return;
            }
        }
        if (proxyType.equals((Object)ProxyOptions.ProxyType.MANUAL_PROXY) && (authenticationError = this.authenticationIsValid(options)) != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)authenticationError, (String)BrowserArb.getString(66), null);
            return;
        }
        this.setProxyTestStatus(ProxyTestStatus.TESTING);
        Runnable testRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProxySettingsPanel proxySettingsPanel = ProxySettingsPanel.this;
                synchronized (proxySettingsPanel) {
                    ProxyTestStatus newStatus = ProxyTestStatus.NOT_STARTED;
                    try {
                        URL[] urls;
                        for (URL url : urls = new URL[]{URLFactory.newURL((String)"http://www.internic.net"), URLFactory.newURL((String)"http://www.oracle.com"), URLFactory.newURL((String)"http://download.oracle.com")}) {
                            ProxySettingsPanel.this.setProxyTestProgress(url);
                            String pingTimeout = System.getProperty("oracle.ide.webbrowser.proxyTestTimeout");
                            if (pingTimeout == null) {
                                new HttpPing(options, url).ping();
                            } else {
                                new HttpPing(options, url, Integer.valueOf(pingTimeout)).ping();
                            }
                            if (!Thread.interrupted()) continue;
                            return;
                        }
                        newStatus = ProxyTestStatus.SUCCESSFUL;
                    }
                    catch (HttpPing.PingFailedException failure) {
                        if (!Thread.interrupted()) {
                            newStatus = ProxyTestStatus.FAILED;
                            ProxySettingsPanel.this.displayProxyTestFailure(failure);
                        }
                    }
                    finally {
                        ProxySettingsPanel.this.setProxyTestStatus(newStatus);
                    }
                }
            }
        };
        this._testThread = new Thread(testRunnable, BrowserArb.getString(65));
        this._testThread.setPriority(1);
        this._testThread.start();
    }

    private void displayProxyTestFailure(final HttpPing.PingFailedException failure) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)ProxySettingsPanel.this), (String)StringUtils.stripMnemonic((String)ProxySettingsArb.getString((int)13)), (int)16);
                final MessagePanel p = new MessagePanel();
                p.setTitle(failure.getMessage());
                p.setMessageText(failure.getDetails());
                p.setMessageType(3);
                AbstractAction details = new AbstractAction(ProxySettingsArb.getString((int)14)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProxySettingsPanel.this.displayProxyTestDetails((Component)p, failure);
                        jd.closeDialog(false);
                    }
                };
                p.addHyperAction((Action)details);
                jd.setContent((Component)p);
                jd.runDialog();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void displayProxyTestDetails(Component parent, HttpPing.PingFailedException failure) {
        JTextArea a = new JTextArea();
        a.setLineWrap(true);
        a.setWrapStyleWord(true);
        a.setRows(22);
        a.setColumns(70);
        a.setEditable(false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (failure.getHttpResponseCode() == -1) {
            sw.append(BrowserArb.getString(62));
        } else {
            sw.append(BrowserArb.format(63, String.valueOf(failure.getHttpResponseCode()) + " " + failure.getHttpResponseMessage()));
        }
        sw.append("\n\n");
        if (failure.getCause() != null) {
            failure.getCause().printStackTrace(pw);
        }
        pw.close();
        a.setText(sw.toString());
        a.setCaretPosition(0);
        JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)BrowserArb.getString(64), (int)16);
        jd.setContent((Component)new JScrollPane(a));
        jd.runDialog();
    }

    public void apply(ApplyEvent e) {
        this.resetProxyTest();
    }

    public void cancel(ApplyEvent e) {
        this.resetProxyTest();
    }

    private static enum ProxyTestStatus {
        NOT_STARTED,
        TESTING,
        SUCCESSFUL,
        FAILED;

    }
}

