/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.saveactions;

import oracle.ideimpl.ceditor.saveactions.SaveActionsHook;
import oracle.javatools.data.HashStructure;

public class SaveActionDescription {
    private static final String EXECUTE_BY_DEFAULT = "execute-by-default";
    private static final String EXECUTE_BEFORE_SAVE = "execute-before-save";
    private static final String ID = "id";
    private String extensionId;
    private String id;
    private boolean executeByDefault;
    private boolean executeBeforeSave;

    SaveActionDescription(String extensionId, HashStructure hash) {
        this.extensionId = extensionId;
        this.id = hash.getString(ID);
        if (this.id == null) {
            SaveActionsHook.logError("Missing 'id' attribute", extensionId);
        }
        this.executeByDefault = this.getBoolean(hash, EXECUTE_BY_DEFAULT, false);
        this.executeBeforeSave = this.getBoolean(hash, EXECUTE_BEFORE_SAVE, false);
    }

    SaveActionDescription(String extensionId, String id, boolean executeByDefault, boolean executeBeforeSave) {
        this.extensionId = extensionId;
        this.id = id;
        this.executeByDefault = executeByDefault;
        this.executeBeforeSave = executeBeforeSave;
    }

    public String getId() {
        return this.id;
    }

    public boolean getExecuteByDefault() {
        return this.executeByDefault;
    }

    public void setExecuteByDefault(boolean executeByDefault) {
        this.executeByDefault = executeByDefault;
    }

    public boolean getExecuteBeforeSave() {
        return this.executeBeforeSave;
    }

    private boolean getBoolean(HashStructure hash, String name, boolean defaultValue) {
        if (hash.keyStatus(name) == 0) {
            SaveActionsHook.logError("Missing '" + name + "' attribute", this.extensionId);
        }
        return hash.getBoolean(name, defaultValue);
    }
}

