/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.panels.ColumnPanel;
import oracle.dbtools.raptor.extract.ui.panels.PredicatePanel;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopPartitionPanel;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class BDACopySinglePredicatePage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private HadoopProperties _hProps;
    private JTextPane _instructions;
    private PredicatePanel _predicatePanel;
    private ColumnPanel _columnPanel;
    private TreeCellCheckedListener _columnCheckedListener;
    private HadoopPartitionPanel _partitionPanel;
    private TreeCellCheckedListener _partitionCheckedListener;
    private JTabbedPane _tabbedPane;
    TraversableContext _ctx;
    private boolean _init = false;
    private boolean _isPartitioned;
    private boolean _isExistingTable;
    private boolean _isStagingMethod;
    private DBObject _dbo;
    private ExtractObject _eo;
    private int _loadMethod = -1;

    public void onEntry(TraversableContext traversableContext) {
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._ctx = traversableContext;
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        DBObject dBObject = this._dbo;
        this._eo = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
        this._dbo = this._eo.getDBObject();
        if (this._loadMethod != this._hProps.getValueInteger(ImportKeys.LOAD_METHOD)) {
            this._init = false;
        }
        this._loadMethod = this._hProps.getValueInteger(ImportKeys.LOAD_METHOD);
        this._isStagingMethod = this._hProps.get(ImportKeys.LOAD_METHOD).equals(3);
        this._isPartitioned = this._isStagingMethod && HadoopUtils.isTablePartitioned(this._dbo);
        this._isExistingTable = (Boolean)this._hProps.get(ImportKeys.IS_EXISTING_TABLE);
        if (!this._init || !this._dbo.checkQualifiedNameEquals(dBObject)) {
            this.build();
            this._init = true;
        }
    }

    private void build() {
        this.removeAll();
        String string = this._dbo.getSchemaName() + "." + this._dbo.getObjectName();
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        if (this._isExistingTable) {
            if (this._isPartitioned) {
                this._instructions.setText(HadoopWizArb.format("COPY_BDA_WHEREX_PART_INSTRUCTIONS", string));
            } else {
                this._instructions.setText(HadoopWizArb.format("COPY_BDA_WHEREX_NOTPART_INSTRUCTIONS", string));
            }
        } else if (this._isPartitioned) {
            this._instructions.setText(HadoopWizArb.format("COPY_BDA_WHERE_PART_INSTRUCTIONS", string));
        } else {
            this._instructions.setText(HadoopWizArb.format("COPY_BDA_WHERE_NOTPART_INSTRUCTIONS", string));
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this._instructions, "North");
        JLabel jLabel = new JLabel(HadoopWizArb.format("SOURCE_OBJECT", string));
        this._tabbedPane = new JTabbedPane();
        if (!this._isExistingTable) {
            this._columnPanel = new ColumnPanel(this._eo, this._eo.getColumns());
            this._columnCheckedListener = new TreeCellCheckedListener(){

                public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
                    BDACopySinglePredicatePage.this._eo.setColumns(BDACopySinglePredicatePage.this._columnPanel.getSelectedColumns());
                    BDACopySinglePredicatePage.this._predicatePanel.setSQL(BDACopySinglePredicatePage.this._eo.getSqlForVisibleCols());
                }

                public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
                    BDACopySinglePredicatePage.this._eo.setColumns(BDACopySinglePredicatePage.this._columnPanel.getSelectedColumns());
                    BDACopySinglePredicatePage.this._predicatePanel.setSQL(BDACopySinglePredicatePage.this._eo.getSqlForVisibleCols());
                }
            };
            this._columnPanel.addTreeCellCheckedListener(this._columnCheckedListener);
            this._columnPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
            this._tabbedPane.add(HadoopWizArb.getString("COLUMN_TAB"), (Component)this._columnPanel);
        }
        if (this._isPartitioned) {
            this._partitionPanel = new HadoopPartitionPanel(this._eo, this._eo.getPartitions());
            this._partitionCheckedListener = new TreeCellCheckedListener(){

                public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
                    BDACopySinglePredicatePage.this._eo.setPartitions(BDACopySinglePredicatePage.this._partitionPanel.getSelectedPartitions());
                    BDACopySinglePredicatePage.this._predicatePanel.setPartitions(BDACopySinglePredicatePage.this._eo.getPartitions());
                }

                public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
                    BDACopySinglePredicatePage.this._eo.setPartitions(BDACopySinglePredicatePage.this._partitionPanel.getSelectedPartitions());
                    BDACopySinglePredicatePage.this._predicatePanel.setPartitions(BDACopySinglePredicatePage.this._eo.getPartitions());
                }
            };
            this._partitionPanel.addTreeCellCheckedListener(this._partitionCheckedListener);
            this._partitionPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
            this._tabbedPane.add(HadoopWizArb.getString("PARTITION_TAB"), this._partitionPanel);
        }
        this._predicatePanel = new PredicatePanel((ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT), "", false);
        this._predicatePanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._predicatePanel, "f1_idedexporttabledata_html");
        this._predicatePanel.setVerticalDisplay(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("WHERE")));
        jPanel3.add((Component)this._predicatePanel, "Center");
        jPanel2.add((Component)jPanel3, "Center");
        this.setLayout(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        if (this._partitionPanel != null || this._columnPanel != null) {
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setTopComponent(this._tabbedPane);
            jSplitPane.setBottomComponent(jPanel2);
            jSplitPane.setOneTouchExpandable(false);
            jSplitPane.setDividerSize(3);
            jSplitPane.setDividerLocation(200);
            jPanel4.add((Component)jSplitPane, "Center");
        } else {
            jPanel4.add((Component)jPanel2, "Center");
        }
        int n = 0;
        this.add(jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add(jPanel4, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.8, 18, 1, new Insets(8, 0, 0, 0), 0, 0));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            boolean bl = this._hProps.get(ImportKeys.LOAD_METHOD).equals(3);
            if (this._eo.getColumns() == null || this._eo.getColumns().isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("COLUMN_REQ"));
            }
            if (this._partitionPanel != null && this._partitionPanel.getSelectedPartitions().isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("PART_REQ"));
            }
            if (this._predicatePanel.isDirty()) {
                throw new TraversalException(HadoopWizArb.getString("DIRTY"));
            }
            if (this._predicatePanel.getRowCount() < 1) {
                throw new TraversalException(HadoopWizArb.getString("NO_DATA"));
            }
            this._eo.setWhere(this._predicatePanel.getPredicate());
            this._hProps.put(HadoopKeys.WHERE, bl ? this._predicatePanel.getPredicate() : this._predicatePanel.getPredicate(false));
        }
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return this._hProps.get(ImportKeys.LOAD_METHOD).equals(3) ? "Fin" : "F";
    }
}

