/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.dbtools.listener.nosql.NoSQLConstants;
import oracle.dbtools.listener.nosql.NoSQLUtils;
import oracle.dbtools.listener.nosql.ui.NoSQLHostPortPanel;
import oracle.dbtools.listener.nosql.ui.NoSQLRolesPanel;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.listener.utils.ListenerUtils;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class NoSQLStorePanel
extends JPanel {
    private static final WildcardURLFilter CLIENT_SECURITY_FILE_FILTER = new WildcardURLFilter("client.security", URLFileSystem.isLocalFileSystemCaseSensitive(), ListenerArb.getString("NOSQL_CLIENT_SECURITY_FILE"));
    private static final WildcardURLFilter CLIENT_SECURITY_TRUST_FILTER = new WildcardURLFilter("client.trust", URLFileSystem.isLocalFileSystemCaseSensitive(), ListenerArb.getString("NOSQL_CLIENT_TRUST_FILE"));
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 1000;
    private JTextField m_storeName = new JTextField();
    private JTextField m_storeAlias = new JTextField();
    private NumericSpinBox m_maxItemsPerPage = new NumericSpinBox(1, 1000);
    private NoSQLHostPortPanel m_hostPortPanel = new NoSQLHostPortPanel();
    private NoSQLRolesPanel m_rolePanel = new NoSQLRolesPanel();
    private JCheckBox m_secureCB;
    private JRadioButton m_passwdBtn;
    private JRadioButton m_walletBtn;
    private JTabbedPane tabs;
    private JTextField m_username;
    private JPasswordField m_password;
    private JPasswordField m_confirmPassword;
    private JTextField m_walletDir;
    private JTextField m_clientSecurityFile;
    private JTextField m_clientTrustFile;
    private JButton m_browseSecFileBtn;
    private JButton m_browseSecTrustBtn;
    private JButton m_browseWalletBtn;
    private NoSQLStoreConfig m_config = new NoSQLStoreConfig();
    private File m_storeDir;
    private StringBuilder errMsg;
    private boolean includeSecureStoreTab = true;

    public NoSQLStorePanel() {
        this.init();
        this.build();
    }

    public NoSQLStorePanel(boolean bl) {
        this.includeSecureStoreTab = bl;
        this.init();
        this.m_hostPortPanel.addRow("localhost", 5000);
        this.m_storeName.setText("kvstore");
    }

    private void init() {
        this.m_maxItemsPerPage.setIntValue(25);
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.getNoSQLStoreConfigPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)this.getSecureStorePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.tabs = new JTabbedPane();
        this.tabs.addTab(ListenerArb.getString("NOSQL_STORE_CONFIG"), jPanel);
        this.tabs.addTab(ListenerArb.getString("NOSQL_SECURE2"), jPanel2);
        int n = 0;
        this.add((Component)this.tabs, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)this, (int)(++n));
    }

    public JPanel getNoSQLStoreConfigPanel() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_storeName, (String)this.labelWithColon(ListenerArb.getString("NOSQL_STORE_NAME")));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_storeAlias, (String)this.labelWithColon(ListenerArb.getString("NOSQL_STORE_ALIAS")));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_maxItemsPerPage, (String)this.labelWithColon(ListenerArb.getString("NOSQL_MAX_ITEMS_PER_PAGE")));
        jLabel.setDisplayedMnemonic(78);
        jLabel2.setDisplayedMnemonic(65);
        jLabel3.setDisplayedMnemonic(77);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(ListenerArb.getString("NOSQL_STORE_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_storeAlias, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_storeName, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring20((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        n = 0;
        jPanel2.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_maxItemsPerPage, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        n = 0;
        jPanel3.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this.m_hostPortPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.5, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_rolePanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.5, 23, 1, new Insets(3, 0, 10, 0), 0, 0));
        jPanel3.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        return jPanel3;
    }

    public JPanel getSecureStorePanel() {
        this.m_secureCB = new JCheckBox();
        this.m_username = new JTextField();
        this.m_passwdBtn = new JRadioButton();
        this.m_walletBtn = new JRadioButton();
        this.m_password = new JPasswordField();
        this.m_confirmPassword = new JPasswordField();
        this.m_walletDir = new JTextField();
        this.m_clientSecurityFile = new JTextField();
        this.m_clientTrustFile = new JTextField();
        this.m_browseSecFileBtn = new JButton();
        this.m_browseSecTrustBtn = new JButton();
        this.m_browseWalletBtn = new JButton();
        this.m_secureCB.setSelected(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_walletBtn);
        buttonGroup.add(this.m_passwdBtn);
        this.m_walletBtn.setSelected(true);
        this.m_password.setEnabled(false);
        this.m_confirmPassword.setEnabled(false);
        this.m_clientSecurityFile.setEditable(false);
        this.m_clientSecurityFile.setFocusable(false);
        this.m_clientTrustFile.setEditable(false);
        this.m_clientTrustFile.setFocusable(false);
        this.m_walletDir.setEditable(false);
        this.m_walletDir.setFocusable(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_secureCB, (String)ListenerArb.getString("NOSQL_SECURE2"));
        ResourceUtils.resButton((AbstractButton)this.m_walletBtn, (String)this.labelWithColon(ListenerArb.getString("NOSQL_WALLET_DIR")));
        ResourceUtils.resButton((AbstractButton)this.m_passwdBtn, (String)ListenerArb.getString("PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.m_browseWalletBtn, (String)ImpExpResources.getString((String)"BROWSE_BUTTON"));
        ResourceUtils.resButton((AbstractButton)this.m_browseSecFileBtn, (String)ImpExpResources.getString((String)"BROWSE_BUTTON"));
        ResourceUtils.resButton((AbstractButton)this.m_browseSecTrustBtn, (String)ImpExpResources.getString((String)"BROWSE_BUTTON"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_username, (String)ListenerArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_confirmPassword, (String)ListenerArb.getString("CONFIRM_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_clientSecurityFile, (String)this.labelWithColon(ListenerArb.getString("NOSQL_CLIENT_SECURITY_FILE")));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_clientTrustFile, (String)this.labelWithColon(ListenerArb.getString("NOSQL_CLIENT_TRUST_FILE")));
        this.m_secureCB.setMnemonic(83);
        this.m_browseSecTrustBtn.setMnemonic(82);
        this.m_browseWalletBtn.setMnemonic(79);
        this.m_walletBtn.setMnemonic(87);
        jLabel2.setDisplayedMnemonic(70);
        jLabel3.setDisplayedMnemonic(84);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.m_secureCB, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_clientSecurityFile, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_browseSecFileBtn, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_clientTrustFile, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_browseSecTrustBtn, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_username, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_walletBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_walletDir, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_browseWalletBtn, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel.add((Component)this.m_passwdBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_password, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_confirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_confirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        this.addListeners();
        this.enableDisableSecureFields();
        return jPanel;
    }

    private void addListeners() {
        this.m_secureCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NoSQLStorePanel.this.enableDisableSecureFields();
            }
        });
        this.m_walletBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = NoSQLStorePanel.this.m_walletBtn.isSelected();
                NoSQLStorePanel.this.m_walletDir.setEnabled(bl);
                NoSQLStorePanel.this.m_browseWalletBtn.setEnabled(bl);
                NoSQLStorePanel.this.m_password.setEnabled(!bl);
                NoSQLStorePanel.this.m_confirmPassword.setEnabled(!bl);
            }
        });
        this.m_passwdBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = NoSQLStorePanel.this.m_passwdBtn.isSelected();
                NoSQLStorePanel.this.m_walletDir.setEnabled(!bl);
                NoSQLStorePanel.this.m_browseWalletBtn.setEnabled(!bl);
                NoSQLStorePanel.this.m_password.setEnabled(bl);
                NoSQLStorePanel.this.m_confirmPassword.setEnabled(bl);
            }
        });
        this.m_browseSecFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = NoSQLStorePanel.this.selectFile(CLIENT_SECURITY_FILE_FILTER, ListenerArb.getString("NOSQL_CLIENT_SECURITY_FILE"));
                if (file != null) {
                    try {
                        File file2 = NoSQLStorePanel.this.getStoreFile("client.security");
                        if (file2.exists()) {
                            ListenerUtils.delete(file2);
                        }
                        ListenerUtils.copy(file, file2);
                        NoSQLStorePanel.this.m_clientSecurityFile.setText(file.getPath());
                        NoSQLStorePanel.this.extractUsername(file2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Logger.warn(this.getClass(), (String)exception.getLocalizedMessage());
                        NoSQLStorePanel.this.showError("NOSQL_CLIENT_SECURITY_FILE", exception.getLocalizedMessage());
                    }
                }
            }
        });
        this.m_browseSecTrustBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = NoSQLStorePanel.this.selectFile(CLIENT_SECURITY_TRUST_FILTER, ListenerArb.getString("NOSQL_CLIENT_TRUST_FILE"));
                if (file != null) {
                    try {
                        File file2 = NoSQLStorePanel.this.getStoreFile("client.trust");
                        if (file2.exists()) {
                            ListenerUtils.delete(file2);
                        }
                        ListenerUtils.copy(file, file2);
                        NoSQLStorePanel.this.m_clientTrustFile.setText(file.getPath());
                    }
                    catch (IOException iOException) {
                        Logger.warn(this.getClass(), (Throwable)iOException);
                        NoSQLStorePanel.this.showError("NOSQL_CLIENT_TRUST_FILE", iOException.getLocalizedMessage());
                    }
                }
            }
        });
        this.m_browseWalletBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = NoSQLStorePanel.this.selectDirectory(ListenerArb.getString("NOSQL_WALLET_DIR"));
                if (file != null) {
                    try {
                        File file2 = NoSQLStorePanel.this.getStoreFile("wallet");
                        if (file2.exists()) {
                            ListenerUtils.delete(file2);
                        }
                        ListenerUtils.copy(file, file2);
                        NoSQLStorePanel.this.m_walletDir.setText(file.getPath());
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                        NoSQLStorePanel.this.showError("NOSQL_WALLET_DIR", exception.getLocalizedMessage());
                    }
                }
            }
        });
    }

    protected void extractUsername(File file) {
        try {
            Properties properties = NoSQLUtils.getProperties(file);
            String string = properties.getProperty("oracle.kv.auth.username");
            if (this.hasValue(string)) {
                this.m_username.setText(string);
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private void enableDisableSecureFields() {
        boolean bl = this.m_secureCB.isSelected();
        this.m_username.setEnabled(bl);
        if (this.m_config.getStoreMode() == NoSQLConstants.StoreMode.ADD || this.m_config.getStoreMode() == NoSQLConstants.StoreMode.UPDATE && !this.m_config.isOrigSecureStore()) {
            this.m_passwdBtn.setEnabled(bl);
            this.m_clientSecurityFile.setEnabled(bl);
            this.m_clientTrustFile.setEnabled(bl);
            this.m_walletBtn.setEnabled(bl);
            this.m_browseSecFileBtn.setEnabled(bl);
            this.m_browseSecTrustBtn.setEnabled(bl);
            if (bl) {
                boolean bl2 = this.m_walletBtn.isSelected();
                this.m_walletDir.setEnabled(bl2);
                this.m_browseWalletBtn.setEnabled(bl2);
                this.m_password.setEnabled(!bl2);
                this.m_confirmPassword.setEnabled(!bl2);
            } else {
                this.m_walletDir.setEnabled(bl);
                this.m_browseWalletBtn.setEnabled(bl);
                this.m_password.setEnabled(bl);
                this.m_confirmPassword.setEnabled(bl);
            }
        }
    }

    private File selectDirectory(String string) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(1);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        uRLFileChooser.setCheckIfFileExists(true);
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), string);
        if (n == 0) {
            return uRLFileChooser.getSelectedFile();
        }
        return null;
    }

    private File selectFile(WildcardURLFilter wildcardURLFilter, String string) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        uRLFileChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        uRLFileChooser.setCheckIfFileExists(true);
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), string);
        if (n == 0) {
            return uRLFileChooser.getSelectedFile().getAbsoluteFile();
        }
        return null;
    }

    private File getStoreFile(String string) {
        String string2 = this.getStoreDir() + File.separator + string;
        File file = new File(string2);
        return file;
    }

    private File getStoreDir() {
        if (this.m_storeDir == null) {
            this.m_storeDir = new File(this.m_config.getStorePath());
        }
        return this.m_storeDir;
    }

    private String labelWithColon(String string) {
        return string + ListenerArb.getString("COLON");
    }

    private boolean hasValue(String string) {
        return string != null && string.trim().length() > 0;
    }

    private void initErrorMessage() {
        if (this.errMsg == null) {
            this.errMsg = new StringBuilder();
        } else if (this.errMsg.length() > 0) {
            this.errMsg.delete(0, this.errMsg.length());
        }
    }

    private void addErrorMsg(String string) {
        this.errMsg.append(string).append("\n");
    }

    private void showErrors(String string) {
        if (this.errMsg != null && this.errMsg.length() > 0) {
            MessageDialog.error((Component)this, (Object)this.errMsg.toString(), (String)ListenerArb.format("ERROR_TITLE", string), null);
        }
    }

    private void showError(String string, String string2) {
        MessageDialog.error((Component)this, (Object)string2, (String)ListenerArb.format("ERROR_TITLE", ListenerArb.getString(string)), null);
    }

    private boolean isAllWhiteSpace(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            for (char c : cArray) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validatePasswords() {
        String string = this.m_username.getText();
        if (this.m_password != null && this.m_password.getPassword().length > 0 && this.m_confirmPassword != null && this.m_confirmPassword.getPassword().length > 0) {
            if (!this.isAllWhiteSpace(this.m_password.getPassword())) {
                if (!this.isAllWhiteSpace(this.m_confirmPassword.getPassword())) {
                    if (Arrays.equals(this.m_password.getPassword(), this.m_confirmPassword.getPassword())) {
                        return true;
                    }
                    if (this.errMsg.length() == 0) {
                        this.m_password.requestFocus();
                    }
                    this.addErrorMsg(ListenerArb.format("ERROR_TRY_AGAIN_PASSWORD", string));
                } else {
                    if (this.errMsg.length() == 0) {
                        this.m_confirmPassword.requestFocus();
                    }
                    this.addErrorMsg(ListenerArb.getString("ERROR_CONFIRM_PWD_EMPTY"));
                }
            } else {
                if (this.errMsg.length() == 0) {
                    this.m_password.requestFocus();
                }
                this.addErrorMsg(ListenerArb.getString("ERROR_PWD_EMPTY"));
            }
        } else {
            if (this.m_password == null || this.m_password.getPassword().length == 0) {
                if (this.errMsg.length() == 0) {
                    this.m_password.requestFocus();
                }
                this.addErrorMsg(ListenerArb.format("ERROR_MISSING_PASSWORD", string));
            }
            if (this.m_confirmPassword == null || this.m_confirmPassword.getPassword().length == 0) {
                if (this.errMsg.length() == 0) {
                    this.m_confirmPassword.requestFocus();
                }
                this.addErrorMsg(ListenerArb.format("ERROR_MISSING_CONFIRM_PASSWORD", string));
            }
        }
        return this.errMsg.length() <= 0;
    }

    public String getStoreAliasName() {
        return this.m_storeAlias.getName();
    }

    public String getStorePath() {
        return this.m_config.getStorePath();
    }

    public void assignValues(NoSQLStoreConfig noSQLStoreConfig) {
        if (noSQLStoreConfig != null) {
            String string;
            this.m_config = noSQLStoreConfig;
            this.m_storeAlias.setText(noSQLStoreConfig.getStoreAlias());
            if (noSQLStoreConfig.getId() != 0) {
                this.m_storeAlias.setEditable(false);
                this.m_storeAlias.setFocusable(false);
            }
            this.m_storeName.setText(noSQLStoreConfig.getStoreName());
            this.m_maxItemsPerPage.setValue((Number)noSQLStoreConfig.getMaxItems());
            this.m_hostPortPanel.addHostPorts(noSQLStoreConfig.getHostPortList());
            this.m_rolePanel.addRoles(noSQLStoreConfig.getRolesList());
            if (noSQLStoreConfig.isSecureStore()) {
                this.m_secureCB.setSelected(true);
                this.m_username.setText(noSQLStoreConfig.getUsername());
                if (this.hasValue(noSQLStoreConfig.getWalletDirectory())) {
                    this.m_walletDir.setText(noSQLStoreConfig.getWalletDirectory());
                    this.m_walletBtn.setSelected(true);
                } else if (this.hasValue(noSQLStoreConfig.getPassword())) {
                    string = noSQLStoreConfig.getPassword();
                    this.m_password.setText(Passwords.comingIn((String)string));
                    this.m_passwdBtn.setSelected(true);
                }
                this.m_clientSecurityFile.setText(noSQLStoreConfig.getClientSecurityFile());
                this.m_clientTrustFile.setText(noSQLStoreConfig.getClientTrustFile());
            }
            if (noSQLStoreConfig.getStoreMode() == NoSQLConstants.StoreMode.UPDATE && noSQLStoreConfig.isOrigSecureStore()) {
                this.m_browseSecFileBtn.setEnabled(false);
                this.m_browseSecTrustBtn.setEnabled(false);
                this.m_browseWalletBtn.setEnabled(false);
                this.m_walletBtn.setEnabled(false);
                this.m_walletDir.setEnabled(false);
                this.m_passwdBtn.setEnabled(false);
                this.m_password.setEnabled(false);
                this.m_confirmPassword.setEnabled(false);
                string = noSQLStoreConfig.getClientTrustFile();
                String string2 = "";
                if (this.hasValue(string)) {
                    int n = -1;
                    if (string.contains("/")) {
                        n = string.lastIndexOf("/");
                    } else if (string.contains("\\")) {
                        n = string.lastIndexOf("\\");
                    }
                    if (n != -1) {
                        string2 = string.substring(0, n + 1);
                    }
                    string2 = string2 + "client.security";
                    this.m_clientSecurityFile.setText(string2);
                }
                this.m_clientSecurityFile.setEnabled(false);
                this.m_clientTrustFile.setEnabled(false);
            }
        }
    }

    public NoSQLStoreConfig getValues() {
        this.m_config.setStoreName(this.m_storeName.getText());
        this.m_config.setStoreAlias(this.m_storeAlias.getText());
        this.m_config.setMaxItems(this.m_maxItemsPerPage.getIntValue());
        this.m_config.setHostPortList(this.m_hostPortPanel.getHostColonPortList());
        this.m_config.setRolesList(this.m_rolePanel.getRoleList());
        if (this.includeSecureStoreTab) {
            this.m_config.setSecureStore(this.m_secureCB.isSelected());
            if (this.m_secureCB.isSelected()) {
                this.m_config.setUsername(this.m_username.getText());
                if (this.m_walletBtn.isSelected()) {
                    this.m_config.setWalletDir(this.m_walletDir.getText());
                    this.m_config.setPassword(null);
                } else {
                    this.m_config.setPassword(Passwords.goingOut((String)String.valueOf(this.m_password.getPassword())));
                    this.m_config.setWalletDir(null);
                }
                this.m_config.setClientSecurityFile(this.m_clientSecurityFile.getText());
                this.m_config.setClientTrustFile(this.m_clientTrustFile.getText());
            } else {
                this.m_config.setUsername(null);
                this.m_config.setWalletDir(null);
                this.m_config.setPassword(null);
                this.m_config.setClientSecurityFile(null);
                this.m_config.setClientTrustFile(null);
            }
        }
        return this.m_config;
    }

    private boolean validateValues() {
        if (this.m_config.getId() == 0) {
            if (!this.hasValue(this.m_storeAlias.getText())) {
                this.m_storeAlias.requestFocus();
                this.addErrorMsg(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_STORE_ALIAS"), ListenerArb.getString("NOSQL_STORE_ALIAS")));
            } else if (ListenerPanel.getInstance().isDuplicateNoSQLStore(0, this.m_storeAlias.getText())) {
                this.addErrorMsg(ListenerArb.format("NOSQL_ERR_DUPLICATE_STORE", this.m_storeAlias.getText()));
            }
        }
        if (!this.hasValue(this.m_storeName.getText())) {
            if (this.errMsg.length() == 0) {
                this.m_storeName.requestFocus();
            }
            this.addErrorMsg(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_STORE_NAME"), ListenerArb.getString("NOSQL_STORE_NAME")));
        }
        if (!this.m_hostPortPanel.validateInfo()) {
            this.addErrorMsg(this.m_hostPortPanel.getErrorMessages());
        }
        if (this.errMsg.length() > 0) {
            if (this.tabs != null && this.tabs.getSelectedIndex() != 0) {
                this.tabs.setSelectedIndex(0);
            }
            return false;
        }
        if (this.includeSecureStoreTab && this.m_secureCB.isSelected()) {
            if (this.m_config.getStoreMode() == NoSQLConstants.StoreMode.UPDATE && this.m_config.isOrigSecureStore()) {
                if (!this.hasValue(this.m_username.getText())) {
                    if (this.errMsg.length() == 0) {
                        this.m_username.requestFocus();
                    }
                    this.addErrorMsg(ListenerArb.getString("ERROR_USERNAME_MISSING"));
                }
            } else {
                File file;
                if (!this.hasValue(this.m_clientSecurityFile.getText())) {
                    this.addErrorMsg(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_CLIENT_SECURITY_FILE"), ListenerArb.getString("NOSQL_CLIENT_SECURITY_FILE")));
                } else {
                    file = new File(this.m_clientSecurityFile.getText());
                    if (!file.exists()) {
                        this.addErrorMsg(ListenerArb.format("NOSQL_ERR_CLIENT_SECURITY_FILE_DOES_NOT_EXISTS", this.m_clientSecurityFile.getText()));
                    } else if (file.isDirectory()) {
                        this.addErrorMsg(ListenerArb.format("NOSQL_ERR_CLIENT_SECURITY_FILE_NOT_FILE", this.m_clientSecurityFile.getText()));
                    }
                }
                if (!this.hasValue(this.m_clientTrustFile.getText())) {
                    this.addErrorMsg(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_CLIENT_TRUST_FILE"), ListenerArb.getString("NOSQL_CLIENT_TRUST_FILE")));
                } else {
                    file = new File(this.m_clientTrustFile.getText());
                    if (!file.exists()) {
                        this.addErrorMsg(ListenerArb.format("NOSQL_ERR_CLIENT_TRUST_FILE_DOES_NOT_EXISTS", this.m_clientTrustFile.getText()));
                    } else if (file.isDirectory()) {
                        this.addErrorMsg(ListenerArb.format("NOSQL_ERR_CLIENT_TRUST_FILE_NOT_FILE", this.m_clientTrustFile.getText()));
                    }
                }
                if (!this.hasValue(this.m_username.getText())) {
                    if (this.errMsg.length() == 0) {
                        this.m_username.requestFocus();
                    }
                    this.addErrorMsg(ListenerArb.getString("ERROR_USERNAME_MISSING"));
                }
                if (this.m_walletBtn.isSelected()) {
                    if (!this.hasValue(this.m_walletDir.getText())) {
                        this.addErrorMsg(ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_WALLET_DIR"), ListenerArb.getString("NOSQL_WALLET_DIR")));
                    } else {
                        file = new File(this.m_walletDir.getText());
                        if (!file.exists()) {
                            this.addErrorMsg(ListenerArb.format("NOSQL_ERR_WALLET_DIR_DOES_NOT_EXISTS", this.m_walletDir.getText()));
                        } else if (!file.isDirectory()) {
                            this.addErrorMsg(ListenerArb.format("NOSQL_ERR_WALLET_DIR_NOT_DIR", this.m_walletDir.getText()));
                        }
                    }
                } else {
                    this.validatePasswords();
                }
            }
            if (this.errMsg.length() > 0) {
                if (this.tabs != null && this.tabs.getSelectedIndex() != 1) {
                    this.tabs.setSelectedIndex(1);
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateInfo() {
        this.initErrorMessage();
        if (this.validateValues()) {
            return true;
        }
        String string = this.m_storeAlias.getText();
        string = this.hasValue(string) ? string + ' ' + ListenerArb.getString("NOSQL_STORE_CONFIG") : ListenerArb.getString("NOSQL_STORE_CONFIG");
        this.showErrors(string);
        return false;
    }

    public void renameStore(String string) {
        this.m_storeAlias.setText(string);
        File file = new File(this.m_config.getStorePath());
        File file2 = file.getParentFile();
        this.m_storeDir = new File(file2, string);
        this.m_config.setStorePath(this.m_storeDir.getPath());
    }

    public void refresh(boolean bl) {
        if (!this.m_config.isSecureStore()) {
            this.m_clientSecurityFile.setText("");
            this.m_clientTrustFile.setText("");
            this.m_walletDir.setText("");
            this.m_username.setText("");
            this.m_password.setText("");
            this.m_confirmPassword.setText("");
            this.m_walletBtn.setSelected(true);
        }
        if (bl) {
            this.m_config.setStoreMode(NoSQLConstants.StoreMode.UPDATE);
            this.m_config.setOrigSecureStore(this.m_config.isSecureStore());
        }
        if (this.m_config.getStoreMode() == NoSQLConstants.StoreMode.UPDATE && this.m_config.isOrigSecureStore()) {
            this.m_browseSecFileBtn.setEnabled(false);
            this.m_browseSecTrustBtn.setEnabled(false);
            this.m_browseWalletBtn.setEnabled(false);
            this.m_walletBtn.setEnabled(false);
            this.m_walletDir.setEnabled(false);
            this.m_passwdBtn.setEnabled(false);
            this.m_password.setEnabled(false);
            this.m_confirmPassword.setEnabled(false);
            this.m_clientSecurityFile.setEnabled(false);
            this.m_clientTrustFile.setEnabled(false);
        }
    }
}

