/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.nosql.NoSQLUtils;
import oracle.dbtools.listener.nosql.ui.NoSQLStorePanel;
import oracle.dbtools.listener.ui.ListenerNodeInfo;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.listener.ui.ORDSNodeInfo;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class NoSQLStoreRename
implements ActionListener {
    private JTextField m_newStoreAlias = new JTextField();
    private JEWTDialog _dialog;
    private String _errMsg;
    private String _storeAlias;
    private int _storeId;

    public static boolean renameNoSQLStore(ListenerNodeInfo listenerNodeInfo) {
        return new NoSQLStoreRename().renameStore(listenerNodeInfo);
    }

    private boolean renameStore(ListenerNodeInfo listenerNodeInfo) {
        this._storeAlias = listenerNodeInfo.getName();
        this._storeId = listenerNodeInfo.getKey();
        if (this.runDialog()) {
            String string = this.m_newStoreAlias.getText();
            NoSQLStorePanel noSQLStorePanel = (NoSQLStorePanel)((ORDSNodeInfo)listenerNodeInfo).getObject();
            File file = new File(noSQLStorePanel.getStorePath());
            if (NoSQLUtils.renameStore(file, string)) {
                ListenerPanel.getInstance().renameNoSQLStore(listenerNodeInfo.getKey(), string);
                ListenerImportAdmin.getInstance().renameNoSQLStoresProperties(this._storeAlias, string);
                return true;
            }
        }
        return false;
    }

    private void initDialog() {
        JPanel jPanel = this.getRenamePanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_nosql_rename_store_html");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)this.getRenameTitle(), (int)14);
        this._dialog.addActionListener((ActionListener)this);
        Dimension dimension = new Dimension(350, 200);
        this._dialog.setMinimumSize(dimension);
        this._dialog.setPreferredSize(dimension);
        this._dialog.setSize(dimension);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
    }

    private JPanel getRenamePanel() {
        JTextField jTextField = new JTextField();
        jTextField.setText(this._storeAlias);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)this.labelWithColon(ListenerArb.getString("NOSQL_STORE_ALIAS")));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_newStoreAlias, (String)this.getRenameStoreLabel());
        jLabel2.setDisplayedMnemonic(82);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)jTextField, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_newStoreAlias, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private String getRenameTitle() {
        String string = this.getRenameLabel() + ' ' + ListenerArb.getString("NOSQL_STORE_ALIAS");
        return string;
    }

    private String getRenameStoreLabel() {
        String string = this.getRenameLabel() + ' ' + ListenerArb.getString("NOSQL_STORE_ALIAS") + ListenerArb.getString("COLON");
        return string;
    }

    private String getRenameLabel() {
        return ImpExpResources.getString((String)"LABEL_DUPLICATION_MODE_RENAME");
    }

    private String labelWithColon(String string) {
        return string + ListenerArb.getString("COLON");
    }

    private boolean validInfo() {
        this._errMsg = null;
        String string = this.m_newStoreAlias.getText();
        if (string != null && string.trim().length() > 0) {
            if (ListenerPanel.getInstance().isDuplicateNoSQLStore(this._storeId, string)) {
                this._errMsg = ListenerArb.format("NOSQL_ERR_DUPLICATE_STORE", string);
            }
        } else {
            this._errMsg = ListenerArb.format("NOSQL_ERR_REQUIRED", ListenerArb.getString("NOSQL_STORE_ALIAS"), ListenerArb.getString("NOSQL_STORE_ALIAS"));
        }
        if (this._errMsg != null) {
            this.m_newStoreAlias.requestFocus();
            return false;
        }
        return true;
    }

    private void showError() {
        String string = this.getRenameLabel() + " " + ListenerArb.getString("NOSQL_STORE_ALIAS");
        MessageDialog.error((Component)this._dialog, (Object)this._errMsg, (String)string, null);
    }

    public boolean runDialog() {
        boolean bl = false;
        try {
            this.initDialog();
            bl = WizardLauncher.runDialog((JDialog)this._dialog);
        }
        catch (Exception exception) {
        }
        finally {
            if (this._dialog != null) {
                this._dialog.removeActionListener((ActionListener)this);
                this._dialog.dispose();
                this._dialog = null;
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validInfo()) {
            this._dialog.dispose();
        } else {
            this.showError();
        }
    }
}

