/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.NoSQLStoreConfig;
import oracle.dbtools.listener.nosql.ui.NoSQLStorePanel;
import oracle.dbtools.listener.ui.IListenerSettings;
import oracle.dbtools.listener.ui.ListenerAPEXRESTUsersPanel;
import oracle.dbtools.listener.ui.ListenerCacheFilesPanel;
import oracle.dbtools.listener.ui.ListenerCacheOptionsPanel;
import oracle.dbtools.listener.ui.ListenerCellRenderer;
import oracle.dbtools.listener.ui.ListenerConnectionPanel;
import oracle.dbtools.listener.ui.ListenerDefaultPasswordPanel;
import oracle.dbtools.listener.ui.ListenerEnvironmentPanel;
import oracle.dbtools.listener.ui.ListenerErrorOptionsPanel;
import oracle.dbtools.listener.ui.ListenerExcelPanel;
import oracle.dbtools.listener.ui.ListenerInfo;
import oracle.dbtools.listener.ui.ListenerInformationPanel;
import oracle.dbtools.listener.ui.ListenerJDBCPanel;
import oracle.dbtools.listener.ui.ListenerLogOptionsPanel;
import oracle.dbtools.listener.ui.ListenerNamePanel;
import oracle.dbtools.listener.ui.ListenerNodeConstants;
import oracle.dbtools.listener.ui.ListenerNodeInfo;
import oracle.dbtools.listener.ui.ListenerORDSUserPanel;
import oracle.dbtools.listener.ui.ListenerOptionsPanel;
import oracle.dbtools.listener.ui.ListenerPLSQLGatewayUserPanel;
import oracle.dbtools.listener.ui.ListenerProcedureProcessingPanel;
import oracle.dbtools.listener.ui.ListenerReportsPanel;
import oracle.dbtools.listener.ui.ListenerSecurityPanel;
import oracle.dbtools.listener.ui.ListenerSecurityProceduresPanel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.listener.ui.ListenerURLMappingPanel;
import oracle.dbtools.listener.ui.ListenerValidationFunctionPanel;
import oracle.dbtools.listener.ui.ListenerVirusScanPanel;
import oracle.dbtools.listener.ui.ORDSNodeInfo;
import oracle.javatools.dialogs.MessageDialog;

public class ListenerTreePanel
extends JPanel
implements TreeSelectionListener {
    private ListenerModel _model;
    private JTree _listenerTree = null;
    private ListenerInfo _globalSettings = null;
    private HashMap<Integer, ListenerInfo> _dbSettingsMap = null;
    private DefaultMutableTreeNode _childNode = null;
    private DefaultMutableTreeNode _noSQLParentNode = null;
    private ListenerOptionsPanel _listenerOptions;
    private ListenerNodeInfo _prevNodeInfo = null;
    private DefaultMutableTreeNode _prevNode;
    private DefaultMutableTreeNode _rootNode;
    private int _childKey = 0;
    private String _errMsg;
    private boolean _showPrevSelected = false;
    private boolean _adminRole = false;

    public ListenerTreePanel() {
        this.init();
    }

    public ListenerTreePanel(ListenerModel listenerModel) {
        this._model = listenerModel;
        this.init();
    }

    private void init() {
        this._listenerTree = null;
        String string = this._model != null ? this._model.getName() : ListenerArb.getString("ADMINISTRATION_NODE");
        this._globalSettings = new ListenerInfo(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ListenerArb.getString("LISTENER_NODE"));
        this._dbSettingsMap = new HashMap();
        this.setPreferredSize(new Dimension(575, 425));
        JScrollPane jScrollPane = this.createListenerTreePane();
        Object object = this.createObject("Listener");
        if (object != null) {
            ((IListenerSettings)object).assignSettings(this._model, null);
            this._globalSettings.addObject("Listener", object);
        }
        JPanel jPanel = (JPanel)object;
        this._listenerOptions = new ListenerOptionsPanel(stringBuffer.toString(), jPanel);
        JScrollPane jScrollPane2 = new JScrollPane(this._listenerOptions);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(200);
        this.add((Component)jSplitPane, "Center");
        this.repaint();
    }

    private JScrollPane createListenerTreePane() {
        this._rootNode = new DefaultMutableTreeNode(new ListenerNodeInfo(ListenerNodeConstants.ROOT_NODE_NAME, "Listener"));
        this._prevNodeInfo = (ListenerNodeInfo)this._rootNode.getUserObject();
        this._prevNode = this._rootNode;
        if (this._model != null) {
            this.createListenerNodes();
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this._rootNode);
        this._listenerTree = new JTree(defaultTreeModel);
        this._listenerTree.setCellRenderer(new ListenerCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._listenerTree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this._listenerTree.setShowsRootHandles(true);
        this._listenerTree.setRootVisible(true);
        this._listenerTree.getSelectionModel().setSelectionMode(1);
        this._listenerTree.setSelectionPath(new TreePath(this._rootNode.getPath()));
        Color color = this._listenerTree.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        this._listenerTree.addTreeSelectionListener(this);
        this.setLayout(new BorderLayout());
        return jScrollPane;
    }

    private void createListenerNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        block5: for (ListenerNodeConstants.ROOT_CHILD_NODES rOOT_CHILD_NODES : ListenerNodeConstants.ROOT_CHILD_NODES.values()) {
            switch (rOOT_CHILD_NODES) {
                case ADMIN_NODE: {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new ListenerNodeInfo(rOOT_CHILD_NODES.getName(), rOOT_CHILD_NODES.getType()));
                    if (!this._adminRole) continue block5;
                    Object object = this.createObject(rOOT_CHILD_NODES.getType());
                    if (object != null && object instanceof IListenerSettings) {
                        ((IListenerSettings)object).assignSettings(this._model, null);
                        this._globalSettings.addObject(rOOT_CHILD_NODES.getType(), object);
                    }
                    this.createAdministrationNodes(defaultMutableTreeNode);
                    this._rootNode.add(defaultMutableTreeNode);
                    continue block5;
                }
                case NOSQL_NODE: {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new ORDSNodeInfo(rOOT_CHILD_NODES.getName(), rOOT_CHILD_NODES.getType(), new ListenerInformationPanel(rOOT_CHILD_NODES.getType())));
                    if (this._model.getNoSQLStores() != null) {
                        for (NoSQLStoreConfig noSQLStoreConfig : this._model.getNoSQLStores()) {
                            DefaultMutableTreeNode defaultMutableTreeNode2 = this.createNoSQLStoreNode(noSQLStoreConfig);
                            defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        }
                    }
                    this._rootNode.add(defaultMutableTreeNode);
                    this._noSQLParentNode = defaultMutableTreeNode;
                    continue block5;
                }
                case REPORT_NODE: {
                    if (this._model.getReportData() == null) continue block5;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new ListenerNodeInfo(rOOT_CHILD_NODES.getName(), rOOT_CHILD_NODES.getType()));
                    Object object = this.createObject(rOOT_CHILD_NODES.getType());
                    if (object != null && object instanceof IListenerSettings) {
                        ((IListenerSettings)object).assignSettings(this._model, null);
                        this._globalSettings.addObject(rOOT_CHILD_NODES.getType(), object);
                    }
                    this.createReports(defaultMutableTreeNode);
                    this._rootNode.add(defaultMutableTreeNode);
                }
            }
        }
    }

    private void createAdministrationNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (ListenerNodeConstants.ADMIN_CHILD_NODES aDMIN_CHILD_NODES : ListenerNodeConstants.ADMIN_CHILD_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(aDMIN_CHILD_NODES.getName(), aDMIN_CHILD_NODES.getType()));
            Object object = this.createObject(aDMIN_CHILD_NODES.getType());
            if (object != null) {
                ((IListenerSettings)object).assignSettings(this._model, null);
                this._globalSettings.addObject(aDMIN_CHILD_NODES.getType(), object);
            }
            switch (aDMIN_CHILD_NODES) {
                case GLOBAL_SETTINGS_NODE: {
                    ListenerUIUtils.createSettingNodes(defaultMutableTreeNode2);
                    this.populateGlobalSettings(defaultMutableTreeNode2);
                    break;
                }
                case DB_SETTINGS_NODE: {
                    if (this._model != null && this._model.hasChildren()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                        for (ListenerModel listenerModel : this._model.getChildren()) {
                            defaultMutableTreeNode3 = this.createDBSettings(listenerModel);
                            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        }
                    }
                    this._childNode = defaultMutableTreeNode2;
                }
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode createDBSettings(ListenerModel listenerModel) {
        ++this._childKey;
        listenerModel.setID(this._childKey);
        String string = listenerModel.getName();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ListenerNodeInfo(string, "DBSettingsName", this._childKey));
        ListenerUIUtils.createSettingNodes(defaultMutableTreeNode);
        ListenerInfo listenerInfo = new ListenerInfo(string);
        listenerInfo.setIsChild(true);
        Object object = this.createObject("DBSettingsName");
        if (object != null && object instanceof IListenerSettings) {
            ((IListenerSettings)object).assignSettings(this._model, listenerModel);
            listenerInfo.addObject("DBSettingsName", object);
        }
        if (this._dbSettingsMap == null) {
            this._dbSettingsMap = new HashMap();
        }
        this._dbSettingsMap.put(this._childKey, listenerInfo);
        this.populateDBSettings(defaultMutableTreeNode, listenerModel, listenerInfo);
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createNoSQLStoreNode(NoSQLStoreConfig noSQLStoreConfig) {
        ++this._childKey;
        noSQLStoreConfig.setId(this._childKey);
        NoSQLStorePanel noSQLStorePanel = new NoSQLStorePanel();
        noSQLStorePanel.assignValues(noSQLStoreConfig);
        return new DefaultMutableTreeNode(new ORDSNodeInfo(noSQLStoreConfig.getStoreAlias(), "NoSQLConfig", this._childKey, noSQLStorePanel));
    }

    private void createReports(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this._model == null || !this._model.hasChildren()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (ListenerNodeConstants.REPORTING_CHILD_NODES rEPORTING_CHILD_NODES : ListenerNodeConstants.REPORTING_CHILD_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(rEPORTING_CHILD_NODES.getName(), rEPORTING_CHILD_NODES.getType()));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.populateGlobalSettings(defaultMutableTreeNode);
    }

    private boolean removeNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (n == 0) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this._listenerTree.getLastSelectedPathComponent();
        ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode2.getUserObject();
        if (listenerNodeInfo.getKey() == n) {
            ((DefaultTreeModel)this.getTree().getModel()).removeNodeFromParent(defaultMutableTreeNode2);
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this._listenerTree.scrollPathToVisible(treePath);
            this._listenerTree.setSelectionPath(treePath);
            this._listenerTree.expandPath(treePath);
            return true;
        }
        return false;
    }

    private void populateGlobalSettings(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Object object = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode2.getUserObject();
            if (listenerNodeInfo != null && listenerNodeInfo.getType() != null && (object = this.createObject(listenerNodeInfo.getType())) != null) {
                ((IListenerSettings)object).assignSettings(this._model, null);
                this._globalSettings.addObject(listenerNodeInfo.getType(), object);
            }
            if (defaultMutableTreeNode2.getChildCount() <= 0) continue;
            this.populateGlobalSettings(defaultMutableTreeNode2);
        }
    }

    private void populateDBSettings(DefaultMutableTreeNode defaultMutableTreeNode, ListenerModel listenerModel, ListenerInfo listenerInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Object object = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode2.getUserObject();
            if (listenerNodeInfo != null && listenerNodeInfo.getType() != null && (object = this.createObject(listenerNodeInfo.getType())) != null) {
                ((IListenerSettings)object).assignSettings(this._model, listenerModel);
                listenerInfo.addObject(listenerNodeInfo.getType(), object);
            }
            if (defaultMutableTreeNode2.getChildCount() <= 0) continue;
            this.populateDBSettings(defaultMutableTreeNode2, listenerModel, listenerInfo);
        }
    }

    private Object createObject(String string) {
        if (string == null) {
            return null;
        }
        ListenerSettings listenerSettings = null;
        try {
            if (string.equalsIgnoreCase("Administration") || string.equalsIgnoreCase("DBSettingsName")) {
                listenerSettings = new ListenerNamePanel();
            } else if (string.equalsIgnoreCase("Connections")) {
                listenerSettings = new ListenerConnectionPanel();
            } else if (string.equalsIgnoreCase("DefaultPassword")) {
                listenerSettings = new ListenerDefaultPasswordPanel();
            } else if (string.equalsIgnoreCase("JDBC")) {
                listenerSettings = new ListenerJDBCPanel();
            } else if (string.equalsIgnoreCase("ORDSConnections")) {
                listenerSettings = new ListenerORDSUserPanel();
            } else if (string.equalsIgnoreCase("PLSQLGatewayConnections")) {
                listenerSettings = new ListenerPLSQLGatewayUserPanel();
            } else if (string.equalsIgnoreCase("APEXRESTConnections")) {
                listenerSettings = new ListenerAPEXRESTUsersPanel();
            } else if (string.equalsIgnoreCase("URLMapping")) {
                listenerSettings = new ListenerURLMappingPanel();
            } else if (string.equalsIgnoreCase("Security")) {
                listenerSettings = new ListenerSecurityPanel();
            } else if (string.equalsIgnoreCase("AllowedProcedures")) {
                listenerSettings = new ListenerSecurityProceduresPanel("AllowedProcedures");
            } else if (string.equalsIgnoreCase("BlockedProcedures")) {
                listenerSettings = new ListenerSecurityProceduresPanel("BlockedProcedures");
            } else if (string.equalsIgnoreCase("ValidationFunction")) {
                listenerSettings = new ListenerValidationFunctionPanel();
            } else if (string.equalsIgnoreCase("VirusScanning")) {
                listenerSettings = new ListenerVirusScanPanel();
            } else if (string.equalsIgnoreCase("CacheFiles")) {
                listenerSettings = new ListenerCacheFilesPanel();
            } else if (string.equalsIgnoreCase("Caching")) {
                listenerSettings = new ListenerCacheOptionsPanel();
            } else if (string.equalsIgnoreCase("PreProcessing")) {
                listenerSettings = new ListenerProcedureProcessingPanel("PreProcessing");
            } else if (string.equalsIgnoreCase("PostProcessing")) {
                listenerSettings = new ListenerProcedureProcessingPanel("PostProcessing");
            } else if (string.equalsIgnoreCase("Excel")) {
                listenerSettings = new ListenerExcelPanel();
            } else if (string.equalsIgnoreCase("Environment")) {
                listenerSettings = new ListenerEnvironmentPanel();
            } else if (string.equalsIgnoreCase("ErrorReporting")) {
                listenerSettings = new ListenerErrorOptionsPanel();
            } else if (string.equalsIgnoreCase("Logging")) {
                listenerSettings = new ListenerLogOptionsPanel();
            } else if (string.equalsIgnoreCase("ReportSummaryStatistics") || string.equalsIgnoreCase("ReportSettingsStatistics") || string.equalsIgnoreCase("ErrorTracking") || string.equalsIgnoreCase("ReportLogging") || string.equalsIgnoreCase("Reports")) {
                listenerSettings = new ListenerReportsPanel(string, this._model.getReportSettings().isReporting());
            } else if (string.equalsIgnoreCase("Listener") || string.equalsIgnoreCase("GlobalSettings") || string.equalsIgnoreCase("DBSettings")) {
                listenerSettings = new ListenerInformationPanel(string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return listenerSettings;
    }

    private boolean isValidName(ListenerNodeInfo listenerNodeInfo) {
        if (listenerNodeInfo == null) {
            return false;
        }
        ListenerNamePanel listenerNamePanel = null;
        String string = null;
        this._errMsg = null;
        if (listenerNodeInfo.getType().equals("Administration")) {
            listenerNamePanel = (ListenerNamePanel)this._globalSettings.getObject("Administration");
            string = listenerNamePanel.getName();
            if (string.equals(this._globalSettings.getName())) {
                return true;
            }
            if (this.hasLength(string)) {
                this._globalSettings.setName(string);
                return true;
            }
            this._errMsg = ListenerArb.getString("ADMIN_ERR_NAME_REQUIRED");
        } else if (listenerNodeInfo.getType().equals("DBSettingsName")) {
            ListenerInfo listenerInfo = this._dbSettingsMap.get(listenerNodeInfo.getKey());
            if (listenerInfo != null) {
                listenerNamePanel = (ListenerNamePanel)listenerInfo.getObject("DBSettingsName");
                if (listenerNamePanel != null) {
                    string = listenerNamePanel.getName();
                    if (string.equals(listenerInfo.getName())) {
                        return true;
                    }
                    if (this.hasLength(string)) {
                        boolean bl = true;
                        for (int n : this._dbSettingsMap.keySet()) {
                            ListenerInfo listenerInfo2;
                            if (n == listenerNodeInfo.getKey() || !(listenerInfo2 = this._dbSettingsMap.get(n)).getName().equalsIgnoreCase(string)) continue;
                            this._errMsg = ListenerArb.getString("DB_ERR_NAME_EXIST");
                            bl = false;
                            break;
                        }
                        if (bl) {
                            listenerInfo.setName(string);
                            listenerNodeInfo.setName(string);
                            return true;
                        }
                    } else {
                        this._errMsg = ListenerArb.getString("DB_ERR_NAME_REQUIRED");
                    }
                } else {
                    this._errMsg = "ListenerNamePanel is null.";
                }
            } else {
                this._errMsg = "ListenerInfo is null.";
            }
        }
        if (listenerNamePanel == null) {
            return true;
        }
        listenerNamePanel.requestFocusOnName();
        return false;
    }

    private boolean hasLength(String string) {
        return string != null && !string.isEmpty() && string.trim().length() != 0;
    }

    private void processGlobalSettingsChanged(ListenerNodeInfo listenerNodeInfo) {
        String string = listenerNodeInfo.getType();
        if (string == null || string.isEmpty()) {
            return;
        }
        IListenerSettings iListenerSettings = (IListenerSettings)this._globalSettings.getObject(string);
        if (iListenerSettings != null && iListenerSettings.isGlobalSettingsChange()) {
            iListenerSettings.updateSettings();
            if (string.equals("Connections") || string.equals("JDBC") || string.equals("DefaultPassword")) {
                for (int n : this._dbSettingsMap.keySet()) {
                    ListenerInfo listenerInfo = this._dbSettingsMap.get(n);
                    if (listenerInfo == null) continue;
                    if (string.equals("DefaultPassword")) {
                        for (String string2 : ListenerNodeConstants.USERSLIST) {
                            IListenerSettings iListenerSettings2 = (IListenerSettings)listenerInfo.getObject(string2);
                            if (iListenerSettings2 == null) continue;
                            iListenerSettings2.highlightGlobalValues();
                        }
                        continue;
                    }
                    IListenerSettings iListenerSettings3 = (IListenerSettings)listenerInfo.getObject(string);
                    if (iListenerSettings3 == null) continue;
                    iListenerSettings3.highlightGlobalValues();
                }
            }
        }
    }

    private JPanel getPanel(ListenerNodeInfo listenerNodeInfo) {
        JPanel jPanel = null;
        if (listenerNodeInfo instanceof ORDSNodeInfo) {
            jPanel = (JPanel)((ORDSNodeInfo)listenerNodeInfo).getObject();
        } else if (listenerNodeInfo.getKey() == 0) {
            jPanel = (JPanel)this._globalSettings.getObject(listenerNodeInfo.getType());
        } else {
            ListenerInfo listenerInfo = this._dbSettingsMap.get(listenerNodeInfo.getKey());
            jPanel = (JPanel)listenerInfo.getObject(listenerNodeInfo.getType());
        }
        return jPanel;
    }

    private String getTitle(ListenerNodeInfo listenerNodeInfo) {
        String string = "";
        String string2 = listenerNodeInfo.getType();
        if (listenerNodeInfo.getType().equals("NoSQLConfig")) {
            string = ListenerArb.format("TITLE_NODE_AND_SETTING_NAME", ListenerArb.getString("NOSQL_STORE_CONFIG"), listenerNodeInfo.getName());
        } else if (listenerNodeInfo.getKey() == 0) {
            string = string2.equals("Listener") || string2.equals("Administration") || string2.equals("GlobalSettings") || string2.equals("DBSettings") || string2.equals("NoSQL") || string2.equals("Reports") || string2.equals("ReportSummaryStatistics") || string2.equals("ErrorTracking") || string2.equals("ReportLogging") ? listenerNodeInfo.getName() : ListenerArb.format("TITLE_NODE_AND_SETTING_NAME", listenerNodeInfo.getName(), ListenerArb.getString("GLOBAL_SETTINGS_NODE"));
        } else {
            ListenerInfo listenerInfo = this._dbSettingsMap.get(listenerNodeInfo.getKey());
            string = string2.equals("DBSettingsName") ? ListenerArb.format("TITLE_NODE_AND_SETTING_NAME", ListenerNodeConstants.ADMIN_CHILD_NODES.DB_SETTINGS_NODE.getName(), listenerNodeInfo.getName()) : ListenerArb.format("TITLE_NODE_AND_SETTING_NAME", listenerNodeInfo.getName(), listenerInfo.getName());
        }
        return string;
    }

    private void displaySettings(String string, JPanel jPanel) {
        this._listenerOptions.setTitle(string);
        this._listenerOptions.setPanel(jPanel);
        this._listenerOptions.revalidate();
        this._listenerOptions.repaint();
    }

    public JTree getTree() {
        return this._listenerTree;
    }

    public void newAdministration(ListenerModel listenerModel) {
        this.loadAdministration(listenerModel, true);
        ListenerModel listenerModel2 = new ListenerModel();
        listenerModel2.setName(ListenerArb.getString("APEX_DB_SETTINGS_NAME"));
        this.newDBSettings(listenerModel2, true);
        TreePath treePath = new TreePath(this._rootNode.getNextNode().getNextNode().getNextNode().getPath());
        this._listenerTree.setSelectionPath(treePath);
    }

    public void loadAdministration(ListenerModel listenerModel, boolean bl) {
        this._adminRole = bl;
        if (this._rootNode.getChildCount() > 0) {
            this.reInitialize();
        }
        this._model = listenerModel;
        this.createListenerNodes();
        TreePath treePath = new TreePath(this._rootNode.getPath());
        this._listenerTree.scrollPathToVisible(new TreePath(treePath));
        DefaultMutableTreeNode defaultMutableTreeNode = this._rootNode.getNextNode();
        TreePath treePath2 = new TreePath(defaultMutableTreeNode.getPath());
        TreePath treePath3 = new TreePath(defaultMutableTreeNode.getNextNode().getNextNode().getPath());
        this._listenerTree.setSelectionPath(treePath3);
        this._listenerTree.expandPath(treePath2);
        this._listenerTree.expandPath(new TreePath(defaultMutableTreeNode.getNextNode().getPath()));
        this._listenerTree.expandPath(treePath3);
        this._listenerTree.expandPath(new TreePath(defaultMutableTreeNode.getNextNode().getNextSibling().getPath()));
    }

    public void loadReports(ListenerModel listenerModel) {
        this._adminRole = false;
        if (this._rootNode.getChildCount() > 0) {
            this.reInitialize();
        }
        this._model = listenerModel;
        this.createListenerNodes();
        TreePath treePath = new TreePath(this._rootNode.getPath());
        this._listenerTree.scrollPathToVisible(new TreePath(treePath));
        DefaultMutableTreeNode defaultMutableTreeNode = this._rootNode.getNextNode();
        TreePath treePath2 = new TreePath(defaultMutableTreeNode.getPath());
        this._listenerTree.setSelectionPath(treePath2);
        this._listenerTree.expandPath(treePath2);
        this._listenerTree.expandPath(new TreePath(defaultMutableTreeNode.getNextNode().getPath()));
    }

    private void reInitialize() {
        this.removeAdminNode();
        this._globalSettings.removeAll();
        this._dbSettingsMap.clear();
        this._prevNodeInfo = (ListenerNodeInfo)this._rootNode.getUserObject();
        this._childNode = null;
        this._noSQLParentNode = null;
        this._childKey = 0;
    }

    private void removeAdminNode() {
        int n = this._rootNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._rootNode.getChildAt(0);
            ((DefaultTreeModel)this.getTree().getModel()).removeNodeFromParent(defaultMutableTreeNode);
        }
        ((DefaultTreeModel)this.getTree().getModel()).nodeStructureChanged(this._rootNode);
    }

    private void resetToPreviousNodeSelection() {
        this._showPrevSelected = true;
        this._listenerTree.setSelectionPath(new TreePath(this._prevNode.getPath()));
    }

    private void showError() {
        MessageDialog.error(null, (Object)this._errMsg, (String)ListenerArb.getString("ADMIN_ERROR_TITLE"), null);
    }

    private boolean isPreviousNodeNamePanel() {
        return this._prevNodeInfo != null && (this._prevNodeInfo.getType().equalsIgnoreCase("Administration") || this._prevNodeInfo.getType().equalsIgnoreCase("DBSettingsName"));
    }

    private boolean isPreviousUserPasswdPanel() {
        return this._prevNodeInfo != null && (this._prevNodeInfo.getType().equalsIgnoreCase("ORDSConnections") || this._prevNodeInfo.getType().equalsIgnoreCase("PLSQLGatewayConnections") || this._prevNodeInfo.getType().equalsIgnoreCase("APEXRESTConnections") || this._prevNodeInfo.getType().equalsIgnoreCase("DefaultPassword"));
    }

    public boolean validateName() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._listenerTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            if ((listenerNodeInfo.getType().equalsIgnoreCase("Administration") || listenerNodeInfo.getType().equalsIgnoreCase("DBSettingsName")) && !this.isValidName(listenerNodeInfo)) {
                this.showError();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean validateNoSQLStoreAliasName(int n, String string) {
        return true;
    }

    public boolean isValidInput() {
        NoSQLStorePanel noSQLStorePanel;
        if (this._prevNodeInfo == null) {
            return true;
        }
        if (this.isPreviousNodeNamePanel()) {
            if (!this.isValidName(this._prevNodeInfo)) {
                this.showError();
                this.resetToPreviousNodeSelection();
                return false;
            }
        } else if (this._prevNodeInfo.getType().equalsIgnoreCase("URLMapping")) {
            ListenerURLMappingPanel listenerURLMappingPanel;
            ListenerInfo listenerInfo = this._dbSettingsMap.get(this._prevNodeInfo.getKey());
            if (listenerInfo != null && !(listenerURLMappingPanel = (ListenerURLMappingPanel)listenerInfo.getObject("URLMapping")).isValidURLMap()) {
                this.resetToPreviousNodeSelection();
                return false;
            }
        } else if (this.isPreviousUserPasswdPanel()) {
            IListenerSettings iListenerSettings = null;
            if (this._prevNodeInfo.getKey() > 0) {
                ListenerInfo listenerInfo = this._dbSettingsMap.get(this._prevNodeInfo.getKey());
                if (listenerInfo != null) {
                    iListenerSettings = (IListenerSettings)listenerInfo.getObject(this._prevNodeInfo.getType());
                }
            } else {
                iListenerSettings = (IListenerSettings)this._globalSettings.getObject(this._prevNodeInfo.getType());
            }
            if (iListenerSettings != null && !iListenerSettings.validateInfo()) {
                this.resetToPreviousNodeSelection();
                return false;
            }
        } else if (this._prevNodeInfo.getType().equals("NoSQLConfig") && !(noSQLStorePanel = (NoSQLStorePanel)((ORDSNodeInfo)this._prevNodeInfo).getObject()).validateInfo()) {
            this.resetToPreviousNodeSelection();
            return false;
        }
        return true;
    }

    public void newDBSettings(ListenerModel listenerModel, boolean bl) {
        ListenerModel listenerModel2 = null;
        try {
            listenerModel2 = ListenerUIUtils.initializeDBSettingsValues(this._model, listenerModel, bl);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, cloneNotSupportedException.getStackTrace()[0].toString(), cloneNotSupportedException);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.createDBSettings(listenerModel2);
        if (this._childNode != null) {
            ((DefaultTreeModel)this._listenerTree.getModel()).insertNodeInto(defaultMutableTreeNode, this._childNode, this._childNode.getChildCount());
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this._listenerTree.scrollPathToVisible(treePath);
        this._listenerTree.setSelectionPath(treePath);
        this._listenerTree.expandPath(treePath);
    }

    public boolean removeDBSettings(int n) {
        if (n > 0 && this.removeNode(this._childNode, n)) {
            this._dbSettingsMap.remove(n);
            return true;
        }
        return false;
    }

    public void newNoSQLStore(NoSQLStoreConfig noSQLStoreConfig) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.createNoSQLStoreNode(noSQLStoreConfig);
        if (this._noSQLParentNode != null) {
            ((DefaultTreeModel)this._listenerTree.getModel()).insertNodeInto(defaultMutableTreeNode, this._noSQLParentNode, this._noSQLParentNode.getChildCount());
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this._listenerTree.scrollPathToVisible(treePath);
            this._listenerTree.setSelectionPath(treePath);
            this._listenerTree.expandPath(treePath);
        }
    }

    public boolean isDuplicateNoSQLStore(int n, String string) {
        boolean bl = false;
        int n2 = this._noSQLParentNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._noSQLParentNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            if (n == 0) {
                if (!string.equalsIgnoreCase(listenerNodeInfo.getName())) continue;
                bl = true;
                continue;
            }
            if (n == listenerNodeInfo.getKey() || !string.equalsIgnoreCase(listenerNodeInfo.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean removeNoSQLStore(int n) {
        if (n == 0) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._listenerTree.getLastSelectedPathComponent();
        ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
        if (listenerNodeInfo.getKey() == n) {
            this._prevNodeInfo = (ListenerNodeInfo)this._noSQLParentNode.getUserObject();
            this._prevNode = this._noSQLParentNode;
            ((DefaultTreeModel)this.getTree().getModel()).removeNodeFromParent(defaultMutableTreeNode);
            TreePath treePath = new TreePath(this._noSQLParentNode.getPath());
            this._listenerTree.scrollPathToVisible(treePath);
            this._listenerTree.setSelectionPath(treePath);
            this._listenerTree.expandPath(treePath);
            return true;
        }
        return false;
    }

    public boolean renameNoSQLStore(int n, String string) {
        boolean bl = false;
        int n2 = this._noSQLParentNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < n2; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this._noSQLParentNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            if (n != listenerNodeInfo.getKey()) continue;
            NoSQLStorePanel noSQLStorePanel = (NoSQLStorePanel)((ORDSNodeInfo)listenerNodeInfo).getObject();
            noSQLStorePanel.renameStore(string);
            ((ORDSNodeInfo)listenerNodeInfo).setName(string);
            ((DefaultTreeModel)this.getTree().getModel()).nodeChanged(defaultMutableTreeNode);
            bl = true;
            break;
        }
        return bl;
    }

    public List<NoSQLStoreConfig> getNoSQLStoresValues() {
        ArrayList<NoSQLStoreConfig> arrayList = new ArrayList<NoSQLStoreConfig>();
        int n = this._noSQLParentNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this._noSQLParentNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            NoSQLStorePanel noSQLStorePanel = (NoSQLStorePanel)((ORDSNodeInfo)listenerNodeInfo).getObject();
            NoSQLStoreConfig noSQLStoreConfig = noSQLStorePanel.getValues();
            arrayList.add(noSQLStoreConfig);
        }
        return arrayList;
    }

    public void refreshNoSQLStores() {
        int n = this._noSQLParentNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this._noSQLParentNode.getChildAt(i);
            ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            NoSQLStorePanel noSQLStorePanel = (NoSQLStorePanel)((ORDSNodeInfo)listenerNodeInfo).getObject();
            noSQLStorePanel.refresh(true);
        }
    }

    public ListenerModel getGlobalSettingsUIValues() {
        ListenerModel listenerModel = null;
        for (String string : this._globalSettings.getObjects().keySet()) {
            Object object = this._globalSettings.getObject(string);
            if (object == null || !(object instanceof IListenerSettings)) continue;
            listenerModel = ((IListenerSettings)object).getSettings();
        }
        return listenerModel;
    }

    public ListenerModel getGlobalSettingsUIValues(String string) {
        ListenerModel listenerModel = null;
        Object object = this._globalSettings.getObject(string);
        if (object != null) {
            listenerModel = ((IListenerSettings)object).getSettings();
        }
        return listenerModel;
    }

    public ListenerModel getAllSettingsValues() {
        ListenerModel listenerModel = this.getGlobalSettingsUIValues();
        ArrayList<ListenerModel> arrayList = new ArrayList<ListenerModel>();
        for (int n : this._dbSettingsMap.keySet()) {
            ListenerInfo listenerInfo = this._dbSettingsMap.get(n);
            ListenerModel listenerModel2 = new ListenerModel();
            for (String string : listenerInfo.getObjects().keySet()) {
                Object object = listenerInfo.getObject(string);
                if (object == null) continue;
                listenerModel2 = ((IListenerSettings)object).getSettings();
            }
            arrayList.add(listenerModel2);
        }
        listenerModel.setChildren(arrayList);
        listenerModel.setNoSQLStores(this.getNoSQLStoresValues());
        return listenerModel;
    }

    public ArrayList<String> getSettingNames() {
        return this.getSettingNames(true);
    }

    public ArrayList<String> getSettingNames(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(this._model.getName());
        }
        if (this._dbSettingsMap != null && !this._dbSettingsMap.isEmpty()) {
            for (int n : this._dbSettingsMap.keySet()) {
                ListenerInfo listenerInfo = this._dbSettingsMap.get(n);
                arrayList.add(listenerInfo.getName());
            }
        }
        return arrayList;
    }

    public boolean refreshReports(ListenerModel listenerModel, boolean bl) {
        if (this._globalSettings != null && !this._globalSettings.getObjects().isEmpty()) {
            ListenerReportsPanel listenerReportsPanel = (ListenerReportsPanel)this._globalSettings.getObject("Reports");
            if (listenerReportsPanel != null) {
                listenerReportsPanel.setServerReporting(bl);
                listenerReportsPanel.assignSettings(listenerModel, null);
            }
            for (ListenerNodeConstants.REPORTING_CHILD_NODES rEPORTING_CHILD_NODES : ListenerNodeConstants.REPORTING_CHILD_NODES.values()) {
                listenerReportsPanel = (ListenerReportsPanel)this._globalSettings.getObject(rEPORTING_CHILD_NODES.getType());
                if (listenerReportsPanel == null) continue;
                listenerReportsPanel.setServerReporting(bl);
                listenerReportsPanel.assignSettings(listenerModel, null);
            }
            return true;
        }
        return false;
    }

    public boolean isValidLastInput() {
        if (!this.isValidInput()) {
            return false;
        }
        if (this._prevNodeInfo.getKey() == 0) {
            this.processGlobalSettingsChanged(this._prevNodeInfo);
        }
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this._showPrevSelected) {
            this._showPrevSelected = false;
            return;
        }
        if (!this.isValidLastInput()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._listenerTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        ListenerNodeInfo listenerNodeInfo = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
        JPanel jPanel = this.getPanel(listenerNodeInfo);
        String string = this.getTitle(listenerNodeInfo);
        this.displaySettings(string, jPanel);
        this._prevNodeInfo = listenerNodeInfo;
        this._prevNode = defaultMutableTreeNode;
    }
}

