/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.util.List;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.java.CodingStyleOptions;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesList;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCompoundStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSimpleStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class Indent {
    public static final boolean REDUCE_SOURCE_FILE = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIndent(TextBuffer buffer, int offset, int tabSize, CodingStyleOptions codingStyleOptions) {
        SourceFile sourceFile = JavaParser.parse((ReadTextBuffer)buffer, (JdkVersion)JdkVersion.getMaxVersion());
        if (sourceFile != null) {
            sourceFile.pinTextBuffer(buffer);
        }
        int ret = 0;
        try {
            ret = Indent.scan(buffer, (SourceElement)sourceFile, offset, tabSize, codingStyleOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sourceFile != null) {
                sourceFile.unpinTextBuffer();
            }
        }
        return ret;
    }

    private static int scan(TextBuffer buffer, SourceElement sourceElement, int offset, int tabSize, CodingStyleOptions codingStyleOptions) {
        int ret;
        int ret2;
        int startOffset;
        int childPos;
        List children = sourceElement.getChildren(458752);
        int size = children.size();
        SourceElement child = null;
        for (childPos = size - 1; childPos >= 0 && offset <= (startOffset = (child = (SourceElement)children.get(childPos)).getStartOffset()); --childPos) {
        }
        if (childPos >= 0 && (ret2 = Indent.scan(buffer, child, offset, tabSize, codingStyleOptions)) >= 0) {
            return ret2;
        }
        boolean isInside = false;
        int endOffset = sourceElement.getEndOffset();
        if (offset < endOffset) {
            isInside = true;
        } else if (!Indent.isCompleteElement(buffer, sourceElement)) {
            isInside = true;
        }
        if (isInside && (ret = Indent.getElementIndent(buffer, sourceElement, offset, tabSize, codingStyleOptions)) >= 0) {
            return ret;
        }
        return -1;
    }

    private static boolean isCompleteElement(TextBuffer buffer, SourceElement sourceElement) {
        boolean ret = true;
        if (sourceElement instanceof SourceSimpleStatement) {
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';') {
                ret = false;
            }
        } else if (sourceElement instanceof SourceCompoundStatement) {
            SourceCompoundStatement sourceCompoundStatement = (SourceCompoundStatement)sourceElement;
            SourceStatement primaryClause = sourceCompoundStatement.getPrimaryClause();
            if (primaryClause == null) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceVariableDeclaration) {
            SourceElement parent;
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';' && (parent = sourceElement.getParent()) != null && parent.getSymbolKind() != 54 && parent.getSymbolKind() != 30) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceLambdaExpression) {
            SourceLambdaExpression lambda = (SourceLambdaExpression)sourceElement;
            SourceElement body = lambda.getBody();
            return body != null;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static int getElementIndent(TextBuffer buffer, SourceElement sourceElement, int offset, int tabSize, CodingStyleOptions codingStyleOptions) {
        symbolKind = sourceElement.getSymbolKind();
        switch (symbolKind) {
            case 79: {
                lambda = (SourceLambdaExpression)sourceElement;
                indentWithParent = false;
                if (lambda.getBody() == null) {
                    indentWithParent = true;
                } else if (offset < lambda.getBody().getStartOffset() && offset >= lambda.getFormalParameterList().getEndOffset()) {
                    indentWithParent = true;
                }
                if (!indentWithParent) break;
                for (parent = lambda.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SourceStatement) && !(parent instanceof SourceVariableDeclaration)) continue;
                    column = Indent.getStartColumn(buffer, parent, tabSize);
                    if (!codingStyleOptions.getAlignLambdaBodies()) {
                        column += codingStyleOptions.getIndentSize();
                    }
                    return column;
                }
                break;
            }
            case 52: {
                children = sourceElement.getChildren();
                if (children.size() <= 0) break;
                child = (SourceElement)children.get(children.size() - 1);
                if ((child.getSymbolKind() == 69 || child.getSymbolKind() == 63) && offset >= child.getEndOffset()) {
                    expr = (SourceExpression)child;
                    lhs = Indent.findLhsExpression(expr);
                    if (lhs == null || (lhs = Indent.findMostLhsExpression(expr)) == null || (nextDot = Indent.getDotAfterOffset(buffer, lhs.getEndOffset(), offset)) <= 0) break;
                    return Utilities.getColumnFromOffset(buffer, nextDot, tabSize);
                }
                if (child.getSymbolKind() != 65 || offset < child.getEndOffset() || (lhs = Indent.findLhsExpression((SourceExpression)(dotExpr = (SourceDotExpression)child))) == null) break;
                hasEndingDot = dotExpr.getText().endsWith(".");
                lhs = Indent.findMostLhsExpression((SourceExpression)dotExpr);
                if (lhs == null || (nextDot = Indent.getDotAfterOffset(buffer, lhs.getEndOffset(), offset)) <= 0) break;
                return Utilities.getColumnFromOffset(buffer, nextDot + (hasEndingDot != false ? 1 : 0), tabSize);
            }
            case 65: {
                dotExpr = (SourceDotExpression)sourceElement;
                lhs = Indent.findLhsExpression((SourceExpression)dotExpr);
                if (lhs == null || offset < lhs.getEndOffset() || offset > dotExpr.getNameElement().getStartOffset()) break;
                hasEndingDot = Indent.getDotAfterOffset(buffer, offset, dotExpr.getNameElement().getStartOffset()) == -1;
                lhs = Indent.findMostLhsExpression((SourceExpression)dotExpr);
                if (lhs == null || (nextDot = Indent.getDotAfterOffset(buffer, lhs.getEndOffset(), offset)) <= 0) break;
                return Utilities.getColumnFromOffset(buffer, nextDot + (hasEndingDot != false ? 1 : 0), tabSize);
            }
            case 69: {
                methodCall = (SourceMethodCallExpression)sourceElement;
                lhs = Indent.findLhsExpression((SourceExpression)methodCall);
                if (lhs == null || offset < lhs.getEndOffset() || offset > methodCall.getNameElement().getStartOffset()) break;
                hasEndingDot = Indent.getDotAfterOffset(buffer, offset, methodCall.getNameElement().getStartOffset()) == -1;
                lhs = Indent.findMostLhsExpression((SourceExpression)methodCall);
                if (lhs == null || (nextDot = Indent.getDotAfterOffset(buffer, lhs.getEndOffset(), offset)) <= 0) break;
                return Utilities.getColumnFromOffset(buffer, nextDot + (hasEndingDot != false ? 1 : 0), tabSize);
            }
            case 2: {
                parent = sourceElement.getParent();
                if (parent == null || parent.getSymbolKind() != 79) break;
                ret = -1;
                if (!Indent.isOffsetOnBlockBoundaries(offset, sourceElement)) {
                    ret = Indent.getSiblingIndent(buffer, offset, tabSize, sourceElement);
                }
                if (ret == -1) {
                    ret = 0;
                    while (parent != null) {
                        if (parent instanceof SourceStatement || parent instanceof SourceVariableDeclaration) {
                            ret = Indent.getStartColumn(buffer, parent, tabSize);
                            break;
                        }
                        parent = parent.getParent();
                    }
                    indent = true;
                    if (Indent.isOffsetOnBlockBoundaries(offset, sourceElement)) {
                        indent = false;
                    }
                    if (indent) {
                        ret += codingStyleOptions.getIndentSize();
                    }
                    if (!codingStyleOptions.getAlignLambdaBodies()) {
                        ret += codingStyleOptions.getIndentSize();
                    }
                }
                return ret;
            }
            case 66: {
                ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                return ret;
            }
            case 12: {
                parameterList = (SourceFormalParameterList)sourceElement;
                sourceParameters = parameterList.getSourceParameters();
                ret = Indent.getListIndent(buffer, sourceElement, sourceParameters, tabSize, codingStyleOptions);
                return ret;
            }
            case 67: {
                sourceListExpression = (SourceListExpression)sourceElement;
                sourceParameters = sourceListExpression.getOperands();
                ret = Indent.getListIndent(buffer, sourceElement, sourceParameters, tabSize, codingStyleOptions);
                return ret;
            }
            case 30: {
                list = (SourceTryResourcesList)sourceElement;
                params = list.getTryResourcesElements();
                return Indent.getListIndent(buffer, sourceElement, params, tabSize, codingStyleOptions);
            }
            case 4: {
                ret = -1;
                sourceClass = (SourceClass)sourceElement.getParent();
                sourceBody = sourceClass.getSourceBody();
                if (sourceBody != null && !Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBody)) {
                    ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBody);
                }
                if (ret != -1) ** GOTO lbl109
                if (!sourceClass.isAnonymousClass()) ** GOTO lbl102
                ret = 0;
                for (parent = sourceClass.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SourceStatement) && !(parent instanceof SourceVariableDeclaration)) continue;
                    ret = Indent.getStartColumn(buffer, parent, tabSize);
                    ** GOTO lbl103
                }
                ** GOTO lbl103
lbl102:
                // 1 sources

                ret = Indent.getStartColumn(buffer, (SourceElement)sourceClass, tabSize);
lbl103:
                // 3 sources

                if (codingStyleOptions.getIndentClassMembers()) {
                    indent = true;
                    if (sourceBody != null && Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBody)) {
                        indent = false;
                    }
                    if (indent) {
                        ret += codingStyleOptions.getIndentSize();
                    }
                }
lbl109:
                // 6 sources

                return ret;
            }
            case 5: {
                sourceClassInitializer = (SourceClassInitializer)sourceElement;
                sourceBlock = sourceClassInitializer.getBlock();
                ret = -1;
                if (sourceBlock != null) {
                    isOffsetOnBlockBoundaries = Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBlock);
                    if (!isOffsetOnBlockBoundaries) {
                        ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBlock);
                    }
                    if (ret == -1) {
                        ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                        if (!isOffsetOnBlockBoundaries) {
                            if (codingStyleOptions.getIndentClassMembers()) {
                                ret += codingStyleOptions.getIndentSize();
                            }
                        } else if (!codingStyleOptions.getAlignAnonymousClasses()) {
                            ret += codingStyleOptions.getIndentSize();
                        }
                    }
                }
                return ret;
            }
            case 6: 
            case 19: {
                sourceMethod = (SourceMethod)sourceElement;
                ret = -1;
                sourceBlock = sourceMethod.getBlock();
                if (sourceBlock != null && !Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBlock)) {
                    ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBlock);
                }
                if (ret == -1) {
                    ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                    if (codingStyleOptions.getIndentBlockChildren() && !Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)(block = sourceMethod.getBlock())) && (indent = Indent.indentInMember(buffer, offset, (SourceMember)sourceMethod))) {
                        ret += codingStyleOptions.getIndentSize();
                    }
                }
                return ret;
            }
            case 9: {
                sourceFieldDeclaration = (SourceFieldDeclaration)sourceElement;
                ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                indentInMember = Indent.indentInMember(buffer, offset, (SourceMember)sourceFieldDeclaration);
                if (indentInMember) {
                    ret += codingStyleOptions.getIndentSize();
                }
                return ret;
            }
            case 45: {
                sourceBlockStatement = (SourceBlockStatement)sourceElement;
                ret = -1;
                parent = sourceElement.getParent();
                parentSymbolKind = parent.getSymbolKind();
                if (parentSymbolKind == 2) {
                    sourceBlock = sourceBlockStatement.getBlock();
                    isOffsetOnBlockBoundaries = Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBlock);
                    if (!isOffsetOnBlockBoundaries) {
                        ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBlock);
                    }
                    if (ret == -1) {
                        ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                        if (!isOffsetOnBlockBoundaries) {
                            ret += codingStyleOptions.getIndentSize();
                        }
                    }
                } else if (parentSymbolKind == 60) {
                    if (sourceElement.getSiblingAfter() != null && (sourceElement.getSiblingAfter().getSymbolKind() == 47 || sourceElement.getSiblingAfter().getSymbolKind() == 53)) {
                        catchOffset = sourceElement.getSiblingAfter().getStartOffset();
                        catchLine = buffer.getLineMap().getLineFromOffset(catchOffset);
                        if (catchLine == (offsetLine = buffer.getLineMap().getLineFromOffset(offset))) {
                            ret = Indent.getStartColumn(buffer, parent, tabSize);
                        }
                    }
                } else if (parentSymbolKind == 47 && parent.getSiblingAfter() != null && parent.getSiblingAfter().getSymbolKind() == 53) {
                    finallyOffset = parent.getSiblingAfter().getStartOffset();
                    finallyLine = buffer.getLineMap().getLineFromOffset(finallyOffset);
                    if (finallyLine == (offsetLine = buffer.getLineMap().getLineFromOffset(offset))) {
                        ret = Indent.getStartColumn(buffer, parent.getParent(), tabSize);
                    }
                }
                return ret;
            }
            case 18: {
                indentSize = codingStyleOptions.getIndentSize();
                return Indent.getStartColumn(buffer, sourceElement, tabSize) + indentSize;
            }
            case 55: {
                sourceIfStatement = (SourceIfStatement)sourceElement;
                ret = -1;
                isOnElse = false;
                elseClause = sourceIfStatement.getElseClause();
                if (elseClause != null && (elseLine = (lineMap = buffer.getLineMap()).getLineFromOffset(elseStart = elseClause.getStartOffset())) == (cursorLine = lineMap.getLineFromOffset(offset))) {
                    isOnElse = true;
                }
                if (!isOnElse && (primaryClause = sourceIfStatement.getPrimaryClause()) instanceof SourceBlockStatement && (sourceBlock = (sourceBlockStatement = (SourceBlockStatement)primaryClause).getBlock()) != null && !Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)sourceBlock)) {
                    ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBlock);
                }
                if (ret == -1) {
                    sourceReference = Indent.getIfReference(sourceIfStatement);
                    ret = Indent.getStartColumn(buffer, sourceReference, tabSize);
                    if (codingStyleOptions.getIndentBlockChildren() && !isOnElse) {
                        indent = Indent.indentInCompound(offset, (SourceCompoundStatement)sourceIfStatement);
                        if (!indent && elseClause != null) {
                            indent = Indent.indentInCompound(offset, (SourceCompoundStatement)elseClause);
                        }
                        if (indent) {
                            ret += codingStyleOptions.getIndentSize();
                        }
                    }
                }
                return ret;
            }
            case 23: 
            case 49: 
            case 58: 
            case 60: 
            case 61: {
                ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                if (codingStyleOptions.getIndentBlockChildren() && Indent.indentInCompound(offset, sourceCompoundStatement = (SourceCompoundStatement)sourceElement)) {
                    ret += codingStyleOptions.getIndentSize();
                }
                return ret;
            }
            case 57: {
                ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
                if (!codingStyleOptions.getIndentBlockChildren()) ** GOTO lbl232
                indent = false;
                sourceSwitchStatement = (SourceSwitchStatement)sourceElement;
                primaryClause = sourceSwitchStatement.getPrimaryClause();
                if (primaryClause == null) ** GOTO lbl230
                if (!(primaryClause instanceof SourceBlockStatement)) ** GOTO lbl229
                blockStatement = (SourceBlockStatement)primaryClause;
                if (Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)blockStatement) || (children = primaryClause.getChildren()).size() != 1 || !((firstChild = (SourceElement)children.get(0)) instanceof SourceBlock)) ** GOTO lbl230
                sourceBlock = (SourceBlock)firstChild;
                stmtList = sourceBlock.getChildren();
                if (codingStyleOptions.getIndentSwitchCases()) {
                    ret += codingStyleOptions.getIndentSize();
                }
                for (SourceElement stmt : stmtList) {
                    startOffset = stmt.getStartOffset();
                    stmtSymbolKind = stmt.getSymbolKind();
                    if (startOffset < offset) ** GOTO lbl221
                    if (stmtSymbolKind == 23) {
                        indent = false;
                    }
                    ** GOTO lbl230
lbl221:
                    // 1 sources

                    switch (stmtSymbolKind) {
                        case 23: {
                            indent = true;
                            break;
                        }
                        case 46: {
                            indent = false;
                        }
                    }
                }
                ** GOTO lbl230
lbl229:
                // 1 sources

                indent = true;
lbl230:
                // 5 sources

                if (indent) {
                    ret += codingStyleOptions.getIndentSize();
                }
lbl232:
                // 4 sources

                return ret;
            }
            case 54: {
                sourceForStatement = (SourceForStatement)sourceElement;
                ret = Indent.getElementIndent_For(buffer, sourceForStatement, offset, tabSize, codingStyleOptions);
                return ret;
            }
            case 50: {
                sourceElseClause = (SourceElseClause)sourceElement;
                parent = sourceElseClause.getParent();
                sourceReference /* !! */  = parent.getSymbolKind() == 55 ? Indent.getIfReference((SourceIfStatement)parent) : sourceElseClause;
                ret = Indent.getStartColumn(buffer, (SourceElement)sourceReference /* !! */ , tabSize);
                if (codingStyleOptions.getIndentBlockChildren() && Indent.indentInCompound(offset, (SourceCompoundStatement)sourceElseClause) && !Indent.isOnIf(buffer, offset, sourceElseClause)) {
                    ret += codingStyleOptions.getIndentSize();
                }
                return ret;
            }
            case 47: 
            case 53: {
                ret = -1;
                sourceCompoundStatement = (SourceCompoundStatement)sourceElement;
                primaryClause = sourceCompoundStatement.getPrimaryClause();
                if (primaryClause instanceof SourceBlockStatement && (sourceBlock = (sourceBlockStatement = (SourceBlockStatement)primaryClause).getBlock()) != null) {
                    ret = Indent.getSiblingIndent(buffer, offset, tabSize, (SourceElement)sourceBlock);
                }
                if (ret == -1 && (parent = sourceElement.getParent()).getSymbolKind() == 60) {
                    ret = Indent.getStartColumn(buffer, parent, tabSize);
                    if (codingStyleOptions.getIndentBlockChildren() && Indent.indentInCompound(offset, sourceCompoundStatement)) {
                        ret += codingStyleOptions.getIndentSize();
                    }
                }
                return ret;
            }
            case 83: 
            case 89: {
                whitespaceCount = Indent.getWhitespaceCount(buffer, offset);
                ret = Utilities.getColumnFromOffset(buffer, whitespaceCount, tabSize);
                return ret;
            }
            case 11: {
                return 0;
            }
        }
        if (44 <= symbolKind && symbolKind <= 62) {
            ret = Indent.getStartColumn(buffer, sourceElement, tabSize);
            if (codingStyleOptions.getIndentBlockChildren()) {
                ret += codingStyleOptions.getIndentSize();
            }
            return ret;
        }
        return -1;
    }

    private static int findStartOffset(SourceElement element) {
        switch (element.getSymbolKind()) {
            case 65: 
            case 69: {
                SourceName sourceName = ((SourceHasName)element).getNameElement();
                return sourceName != null ? sourceName.getStartOffset() : element.getStartOffset();
            }
            case 63: {
                List children = element.getChildren();
                if (children.size() <= 0) break;
                SourceElement child = (SourceElement)children.get(0);
                if (child instanceof SourceExpression) {
                    return Indent.findStartOffset(child);
                }
                return child.getStartOffset();
            }
        }
        return element.getStartOffset();
    }

    private static SourceExpression findLhsExpression(SourceExpression expr) {
        if (expr != null) {
            SourceElement firstChild;
            List children = expr.getChildren();
            SourceElement sourceElement = firstChild = children.size() > 0 ? (SourceElement)children.get(0) : null;
            if (firstChild instanceof SourceExpression) {
                return (SourceExpression)firstChild;
            }
        }
        return null;
    }

    private static SourceExpression findMostLhsExpression(SourceExpression expr) {
        SourceExpression lhsExpr;
        SourceExpression lhs = expr;
        while ((lhsExpr = Indent.findLhsExpression(lhs)) != null) {
            lhs = lhsExpr;
        }
        return lhs;
    }

    private static int getDotAfterOffset(TextBuffer buffer, int startOffset, int endOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(startOffset);
        while (true) {
            int token = lexer.lex();
            if (lexer.getStartOffset() >= endOffset) break;
            switch (token) {
                case 43: {
                    return lexer.getStartOffset();
                }
            }
        }
        return -1;
    }

    private static boolean indentInMember(TextBuffer buffer, int offset, SourceMember sourceMember) {
        int docEnd;
        SourceDocComment docComment = sourceMember.getDocComment();
        if (docComment != null && (docEnd = docComment.getEndOffset()) < offset) {
            int token;
            JavaLexer javaLexer = new JavaLexer();
            javaLexer.setTextBuffer((ReadTextBuffer)buffer);
            javaLexer.setPosition(docEnd);
            do {
                token = javaLexer.lex();
                if (javaLexer.getStartOffset() < offset) continue;
                return false;
            } while (96 > token || token > 146);
            return true;
        }
        return true;
    }

    private static int getSiblingIndent(TextBuffer textBuffer, int offset, int tabSize, SourceElement parent) {
        List children = parent.getChildren();
        int line = -1;
        int ret = -1;
        for (int i = children.size() - 1; i >= 0; --i) {
            SourceElement childElement = (SourceElement)children.get(i);
            int startOffset = childElement.getStartOffset();
            if (startOffset >= offset) continue;
            int thisStart = Indent.getStartColumn(textBuffer, childElement, tabSize);
            int thisStartLine = Utilities.getLineFromOffset(textBuffer, startOffset);
            if (line < 0) {
                ret = thisStart;
                line = thisStartLine;
                continue;
            }
            int thisEndLine = Utilities.getLineFromOffset(textBuffer, childElement.getEndOffset());
            if (thisStartLine < line && thisEndLine < line) {
                return ret;
            }
            ret = thisStart;
            line = thisStartLine;
        }
        return ret;
    }

    private static SourceElement getIfReference(SourceIfStatement sourceIfStatement) {
        SourceIfStatement sourceReference = sourceIfStatement;
        SourceElement ifsParent;
        while ((ifsParent = sourceReference.getParent()) instanceof SourceElseClause) {
            SourceElseClause sourceElseClause = (SourceElseClause)ifsParent;
            SourceIfStatement owningIf = sourceElseClause.getOwningIf();
            if (owningIf == null) {
                return sourceElseClause;
            }
            sourceReference = owningIf;
        }
        return sourceReference;
    }

    private static int getListIndent(TextBuffer buffer, SourceElement sourceElement, List<? extends SourceElement> sourceElements, int tabSize, CodingStyleOptions codingStyleOptions) {
        if (codingStyleOptions.getWrapAlign() && sourceElements.size() > 0) {
            SourceElement firstElement = sourceElements.get(0);
            return Indent.getStartColumn(buffer, firstElement, tabSize);
        }
        SourceElement parent = sourceElement.getParent();
        int ret = Indent.getStartColumn(buffer, parent, tabSize);
        return ret += codingStyleOptions.getIndentSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getElementIndent_For(TextBuffer buffer, SourceForStatement sourceForStatement, int offset, int tabSize, CodingStyleOptions codingStyleOptions) {
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer((ReadTextBuffer)buffer);
        javaLexer.setPosition(sourceForStatement.getStartOffset());
        int parentDepth = 0;
        int leftParentOffset = -1;
        int rightParentOffset = -1;
        int braceDepth = 0;
        block7: while (true) {
            int token = javaLexer.lex();
            int startOffset = javaLexer.getStartOffset();
            if (startOffset >= offset) break;
            switch (token) {
                case 0: {
                    break block7;
                }
                case 55: {
                    if (parentDepth == 0) {
                        leftParentOffset = startOffset;
                    }
                    ++parentDepth;
                    break;
                }
                case 72: {
                    if (--parentDepth != 0) break;
                    rightParentOffset = startOffset;
                    break block7;
                }
                case 49: {
                    ++braceDepth;
                    break;
                }
                case 70: {
                    if (--braceDepth < 0) break block7;
                }
            }
        }
        boolean alignAfterLParen = false;
        if (leftParentOffset >= 0 && offset > leftParentOffset && rightParentOffset < 0) {
            alignAfterLParen = true;
        }
        if (alignAfterLParen) {
            return Utilities.getColumnFromOffset(buffer, leftParentOffset, tabSize) + 1;
        }
        int ret = Indent.getStartColumn(buffer, (SourceElement)sourceForStatement, tabSize);
        if (!Indent.indentInCompound(offset, (SourceCompoundStatement)sourceForStatement)) return ret;
        ret += codingStyleOptions.getIndentSize();
        return ret;
    }

    private static int getStartColumn(TextBuffer buffer, SourceElement sourceElement, int tabSize) {
        int startOffset = sourceElement.getStartOffset();
        int ret = Utilities.getColumnFromOffset(buffer, startOffset, tabSize);
        return ret;
    }

    private static int getEndColumn(TextBuffer buffer, SourceElement sourceElement, int tabSize) {
        int endOffset = sourceElement.getEndOffset();
        int ret = Utilities.getColumnFromOffset(buffer, endOffset, tabSize);
        return ret;
    }

    private static int getWhitespaceCount(TextBuffer textBuffer, int offset) {
        LineMap lineMap = textBuffer.getLineMap();
        int line = lineMap.getLineFromOffset(offset);
        int lineStartOffset = lineMap.getLineStartOffset(line);
        int lineEndOffset = lineMap.getLineEndOffset(line);
        for (int i = lineStartOffset; i < lineEndOffset; ++i) {
            char c = textBuffer.getChar(i);
            if (Character.isWhitespace(c)) continue;
            return i - lineStartOffset;
        }
        return 0;
    }

    private static boolean indentInCompound(int offset, SourceCompoundStatement sourceCompoundStatement) {
        SourceBlockStatement sourceBlockStatement;
        if (offset < sourceCompoundStatement.getStartOffset() || offset >= sourceCompoundStatement.getEndOffset()) {
            return false;
        }
        SourceStatement primaryClause = sourceCompoundStatement.getPrimaryClause();
        return !(primaryClause instanceof SourceBlockStatement) || !Indent.isOffsetOnBlockBoundaries(offset, (SourceElement)(sourceBlockStatement = (SourceBlockStatement)primaryClause));
    }

    private static boolean isOffsetOnBlockBoundaries(int offset, SourceElement sourceBlock) {
        if (sourceBlock != null) {
            int blockStart = sourceBlock.getStartOffset();
            int blockEnd = sourceBlock.getEndOffset();
            if (offset > blockStart && offset < blockEnd) {
                return false;
            }
        }
        return true;
    }

    private static boolean isOnIf(TextBuffer buffer, int offset, SourceElseClause sourceElseClause) {
        SourceStatement primaryClause = sourceElseClause.getPrimaryClause();
        boolean ret = false;
        if (primaryClause instanceof SourceIfStatement) {
            int cursorLine;
            SourceIfStatement sourceIfStatement = (SourceIfStatement)primaryClause;
            int ifOffset = sourceIfStatement.getStartOffset();
            LineMap lineMap = buffer.getLineMap();
            int ifLine = lineMap.getLineFromOffset(ifOffset);
            if (ifLine == (cursorLine = lineMap.getLineFromOffset(offset))) {
                ret = true;
            }
        }
        return ret;
    }
}

