/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.editor.language.java.JavaLanguageSupport;
import oracle.javatools.editor.language.java.JavaStyles;
import oracle.javatools.resource.BundleHelper;

public final class JavaLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"java", "sqlj"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("JAVA_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return JavaStyles.getStyleNames();
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("import java.util.Date;\n");
        buffer.append("import java.text.DateFormat;\n");
        buffer.append("\n");
        buffer.append("/**\n");
        buffer.append(" * Simple <code>Today</code> class which ");
        buffer.append("prints out today's date.\n");
        buffer.append(" * @version 1.00 09/25/2001\n");
        buffer.append(" */\n");
        buffer.append("public final class Today\n");
        buffer.append("{\n");
        buffer.append("  public static void main( String[] args )\n");
        buffer.append("  {\n");
        buffer.append("    // We don't take any arguments\n");
        buffer.append("    if ( ( args != null ) && ( args.length > 0 ) )\n");
        buffer.append("    {\n");
        buffer.append("      System.out.println( \"Usage:\" );\n");
        buffer.append("      System.out.println( \"  java Today\" );\n");
        buffer.append("      return;\n");
        buffer.append("    }\n");
        buffer.append("\n");
        buffer.append("    // Use the local date formatter\n");
        buffer.append("    Date today = new Date();\n");
        buffer.append("    String todayText = ");
        buffer.append("DateFormat.getDateInstance().format( today );\n");
        buffer.append("    System.out.println( \"Today's date: \" + ");
        buffer.append("todayText );\n");
        buffer.append("  }\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new JavaStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new JavaLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new JavaBlockRenderer(buffer);
    }
}

