/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.CoreLoop;
import oracle.maps.core.EventManager;
import oracle.maps.core.Filter;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapRegion;
import oracle.maps.core.MapUndoManager;
import oracle.maps.core.TileLayerConfig;
import oracle.maps.layer.MVImageLayer;
import oracle.maps.layer.ui.ProgressIndicatorLayer;

public class MapCanvas
extends JPanel
implements PropertyChangeListener {
    public static final String PROGRESS_STATE = "state";
    public static final String PROGRESS_VALUE = "progress";
    public static final String PROGRESS_STRING = "progressString";
    public static final String PROGRESS_INDETERMINATE = "progressIndeterminate";
    private long paintTime;
    private CoreLoop loop = null;
    private EventManager eventManager = null;
    private LayerManager layerManager = null;
    private MapUndoManager undoManager = null;
    private MapRegion mapRegion = null;
    private JPopupMenu popUpMenu = null;
    private JProgressBar progressBar = new JProgressBar();
    private Hashtable<Object, ProgressBean> progressRecord = new Hashtable();
    private Cursor myCursor = this.getCursor();
    private EventListenerList listenerList = new EventListenerList();

    public MapCanvas() {
        this((LayerManager)null);
    }

    public MapCanvas(LayerManager layerManager) {
        this.loop = new CoreLoop(this);
        this.progressBar.setStringPainted(true);
        ProgressBean rdy = new ProgressBean();
        rdy.lastModify = System.currentTimeMillis();
        rdy.progress = 0;
        rdy.string = "Ready";
        this.progressRecord.put(rdy, rdy);
        this.updateBarInfo(rdy);
        this.setFocusable(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MapCanvas.this.loop.start();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MapCanvas.this.loop.stop();
            }
        });
        this.setLayerManager(layerManager);
        this.setMapRegion(new MapRegion(this));
        this.setEventManager(new EventManager());
        this.setUndoManager(new MapUndoManager());
        this.loop.start();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.myCursor = cursor;
    }

    public void actuallySetCursor() {
        if (this.myCursor != this.getCursor()) {
            super.setCursor(this.myCursor);
        }
    }

    public Frame getFrameForDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        long start = System.currentTimeMillis();
        super.paintComponent(g);
        ArrayList<Layer> exceptedLayers = new ArrayList<Layer>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Layer layer : this.getLayerManager()) {
            try {
                if (!layer.isVisible()) continue;
                layer.render((Graphics2D)g.create());
            }
            catch (Throwable ex) {
                exceptedLayers.add(layer);
                exceptions.add(ex);
            }
        }
        if (!exceptedLayers.isEmpty()) {
            this.onLayerException(exceptedLayers, exceptions);
        }
        this.paintTime = System.currentTimeMillis() - start;
    }

    public long getPaintTime() {
        return this.paintTime;
    }

    public void update(long elapsedTime) {
        ArrayList<Layer> exceptedLayers = new ArrayList<Layer>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Layer layer : this.getLayerManager()) {
            try {
                Rectangle2D mbr;
                if (layer.isVisible()) {
                    layer.update(elapsedTime);
                }
                if (this.mapRegion.getDataWindow() != null || (mbr = layer.getDataMBR()) == null) continue;
                this.mapRegion.setDataWindowQuietly(mbr);
            }
            catch (Throwable ex) {
                exceptedLayers.add(layer);
                exceptions.add(ex);
            }
        }
        if (!exceptedLayers.isEmpty()) {
            this.onLayerException(exceptedLayers, exceptions);
        }
    }

    void onLayerException(ArrayList<Layer> layers, ArrayList<Throwable> exceptions) {
        Iterator<Layer> li = layers.iterator();
        Iterator<Throwable> ei = exceptions.iterator();
        while (li.hasNext() && ei.hasNext()) {
            Layer layer = li.next();
            Throwable exception = ei.next();
            System.err.println("Layer \"" + layer.getName() + "\" (" + layer.getClass().getName() + ") has thrown an exception.");
            exception.printStackTrace();
        }
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void setLayerManager(LayerManager layerManager) {
        if (layerManager == null) {
            layerManager = new LayerManager(this);
        }
        this.layerManager = layerManager;
        layerManager.setMapCanvas(this);
    }

    public MapUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(MapUndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public MapRegion getMapRegion() {
        return this.mapRegion;
    }

    public void setMapRegion(MapRegion mapRegion) {
        MapRegion old = this.getMapRegion();
        if (old != null && this.getEventManager() != null) {
            old.removeChangeListener(this.getEventManager());
        }
        this.mapRegion = mapRegion;
        if (mapRegion == null) {
            return;
        }
        if (this.getEventManager() != null) {
            mapRegion.addChangeListener(this.getEventManager());
        }
    }

    public AffineTransform getViewportTransform() {
        return this.mapRegion.getViewportTransform();
    }

    public ProgressIndicatorLayer getProgressIndicator() {
        return (ProgressIndicatorLayer)this.layerManager.getLayerByTag("progresIndicatorLayer");
    }

    public TileLayerConfig getTileLayerConfig() {
        TileLayerConfig tlc = null;
        Layer sml = this.layerManager.filterSet(new Filter<Layer>(){

            @Override
            public boolean accept(Layer l, Object[] p) {
                return l.isVisible() && l instanceof MVImageLayer && ((MVImageLayer)l).getTileLayerConfig() != null;
            }
        }, 1).getFirst();
        if (sml != null) {
            tlc = ((MVImageLayer)sml).getTileLayerConfig();
        }
        return tlc;
    }

    public void zoomToLayer(Layer layer) {
        if (layer == null) {
            return;
        }
        Rectangle2D dataMbr = layer.getDataMBR();
        if (dataMbr == null) {
            System.err.println("No data MBR found.");
            return;
        }
        AffineTransform xfm = this.mapRegion.getViewportTransform();
        Point2D.Double p = new Point2D.Double(dataMbr.getMinX(), dataMbr.getMinY());
        xfm.transform(p, p);
        Point2D.Double p2 = new Point2D.Double(dataMbr.getMaxX(), dataMbr.getMaxY());
        xfm.transform(p2, p2);
        Rectangle2D.Double window = new Rectangle2D.Double(Math.min(((Point2D)p).getX(), ((Point2D)p2).getX()), Math.min(((Point2D)p).getY(), ((Point2D)p2).getY()), Math.abs(((Point2D)p2).getX() - ((Point2D)p).getX()), Math.abs(((Point2D)p2).getY() - ((Point2D)p).getY()));
        this.mapRegion.zoomBox(window);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        EventManager old = this.getEventManager();
        if (old != null) {
            old.setCanvas(null);
            this.removeMouseListener(old);
            this.removeKeyListener(old);
            this.removeMouseMotionListener(old);
            this.removeMouseWheelListener(old);
            this.removeComponentListener(old);
            this.removeFocusListener(old);
            if (this.getMapRegion() != null) {
                this.getMapRegion().removeChangeListener(old);
            }
        }
        this.eventManager = eventManager;
        if (eventManager == null) {
            return;
        }
        eventManager.setCanvas(this);
        this.addMouseListener(eventManager);
        this.addKeyListener(eventManager);
        this.addMouseMotionListener(eventManager);
        this.addMouseWheelListener(eventManager);
        this.addComponentListener(eventManager);
        this.addFocusListener(eventManager);
        if (this.getMapRegion() != null) {
            this.getMapRegion().addChangeListener(eventManager);
        }
    }

    public CoreLoop getCoreLoop() {
        return this.loop;
    }

    public void setCoreLoop(CoreLoop loop) {
        this.loop = loop;
    }

    public void setPopupMenu(JPopupMenu popUpMenu) {
        this.popUpMenu = popUpMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.popUpMenu;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public void propertyChange(Object src, String propertyName, Object oldValue, Object newValue) {
        this.propertyChange(new PropertyChangeEvent(src, propertyName, oldValue, newValue));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        ProgressBean bean = this.progressRecord.get(src);
        if (bean == null) {
            if (src instanceof SwingWorker && ((SwingWorker)src).isCancelled()) {
                return;
            }
            bean = new ProgressBean();
            this.progressRecord.put(src, bean);
        }
        String propName = evt.getPropertyName();
        Object newVal = evt.getNewValue();
        if (PROGRESS_VALUE.equals(propName)) {
            bean.progress = (Integer)newVal;
        } else if (PROGRESS_STRING.equals(propName)) {
            bean.string = (String)newVal;
        } else if (PROGRESS_INDETERMINATE.equals(propName)) {
            bean.indeterminate = (Boolean)newVal;
        } else if (PROGRESS_STATE.equals(propName) && newVal == SwingWorker.StateValue.DONE) {
            this.progressRecord.remove(src);
            ProgressBean mostRecent = null;
            for (ProgressBean b : this.progressRecord.values()) {
                if (mostRecent != null && b.lastModify <= mostRecent.lastModify) continue;
                mostRecent = b;
            }
            if (mostRecent != null) {
                this.updateBarInfo(mostRecent);
                return;
            }
        }
        bean.lastModify = System.currentTimeMillis();
        this.updateBarInfo(bean);
    }

    private void updateBarInfo(ProgressBean bean) {
        if (bean.string != null) {
            int chars;
            int percentWidth;
            FontMetrics metrics;
            int statusWidth;
            Graphics g;
            String status = bean.string;
            String percent = "";
            if (bean.progress > 0) {
                percent = " [" + bean.progress + "%]";
            }
            if ((g = this.progressBar.getGraphics()) != null && (statusWidth = (metrics = g.getFontMetrics(this.progressBar.getFont())).stringWidth(status)) + (percentWidth = metrics.stringWidth(percent)) > this.progressBar.getWidth() && (chars = (int)((double)status.length() * ((1.0 * (double)this.progressBar.getWidth() - (double)percentWidth) / (double)statusWidth)) - 1) > 0 && chars <= status.length()) {
                status = status.substring(0, chars);
            }
            this.progressBar.setIndeterminate(bean.indeterminate);
            this.progressBar.setString(status + percent);
            this.progressBar.setValue(bean.progress);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private class ProgressBean {
        public long lastModify = -1L;
        public String string = null;
        public int progress = 0;
        public boolean indeterminate = false;

        private ProgressBean() {
        }
    }
}

