/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MapUndoManager
extends UndoManager {
    private static final int BLOCKSTART = 1;
    private static final int BLOCKEND = 2;
    private int openBlocks = 0;
    private EventListenerList listenerList = new EventListenerList();
    private boolean undoORredoPerformed = false;

    public MapUndoManager() {
        this.setLimit(-1);
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean result = super.addEdit(anEdit);
        if (result && this.openBlocks == 0) {
            this.fireStateChanged();
        }
        return result;
    }

    public synchronized boolean trimEdits(UndoableEdit from, boolean inclusiveFrom) {
        if (this.edits.size() == 0) {
            return false;
        }
        return this.trimEdits(from, inclusiveFrom, (UndoableEdit)this.edits.get(this.edits.size() - 1), true);
    }

    public synchronized boolean trimEdits(UndoableEdit from, UndoableEdit to) {
        return this.trimEdits(from, true, to, true);
    }

    public synchronized boolean trimEdits(UndoableEdit from, boolean inclusiveFrom, UndoableEdit to, boolean inclusiveTo) {
        int indFrom = this.edits.lastIndexOf(from);
        int indTo = this.edits.indexOf(to);
        if (indFrom == -1 || indTo == -1) {
            return false;
        }
        if (!inclusiveFrom) {
            ++indFrom;
        }
        if (!inclusiveTo) {
            --indTo;
        }
        int prevSize = this.edits.size();
        this.trimEdits(indFrom, indTo);
        if (prevSize == this.edits.size()) {
            return false;
        }
        this.fireStateChanged();
        return true;
    }

    @Override
    public synchronized void discardAllEdits() {
        int prevSize = this.edits.size();
        super.discardAllEdits();
        if (prevSize != this.edits.size()) {
            this.fireStateChanged();
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        if (this.openBlocks > 0) {
            throw new CannotUndoException();
        }
        int blocks = 0;
        do {
            UndoableEdit edit = this.editToBeUndone();
            super.undo();
            if (!(edit instanceof SpecialUndoableEdit)) continue;
            SpecialUndoableEdit se = (SpecialUndoableEdit)edit;
            int type = se.getType();
            if (type == 2) {
                ++blocks;
                continue;
            }
            --blocks;
        } while (blocks > 0);
        this.undoORredoPerformed = true;
        this.fireStateChanged();
        this.undoORredoPerformed = false;
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        if (this.openBlocks > 0) {
            throw new CannotRedoException();
        }
        int blocks = 0;
        do {
            UndoableEdit edit = this.editToBeRedone();
            super.redo();
            if (!(edit instanceof SpecialUndoableEdit)) continue;
            SpecialUndoableEdit se = (SpecialUndoableEdit)edit;
            int type = se.getType();
            if (type == 1) {
                ++blocks;
                continue;
            }
            --blocks;
        } while (blocks > 0);
        this.undoORredoPerformed = true;
        this.fireStateChanged();
        this.undoORredoPerformed = false;
    }

    public boolean undoORredoPerfomed() {
        return this.undoORredoPerformed;
    }

    public synchronized UndoableEdit startChangeBlock(String changeName) {
        ++this.openBlocks;
        SpecialUndoableEdit edit = new SpecialUndoableEdit(1, changeName);
        this.addEdit(edit);
        return edit;
    }

    public synchronized UndoableEdit endChangeBlock(String changeName) {
        if (this.openBlocks < 1) {
            return null;
        }
        --this.openBlocks;
        SpecialUndoableEdit edit = null;
        UndoableEdit last = (UndoableEdit)this.edits.get(this.edits.size() - 1);
        if (last instanceof SpecialUndoableEdit && ((SpecialUndoableEdit)last).getType() == 1) {
            this.trimEdits(this.edits.size() - 1, this.edits.size() - 1);
        } else {
            edit = new SpecialUndoableEdit(2, changeName);
            this.addEdit(edit);
        }
        return edit;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public int getNumberOfEdits() {
        if (this.edits == null) {
            return 0;
        }
        return this.edits.size();
    }

    private class SpecialUndoableEdit
    extends AbstractUndoableEdit {
        int type = -1;
        String name = null;

        public SpecialUndoableEdit(int type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public String getPresentationName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }
}

