/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.internal;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.maps.core.MapCanvas;

public class LayerTransitionHelper {
    MapCanvas canvas;
    boolean waitingOnServer = false;
    protected Rectangle2D lastQueryWindow = null;

    public LayerTransitionHelper(MapCanvas canvas) {
        this.canvas = canvas;
    }

    public MapCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
    }

    public Rectangle2D getLastQueryWindow() {
        return this.lastQueryWindow;
    }

    public void setLastQueryWindow(Rectangle2D lastQueryWindow) {
        this.lastQueryWindow = lastQueryWindow;
    }

    public boolean isWaitingOnServer() {
        return this.waitingOnServer;
    }

    public void setWaitingOnServer(boolean waitingOnServer) {
        this.waitingOnServer = waitingOnServer;
    }

    public boolean regionChanged() {
        boolean regionChanged = false;
        Rectangle2D currentQueryWin = this.canvas.getMapRegion().getDataWindow();
        if (this.lastQueryWindow != null && currentQueryWin != null && (this.lastQueryWindow.getMinX() != currentQueryWin.getMinX() || this.lastQueryWindow.getMinY() != currentQueryWin.getMinY() || this.lastQueryWindow.getWidth() != currentQueryWin.getWidth() || this.lastQueryWindow.getHeight() != currentQueryWin.getHeight())) {
            regionChanged = true;
        }
        return regionChanged;
    }

    public void drawTransitionImage(Graphics2D g, Image img) {
        if (this.lastQueryWindow == null && img != null) {
            g.drawImage(img, 0, 0, null);
            return;
        }
        Rectangle2D currentQW = this.canvas.getMapRegion().getDataWindow();
        boolean isPan = false;
        if (this.lastQueryWindow.getWidth() == currentQW.getWidth() && this.lastQueryWindow.getHeight() == currentQW.getHeight()) {
            isPan = true;
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        Point2D.Double p1 = new Point2D.Double(this.lastQueryWindow.getMinX(), this.lastQueryWindow.getMinY());
        xfm.transform(p1, p1);
        Point2D.Double p2 = new Point2D.Double(this.lastQueryWindow.getMaxX(), this.lastQueryWindow.getMaxY());
        xfm.transform(p2, p2);
        double x = Math.min(((Point2D)p1).getX(), ((Point2D)p2).getX());
        double y = Math.min(((Point2D)p1).getY(), ((Point2D)p2).getY());
        double w = Math.abs(((Point2D)p2).getX() - ((Point2D)p1).getX());
        double h = Math.abs(((Point2D)p2).getY() - ((Point2D)p1).getY());
        if (isPan) {
            g.drawImage(img, (int)x, (int)y, null);
            return;
        }
        int dw = this.canvas.getWidth();
        int dh = this.canvas.getHeight();
        g.drawImage(img, (int)x, (int)y, (int)(x + w), (int)(y + h), 0, 0, dw, dh, this.canvas);
    }
}

