/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.maps.core.DefaultSelectionManager;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionListener;
import oracle.maps.geoobject.ShapeObject;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.util.DynamicVertexSet;

public class HandDrawingLayer
extends BasicLayer
implements EditableLayer,
SelectableLayer,
HoverableLayer {
    private static int DRAW_MODE = 0;
    private static int PICK_MODE = 1;
    private int nextKey = 0;
    private Map<String, GeoObject> shapes = new HashMap<String, GeoObject>();
    private Cursor myCursor = null;
    private Color shapeColor = Color.blue;
    private Stroke shapeStroke = new BasicStroke(2.0f);
    private Stroke simpleStroke = new BasicStroke(1.0f);
    private float dashOffset = 0.0f;
    private boolean offsetIncreasing = true;
    private AnimatedStroke animeStroke = null;
    private AnimatedStroke animeStrokeForSelected = null;
    private int operationMode = DRAW_MODE;
    private DynamicVertexSet vertexHandles = new DynamicVertexSet(4.0);
    private Font f = new Font("Helvetica", 1, 14);
    private Color bboxColor = new Color(10, 255, 255, 128);
    private DefaultSelectionManager selectionManager = new DefaultSelectionManager(this);
    private DefaultSelectionManager hoverManager = new DefaultSelectionManager(this);

    public HandDrawingLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
        this.myCursor = Cursor.getPredefinedCursor(1);
        this.animeStroke = new AnimatedStroke(Color.magenta, 5.0f);
        this.animeStroke.setWidth(2.0f);
        this.animeStroke.setDash(new float[]{10.0f, 6.0f});
        this.animeStroke.setMode(1);
        this.animeStrokeForSelected = new AnimatedStroke(Color.black);
    }

    @Override
    public void setEditable(boolean editable) {
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(editable));
    }

    @Override
    public boolean isEditable() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.EditableLayer.editable"));
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void clearChanges() {
        this.clear();
    }

    @Override
    public void addEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void clear() {
        this.shapes.clear();
    }

    @Override
    public void handleTheEvent(EventObject evt) {
    }

    @Override
    public long render(Graphics2D g) {
        GeoObject hoverShape;
        Shape shp;
        long t0 = System.currentTimeMillis();
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.shapeColor);
        g.setStroke(this.shapeStroke);
        for (String key : this.shapes.keySet()) {
            GeoObject obj = this.shapes.get(key);
            shp = (Shape)((Object)obj.getDrawable(xfm));
            if (this.isSelected(obj)) continue;
            g.draw(shp);
        }
        if (this.numSelected() > 0 && this.animeStrokeForSelected != null) {
            for (GeoObject selectedShape : this.getSelection()) {
                g.setColor(this.animeStrokeForSelected.getColor());
                g.setStroke(this.animeStrokeForSelected.getStroke());
                shp = (Shape)((Object)selectedShape.getDrawable(xfm));
                g.draw(shp);
            }
        }
        if (this.numHovered() > 0 && !this.isSelected(hoverShape = this.getHover().get(0))) {
            g.setColor(Color.yellow);
            g.setStroke(this.shapeStroke);
            Shape shp2 = (Shape)((Object)hoverShape.getDrawable(xfm));
            g.draw(shp2);
        }
        if (this.vertexHandles.size() > 0) {
            g.setColor(Color.blue);
            g.setStroke(this.simpleStroke);
            Rectangle2D[] boxes = this.vertexHandles.getBoxes();
            for (int i = 0; i < boxes.length; ++i) {
                g.draw(boxes[i]);
            }
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    @Override
    public void update(long elapsedTime) {
        this.animeStroke.update(elapsedTime);
        this.animeStrokeForSelected.update(elapsedTime);
    }

    public Map getShapes() {
        return this.shapes;
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        xfm.transform(new Point2D.Double(x, y), pt);
        double _x = ((Point2D)pt).getX();
        double _y = ((Point2D)pt).getY();
        for (String key : this.shapes.keySet()) {
            GeoObject obj = this.shapes.get(key);
            Shape shp = ((ShapeObject)obj).getShape();
            Rectangle2D mbr = shp.getBounds2D();
            if (!mbr.contains(_x, _y)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GeoObject deleteObject(Object key) {
        GeoObject old = this.shapes.get(key);
        this.shapes.remove(key);
        return old;
    }

    @Override
    public boolean insertObject(Object key, GeoObject obj) {
        if (key == null) {
            key = this.getNextKey();
            obj.setKey(key);
        }
        this.shapes.put((String)key, obj);
        return true;
    }

    @Override
    public GeoObject updateObject(Object key, GeoObject changedObject) {
        GeoObject old = this.shapes.get(changedObject.getKey());
        if (old != changedObject) {
            this.shapes.put((String)key, changedObject);
        }
        return old;
    }

    @Override
    public GeoObject getObject(Object key) {
        return this.shapes.get(key);
    }

    @Override
    public GeoObject[] getObjects() {
        return this.shapes.values().toArray(new GeoObject[this.shapes.size()]);
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DynamicVertexSet getActiveVertexHandles() {
        return this.vertexHandles;
    }

    private Object getNextKey() {
        return "" + this.nextKey++;
    }

    @Override
    public boolean isSelected(GeoObject obj) {
        return this.selectionManager.isSelected(obj);
    }

    @Override
    public boolean clearSelection() {
        return this.selectionManager.clear();
    }

    @Override
    public int numSelected() {
        return this.selectionManager.size();
    }

    @Override
    public List<GeoObject> getSelection() {
        return this.selectionManager.getSelection();
    }

    @Override
    public List<GeoObject> getSelection(GeoObject obj) {
        return this.selectionManager.getSelection(obj);
    }

    @Override
    public boolean setSelection(List<GeoObject> objs) {
        return this.selectionManager.setSelection(objs);
    }

    @Override
    public boolean select(List<GeoObject> objs) {
        return this.selectionManager.select(objs);
    }

    @Override
    public boolean unselect(List<GeoObject> objs) {
        return this.selectionManager.unselect(objs);
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionManager.addSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionManager.removeSelectionListener(l);
    }

    @Override
    public boolean setHover(List<GeoObject> objs) {
        return this.hoverManager.setSelection(objs);
    }

    @Override
    public boolean clearHover() {
        return this.hoverManager.clear();
    }

    @Override
    public List<GeoObject> getHover() {
        return this.hoverManager.getSelection();
    }

    @Override
    public boolean isHover(GeoObject obj) {
        return this.hoverManager.isSelected(obj);
    }

    @Override
    public int numHovered() {
        return this.hoverManager.size();
    }
}

