/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.DataProducer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MVThemeLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.TileLayerConfig;
import oracle.maps.geoobject.ImageObject;
import oracle.maps.internal.LayerTransitionHelper;
import oracle.maps.layer.BasicLayer;
import oracle.maps.producer.MVImageProducer;

public class ServerMapLayer
extends BasicLayer
implements ChangeListener {
    protected boolean imgUpToDate = false;
    protected GeoDataProducer geoProducer = null;
    protected Image img = null;
    protected Color backgroundColor = new Color(204, 204, 255);
    private LayerTransitionHelper transitionHelper = null;

    public ServerMapLayer(MapCanvas canvas) {
        super(canvas);
        this.transitionHelper = new LayerTransitionHelper(canvas);
    }

    @Override
    public void clear() {
        this.img = null;
        this.imgUpToDate = false;
    }

    public List<ThemeDescriptor> getThemes() {
        ArrayList<ThemeDescriptor> themes = new ArrayList<ThemeDescriptor>();
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof MVThemeLayer) || !l.isVisible()) continue;
            themes.add(((MVThemeLayer)l).getThemeDescriptor());
        }
        return themes;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getThemes().size() > 0;
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasEnabledThemes() {
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof MVThemeLayer) || !l.isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTileLayer() {
        List<ThemeDescriptor> tds = this.getThemes();
        for (ThemeDescriptor td : tds) {
            if (td.type != 9) continue;
            return true;
        }
        return false;
    }

    @Override
    public long render(Graphics2D g) {
        if (this.img == null) {
            return 0L;
        }
        long t1 = System.currentTimeMillis();
        if (this.imgUpToDate) {
            if (this.transitionHelper.isWaitingOnServer() || this.transitionHelper.regionChanged()) {
                this.transitionHelper.drawTransitionImage(g, this.img);
            } else {
                g.drawImage(this.img, 0, 0, null);
            }
        } else {
            g.drawImage(this.img, 0, 0, null);
            this.imgUpToDate = true;
            this.transitionHelper.setLastQueryWindow(this.canvas.getMapRegion().getDataWindow());
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        super.setCanvas(canvas);
        if (canvas != null) {
            canvas.getLayerManager().addChangeListener(this);
        }
        if (this.transitionHelper != null) {
            this.transitionHelper.setCanvas(canvas);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
    }

    public void onDataException(DataProducer producer, Throwable exception) {
        this.transitionHelper.setWaitingOnServer(false);
        exception.printStackTrace();
    }

    public void onDataReady(DataProducer producer) {
        this.transitionHelper.setWaitingOnServer(false);
        this.img = ((ImageObject)this.geoProducer.getData()[0]).getImage();
        this.imgUpToDate = false;
    }

    public GeoDataProducer getGeoDataProducer() {
        return this.geoProducer;
    }

    public void setGeoDataProducer(GeoDataProducer producer) {
        if (!(producer instanceof MVImageProducer)) {
            throw new UnsupportedOperationException("Invalid producer");
        }
        this.geoProducer = producer;
        this.geoProducer.setLayer(this);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroudnColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.backgroundColor == color) {
            return;
        }
        this.backgroundColor = color;
    }

    @Override
    public void repaint() {
    }

    public TileLayerConfig getTileLayerConfig() {
        return null;
    }

    public void setTileLayerConfig(TileLayerConfig tileLayerConfig) {
        this.canvas.getMapRegion().setDataWindow(this.canvas.getMapRegion().getDataWindow());
    }

    @Override
    public Rectangle2D getDataMBR() {
        return null;
    }

    @Override
    public void added(Object source) {
        super.added(source);
        if (source instanceof MapCanvas && this.hasTileLayer()) {
            this.canvas.getMapRegion().setDataWindow(this.canvas.getMapRegion().getDataWindow());
        }
    }
}

