/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.maps.core.MapCanvas;
import oracle.mdeditor.ui.AnnotationTextMetadataAttrsPanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.text.AnnotationText;
import oracle.spatial.edit.index.annotationtext.IndexedAnnotationTextSet;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;

public class AnnotationTextElementPanel
extends JPanel {
    private JLabel textelemLabel = new JLabel();
    private JTextField textelemTxt = new JTextField();
    private JLabel elemvalueLabel = new JLabel();
    private JTextField elemvalueTxt = new JTextField();
    private AnnotationTextMetadataAttrsPanel textattrsPanel = new AnnotationTextMetadataAttrsPanel(null);
    private JButton applyButton = new JButton();
    private JCheckBox textattrBox = new JCheckBox();
    private AnnotationTextFeature selFeature = null;
    private int featElemIndex = -1;
    private MapCanvas drawPanel = null;
    private int undoSteps = 0;
    private JButton undoButton = new JButton();
    private AnnotationTextSetLayer layer = null;

    public AnnotationTextElementPanel(AnnotationTextSetLayer layer, AnnotationTextFeature feat, int elemIndex) {
        this.layer = layer;
        this.selFeature = feat;
        this.featElemIndex = elemIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(321, 406));
        this.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Annotation_text")));
        this.textelemLabel.setText(MessagesBundle.getMessage("Label_text_element"));
        this.textelemTxt.setText(String.valueOf(this.featElemIndex));
        this.textelemTxt.setEditable(false);
        this.elemvalueLabel.setText(MessagesBundle.getMessage("Label_text_value"));
        this.applyButton.setText(MessagesBundle.getMessage("Apply"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationTextElementPanel.this.applyButton_actionPerformed(e);
            }
        });
        this.textattrBox.setText(MessagesBundle.getMessage("Text_attributes_from_metadata"));
        this.textattrBox.setSelected(true);
        this.textattrBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationTextElementPanel.this.textattrBox_actionPerformed(e);
            }
        });
        this.undoButton.setText(MessagesBundle.getMessage("Undo"));
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationTextElementPanel.this.undoButton_actionPerformed(e);
            }
        });
        this.add((Component)this.textelemLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.textelemTxt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 50, 0));
        this.add((Component)this.elemvalueLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.elemvalueTxt, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.textattrBox, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.textattrsPanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.undoButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.refreshUI();
    }

    public AnnotationTextFeature getFeature() {
        return this.selFeature;
    }

    public void setFeatureElement(AnnotationTextFeature feat, int elemIndex) {
        this.selFeature = feat;
        this.featElemIndex = feat != null && feat.getSpatialAttribute() != null ? (elemIndex >= feat.getSpatialAttribute().getNumberOfElements() ? 0 : elemIndex) : -1;
        this.refreshUI();
    }

    public void refreshUI() {
        if (this.selFeature == null) {
            this.setUIEnabledForTextElements(false);
        } else {
            AnnotationText geom = this.selFeature.getSpatialAttribute();
            if (geom == null) {
                this.setUIEnabledForTextElements(false);
                return;
            }
            int numElements = geom.getNumberOfElements();
            if (numElements > 0) {
                this.setTextElementInfo(this.featElemIndex);
                this.setUIEnabledForTextElements(true);
            } else {
                this.setUIEnabledForTextElements(false);
            }
            if (this.drawPanel == null) {
                this.applyButton.setEnabled(false);
                this.undoButton.setEnabled(false);
            } else {
                this.applyButton.setEnabled(true);
                if (this.undoSteps > 0) {
                    this.undoButton.setEnabled(true);
                } else {
                    this.undoButton.setEnabled(false);
                }
            }
        }
    }

    public void resetUndoSteps() {
        this.undoSteps = 0;
        this.undoButton.setEnabled(false);
    }

    public AnnotationText getAnnotationText() {
        if (this.selFeature == null) {
            return null;
        }
        return this.selFeature.getSpatialAttribute();
    }

    public void setTextValue(String value) {
        if (value == null) {
            this.elemvalueTxt.setText("");
        } else {
            this.elemvalueTxt.setText(value);
        }
    }

    public String getTextValue() {
        String value = this.elemvalueTxt.getText().trim();
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    public void setUIEnabledForTextElements(boolean enable) {
        this.textelemTxt.setEnabled(enable);
        this.elemvalueTxt.setEnabled(enable);
        this.textattrBox.setEnabled(enable);
        this.applyButton.setEnabled(enable);
        this.undoButton.setEnabled(enable);
        if (enable) {
            this.textattrBox_actionPerformed(null);
        } else {
            this.textattrsPanel.allowChanges(enable);
        }
    }

    private void setTextElementInfo(int elemIndex) {
        if (this.selFeature == null) {
            return;
        }
        AnnotationText geom = this.selFeature.getSpatialAttribute();
        if (geom == null) {
            return;
        }
        if (elemIndex > -1) {
            this.textelemTxt.setText(String.valueOf(elemIndex));
            this.setTextValue(geom.getElementValue(elemIndex));
            if (geom.getElementAttributes(elemIndex) != null) {
                this.textattrBox.setSelected(false);
                this.textattrsPanel.updateAttributes(geom.getElementAttributes(elemIndex));
            } else {
                this.textattrBox.setSelected(true);
            }
            this.textattrBox_actionPerformed(null);
        }
    }

    public void setDrawPanel(MapCanvas dp) {
        this.drawPanel = dp;
        if (dp != null) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    private void applyButton_actionPerformed(ActionEvent e) {
        if (this.selFeature == null) {
            return;
        }
        int elemIndex = -1;
        try {
            elemIndex = Integer.parseInt(this.textelemTxt.getText());
        }
        catch (Exception ex) {
            return;
        }
        if (elemIndex < 0) {
            return;
        }
        AnnotationText atext = this.selFeature.getSpatialAttribute();
        if (atext == null) {
            return;
        }
        AnnotationText change = (AnnotationText)atext.clone();
        String textValue = this.getTextValue();
        change.setElementValue(elemIndex, textValue);
        if (this.useMetadataAttributes()) {
            change.setElementAttributes(elemIndex, null);
        } else {
            change.setElementAttributes(elemIndex, this.textattrsPanel.getCurrentAttributes());
        }
        ((IndexedAnnotationTextSet)this.layer.getIndexedDataSet()).updateEnvelope(change);
        String keyColumn = this.layer.getIndexedDataSet().getDataSet().getKeyColumn();
        String fkey = this.selFeature.getAttribute(keyColumn).getValue().toString();
        if (this.layer.updateObjectSpatialAttribute(fkey, change) == 1) {
            ++this.undoSteps;
            this.undoButton.setEnabled(true);
        }
    }

    private void textattrBox_actionPerformed(ActionEvent e) {
        if (this.textattrBox.isSelected()) {
            this.textattrsPanel.allowChanges(false);
        } else {
            this.textattrsPanel.allowChanges(true);
        }
    }

    public boolean useMetadataAttributes() {
        return this.textattrBox.isSelected();
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    private void undoButton_actionPerformed(ActionEvent e) {
        if (this.drawPanel == null) {
            return;
        }
        try {
            this.layer.getCanvas().getUndoManager().undo();
        }
        catch (Exception ex) {
            ErrorDialog.showErrorDialog(ex, this, MessagesBundle.getMessage("Unable_toundo_edit_operation"), MessagesBundle.getMessage("Error"), 0);
        }
        --this.undoSteps;
        if (this.undoSteps > 0) {
            this.undoButton.setEnabled(true);
        } else {
            this.undoButton.setEnabled(false);
        }
        if (this.featElemIndex < 0) {
            return;
        }
        this.setTextElementInfo(this.featElemIndex);
    }
}

