/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class ListPanel
extends JPanel {
    private JList list = new JList(new DefaultListModel());
    private JScrollPane scrollPane1 = new JScrollPane(this.list);
    private JLabel dataLabel = new JLabel(MessagesBundle.getMessage("List_items"));

    public ListPanel(List<String> values, String listHeader, int selectionMode) {
        if (listHeader != null) {
            this.dataLabel.setText(listHeader);
        }
        this.list.setSelectionMode(selectionMode);
        DefaultListModel lmodel = (DefaultListModel)this.list.getModel();
        lmodel.clear();
        if (values != null) {
            Collections.sort(values);
            for (String value : values) {
                lmodel.addElement(value);
            }
            if (values.size() > 0) {
                this.list.setSelectedIndex(0);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(450, 233));
        this.add((Component)this.dataLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.scrollPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public Object[] getSelectedItems() {
        return this.list.getSelectedValues();
    }
}

