/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.wfs.layer;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.WfsException;
import oracle.mdeditor.wfs.producer.WFSLayerProducer;
import oracle.sdovis.SRS;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WFSThemeProducer;
import oracle.sdovis.util.GMLGeometryUtils;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsCapabilities;
import oracle.sdovis.util.WfsFeatureType;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.ui.WFSLayerPropertyPanel;
import oracle.spatial.geometry.JGeometry;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WFSLayer
extends GeometrySetLayer {
    private int tmpCounter = 0;
    protected final String KEYATTR = "fid";
    public static final String PROPERTY_SERVERURL = "oracle.mdeditor.wfs.layer.WFSLayer.serverURL";
    public static final String PROPERTY_FEATURETYPE_NAME = "oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName";
    public static final String PROPERTY_FEATURETYPE_NSALIAS = "oracle.mdeditor.wfs.layer.WFSLayer.featureTypeNSAlias";
    public static final String PROPERTY_FEATURETYPE_NSURI = "oracle.mdeditor.wfs.layer.WFSLayer.featureTypeNSURI";
    public static final String PROPERTY_AUTHENTICATION_USER = "oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser";
    public static final String PROPERTY_AUTHENTICATION_PASSWORD = "oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword";
    public static final String PROPERTY_VERSION = "oracle.mdeditor.wfs.layer.WFSLayer.version";

    public WFSLayer() {
        this(null);
    }

    public WFSLayer(MapCanvas mapCanvas) {
        super(mapCanvas);
        this.properties.setDefaultProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer", Boolean.toString(false));
        this.properties.setDefaultProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "fid");
        this.properties.setDefaultProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.optimizeGeometryOperation", Boolean.toString(false));
        this.properties.setDefaultProperty(PROPERTY_VERSION, "1.0.0");
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("earth16.gif");
    }

    public void setThemeProducer(WFSThemeProducer themeProducer) {
        this.liveProducer = new WFSLayerProducer(this, themeProducer);
    }

    public WfsFeatureType getWfsFeatureType() {
        WfsFeatureType type = null;
        WfsCapabilities cap = this.getWfsCapabilities();
        if (cap != null) {
            type = cap.getFeatureType(this.getProperty(PROPERTY_FEATURETYPE_NAME));
        }
        return type;
    }

    public WfsCapabilities getWfsCapabilities() {
        WfsCapabilities cap = null;
        if (this.liveProducer != null) {
            try {
                cap = ((WFSThemeDefinition)((WFSLayerProducer)this.liveProducer).getThemeProd().getTheme().getDefinition()).getCapabilities();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cap;
    }

    @Override
    public Rectangle2D getFullExtent() {
        Rectangle2D.Double extent = null;
        WfsFeatureType featureType = this.getWfsFeatureType();
        if (featureType != null) {
            double[] mbr = featureType.getLatLongBoundingBox();
            extent = mbr != null && mbr.length >= 4 ? new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]) : new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        }
        return extent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSRID() {
        int srid = 0;
        String propSrid = this.getProperty("oracle.maps.core.Layer.srid");
        if (propSrid != null && !propSrid.equalsIgnoreCase("null") && (srid = Integer.parseInt(propSrid)) > 0) {
            return srid;
        }
        WfsFeatureType featureType = this.getWfsFeatureType();
        String srs = featureType.getSRS();
        AbstractDataSource dsrc = this.getDataSource();
        if (dsrc == null) {
            String[] s = srs.split(":");
            srid = Integer.parseInt(s[1]);
        } else {
            AbstractDataAccessObject dao = null;
            try {
                dao = dsrc.getDataAccessObject();
                dao.openConnection();
                SRS srsData = dao.getSRS(srs);
                if (srsData == null) {
                    String[] s = srs.split(":");
                    srid = Integer.parseInt(s[1]);
                } else {
                    srid = srsData.getSRID();
                }
            }
            catch (MDSException ex) {
                String[] s = srs.split(":");
                srid = Integer.parseInt(s[1]);
            }
            catch (Exception e) {
                String[] s = srs.split(":");
                srid = Integer.parseInt(s[1]);
            }
            finally {
                try {
                    dao.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.setProperty("oracle.maps.core.Layer.srid", "" + srid);
        return srid;
    }

    @Override
    protected void updateDataSource() {
    }

    @Override
    public void getTableKeyColumn() {
    }

    @Override
    protected void checkTableKeyExists(String table, String attr, String value, String workspace) throws Exception {
    }

    @Override
    public boolean isVersionEnabled() {
        return false;
    }

    @Override
    public void checkEditReady() throws Exception {
        String txnPostURL = this.getWfsCapabilities().getTransactionPostURL();
        String txnGetURL = this.getWfsCapabilities().getTransactionGetURL();
        if (txnPostURL == null && txnGetURL == null) {
            throw new Exception("Editing not possible");
        }
    }

    @Override
    public void buildDataSet() {
        this.myNewObjects.clear();
        this.myDeleteObjects.clear();
        this.selectionManager.clear();
        this.hoverManager.clear();
        this.liveImg = null;
        this.mvImg = null;
        this.lastViewXFM = null;
        this.lastDataWindow = null;
        this.nonComplexAttrs = null;
        GeometrySet geomSet = new GeometrySet();
        geomSet.setName(this.getName());
        geomSet.setSpatialInfo(null, "fid", null);
        geomSet.addToNonNullAttributes("fid");
        geomSet.setAttributeJavaType("fid", "string");
        geomSet.setSequenceName("something");
        WfsFeatureType type = this.getWfsFeatureType();
        if (type != null) {
            Hashtable nullable = type.getAttributeNullable();
            Hashtable attrTypes = type.getAttributeTypes();
            String geomAttr = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
            String[] attrs = type.getAttributeNames();
            if (attrs != null) {
                for (String attr : attrs) {
                    if (attr.equalsIgnoreCase(geomAttr)) continue;
                    String attrType = (String)attrTypes.get(attr);
                    geomSet.setAttributeJavaType(attr, attrType);
                    String nillable = (String)nullable.get(attr);
                    if (nillable != null && !"false".equalsIgnoreCase(nillable)) continue;
                    geomSet.addToNonNullAttributes(attr);
                }
            }
        }
        this.indexedSet = new IndexedGeometrySet(geomSet);
        this.indexedSet.setDataSetLayer(this);
        this.mapRegionChanged(null);
    }

    @Override
    protected String getNextKeyValueForDataset(String sequence) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(4);
        nf.setGroupingUsed(false);
        return "TEMP." + nf.format(this.tmpCounter++);
    }

    @Override
    public boolean save() {
        try {
            AbstractDataSet set = this.getDataSet();
            if (set == null) {
                throw new Exception("DataSet is null");
            }
            String featureName = this.getProperty(PROPERTY_FEATURETYPE_NAME);
            String spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
            if (featureName == null || featureName.trim().isEmpty() || spatialColumn == null || spatialColumn.trim().isEmpty()) {
                throw new Exception("Undefined spatial column or featureTypeName");
            }
            String nsAlias = this.getProperty(PROPERTY_FEATURETYPE_NSALIAS);
            String nsURI = this.getProperty(PROPERTY_FEATURETYPE_NSURI);
            if (nsAlias == null || nsAlias.trim().isEmpty() || nsURI == null || nsURI.trim().isEmpty()) {
                throw new Exception("Undefined namespace alias or URI");
            }
            WfsCapabilities capabilities = this.getWfsCapabilities();
            if (capabilities == null) {
                throw new Exception("WfsCapabilities is null");
            }
            String srsName = this.getWfsFeatureType().getSRS();
            if (srsName == null) {
                throw new Exception("Undefined SRS Name");
            }
            String wfsTypeName = this.getWfsFeatureType().getAttributeTypes().get(spatialColumn).toString();
            XMLDocument doc = null;
            String[] newFeatures = set.getNewFeatures();
            String[] modFeatures = set.getModifiedFeatures();
            String[] remFeatures = set.getRemovedFeatures();
            String lockId = null;
            ArrayList<String> lockList = new ArrayList<String>();
            if (modFeatures != null && modFeatures.length > 0) {
                for (String s : modFeatures) {
                    lockList.add(s);
                }
            }
            if (remFeatures != null && remFeatures.length > 0) {
                for (String s : remFeatures) {
                    lockList.add(s);
                }
            }
            if (lockList.size() > 0) {
                doc = WFSLayer.createXMLDocument();
                String[] lockFeats = lockList.toArray(new String[lockList.size()]);
                Element lockElem = WFSLayer.createLockFeatureElement100(lockFeats, nsAlias, nsURI, featureName, "ALL", -1, doc);
                doc.appendChild((Node)lockElem);
                lockId = WFSLayer.issueLockFeatureRequest(doc, capabilities);
                if (lockId == null) {
                    throw new Exception("Could not lock all features");
                }
            }
            if (newFeatures != null || remFeatures != null || modFeatures != null) {
                String[] newIds;
                XMLDocument respDoc;
                String status;
                doc = WFSLayer.createXMLDocument();
                Element txnElem = WFSLayer.createTransactionElement100(nsAlias, nsURI, lockId, "ALL", doc);
                doc.appendChild((Node)txnElem);
                ArrayList<String> newFeaturesList = new ArrayList<String>();
                if (newFeatures != null) {
                    Element insertElem = doc.createElement("wfs:Insert");
                    for (String fn : newFeatures) {
                        AbstractFeature gf = set.getFeature(fn);
                        Element featInsertElem = WFSLayer.createInsertElement100(gf, set.getKeyColumn(), nsAlias, nsURI, featureName, spatialColumn, srsName, wfsTypeName, doc);
                        if (featInsertElem == null) continue;
                        insertElem.appendChild(featInsertElem);
                        newFeaturesList.add(fn);
                    }
                    txnElem.appendChild(insertElem);
                }
                if (remFeatures != null) {
                    Element deleteElem = WFSLayer.createDeleteElement100(remFeatures, nsAlias, featureName, doc);
                    txnElem.appendChild(deleteElem);
                }
                if (modFeatures != null) {
                    for (String fn : modFeatures) {
                        Element updateElem = WFSLayer.createUpdateElement100(fn, set, nsAlias, featureName, spatialColumn, srsName, wfsTypeName, doc);
                        txnElem.appendChild(updateElem);
                    }
                }
                if (!(status = WFSLayer.parseTransactionResultStatus(respDoc = WFSLayer.issueTransactionRequest(doc, capabilities))).equalsIgnoreCase("SUCCESS")) {
                    return false;
                }
                if (newFeatures != null && (newIds = WFSLayer.parseTransactionInsertResult(respDoc)) != null) {
                    for (int i = 0; i < newIds.length; ++i) {
                        AbstractFeature gf = set.getFeature((String)newFeaturesList.get(i));
                        if (gf == null) continue;
                        String fid = newIds[i];
                        try {
                            set.deleteFeature(newFeatures[i]);
                            gf.setKey(fid);
                            set.appendFeature(gf);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            this.getDataSet().clearChanges();
            return true;
        }
        catch (Exception ex) {
            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_tosave_data_set", this.getName()), "Error", 2);
            return false;
        }
    }

    private static XMLDocument parse(String s) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setValidationMode(0);
        parser.setPreserveWhitespace(false);
        XMLDocument doc = null;
        StringReader reader = new StringReader(s);
        try {
            parser.parse((Reader)reader);
            doc = parser.getDocument();
        }
        catch (Exception e) {
            throw new Exception("Could not parse server response.");
        }
        finally {
            reader.close();
        }
        return doc;
    }

    public static void createFieldPropertyNode(XMLDocument doc, Element root, String name, Object value, String srsName, String typeName) {
        Element propElem = doc.createElement("wfs:Property");
        root.appendChild(propElem);
        Element propName = doc.createElement("wfs:Name");
        propElem.appendChild(propName);
        Text propNameTxt = doc.createTextNode(name);
        propName.appendChild(propNameTxt);
        Element propValue = doc.createElement("wfs:Value");
        propElem.appendChild(propValue);
        if (value instanceof String) {
            Text propValueTxt = doc.createTextNode((String)value);
            propValue.appendChild(propValueTxt);
        } else if (value instanceof JGeometry) {
            Element gmlElem = WFSLayer.toGMLXMLElem((JGeometry)value, srsName, typeName);
            propValue.appendChild(doc.adoptNode((Node)gmlElem));
        }
    }

    private static XMLDocument createXMLDocument() {
        XMLDocument doc = new XMLDocument();
        doc.setXmlVersion("1.0");
        doc.setEncoding("UTF-8");
        return doc;
    }

    public static Element createTransactionElement100(String nsAlias, String nsURI, String lockId, String releaseAction, XMLDocument doc) {
        if (doc == null) {
            doc = WFSLayer.createXMLDocument();
        }
        Element txnElem = doc.createElement("wfs:Transaction");
        txnElem.setAttribute("version", "1.0.0");
        txnElem.setAttribute("service", "WFS");
        txnElem.setAttribute("releaseAction", releaseAction);
        txnElem.setAttribute("xmlns", nsURI);
        txnElem.setAttribute("xmlns:" + nsAlias, nsURI);
        txnElem.setAttribute("xmlns:gml", "http://www.opengis.net/gml");
        txnElem.setAttribute("xmlns:ogc", "http://www.opengis.net/ogc");
        txnElem.setAttribute("xmlns:wfs", "http://www.opengis.net/wfs");
        txnElem.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (lockId != null) {
            Element lockIdElem = doc.createElement("wfs:LockId");
            txnElem.appendChild(lockIdElem);
            Text idTxt = doc.createTextNode(lockId);
            lockIdElem.appendChild(idTxt);
        }
        return txnElem;
    }

    public static Element createInsertElement100(AbstractFeature feature, String keyColumn, String nsAlias, String nsURI, String featureName, String geometryColumn, String srsName, String typeName, XMLDocument doc) {
        Field[] attrs;
        if (doc == null) {
            doc = WFSLayer.createXMLDocument();
        }
        Element featureInsertElem = doc.createElement(nsAlias + ":" + featureName);
        featureInsertElem.setAttribute("xmlns:" + nsAlias, nsURI);
        Element geomAttrElem = doc.createElement(nsAlias + ":" + geometryColumn);
        featureInsertElem.appendChild(geomAttrElem);
        Element gmlElem = WFSLayer.toGMLXMLElem((JGeometry)feature.getSpatialAttribute(), srsName, typeName);
        if (gmlElem == null) {
            return null;
        }
        geomAttrElem.appendChild(doc.adoptNode((Node)gmlElem));
        for (Field attr : attrs = feature.getAttributes()) {
            if (attr.getName().equalsIgnoreCase(keyColumn)) continue;
            Element featureAttrElem = doc.createElement(nsAlias + ":" + attr.getName());
            featureInsertElem.appendChild(featureAttrElem);
            Text attrTxt = doc.createTextNode(attr.getValue().toString());
            featureAttrElem.appendChild(attrTxt);
        }
        return featureInsertElem;
    }

    public static Element createDeleteElement100(String[] remFeatures, String nsAlias, String featureName, XMLDocument doc) {
        if (doc == null) {
            doc = WFSLayer.createXMLDocument();
        }
        Element deleteElem = doc.createElement("wfs:Delete");
        deleteElem.setAttribute("handle", "DELETE1");
        deleteElem.setAttribute("typeName", nsAlias + ":" + featureName);
        Element deleteFilter = doc.createElement("ogc:Filter");
        deleteElem.appendChild(deleteFilter);
        for (String fn : remFeatures) {
            Element featDeleteElem = doc.createElement("ogc:FeatureId");
            featDeleteElem.setAttribute("fid", fn);
            deleteFilter.appendChild(featDeleteElem);
        }
        return deleteElem;
    }

    public static Element createUpdateElement100(String featureKey, AbstractDataSet set, String nsAlias, String featureName, String geometryColumn, String srsName, String typeName, XMLDocument doc) {
        AbstractFeature gf;
        if (doc == null) {
            doc = WFSLayer.createXMLDocument();
        }
        if ((gf = set.getFeature(featureKey)) == null) {
            return null;
        }
        Element updateElem = doc.createElement("wfs:Update");
        updateElem.setAttribute("handle", "UPDATE_" + featureKey);
        updateElem.setAttribute("typeName", nsAlias + ":" + featureName);
        Field[] attrs = gf.getAttributes();
        String[] modAttrs = set.getChangedAttributesOfModifiedFeature(featureKey);
        ArrayList<String> modifiedAttrs = new ArrayList<String>();
        if (modAttrs != null) {
            for (String string : modAttrs) {
                modifiedAttrs.add(string.toUpperCase());
            }
        }
        for (String string : attrs) {
            if (!modifiedAttrs.contains(string.getName().toUpperCase())) continue;
            WFSLayer.createFieldPropertyNode(doc, updateElem, nsAlias + ":" + string.getName(), string.getValue().toString(), srsName, typeName);
        }
        if (set.hasSpatialAttributeChanged(featureKey) && geometryColumn != null) {
            WFSLayer.createFieldPropertyNode(doc, updateElem, nsAlias + ":" + geometryColumn, gf.getSpatialAttribute(), srsName, typeName);
        }
        Element filterElem = doc.createElement("ogc:Filter");
        updateElem.appendChild(filterElem);
        Element filterFeatureID = doc.createElement("ogc:FeatureId");
        filterFeatureID.setAttribute("fid", featureKey);
        filterElem.appendChild(filterFeatureID);
        return updateElem;
    }

    public static Element createLockFeatureElement100(String[] features, String nsAlias, String nsURI, String featureName, String lockAction, int expiry, XMLDocument doc) {
        if (doc == null) {
            doc = WFSLayer.createXMLDocument();
        }
        Element lockFeatureElem = doc.createElement("wfs:LockFeature");
        lockFeatureElem.setAttribute("version", "1.0.0");
        lockFeatureElem.setAttribute("service", "WFS");
        lockFeatureElem.setAttribute("lockAction", lockAction);
        if (expiry > 0) {
            lockFeatureElem.setAttribute("expiry", "" + expiry);
        }
        lockFeatureElem.setAttribute("xmlns", nsURI);
        lockFeatureElem.setAttribute("xmlns:" + nsAlias, nsURI);
        lockFeatureElem.setAttribute("xmlns:ogc", "http://www.opengis.net/ogc");
        lockFeatureElem.setAttribute("xmlns:wfs", "http://www.opengis.net/wfs");
        lockFeatureElem.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element lockElem = doc.createElement("wfs:Lock");
        lockElem.setAttribute("typeName", nsAlias + ":" + featureName);
        lockFeatureElem.appendChild(lockElem);
        Element filterElem = doc.createElement("ogc:Filter");
        lockElem.appendChild(filterElem);
        for (String fn : features) {
            Element featIdElem = doc.createElement("ogc:FeatureId");
            featIdElem.setAttribute("fid", fn);
            filterElem.appendChild(featIdElem);
        }
        return lockFeatureElem;
    }

    public static XMLDocument issueTransactionRequest(XMLDocument doc, WfsCapabilities capabilities) throws Exception {
        return WFSLayer.issueWFSRequest(doc, capabilities.getTransactionPostURL(), capabilities.getTransactionGetURL());
    }

    public static String issueLockFeatureRequest(XMLDocument doc, WfsCapabilities capabilities) throws Exception {
        XMLDocument respDoc = WFSLayer.issueWFSRequest(doc, capabilities.getLocFeaturePostURL(), capabilities.getLockFeatureGetURL());
        String id = null;
        Element rootNode = respDoc.getDocumentElement();
        if (rootNode != null && Util.normalize((String)rootNode.getNodeName()).equalsIgnoreCase("WFS_LockFeatureResponse")) {
            NodeList children = rootNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || !Util.normalize((String)child.getNodeName()).equalsIgnoreCase("LockId")) continue;
                id = child.getTextContent();
                break;
            }
        }
        return id;
    }

    public static XMLDocument issueWFSRequest(XMLDocument doc, String postURL, String getURL) throws Exception {
        if (postURL == null) {
            throw new NullPointerException("Both post and get URLs are null");
        }
        StringWriter sw = new StringWriter();
        doc.print((Writer)sw);
        String request = sw.toString();
        HttpConnection conn = new HttpConnection();
        conn.connect(postURL);
        XMLDocument respDoc = null;
        try {
            conn.sendXMLRequest("", request);
            String response = conn.getXMLResponse();
            respDoc = WFSLayer.parse(response);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (conn != null) {
                conn.disConnect();
            }
        }
        if (respDoc != null) {
            WFSLayer.parseAndThrowWFSException(respDoc);
        }
        return respDoc;
    }

    public static String parseTransactionResultStatus(XMLDocument doc) {
        String status = "FAILED";
        try {
            XMLElement nsResolver = (XMLElement)doc.getDocumentElement();
            Node statusNode = doc.selectSingleNode("/wfs:WFS_TransactionResponse/wfs:TransactionResult/wfs:Status/*[1]", (NSResolver)nsResolver);
            if (statusNode != null) {
                status = statusNode.getLocalName();
            }
        }
        catch (XSLException ex) {
            ex.printStackTrace();
        }
        return status;
    }

    public static String[] parseTransactionInsertResult(XMLDocument doc) {
        String[] result = null;
        try {
            Node insertNode = doc.selectSingleNode("/wfs:WFS_TransactionResponse/wfs:InsertResult", (NSResolver)((XMLElement)doc.getDocumentElement()));
            NodeList idNodes = insertNode.getChildNodes();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < idNodes.getLength(); ++i) {
                Node idNode = idNodes.item(i);
                String fid = idNode.getAttributes().getNamedItem("fid").getNodeValue();
                list.add(fid);
            }
            result = list.toArray(new String[list.size()]);
        }
        catch (XSLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void parseAndThrowWFSException(XMLDocument doc) throws WfsException {
        Node seNode;
        Element rootNode = doc.getDocumentElement();
        if (rootNode != null && rootNode.getLocalName().equalsIgnoreCase("ServiceExceptionReport") && (seNode = rootNode.getFirstChild()) != null && seNode.getLocalName().equalsIgnoreCase("ServiceException")) {
            String code = null;
            Node codeN = seNode.getAttributes().getNamedItem("code");
            if (codeN != null) {
                code = codeN.getNodeValue();
            }
            String locator = null;
            Node locatorN = seNode.getAttributes().getNamedItem("locator");
            if (locatorN != null) {
                locator = locatorN.getNodeValue();
            }
            String message = seNode.getTextContent().trim();
            throw new WfsException(message, code, locator);
        }
    }

    public static int getNewGTYPE(JGeometry geom, String typeName) {
        int result = -1;
        try {
            typeName = typeName.toUpperCase();
            if (typeName.indexOf("GEOMETRY") > -1) {
                return geom.getType();
            }
            if (typeName.indexOf("member".toUpperCase()) > -1) {
                result = geom.getType();
            } else {
                int targetType = -1;
                if (typeName.indexOf("POINT") > -1) {
                    targetType = 1;
                } else if (typeName.indexOf("LINESTRING") > -1) {
                    targetType = 2;
                } else if (typeName.indexOf("POLYGON") > -1) {
                    targetType = 3;
                }
                JGeometry[] elems = geom.getElements();
                if (targetType == elems[0].getType()) {
                    if (typeName.indexOf("MULTI") > -1) {
                        targetType += 4;
                    } else if (elems.length > 1) {
                        throw new Exception("Single geometry type expected");
                    }
                    result = targetType;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element toGMLXMLElem(JGeometry geom, String srsName, String typeName) {
        StringReader reader = null;
        String gml = null;
        try {
            int newGtype = WFSLayer.getNewGTYPE(geom, typeName);
            if (newGtype != -1) {
                if (newGtype == 5 && geom.getType() == 1) {
                    Point2D pt = geom.getJavaPoint();
                    int[] elemInfo = new int[]{1, 1, 1};
                    double[] oords = new double[]{pt.getX(), pt.getY()};
                    JGeometry g = new JGeometry(2005, geom.getSRID(), elemInfo, oords);
                    gml = GMLGeometryUtils.toGML((JGeometry)g);
                } else {
                    geom.setType(newGtype);
                    gml = GMLGeometryUtils.toGML((JGeometry)geom);
                }
                DOMParser parser = new DOMParser();
                parser.setValidationMode(0);
                parser.setPreserveWhitespace(false);
                reader = new StringReader(gml);
                parser.parse((Reader)reader);
                Element gmlElem = parser.getDocument().getDocumentElement();
                if (srsName != null) {
                    gmlElem.setAttribute("srsName", srsName);
                }
                Element element = gmlElem;
                return element;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return null;
    }

    @Override
    public String[] getNonComplexAttributes() {
        if (this.nonComplexAttrs == null) {
            if (this.liveProducer == null) {
                return null;
            }
            WFSThemeProducer tprod = ((WFSLayerProducer)this.liveProducer).getThemeProd();
            if (tprod == null || tprod.getTheme() == null) {
                return null;
            }
            WFSThemeDefinition tdef = (WFSThemeDefinition)tprod.getTheme().getDefinition();
            if (tdef == null) {
                return null;
            }
            this.nonComplexAttrs = tdef.getFeatureAttributes();
        }
        return this.nonComplexAttrs;
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        WFSLayerPropertyPanel gpropPanel = new WFSLayerPropertyPanel(this);
        return gpropPanel;
    }
}

