/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.AttributeDataProducer;
import oracle.maps.core.DataProducer;
import oracle.maps.core.DefaultSelectionManager;
import oracle.maps.core.Drawable;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.MVThemeLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.MapUndoManager;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionListener;
import oracle.maps.core.SnappableLayer;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.maps.graphics.ShadowRenderer;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.layer.BasicLayer;
import oracle.maps.util.RenderUtils;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.session.layer.WorkspaceLayer;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextLabeler;
import oracle.sdovis.VisContext;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.util.RectArray;
import oracle.spatial.edit.index.topology.IndexedTopologyModel;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.producer.TopologyPrimitivesProducer;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Node;
import org.w3c.dom.Element;

public class TopologyPrimitiveLayer
extends BasicLayer
implements EditableLayer,
SelectableLayer,
HoverableLayer,
MVThemeLayer,
WorkspaceLayer,
ChangeListener,
SnappableLayer {
    protected BufferedImage img = null;
    protected boolean imgUpToDate = false;
    protected String renderStyle = null;
    protected String labelAttribute = null;
    protected String labelStyle = null;
    protected Color hoverColor = new Color(255, 255, 0, 200);
    protected Color hoverBorderColor = Color.darkGray;
    protected Stroke hoverStroke = new BasicStroke(2.0f);
    protected AbstractDataSource dataSource = null;
    protected GeoDataProducer geoProducer = null;
    protected boolean waitingOnServer = false;
    protected Rectangle2D lastQueryWindow = null;
    protected DefaultSelectionManager selectionManager = new DefaultSelectionManager(this);
    protected DefaultSelectionManager hoverManager = new DefaultSelectionManager(this);
    protected MapUndoManager undoManager = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static int UNKNOWN_TYPE = 0;
    public static int NODE_TYPE = 1;
    public static int EDGE_TYPE = 2;
    public static int FACE_TYPE = 3;
    private IndexedTopologyModel indexedModel = null;
    private int primitiveType = UNKNOWN_TYPE;

    public TopologyPrimitiveLayer(MapCanvas canvas, IndexedTopologyModel model, int type) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
        this.indexedModel = model;
        if (type > 0 && type < 4) {
            this.primitiveType = type;
        }
    }

    public TopologyPrimitiveLayer() {
        this(null, null, UNKNOWN_TYPE);
    }

    @Override
    public Point2D snapTo(Point2D point, double tolerance, int granularity) {
        JGeometrySegmentPoint segPt;
        Point2D r = null;
        if (this.indexedModel != null && (segPt = this.indexedModel.getEdgeSegmentPoint(point, tolerance)) != null) {
            r = segPt.getPoint();
        }
        return r;
    }

    @Override
    public boolean isVersionEnabled() throws Exception {
        throw new Exception();
    }

    @Override
    public boolean enableVersioning() throws Exception {
        throw new Exception();
    }

    @Override
    public boolean canDisableVersioning() throws Exception {
        throw new Exception();
    }

    @Override
    public boolean disableVersioning() throws Exception {
        throw new Exception();
    }

    @Override
    public WorkSpace getWorkspace() {
        return new WorkSpace(this.getProperty("oracle.mdeditor.session.layer.WorkspaceLayer.workspacename"));
    }

    public void setWorkspace(String workspace) {
        this.setProperty("oracle.mdeditor.session.layer.WorkspaceLayer.workspacename", workspace);
    }

    @Override
    public Vector<FeatureConflictDescriptor> getConflicts() {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public boolean resolveConflicts(Vector<FeatureConflictDescriptor> conflicts) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public boolean mergeWorkspace() {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public void fromXMLElement(Element element) {
        IndexedTopologyModel indexedModel;
        super.fromXMLElement(element);
        String topology = this.getProperty("topology");
        TopologyModel topoModel = TopologySetLayer.getTopoModels().get(topology.toUpperCase());
        boolean newTopoModel = false;
        if (topoModel == null) {
            topoModel = new TopologyModel(topology, this.canvas.getUndoManager());
            TopologySetLayer.getTopoModels().put(topology.toUpperCase(), topoModel);
            newTopoModel = true;
        }
        int mode = AbstractDataSet.READ_ONLY_SET;
        if (this.isEditable()) {
            mode = AbstractDataSet.READ_WRITE_SET;
        }
        if (newTopoModel) {
            // empty if block
        }
        if ((indexedModel = TopologySetLayer.getIndexedTopoModels().get(topology.toUpperCase())) == null) {
            indexedModel = new IndexedTopologyModel(topoModel);
            TopologySetLayer.getIndexedTopoModels().put(topology.toUpperCase(), indexedModel);
        }
        int topoType = UNKNOWN_TYPE;
        String baseTable = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        if (baseTable.toUpperCase().endsWith("_NODE$")) {
            topoType = NODE_TYPE;
        } else if (baseTable.toUpperCase().endsWith("_EDGE$")) {
            topoType = EDGE_TYPE;
        } else if (baseTable.toUpperCase().endsWith("_FACE$")) {
            topoType = FACE_TYPE;
        }
        TopologySetLayer.getTopoPrimLayers().add(this);
        TopologyPrimitivesProducer idxprod = TopologySetLayer.getTopoPrimProducers().get(topology.toUpperCase());
        if (idxprod == null) {
            idxprod = new TopologyPrimitivesProducer(this.dataSource, indexedModel);
            TopologySetLayer.getTopoPrimProducers().put(topology.toUpperCase(), idxprod);
        }
        idxprod.setTargetSRID(this.getSRID());
        this.setGeoDataProducer(idxprod);
    }

    @Override
    public ThemeDescriptor getThemeDescriptor() {
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = this.getName();
        if (this.primitiveType == FACE_TYPE) {
            td.isDebugTheme = true;
            td.topologyName = this.getProperty("topology");
            td.type = 7;
        } else {
            td.type = 2;
        }
        td.featureTableName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        td.spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        td.renderStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        td.labelColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn");
        td.labelStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle");
        td.SRID = this.getSRID();
        if (!td.isDebugTheme) {
            String query = "select " + td.spatialColumn;
            if (td.labelColumn != null && td.labelColumn.trim().length() > 0) {
                query = query + "," + td.labelColumn.trim();
            }
            query = query + " from " + td.featureTableName;
            td.WFS_queryCondition = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
            if (td.WFS_queryCondition != null && td.WFS_queryCondition.trim().length() > 0) {
                query = query + " where " + td.WFS_queryCondition.trim();
            }
            td.query = query;
            td.nodeStyle = this.getProperty("nodeRenderStyle");
            td.nodeLabelStyle = this.getProperty("nodeLabelStyle");
            td.linkStyle = this.getProperty("edgeRenderStyle");
            td.edgeLabelStyle = this.getProperty("edgeLabelStyle");
            td.faceStyle = this.getProperty("faceRenderStyle");
            td.faceLabelStyle = this.getProperty("faceLabelStyle");
        }
        return td;
    }

    @Override
    public void setEditable(boolean editable) {
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(editable));
    }

    @Override
    public boolean isEditable() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.EditableLayer.editable"));
    }

    @Override
    public boolean save() {
        try {
            this.dataSource.getDataAccessObject().saveDataModel(this.indexedModel.getTopologyModel());
            return true;
        }
        catch (MDSException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void clearChanges() {
        this.indexedModel.getTopologyModel().clearChanges();
    }

    public IndexedTopologyModel getIndexedTopologyModel() {
        return this.indexedModel;
    }

    public int getPrimitiveType() {
        return this.primitiveType;
    }

    protected void renderHoverPoint(Point2D pt, Graphics2D g) {
        Color oc = g.getColor();
        g.setColor(this.hoverColor);
        g.fillOval((int)(pt.getX() - 6.5), (int)(pt.getY() - 6.5), 13, 13);
        g.setColor(oc);
    }

    @Override
    public long render(Graphics2D g) {
        GeoObject hoverShape;
        if (this.indexedModel == null || this.indexedModel.getTopologyModel() == null) {
            return 0L;
        }
        long t1 = System.currentTimeMillis();
        if (!this.imgUpToDate) {
            this.doRealRendering();
            this.lastQueryWindow = this.canvas.getMapRegion().getDataWindow();
        }
        if (this.waitingOnServer || this.regionChanged()) {
            this.drawTransitionImage(g);
        } else {
            g.drawImage((Image)this.img, 0, 0, null);
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        if (this.numHovered() > 0 && (hoverShape = this.getHover().get(0)).getLayer() == this && !this.isSelected(hoverShape)) {
            for (Drawable drawable = hoverShape.getDrawable(xfm); drawable != null; drawable = drawable.getNext()) {
                AbstractFeature feat;
                Field label;
                Point2D shppt = null;
                Shape shp = drawable.getShape();
                if (shp != null) {
                    this.renderHoverShape(hoverShape, shp, g, xfm);
                } else {
                    shppt = drawable.getPoint();
                    if (shppt != null) {
                        this.renderHoverPoint(shppt, g);
                    }
                }
                if (this.labelAttribute == null || this.labelStyle == null || (label = (feat = (AbstractFeature)hoverShape).getAttribute(this.labelAttribute)) == null) continue;
                StyleModel txtmodel = StyleModelUtils.getStyleModel(this.labelStyle);
                StyleText style = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
                float px = 0.0f;
                float py = 0.0f;
                if (shp != null) {
                    Rectangle2D rect = shp.getBounds2D();
                    px = (float)rect.getCenterX();
                    py = (float)rect.getCenterY();
                } else if (shppt != null) {
                    px = (float)shppt.getX() - 5.0f;
                    py = (float)shppt.getY() + 12.0f;
                }
                try {
                    if (shp == null && shppt == null) continue;
                    style.apply(g, px, py, label.getValue().toString(), null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    private void doRealRendering() {
        StyledFeature sf;
        Drawable dr;
        JGeometry geom;
        int i;
        if (this.renderStyle == null || this.primitiveType == UNKNOWN_TYPE) {
            return;
        }
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, 2);
        StyleModel styModel = StyleModelUtils.getStyleModel(this.renderStyle);
        Style style = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
        long t1 = System.currentTimeMillis();
        Graphics2D g = tmpImg.createGraphics();
        AffineTransform xfm = this.canvas.getViewportTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        VisContext vc = null;
        if (this.labelStyle != null) {
            vc = new VisContext();
            vc.setCRArray(new RectArray(10));
            vc.setMarkerCRArray(new RectArray(10));
            vc.setRenderedMarkerCRArray(new RectArray(10));
            try {
                vc.setDeviceWindow((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Rectangle2D rect = this.canvas.getMapRegion().getDataWindow();
        ArrayList faces = null;
        ArrayList edges = null;
        ArrayList nodes = null;
        if (this.primitiveType == NODE_TYPE) {
            nodes = new ArrayList();
        } else if (this.primitiveType == EDGE_TYPE) {
            edges = new ArrayList();
        } else if (this.primitiveType == FACE_TYPE) {
            faces = new ArrayList();
        } else {
            return;
        }
        this.indexedModel.getTopologyModel().getTopologyPrimitives(rect, nodes, edges, faces);
        if (this.primitiveType == FACE_TYPE) {
            Style fcStyle = null;
            StyleText fclbstyle = null;
            if (this.renderStyle != null) {
                StyleModel fcstyModel = StyleModelUtils.getStyleModel(this.renderStyle);
                fcStyle = StyleFactory.createStyleFromXML((String)fcstyModel.toXMLString());
            }
            if (this.labelStyle != null && this.labelAttribute != null) {
                StyleModel txtmodel = StyleModelUtils.getStyleModel(this.labelStyle);
                fclbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
            }
            for (i = 0; i < faces.size(); ++i) {
                int fid = ((Face)faces.get(i)).getID();
                geom = this.indexedModel.getTopologyModel().getFaceGeometry(fid);
                if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getShape() == null) continue;
                if (fcStyle != null) {
                    try {
                        fcStyle.apply(null, g, dr.getShape(), geom.getType(), null, null, null, null, null);
                    }
                    catch (StyleNotApplicableException ex) {
                        // empty catch block
                    }
                }
                if (fclbstyle == null) continue;
                sf = new StyledFeature();
                sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                sf.setShape(dr.getShape());
                try {
                    TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)fclbstyle, (String)("" + fid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                    continue;
                }
                catch (StyleNotApplicableException ex) {
                    // empty catch block
                }
            }
        }
        if (this.primitiveType == EDGE_TYPE) {
            Style edStyle = null;
            StyleText edlbstyle = null;
            if (this.renderStyle != null) {
                StyleModel edstyModel = StyleModelUtils.getStyleModel(this.renderStyle);
                edStyle = StyleFactory.createStyleFromXML((String)edstyModel.toXMLString());
            }
            if (this.labelStyle != null && this.labelAttribute != null) {
                StyleModel txtmodel = StyleModelUtils.getStyleModel(this.labelStyle);
                edlbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
            }
            for (i = 0; i < edges.size(); ++i) {
                int eid = ((Edge)edges.get(i)).getId();
                geom = this.indexedModel.getTopologyModel().getEdgeGeometry(eid);
                if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getShape() == null) continue;
                if (edStyle != null) {
                    try {
                        edStyle.apply(null, g, dr.getShape(), geom.getType(), null, null, null, null, null);
                    }
                    catch (StyleNotApplicableException ex) {
                        // empty catch block
                    }
                }
                if (edlbstyle == null) continue;
                sf = new StyledFeature();
                sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                sf.setShape(dr.getShape());
                try {
                    TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)edlbstyle, (String)("" + eid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                    continue;
                }
                catch (StyleNotApplicableException ex) {
                    // empty catch block
                }
            }
        }
        if (this.primitiveType == NODE_TYPE) {
            Style ndStyle = null;
            StyleText ndlbstyle = null;
            if (this.renderStyle != null) {
                StyleModel ndstyModel = StyleModelUtils.getStyleModel(this.renderStyle);
                ndStyle = StyleFactory.createStyleFromXML((String)ndstyModel.toXMLString());
            }
            if (this.labelStyle != null && this.labelAttribute != null) {
                StyleModel txtmodel = StyleModelUtils.getStyleModel(this.labelStyle);
                ndlbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
            }
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                int nid = ((Node)nodes.get(i2)).getId();
                geom = this.indexedModel.getTopologyModel().getNodeGeometry(nid);
                if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getPoint() == null) continue;
                if (ndStyle != null) {
                    RenderUtils.renderStyledPoint(g, ndStyle, dr.getPoint(), 0.0);
                }
                if (ndlbstyle == null) continue;
                sf = new StyledFeature();
                sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                sf.setPoint(dr.getPoint());
                try {
                    TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)ndlbstyle, (String)("" + nid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                    continue;
                }
                catch (StyleNotApplicableException ex) {
                    // empty catch block
                }
            }
        }
        g.dispose();
        this.imgUpToDate = true;
        this.img = tmpImg;
        long t2 = System.currentTimeMillis();
        System.out.println(this.getName() + "(" + this.getClass().getSimpleName() + "): Time spent on actual rendering: " + (t2 - t1) + "ms.");
    }

    @Override
    public void repaint() {
        this.doRealRendering();
    }

    private boolean regionChanged() {
        boolean regionChanged = false;
        Rectangle2D currentQueryWin = this.canvas.getMapRegion().getDataWindow();
        if (this.lastQueryWindow != null && (this.lastQueryWindow.getMinX() != currentQueryWin.getMinX() || this.lastQueryWindow.getMinY() != currentQueryWin.getMinY() || this.lastQueryWindow.getWidth() != currentQueryWin.getWidth() || this.lastQueryWindow.getHeight() != currentQueryWin.getHeight())) {
            regionChanged = true;
        }
        return regionChanged;
    }

    private void drawTransitionImage(Graphics2D g) {
        if (this.lastQueryWindow == null && this.img != null) {
            g.drawImage((Image)this.img, 0, 0, null);
            return;
        }
        Rectangle2D currentQW = this.canvas.getMapRegion().getDataWindow();
        boolean isPan = false;
        if (this.lastQueryWindow.getWidth() == currentQW.getWidth() && this.lastQueryWindow.getHeight() == currentQW.getHeight()) {
            isPan = true;
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        Point2D.Double p1 = new Point2D.Double(this.lastQueryWindow.getMinX(), this.lastQueryWindow.getMinY());
        xfm.transform(p1, p1);
        Point2D.Double p2 = new Point2D.Double(this.lastQueryWindow.getMaxX(), this.lastQueryWindow.getMaxY());
        xfm.transform(p2, p2);
        double x = Math.min(((Point2D)p1).getX(), ((Point2D)p2).getX());
        double y = Math.min(((Point2D)p1).getY(), ((Point2D)p2).getY());
        double w = Math.abs(((Point2D)p2).getX() - ((Point2D)p1).getX());
        double h = Math.abs(((Point2D)p2).getY() - ((Point2D)p1).getY());
        if (isPan) {
            g.drawImage((Image)this.img, (int)x, (int)y, null);
            return;
        }
        Rectangle2D.Double deviceWin4LastQW = new Rectangle2D.Double(x, y, w, h);
        int dw = this.canvas.getWidth();
        int dh = this.canvas.getHeight();
        g.drawImage(this.img, (int)x, (int)y, (int)(x + w), (int)(y + h), 0, 0, dw, dh, this.canvas);
    }

    @Override
    public Rectangle2D getDataMBR() {
        if (this.indexedModel == null || this.indexedModel.getTopologyModel() == null) {
            return null;
        }
        return this.indexedModel.getTopologyModel().getPrimitivesMBR();
    }

    protected void renderHoverShape(GeoObject object, Shape shape, Graphics2D dest, AffineTransform transf) {
        Rectangle2D mbr = shape.getBounds2D();
        int x = (int)mbr.getMinX();
        int y = (int)mbr.getMinY();
        int w = (int)mbr.getWidth() + 1;
        int h = (int)mbr.getHeight() + 1;
        JGeometry geom = ((GeometryFeature)object).getSpatialAttribute();
        int gType = geom.getType();
        int cvw_offset = 0;
        if (this.canvas.getWidth() < (int)mbr.getWidth()) {
            cvw_offset = (int)mbr.getWidth() - this.canvas.getWidth();
        }
        if (x + w > this.canvas.getWidth()) {
            cvw_offset -= x + w - this.canvas.getWidth();
        }
        int cvh_offset = 0;
        if (this.canvas.getHeight() < (int)mbr.getHeight()) {
            cvh_offset = (int)mbr.getHeight() - this.canvas.getHeight();
        }
        if (y + h > this.canvas.getHeight()) {
            cvh_offset -= y + h - this.canvas.getHeight();
        }
        int imgW = Math.min((int)mbr.getWidth(), this.canvas.getWidth());
        int imgH = Math.min((int)mbr.getHeight(), this.canvas.getHeight());
        if (imgW <= 0) {
            imgW = 1;
        }
        if (imgH <= 0) {
            imgH = 1;
        }
        BufferedImage image = new BufferedImage(imgW, imgH, 2);
        Graphics2D g = image.createGraphics();
        g.translate(-x - cvw_offset, -y - cvh_offset);
        if (gType == 3) {
            g.setColor(this.hoverColor);
            g.fill(shape);
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(shape);
        } else if (gType == 2) {
            g.setColor(this.hoverBorderColor);
            g.setStroke(this.hoverStroke);
            g.draw(shape);
        }
        g.dispose();
        ShadowRenderer sr = new ShadowRenderer();
        BufferedImage shadow = sr.createShadow(image);
        dest.drawImage((Image)shadow, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        dest.drawImage((Image)image, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        shadow = null;
        image = null;
    }

    @Override
    public boolean isSelected(GeoObject obj) {
        return this.selectionManager.isSelected(obj);
    }

    @Override
    public boolean clearSelection() {
        boolean res = this.selectionManager.clear();
        if (res) {
            this.imgUpToDate = false;
        }
        return res;
    }

    @Override
    public int numSelected() {
        return this.selectionManager.size();
    }

    @Override
    public List<GeoObject> getSelection() {
        return this.selectionManager.getSelection();
    }

    @Override
    public List<GeoObject> getSelection(GeoObject obj) {
        return this.selectionManager.getSelection(obj);
    }

    @Override
    public boolean setSelection(List<GeoObject> objs) {
        boolean res = this.selectionManager.setSelection(objs);
        if (res) {
            this.imgUpToDate = false;
        }
        return res;
    }

    @Override
    public boolean select(List<GeoObject> objs) {
        boolean res = this.selectionManager.select(objs);
        if (res) {
            this.imgUpToDate = false;
        }
        return res;
    }

    @Override
    public boolean unselect(List<GeoObject> objs) {
        boolean res = this.selectionManager.unselect(objs);
        if (res) {
            this.imgUpToDate = false;
        }
        return res;
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionManager.addSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionManager.removeSelectionListener(l);
    }

    @Override
    public boolean setHover(List<GeoObject> objs) {
        return this.hoverManager.setSelection(objs);
    }

    @Override
    public boolean clearHover() {
        return this.hoverManager.clear();
    }

    @Override
    public List<GeoObject> getHover() {
        return this.hoverManager.getSelection();
    }

    @Override
    public boolean isHover(GeoObject obj) {
        return this.hoverManager.isSelected(obj);
    }

    @Override
    public int numHovered() {
        return this.hoverManager.size();
    }

    @Override
    public GeoObject updateObject(Object key, GeoObject changedObject) {
        return null;
    }

    @Override
    public GeoObject deleteObject(Object key) {
        return null;
    }

    @Override
    public boolean insertObject(Object key, GeoObject obj) throws Exception {
        return false;
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        return null;
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        throw new Exception("Do not apply to this class.");
    }

    @Override
    public GeoObject getObject(Object key) {
        return null;
    }

    @Override
    public GeoObject[] getObjects() {
        return null;
    }

    public GeoDataProducer getGeoDataProducer() {
        return this.geoProducer;
    }

    public void setGeoDataProducer(GeoDataProducer producer) {
        this.geoProducer = producer;
        if (producer != null && producer instanceof TopologyPrimitivesProducer) {
            if (this.primitiveType == NODE_TYPE) {
                ((TopologyPrimitivesProducer)producer).setNodesLayer(this);
            } else if (this.primitiveType == EDGE_TYPE) {
                ((TopologyPrimitivesProducer)producer).setEdgesLayer(this);
            } else if (this.primitiveType == FACE_TYPE) {
                ((TopologyPrimitivesProducer)producer).setFacesLayer(this);
            }
        }
        if (this.canvas != null && this.canvas.getMapRegion() != null && this.canvas.getMapRegion().getDataWindow() != null) {
            this.reloadData();
        }
    }

    private void reloadData() {
        MapRegion region;
        if (this.geoProducer != null && this.geoProducer instanceof TopologyPrimitivesProducer && (region = this.canvas.getMapRegion()) != null && region.getDataWindow() != null) {
            this.waitingOnServer = true;
        }
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        this.reloadData();
    }

    public AttributeDataProducer getAttributeDataProducer() {
        return null;
    }

    public void setAttributeDataProducer(AttributeDataProducer producer) {
    }

    public void onDataReady(DataProducer producer) {
        this.waitingOnServer = false;
        this.imgUpToDate = false;
    }

    public void onDataException(DataProducer producer, Throwable exception) {
        this.waitingOnServer = false;
    }

    @Override
    public void setCanvas(MapCanvas parent) {
        this.canvas = parent;
    }

    @Override
    public MapCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        if (this.primitiveType == UNKNOWN_TYPE || this.indexedModel == null || this.indexedModel.getTopologyModel() == null) {
            return result;
        }
        try {
            Face[] faces;
            AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform().createInverse();
            Rectangle2D searchMBR = xfm.createTransformedShape(box).getBounds2D();
            JGeometry geom = null;
            String objId = null;
            String keyCol = null;
            if (this.primitiveType == NODE_TYPE) {
                Node[] nodes = this.indexedModel.getNodes(searchMBR);
                if (nodes != null) {
                    keyCol = "NODE_ID";
                    for (int i = 0; i < nodes.length; ++i) {
                        geom = this.indexedModel.getTopologyModel().getNodeGeometry(nodes[i].getId());
                        objId = "" + nodes[i].getId();
                        GeometryFeature gf = new GeometryFeature();
                        Field keyField = Field.createField((String)objId, (String)"integer");
                        gf.setAttribute(keyCol, keyField);
                        gf.setSpatialAttribute(geom);
                        gf.setLayer(this);
                        GeometryFeature obj = gf;
                        result.add(obj);
                    }
                }
            } else if (this.primitiveType == EDGE_TYPE) {
                Edge[] edges = this.indexedModel.getEdges(searchMBR);
                if (edges != null) {
                    keyCol = "EDGE_ID";
                    for (int i = 0; i < edges.length; ++i) {
                        geom = this.indexedModel.getTopologyModel().getEdgeGeometry(edges[i].getId());
                        objId = "" + edges[i].getId();
                        GeometryFeature gf = new GeometryFeature();
                        Field keyField = Field.createField((String)objId, (String)"integer");
                        gf.setAttribute(keyCol, keyField);
                        gf.setSpatialAttribute(geom);
                        gf.setLayer(this);
                        GeometryFeature obj = gf;
                        result.add(obj);
                    }
                }
            } else if (this.primitiveType == FACE_TYPE && (faces = this.indexedModel.getFaces(searchMBR)) != null) {
                keyCol = "FACE_ID";
                for (int i = 0; i < faces.length; ++i) {
                    geom = this.indexedModel.getTopologyModel().getFaceGeometry(faces[i].getID());
                    objId = "" + faces[i].getID();
                    GeometryFeature gf = new GeometryFeature();
                    Field keyField = Field.createField((String)objId, (String)"integer");
                    gf.setAttribute(keyCol, keyField);
                    gf.setSpatialAttribute(geom);
                    gf.setLayer(this);
                    GeometryFeature obj = gf;
                    result.add(obj);
                }
            }
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        Face face;
        Vector<GeoObject> result = new Vector<GeoObject>();
        if (this.primitiveType == UNKNOWN_TYPE || this.indexedModel == null || this.indexedModel.getTopologyModel() == null) {
            return result;
        }
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        try {
            xfm = xfm.createInverse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
        double searchTolerance = 3.0;
        Point2D.Double ptC = new Point2D.Double(0.0, 0.0);
        xfm.transform(new Point2D.Double(x, y), ptC);
        Point2D.Double ptUL = new Point2D.Double(0.0, 0.0);
        xfm.transform(new Point2D.Double((double)x - searchTolerance, (double)y - searchTolerance), ptUL);
        double tolerance = Math.max(((Point2D)ptC).getX() - ((Point2D)ptUL).getX(), ((Point2D)ptUL).getY() - ((Point2D)ptC).getY());
        JGeometry geom = null;
        String objId = null;
        String keyCol = null;
        if (this.primitiveType == NODE_TYPE) {
            Node node = this.indexedModel.identifyNode(ptC, tolerance);
            if (node != null) {
                geom = this.indexedModel.getTopologyModel().getNodeGeometry(node.getId());
                objId = "" + node.getId();
                keyCol = "NODE_ID";
            }
        } else if (this.primitiveType == EDGE_TYPE) {
            Edge edge = this.indexedModel.identifyEdge(ptC, tolerance);
            if (edge != null) {
                geom = this.indexedModel.getTopologyModel().getEdgeGeometry(edge.getId());
                objId = "" + edge.getId();
                keyCol = "EDGE_ID";
            }
        } else if (this.primitiveType == FACE_TYPE && (face = this.indexedModel.identifyFace(ptC, tolerance)) != null) {
            geom = this.indexedModel.getTopologyModel().getFaceGeometry(face.getID());
            objId = "" + face.getID();
            keyCol = "FACE_ID";
        }
        if (geom != null) {
            GeometryFeature gf = new GeometryFeature();
            Field keyField = Field.createField(objId, (String)"integer");
            gf.setAttribute(keyCol, keyField);
            gf.setSpatialAttribute(geom);
            gf.setLayer(this);
            GeometryFeature obj = gf;
            result.add(obj);
        }
        return result;
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            this.reloadData();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof MapUndoManager && ((MapUndoManager)src).undoORredoPerfomed()) {
            GeometryFeature activeFeature;
            ActiveFeaturesLayer featureLayer;
            Layer ly;
            if (this.canvas != null && (this.primitiveType == NODE_TYPE || this.primitiveType == EDGE_TYPE) && (ly = this.canvas.getLayerManager().getLayerByTag("toolLayer")) != null && ly instanceof ActiveFeaturesLayer && (featureLayer = (ActiveFeaturesLayer)ly) != null && (activeFeature = (GeometryFeature)featureLayer.getActiveFeature()) != null && this == activeFeature.getLayer()) {
                try {
                    int edgeId = Integer.parseInt(activeFeature.getKey().toString());
                    JGeometry geom = this.indexedModel.getTopologyModel().getEdgeGeometry(edgeId);
                    if (geom != null) {
                        activeFeature.setSpatialAttribute(geom);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setToUpdate();
        }
    }

    public void setToUpdate() {
        this.imgUpToDate = false;
        this.fireStateChanged();
    }

    @Override
    public void addEditChangeListener(EditChangeListener l) {
        this.listenerList.add(EditChangeListener.class, l);
    }

    @Override
    public void removeEditChangeListener(EditChangeListener l) {
        this.listenerList.remove(EditChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((EditChangeListener)listeners[i + 1]).editStateChanged(changeEvent);
        }
    }

    @Override
    public boolean isModified() {
        TopologyModel model;
        if (this.indexedModel != null && (model = this.indexedModel.getTopologyModel()) != null) {
            if (this.primitiveType == NODE_TYPE && model.hasNodeChanges()) {
                return true;
            }
            if (this.primitiveType == EDGE_TYPE && model.hasEdgeChanges()) {
                return true;
            }
            if (this.primitiveType == FACE_TYPE && model.hasFaceChanges()) {
                return true;
            }
        }
        return false;
    }

    public void setRenderStyle(String style) {
        if (this.renderStyle != null && this.renderStyle.equalsIgnoreCase(style)) {
            return;
        }
        this.renderStyle = style;
        if (this.imgUpToDate) {
            this.imgUpToDate = false;
        }
    }

    public void setLabelAttribute(String attr) {
        if (this.labelAttribute != null && this.labelAttribute.equalsIgnoreCase(attr)) {
            return;
        }
        this.labelAttribute = attr;
        if (this.imgUpToDate) {
            this.imgUpToDate = false;
        }
    }

    public void setLabelStyle(String style) {
        if (this.labelStyle != null && this.labelStyle.equalsIgnoreCase(style)) {
            return;
        }
        this.labelStyle = style;
        if (this.imgUpToDate) {
            this.imgUpToDate = false;
        }
    }

    public boolean addPrimitive(JGeometry primitive) throws Exception {
        if (primitive == null) {
            throw new Exception("Null topology primitive.");
        }
        if (this.primitiveType == FACE_TYPE) {
            throw new Exception("Thsi operation does not apply to face layer.");
        }
        if (primitive.getType() != 1 && primitive.getType() != 2 && primitive.getType() != 3) {
            throw new Exception("Invalid geometry type for this operation.");
        }
        if (primitive.getType() == 1 && this.primitiveType != NODE_TYPE || primitive.getType() == 2 && this.primitiveType != EDGE_TYPE || primitive.getType() == 3 && this.primitiveType != EDGE_TYPE) {
            throw new Exception("Invalid operation for layer type.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        double[] mbr = primitive.getMBR();
        boolean status = false;
        this.canvas.getUndoManager().startChangeBlock("topo node add");
        try {
            status = tpmodel.addPrimitiveGeometry(primitive);
            if (status) {
                Edge[] edges;
                if (mbr != null && (edges = tpmodel.searchEdges(new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]))) != null && edges.length > 0) {
                    for (int i = 0; i < edges.length; ++i) {
                        this.indexedModel.removeEdgeSegmentTree(edges[i].getId());
                    }
                }
                this.imgUpToDate = false;
                this.fireStateChanged();
                this.refreshOtherPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.canvas.getUndoManager().endChangeBlock("topo node add");
        }
        return status;
    }

    public boolean removeNode(int nodeId) throws Exception {
        if (this.primitiveType != NODE_TYPE) {
            throw new Exception("Invalid operation for layer type.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        Rectangle2D mbr = tpmodel.getNodeMBR(nodeId);
        this.canvas.getUndoManager().startChangeBlock("topo node remove");
        boolean status = false;
        try {
            status = tpmodel.removeNode(nodeId);
            if (status) {
                Edge[] edges;
                if (mbr != null && (edges = tpmodel.searchEdges(mbr)) != null && edges.length > 0) {
                    for (int i = 0; i < edges.length; ++i) {
                        this.indexedModel.removeEdgeSegmentTree(edges[i].getId());
                    }
                }
                this.imgUpToDate = false;
                this.fireStateChanged();
                this.refreshOtherPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.canvas.getUndoManager().endChangeBlock("topo node remove");
        }
        return status;
    }

    public int[] moveNode(int nodeId, Point2D newLocation) throws Exception {
        if (newLocation == null) {
            throw new Exception("New node location is null.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        int[] edgeIds = null;
        this.canvas.getUndoManager().startChangeBlock("topo node move");
        try {
            edgeIds = tpmodel.moveNode(nodeId, newLocation);
            if (edgeIds != null) {
                for (int i = 0; i < edgeIds.length; ++i) {
                    this.indexedModel.removeEdgeSegmentTree(Math.abs(edgeIds[i]));
                }
                this.imgUpToDate = false;
                this.fireStateChanged();
                this.refreshOtherPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.canvas.getUndoManager().endChangeBlock("topo node move");
        }
        return edgeIds;
    }

    public boolean removeEdge(int edgeId) throws Exception {
        if (this.primitiveType != EDGE_TYPE) {
            throw new Exception("Invalid operation for layer type.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        this.canvas.getUndoManager().startChangeBlock("topo edge remove");
        boolean status = false;
        try {
            status = tpmodel.removeEdge(edgeId);
            if (status) {
                this.indexedModel.removeEdgeSegmentTree(edgeId);
                this.imgUpToDate = false;
                this.fireStateChanged();
                this.refreshOtherPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.canvas.getUndoManager().endChangeBlock("topo edge remove");
        }
        return status;
    }

    public boolean changeEdgeGeometry(int edgeId, JGeometry newGeometry) throws Exception {
        if (this.primitiveType != EDGE_TYPE) {
            throw new Exception("Invalid operation for layer type.");
        }
        if (newGeometry == null) {
            throw new Exception("New edge geometry is null.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        this.canvas.getUndoManager().startChangeBlock("topo change edge");
        boolean status = false;
        try {
            status = tpmodel.changeEdgeGeometry(edgeId, newGeometry);
            if (status) {
                this.indexedModel.removeEdgeSegmentTree(edgeId);
                this.imgUpToDate = false;
                this.fireStateChanged();
                this.refreshOtherPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.canvas.getUndoManager().endChangeBlock("topo change edge");
        }
        return status;
    }

    private void refreshOtherPrimitives() {
        if (!this.imgUpToDate && this.geoProducer != null && this.geoProducer instanceof TopologyPrimitivesProducer) {
            if (this.primitiveType == NODE_TYPE) {
                if (((TopologyPrimitivesProducer)this.geoProducer).getFacesLayer() != null) {
                    ((TopologyPrimitivesProducer)this.geoProducer).getFacesLayer().refreshPaint();
                }
                if (((TopologyPrimitivesProducer)this.geoProducer).getEdgesLayer() != null) {
                    ((TopologyPrimitivesProducer)this.geoProducer).getEdgesLayer().refreshPaint();
                }
            } else if (this.primitiveType == EDGE_TYPE) {
                if (((TopologyPrimitivesProducer)this.geoProducer).getFacesLayer() != null) {
                    ((TopologyPrimitivesProducer)this.geoProducer).getFacesLayer().refreshPaint();
                }
                if (((TopologyPrimitivesProducer)this.geoProducer).getNodesLayer() != null) {
                    ((TopologyPrimitivesProducer)this.geoProducer).getNodesLayer().refreshPaint();
                }
            }
        }
    }

    public void refreshPaint() {
        this.imgUpToDate = false;
    }
}

