/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.edit.producer.AbstractDataSetProducer;
import oracle.spatial.edit.producer.TopologyPrimitivesProducer;

public class TopologySetProducer
extends AbstractDataSetProducer {
    private TopologyPrimitivesProducer primProducer = null;

    public TopologySetProducer(TopologySetLayer layer, TopologyPrimitivesProducer producer) {
        super(layer);
        this.primProducer = producer;
    }

    @Override
    protected String buildQuery(Area queryArea, int srid) {
        return null;
    }

    @Override
    protected String getSpatialType() {
        return null;
    }

    @Override
    protected void doLoad(Callable callable, PropertyChangeSupport propSupport, Area queryArea, int srid, AbstractDataAccessObject dao) throws Exception, MDSException {
        String baseTable = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String keyColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
        String spatialColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        WorkSpace workspace = this.layer.getWorkspace();
        TopologySet set = (TopologySet)this.layer.getDataSet();
        TopologyModel topoModel = set.getTopologyModel();
        String topology = topoModel.getName();
        Rectangle2D queryWindow = queryArea.getBounds2D();
        System.out.println(this.layer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": Topology Data set query-loading: started...");
        long t1 = System.currentTimeMillis();
        if (this.primProducer.getLoadedArea().isEmpty() || !this.primProducer.getLoadedArea().contains(queryWindow)) {
            this.primProducer.loadPrimitives(queryWindow, this.layer.getSRID(), this.layer);
        }
        dao.openConnection();
        Vector<AbstractFeature> features = dao.loadTopologyFeatures(topology, baseTable, spatialColumn, queryWindow, workspace);
        int appended = 0;
        if (features != null) {
            for (int i = 0; i < features.size(); ++i) {
                try {
                    TopologyFeature feature = (TopologyFeature)features.get(i);
                    String key = feature.getAttribute(keyColumn).getValue().toString();
                    if (set.getFeature(key) != null || set.isRemovedFeature(key)) continue;
                    feature.setTopologyModel(topoModel);
                    set.appendFeature(features.get(i));
                    ++appended;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
            }
        }
        System.out.println(this.layer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": New #tree entries: " + appended);
        long t2 = System.currentTimeMillis();
        System.out.println(this.layer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": Data loading: finished after " + (t2 - t1) + " ms.");
        AbstractFeature[] deletedFeats = this.layer.getCurrentDeletedFeatures();
        List<GeoObject> featsInDataSet = set.getIndexedSet().getFeatures(queryWindow);
        int total = 0;
        if (featsInDataSet != null) {
            total += featsInDataSet.size();
        }
        if (deletedFeats != null) {
            total += deletedFeats.length;
        }
        if (total > 0) {
            String key;
            TopologyFeature feature;
            int i;
            boolean count = false;
            if (featsInDataSet != null && featsInDataSet.size() > 0) {
                for (i = 0; i < featsInDataSet.size(); ++i) {
                    feature = (TopologyFeature)featsInDataSet.get(i);
                    key = feature.getAttribute(keyColumn).getValue().toString();
                    feature.setKey(key);
                    feature.setLayer(this.layer);
                    this.readyFeatures.add(feature);
                    callable.call();
                }
            }
            if (deletedFeats != null && deletedFeats.length > 0) {
                for (i = 0; i < deletedFeats.length; ++i) {
                    feature = (TopologyFeature)deletedFeats[i];
                    key = feature.getAttribute(keyColumn).getValue().toString();
                    feature.setKey(key);
                    feature.setLayer(this.layer);
                    this.readyFeatures.add(feature);
                    callable.call();
                }
            }
        }
    }

    public TopologyPrimitivesProducer getTopologyPrimitivesProducer() {
        return this.primProducer;
    }
}

