/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometrySegment;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.geometry.JGeometry;

public class JGeometrySegmentUtil {
    public static RTreeIndex buildSegmentTree(JGeometry geometry) {
        if (geometry == null) {
            return null;
        }
        JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geometry);
        if (geos == null || geos.length == 0) {
            return null;
        }
        RTreeIndex index = new RTreeIndex();
        index.create(null);
        Vector<double[]> mbrs = new Vector<double[]>();
        Vector<JGeometrySegment> segments = new Vector<JGeometrySegment>();
        for (int k = 0; k < geos.length; ++k) {
            int i;
            int segpos;
            int coordsEnd;
            int coordsStart;
            int l;
            int etype;
            int offset;
            double[] oords;
            int dim;
            int nelems;
            int[] elemInfo;
            double[] mbr = geos[k].getMBR();
            JGeometrySegment fseg = null;
            if (geos[k].isPoint() || geos[k].isRectangle() || geos[k].isCircle()) {
                fseg = new JGeometrySegment();
                fseg.setElementIndex(k);
                fseg.setSegmentIndex(0);
                fseg.setSubElementIndex(0);
                if (geos[k].isPoint()) {
                    fseg.setSegmentType(JGeometrySegment.POINT_TYPE);
                } else if (geos[k].isRectangle()) {
                    fseg.setSegmentType(JGeometrySegment.RECTANGLE_TYPE);
                } else if (geos[k].isCircle()) {
                    fseg.setSegmentType(JGeometrySegment.CIRCLE_TYPE);
                }
                mbrs.add(mbr);
                segments.add(fseg);
                continue;
            }
            if (geos[k].getType() == 3) {
                elemInfo = geos[k].getElemInfo();
                nelems = elemInfo.length / 3;
                dim = geos[k].getDimensions();
                oords = geos[k].getOrdinatesArray();
                offset = 0;
                etype = elemInfo[1];
                if (etype == 1005 || etype == 2005) {
                    offset = 3;
                    --nelems;
                }
                for (l = 0; l < nelems; ++l) {
                    coordsStart = elemInfo[3 * l + offset];
                    coordsEnd = -1;
                    coordsEnd = l < nelems - 1 ? elemInfo[3 * (l + 1) + offset] : oords.length;
                    if (elemInfo[3 * l + 2 + offset] == 2) {
                        segpos = 0;
                        for (i = coordsStart - 1; i < coordsEnd - dim; i += dim * 2) {
                            fseg = new JGeometrySegment();
                            fseg.setElementIndex(k);
                            fseg.setSegmentIndex(segpos++);
                            fseg.setSubElementIndex(l);
                            fseg.setSegmentType(JGeometrySegment.ARC_TYPE);
                            mbr = GeometryUtil.getArcMBR((double)oords[i], (double)oords[i + 1], (double)oords[i + dim], (double)oords[i + dim + 1], (double)oords[i + 2 * dim], (double)oords[i + 2 * dim + 1]);
                            if (mbr == null) continue;
                            mbrs.add(mbr);
                            segments.add(fseg);
                        }
                        continue;
                    }
                    if (elemInfo[3 * l + 2 + offset] == 3) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(0);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.RECTANGLE_TYPE);
                        double xmin = Math.min(oords[coordsStart - 1], oords[coordsStart - 1 + dim]);
                        double xmax = Math.max(oords[coordsStart - 1], oords[coordsStart - 1 + dim]);
                        double ymin = Math.min(oords[coordsStart], oords[coordsStart + dim]);
                        double ymax = Math.max(oords[coordsStart], oords[coordsStart + dim]);
                        mbr = new double[]{xmin, ymin, xmax, ymax};
                        mbrs.add(mbr);
                        segments.add(fseg);
                        continue;
                    }
                    if (elemInfo[3 * l + 2 + offset] == 4) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(0);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.CIRCLE_TYPE);
                        mbr = GeometryUtil.getArcMBR((double)oords[coordsStart - 1], (double)oords[coordsStart], (double)oords[coordsStart - 1 + dim], (double)oords[coordsStart + dim], (double)oords[coordsStart - 1 + 2 * dim], (double)oords[coordsStart + 2 * dim]);
                        if (mbr == null) continue;
                        mbrs.add(mbr);
                        segments.add(fseg);
                        continue;
                    }
                    segpos = 0;
                    for (i = coordsStart - 1; i < coordsEnd - dim; i += dim) {
                        mbr = new double[4];
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(segpos++);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.LINE_TYPE);
                        mbr[0] = Math.min(oords[i], oords[i + dim]);
                        mbr[2] = Math.max(oords[i], oords[i + dim]);
                        mbr[1] = Math.min(oords[i + 1], oords[i + dim + 1]);
                        mbr[3] = Math.max(oords[i + 1], oords[i + dim + 1]);
                        mbrs.add(mbr);
                        segments.add(fseg);
                    }
                }
                continue;
            }
            if (geos[k].getType() != 2) continue;
            elemInfo = geos[k].getElemInfo();
            nelems = elemInfo.length / 3;
            dim = geos[k].getDimensions();
            oords = geos[k].getOrdinatesArray();
            offset = 0;
            etype = elemInfo[1];
            if (etype == 4) {
                offset = 3;
                --nelems;
            }
            for (l = 0; l < nelems; ++l) {
                coordsStart = elemInfo[3 * l + offset];
                coordsEnd = -1;
                coordsEnd = l < nelems - 1 ? elemInfo[3 * (l + 1) + offset] : oords.length;
                if (elemInfo[3 * l + 2 + offset] == 2) {
                    segpos = 0;
                    for (i = coordsStart - 1; i < coordsEnd - dim; i += dim * 2) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(segpos++);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.ARC_TYPE);
                        mbr = GeometryUtil.getArcMBR((double)oords[i], (double)oords[i + 1], (double)oords[i + dim], (double)oords[i + dim + 1], (double)oords[i + 2 * dim], (double)oords[i + 2 * dim + 1]);
                        if (mbr == null) continue;
                        mbrs.add(mbr);
                        segments.add(fseg);
                    }
                    continue;
                }
                segpos = 0;
                for (i = coordsStart - 1; i < coordsEnd - dim; i += dim) {
                    mbr = new double[4];
                    mbr[0] = Math.min(oords[i], oords[i + dim]);
                    mbr[2] = Math.max(oords[i], oords[i + dim]);
                    mbr[1] = Math.min(oords[i + 1], oords[i + dim + 1]);
                    mbr[3] = Math.max(oords[i + 1], oords[i + dim + 1]);
                    fseg = new JGeometrySegment();
                    fseg.setElementIndex(k);
                    fseg.setSegmentIndex(segpos++);
                    fseg.setSubElementIndex(l);
                    fseg.setSegmentType(JGeometrySegment.LINE_TYPE);
                    mbrs.add(mbr);
                    segments.add(fseg);
                }
            }
        }
        double[][][] mbhs = new double[mbrs.size()][2][2];
        Object[] o = new Object[mbrs.size()];
        for (int i = 0; i < mbrs.size(); ++i) {
            double[] mbr = (double[])mbrs.get(i);
            JGeometrySegment fseg = (JGeometrySegment)segments.get(i);
            mbhs[i][0][0] = mbr[0];
            mbhs[i][0][1] = mbr[2];
            mbhs[i][1][0] = mbr[1];
            mbhs[i][1][1] = mbr[3];
            o[i] = fseg;
        }
        try {
            index.getTree().packTree(mbhs, o);
        }
        catch (Exception e) {
            index = null;
            System.out.println("Exception in buildSegmentTree: " + e.getMessage());
            return null;
        }
        return index;
    }

    public static JGeometrySegmentPoint getSegmentPoint(JGeometry geometry, Point2D point, double tolerance, boolean checkIsolatedPoints, boolean checkArcs, boolean checkCircles, boolean checkRectangles, RTreeIndex segmentTree, String segmentId) {
        int fsegloc;
        JGeometrySegment fseg;
        Point2D intersectPoint;
        block21: {
            if (geometry == null) {
                return null;
            }
            intersectPoint = null;
            fseg = null;
            fsegloc = -1;
            RTreeIndex index = segmentTree;
            if (index == null) {
                index = JGeometrySegmentUtil.buildSegmentTree(geometry);
            }
            if (index == null) {
                return null;
            }
            int dim = 2;
            double[] oords = null;
            int offset = 0;
            double distance = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            Point2D pt = null;
            int[] elemInfo = null;
            int coordsStart = 0;
            try {
                boolean gotSome = false;
                double[][] searchMBR = new double[][]{new double[2], new double[2]};
                searchMBR[0][0] = point.getX() - tolerance;
                searchMBR[0][1] = point.getX() + tolerance;
                searchMBR[1][0] = point.getY() - tolerance;
                searchMBR[1][1] = point.getY() + tolerance;
                double minDist = Double.MAX_VALUE;
                ArrayList a = new ArrayList(500);
                a.clear();
                gotSome = index.getTree().search((double[][])searchMBR, a);
                if (!gotSome) break block21;
                JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geometry);
                for (int i = 0; i < a.size(); ++i) {
                    JGeometrySegment o = (JGeometrySegment)a.get(i);
                    int seg = o.getSegmentIndex();
                    int elemindex = o.getElementIndex();
                    int subelemindex = o.getSubElementIndex();
                    if (o.getSegmentType() == JGeometrySegment.POINT_TYPE) {
                        if (!checkIsolatedPoints || !((distance = Math.sqrt((dx = (pt = geos[elemindex].getJavaPoint()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                        minDist = distance;
                        intersectPoint = pt;
                        fseg = o;
                        fsegloc = 0;
                        continue;
                    }
                    if (o.getSegmentType() == JGeometrySegment.LINE_TYPE) {
                        Point2D.Double p2;
                        Point2D.Double p1;
                        double[] dist;
                        dim = geos[elemindex].getDimensions();
                        oords = geos[elemindex].getOrdinatesArray();
                        offset = 0;
                        if (subelemindex > 0) {
                            elemInfo = geos[elemindex].getElemInfo();
                            offset = elemInfo[3 * subelemindex] - 1;
                        }
                        if ((dist = GeometryUtil.distToLine((Point2D)point, (Point2D)(p1 = new Point2D.Double(oords[dim * seg + offset], oords[dim * seg + 1 + offset])), (Point2D)(p2 = new Point2D.Double(oords[dim * (seg + 1) + offset], oords[dim * (seg + 1) + 1 + offset])))) == null || !(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                        minDist = dist[0];
                        fseg = o;
                        fsegloc = (int)dist[1];
                        if ((int)dist[1] == 0) {
                            intersectPoint = p1;
                            continue;
                        }
                        if ((int)dist[1] == 1) {
                            intersectPoint = p2;
                            continue;
                        }
                        intersectPoint = GeometryUtil.getIntersectionPoint((Point2D)point, (Point2D)p1, (Point2D)p2);
                        fsegloc = 2;
                        if (intersectPoint == null) continue;
                        dx = intersectPoint.getX() - ((Point2D)p1).getX();
                        if (Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p1).getY()) * dy) <= tolerance) {
                            intersectPoint = p1;
                            fsegloc = 0;
                            continue;
                        }
                        dx = intersectPoint.getX() - ((Point2D)p2).getX();
                        if (!(Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p2).getY()) * dy) <= tolerance)) continue;
                        intersectPoint = p2;
                        fsegloc = 1;
                        continue;
                    }
                    if (o.getSegmentType() == JGeometrySegment.ARC_TYPE && checkArcs || o.getSegmentType() == JGeometrySegment.CIRCLE_TYPE && checkCircles) {
                        elemInfo = geos[elemindex].getElemInfo();
                        dim = geos[elemindex].getDimensions();
                        oords = geos[elemindex].getOrdinatesArray();
                        offset = 0;
                        int etype = elemInfo[1];
                        if (o.getSegmentType() == JGeometrySegment.ARC_TYPE && etype == 4 || o.getSegmentType() == JGeometrySegment.CIRCLE_TYPE && (etype == 1005 || etype == 2005)) {
                            offset = 3;
                        }
                        coordsStart = elemInfo[3 * subelemindex + offset] + seg * 2 * dim;
                        for (int arcPt = 0; arcPt < 3; ++arcPt) {
                            int pos = coordsStart - 1 + arcPt * dim;
                            pt = new Point2D.Double(oords[pos], oords[pos + 1]);
                            dx = pt.getX() - point.getX();
                            distance = Math.sqrt(dx * dx + (dy = pt.getY() - point.getY()) * dy);
                            if (!(distance <= tolerance) || !(distance < minDist)) continue;
                            minDist = distance;
                            intersectPoint = pt;
                            fseg = o;
                            fsegloc = arcPt == 0 ? 0 : (arcPt == 1 ? 2 : 1);
                        }
                        continue;
                    }
                    if (o.getSegmentType() != JGeometrySegment.RECTANGLE_TYPE || !checkRectangles) continue;
                    elemInfo = geos[elemindex].getElemInfo();
                    dim = geos[elemindex].getDimensions();
                    oords = geos[elemindex].getOrdinatesArray();
                    coordsStart = elemInfo[3 * subelemindex];
                    double x1 = 0.0;
                    double x2 = 0.0;
                    double y1 = 0.0;
                    double y2 = 0.0;
                    for (int recPt = 0; recPt < 4; ++recPt) {
                        if (recPt < 2) {
                            int pos = coordsStart - 1 + recPt * dim;
                            pt = new Point2D.Double(oords[pos], oords[pos + 1]);
                            if (recPt == 0) {
                                x1 = pt.getX();
                                y1 = pt.getY();
                            } else {
                                x2 = pt.getX();
                                y2 = pt.getY();
                            }
                        } else {
                            pt = recPt == 2 ? new Point2D.Double(x1, y2) : new Point2D.Double(x2, y1);
                        }
                        dx = pt.getX() - point.getX();
                        dy = pt.getY() - point.getY();
                        distance = Math.sqrt(dx * dx + dy * dy);
                        if (!(distance <= tolerance) || !(distance < minDist)) continue;
                        minDist = distance;
                        intersectPoint = pt;
                        fseg = o;
                        fsegloc = recPt == 0 ? 0 : (recPt == 1 ? 1 : 2);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception in getIntersectionPoint: " + e.getMessage());
                intersectPoint = null;
            }
        }
        if (intersectPoint == null) {
            return null;
        }
        return new JGeometrySegmentPoint(intersectPoint, fseg, fsegloc, segmentId);
    }

    public static JGeometrySegmentPoint[] getSegmentPointsWithinBox(JGeometry geometry, Rectangle2D box, RTreeIndex segmentTree, String segmentId) {
        if (geometry == null || box == null) {
            return null;
        }
        JGeometry geo = geometry;
        RTreeIndex index = segmentTree;
        if (index == null) {
            index = JGeometrySegmentUtil.buildSegmentTree(geometry);
        }
        if (index == null) {
            return null;
        }
        int dim = 2;
        double[] oords = null;
        int offset = 0;
        int[] elemInfo = null;
        ArrayList<JGeometrySegmentPoint> featSegments = new ArrayList<JGeometrySegmentPoint>();
        try {
            boolean gotSome = false;
            double[][] searchMBR = new double[][]{new double[2], new double[2]};
            searchMBR[0][0] = box.getMinX();
            searchMBR[0][1] = box.getMaxX();
            searchMBR[1][0] = box.getMinY();
            searchMBR[1][1] = box.getMaxY();
            ArrayList a = new ArrayList(500);
            a.clear();
            gotSome = index.getTree().search((double[][])searchMBR, a);
            if (gotSome) {
                JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geo);
                Hashtable<String, String> segs = new Hashtable<String, String>();
                String search = null;
                for (int i = 0; i < a.size(); ++i) {
                    JGeometrySegment o = (JGeometrySegment)a.get(i);
                    int seg = o.getSegmentIndex();
                    int elemindex = o.getElementIndex();
                    int subelemindex = o.getSubElementIndex();
                    if (o.getSegmentType() != JGeometrySegment.LINE_TYPE) continue;
                    dim = geos[elemindex].getDimensions();
                    oords = geos[elemindex].getOrdinatesArray();
                    offset = 0;
                    if (subelemindex > 0) {
                        elemInfo = geos[elemindex].getElemInfo();
                        offset = elemInfo[3 * subelemindex] - 1;
                    }
                    Point2D.Double p1 = new Point2D.Double(oords[dim * seg + offset], oords[dim * seg + 1 + offset]);
                    search = "" + elemindex + ":" + (seg - 1) + ":" + subelemindex + ":" + 1;
                    if (box.contains(p1) && segs.get(search) == null) {
                        featSegments.add(new JGeometrySegmentPoint((Point2D)p1, o, 0, segmentId));
                        segs.put("" + elemindex + ":" + seg + ":" + subelemindex + ":" + 0, "*");
                    }
                    Point2D.Double p2 = new Point2D.Double(oords[dim * (seg + 1) + offset], oords[dim * (seg + 1) + 1 + offset]);
                    search = "" + elemindex + ":" + (seg + 1) + ":" + subelemindex + ":" + 0;
                    if (!box.contains(p2) || segs.get(search) != null) continue;
                    featSegments.add(new JGeometrySegmentPoint((Point2D)p2, o, 1, segmentId));
                    segs.put("" + elemindex + ":" + seg + ":" + subelemindex + ":" + 1, "*");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSegmentPointsWithinBox: " + e.getMessage());
            featSegments.clear();
        }
        if (featSegments.size() == 0) {
            return null;
        }
        return featSegments.toArray(new JGeometrySegmentPoint[featSegments.size()]);
    }
}

