/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.table.GenericTableHeaderRenderer;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.ui.table.TableHelper;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.SelectDependenciesPanel;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.library.BooleanTableCellRenderer;

public class DependencyPanel
extends DefaultTraversablePanel {
    public static final String PROPERTY_STORAGE_KEY = DependencyPanel.class.getName() + ".property.storage";
    public static final String PROJECT_URL_KEY = DependencyPanel.class.getName() + ".project.url";
    public static final String DEPENDABLE_UNDER_EDIT_KEY = DependencyPanel.class.getName() + ".dependable.under.edit";
    public static final String WORKSPACE_KEY = "Application";
    private BuiltTable<DepItem> _builtTable;
    private SimpleTableModel<DepItem> _model;
    private final SelectDependenciesPanel _selectDependenciesPanel = new SelectDependenciesPanel();
    private Dependable _activeDependable;
    private Set<URL> _children;
    private URL _curProjectURL;
    private Workspace _curWorkspace;
    private static final String PANEL_VISITED_KEY = DependencyPanel.class.getName() + ".panel.visited";
    private boolean asModuleColumnShowing;

    public DependencyPanel() {
        this.setHelpID("f1_idedprojsetdependencies_html");
        this.setLayout(new BorderLayout());
        this.initializeComponent();
    }

    public void setSelectionDialogHelpId(String helpTopicId) {
        this._selectDependenciesPanel.setHelpID(helpTopicId);
    }

    public void setSelectionDialogInstruction(String text) {
        this._selectDependenciesPanel.setInstructionText(text);
    }

    public void onEntry(TraversableContext dataContext) {
        PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
        if (!dataContext.contains(PANEL_VISITED_KEY)) {
            DependencyConfiguration depConfig;
            List<DepItem> dependencies;
            dataContext.put(PANEL_VISITED_KEY, (Object)Boolean.TRUE);
            this._curProjectURL = (URL)dataContext.get(PROJECT_URL_KEY);
            Assert.check((this._curProjectURL != null ? 1 : 0) != 0, (String)"The URL of the active project must be stored in the namespace");
            this._curWorkspace = (Workspace)dataContext.get(WORKSPACE_KEY);
            Assert.check((this._curWorkspace != null ? 1 : 0) != 0, (String)"The active workspace must be stored in the namespace");
            Assert.check((propertyStorage != null ? 1 : 0) != 0, (String)"The PropertyStorage must be stored in the namespace");
            if (dataContext.contains(DEPENDABLE_UNDER_EDIT_KEY)) {
                this._activeDependable = (Dependable)dataContext.get(DEPENDABLE_UNDER_EDIT_KEY);
            }
            if (!(dependencies = this.wrapDependables((depConfig = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage)).getDependencyList(), depConfig.getModulePathDependencyList())).isEmpty()) {
                this._model.asList().clear();
                this._model.asList().addAll(dependencies);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTable table = DependencyPanel.this._builtTable.getTable();
                        table.clearSelection();
                        int selectedRow = table.getRowCount() - 1;
                        table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                    }
                });
            }
        }
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)propertyStorage);
        if (this.asModuleColumnShowing) {
            if (jProjectLibraries.getJDK().getJavaVersion().isBefore(new VersionNumber("9"))) {
                this._builtTable.setHiddenColumns(new int[]{0});
                this.asModuleColumnShowing = false;
            }
        } else if (jProjectLibraries.getJDK().getJavaVersion().isAfter(new VersionNumber("9"), true)) {
            this._builtTable.setHiddenColumnsVisible(new int[]{0});
            this.asModuleColumnShowing = true;
        }
    }

    private Set getChildren() {
        if (this._children == null) {
            this._children = new HashSet<URL>();
            Iterator children = this._curWorkspace.getChildren();
            while (children.hasNext()) {
                Object next = children.next();
                if (!(next instanceof Project)) continue;
                this._children.add(((Project)next).getURL());
            }
        }
        return this._children;
    }

    public void onExit(TraversableContext dataContext) {
        PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
        dependencyConfiguration.setDependencyList(this.getDependables());
        dependencyConfiguration.setModulePathDependencyList(this.getModulePathDependables());
    }

    private void selectDependencies() {
        Namespace data = new Namespace();
        data.put(WORKSPACE_KEY, (Object)this._curWorkspace);
        data.put(SelectDependenciesPanel.PROJECT_URL_KEY, (Object)this._curProjectURL);
        data.put(SelectDependenciesPanel.DEPENDENCIES_KEY, this.getDependables());
        JTable table = this._builtTable.getTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int insertionPoint = selectionModel.getMaxSelectionIndex();
        if (insertionPoint < 0) {
            insertionPoint = -1;
        } else if (insertionPoint > table.getRowCount() - 1) {
            insertionPoint = table.getRowCount() - 1;
        }
        data.put(SelectDependenciesPanel.DEPENDENCIES_INSERTION_POINT, (Object)insertionPoint);
        data.put(SelectDependenciesPanel.DEPENDABLE_UNDER_EDIT_KEY, (Object)this._activeDependable);
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)this), JProjectArb.getString((int)187), (Traversable)this._selectDependenciesPanel, data);
        launcher.setInitialSize(new Dimension(475, 400));
        JEWTDialog dialog = launcher.initDialog();
        dialog.setOKButtonEnabled(false);
        this._selectDependenciesPanel.setDialog(dialog);
        boolean okResponse = dialog.runDialog();
        dialog.dispose();
        if (okResponse) {
            List newDeps = (List)data.find(SelectDependenciesPanel.DEPENDENCIES_KEY);
            List<Dependable> modulePathDependables = this.getModulePathDependables();
            List<DepItem> dependencies = this.wrapDependables(newDeps, modulePathDependables);
            final int newDepsIndex = (Integer)data.find(SelectDependenciesPanel.DEPENDENCIES_INSERTION_POINT);
            this._model.asList().clear();
            this._model.asList().addAll(dependencies);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTable table = DependencyPanel.this._builtTable.getTable();
                    table.clearSelection();
                    table.getSelectionModel().setSelectionInterval(newDepsIndex, newDepsIndex);
                }
            });
        }
    }

    private List<DepItem> wrapDependables(List<Dependable> dependables, List<Dependable> modulePathDependables) {
        if (dependables == null || dependables.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DepItem> depItems = new ArrayList<DepItem>(dependables.size());
        for (Dependable dependable : dependables) {
            DepItem depItem = new DepItem(dependable);
            depItem.asModule = modulePathDependables.contains(dependable);
            depItems.add(depItem);
        }
        return depItems;
    }

    private List<Dependable> getDependables() {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        for (DepItem depItem : this._model.asList()) {
            deps.add(depItem._dep);
        }
        return deps;
    }

    private List<Dependable> getModulePathDependables() {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        for (DepItem depItem : this._model.asList()) {
            if (!depItem.asModule) continue;
            deps.add(depItem._dep);
        }
        return deps;
    }

    private void initializeComponent() {
        ActionListener addListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DependencyPanel.this.selectDependencies();
            }
        };
        ActionListener removeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List depItems = DependencyPanel.this._builtTable.getSelectedValues();
                if (depItems.isEmpty()) {
                    return;
                }
                List selectedRows = DependencyPanel.this._builtTable.getSelectedRows();
                selectedRows.sort(null);
                final int nextSelectedRow = (Integer)selectedRows.get(selectedRows.size() - 1) - selectedRows.size() + 1;
                for (DepItem depItem : depItems) {
                    DependencyPanel.this._model.asList().remove(depItem);
                }
                DependencyPanel.this._builtTable.getTable().repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTable table = DependencyPanel.this._builtTable.getTable();
                        table.clearSelection();
                        if (table.getRowCount() > 0) {
                            ListSelectionModel listSelectionModel = table.getSelectionModel();
                            int selectedRow = nextSelectedRow;
                            if (selectedRow < 0) {
                                selectedRow = 0;
                            } else if (selectedRow > table.getRowCount() - 1) {
                                selectedRow = table.getRowCount() - 1;
                            }
                            listSelectionModel.setSelectionInterval(selectedRow, selectedRow);
                        }
                    }
                });
            }
        };
        this._model = new SimpleTableModel(new ArrayList(), (SimpleTableFormat)new DepItemTableFormat());
        TableBuilder builder = new TableBuilder();
        builder.setModel(this._model);
        builder.setLabel(JProjectArb.getString((int)179));
        builder.setEmptyTextLarge(JProjectArb.getString((int)180));
        builder.setReorderable(true);
        builder.setSortable(false);
        builder.setRollover(false);
        builder.setColumnSelectionAllowed(false);
        builder.setHiddenColumnsAllowed(false);
        builder.setResizable(true);
        builder.setAutoSizeColumns(false);
        builder.setSelectionMode(2);
        builder.setActionsDefault(TableBuilder.DefaultAction.ADD, addListener);
        builder.setActionsDefault(TableBuilder.DefaultAction.REMOVE, removeListener);
        this.asModuleColumnShowing = true;
        this._builtTable = builder.build();
        JTable table = this._builtTable.getTable();
        JTableHeader tableHeader = table.getTableHeader();
        if (tableHeader != null) {
            tableHeader.setDefaultRenderer((TableCellRenderer)new GenericTableHeaderRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        if (column == 0 && DependencyPanel.this.isAsModuleColumnShowing()) {
                            ((JLabel)component).setHorizontalAlignment(0);
                        } else {
                            ((JLabel)component).setHorizontalAlignment(2);
                        }
                    }
                    return component;
                }
            });
        }
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn zeroColumn = columnModel.getColumn(0);
        zeroColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        String zeroColumnName = JProjectArb.getString((int)196);
        columnModel.getColumn(1).setCellRenderer(new DependableRenderer());
        TableCellRenderer headerCellRenderer = zeroColumn.getHeaderRenderer();
        if (headerCellRenderer == null && tableHeader != null) {
            headerCellRenderer = tableHeader.getDefaultRenderer();
        }
        if (headerCellRenderer != null) {
            Component columnZeroHeader = headerCellRenderer.getTableCellRendererComponent(table, zeroColumnName, false, false, -1, 0);
            FontMetrics fontMetrics = columnZeroHeader.getFontMetrics(columnZeroHeader.getFont());
            int computeStringWidth = SwingUtilities.computeStringWidth(fontMetrics, "   " + zeroColumnName + "   ");
            zeroColumn.setPreferredWidth(computeStringWidth);
            zeroColumn.setMaxWidth((int)((double)computeStringWidth * 1.5));
        } else {
            TableHelper.sizeColumnToContents((JTable)table, (int)0, (int)-1);
        }
        this.add(this._builtTable.getGUI(), "Center");
    }

    private boolean isAsModuleColumnShowing() {
        return this.asModuleColumnShowing;
    }

    private static class DepItemTableFormat
    implements SimpleTableFormat<DepItem> {
        private DepItemTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : DepItem.class;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return JProjectArb.getString((int)196);
                }
                case 1: {
                    return JProjectArb.getString((int)197);
                }
            }
            return "";
        }

        public Object getValueAt(DepItem rowValue, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowValue.asModule;
                }
                case 1: {
                    return rowValue._dep;
                }
            }
            return null;
        }

        public void setValueAt(DepItem rowValue, Object value, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    rowValue.asModule = (Boolean)value;
                    break;
                }
                case 1: {
                    rowValue._dep = (Dependable)value;
                }
            }
        }

        public boolean isCellEditable(DepItem rowValue, int columnIndex) {
            return columnIndex == 0;
        }
    }

    private static class DependableRenderer
    extends DefaultTableCellRenderer {
        private DependableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DepItem) {
                DepItem d = (DepItem)value;
                label.setIcon(d.getIcon());
                label.setText(d.toString());
            }
            return label;
        }
    }

    private class DepItem {
        Icon _icon;
        String _label;
        Dependable _dep;
        boolean asModule;

        DepItem(Dependable dependable) {
            this._dep = dependable;
        }

        private Icon getIcon() {
            if (this._icon == null) {
                this.getLabelAndIcon();
            }
            return this._icon;
        }

        private void getErrorOrWarningLabelAndIcon(Locatable locatable) {
            URL nextURL;
            Set children = DependencyPanel.this.getChildren();
            if (!children.contains(nextURL = locatable.getURL())) {
                if (URLFileSystem.exists((URL)nextURL)) {
                    this._icon = OracleIcons.getIcon((String)"warning.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)177));
                } else {
                    this._icon = OracleIcons.getIcon((String)"error.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)176));
                }
            }
        }

        private void getLabelAndIcon() {
            if (this._label != null || this._icon != null) {
                return;
            }
            if (this._dep.getSource() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSource());
            } else if (this._dep.getSourceOwner() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSourceOwner());
            }
            if (this._label == null) {
                this._label = this._dep.toString();
            }
            if (this._icon == null) {
                this._icon = this._dep.getSource() != null ? this._dep.getSource().getIcon() : OracleIcons.getIcon((String)"error.png");
            }
        }

        public String toString() {
            this.getLabelAndIcon();
            return this._label;
        }
    }
}

