/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.DeleteElementActionHandler;
import oracle.ide.refactoring.SimpleDeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.DialogsArb;

public class DirectoryDeleteActionHandler
extends DeleteElementActionHandler<RelativeDirectoryContextFolder> {
    private volatile IdeModelTree m_ideModel = null;
    private volatile JTree m_contentsTree = null;
    private volatile JTree m_errorTree = null;
    private JPanel m_detailsPanel = null;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    public DirectoryDeleteActionHandler(Context context) {
        super(context);
    }

    private void buildWorkspaceContentsTree() {
        Runnable buildAppTreeRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                try {
                    for (RelativeDirectoryContextFolder f : DirectoryDeleteActionHandler.this.getNodes()) {
                        String relativePath = f.getRelativePath().replace('.', File.separatorChar);
                        URLPath urlPath = f.getRootDirectories();
                        for (URL url : urlPath.asList()) {
                            URL directoryUrl = URLFactory.newDirURL((URL)url, (String)relativePath);
                            treeBuilder.folder(FileSystemModelUtils.urlToFile((URL)directoryUrl));
                        }
                    }
                    DirectoryDeleteActionHandler.this.m_ideModel = treeBuilder.build();
                    DirectoryDeleteActionHandler.this.m_contentsTree = DirectoryDeleteActionHandler.this.m_ideModel.getTree();
                }
                catch (Throwable t) {
                    try {
                        DirectoryDeleteActionHandler.this.m_errorTree = UIUtils.createErrorTree((Throwable)t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (DirectoryDeleteActionHandler.this.m_errorTree == null) {
                                    DirectoryDeleteActionHandler.this.m_detailsContents.setViewportView(DirectoryDeleteActionHandler.this.m_contentsTree);
                                    if (DirectoryDeleteActionHandler.this.m_ideModel != null && DirectoryDeleteActionHandler.this.m_ideModel.hasOptionalItems()) {
                                        DirectoryDeleteActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)32));
                                    }
                                    DirectoryDeleteActionHandler.this.deleteDetailsAvailable(true);
                                    DirectoryDeleteActionHandler.this.clearStatus();
                                    if (DirectoryDeleteActionHandler.this.m_contentsTree.getRowCount() == 1) {
                                        TreePath treePath = DirectoryDeleteActionHandler.this.m_contentsTree.getPathForRow(0);
                                        DirectoryDeleteActionHandler.expandAllSingleChildren(DirectoryDeleteActionHandler.this.m_contentsTree, treePath);
                                    }
                                    DirectoryDeleteActionHandler.this.setOKButtonEnabled(true);
                                } else {
                                    DirectoryDeleteActionHandler.this.m_detailsContents.setViewportView(DirectoryDeleteActionHandler.this.m_errorTree);
                                    DirectoryDeleteActionHandler.this.deleteDetailsAvailable(true);
                                    DirectoryDeleteActionHandler.this.clearStatus();
                                    DirectoryDeleteActionHandler.this.setStatus(DeleteDialogArb.getString((int)34), OracleIcons.getIcon((String)"error.png"));
                                    DirectoryDeleteActionHandler.this.setOKButtonEnabled(false);
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(buildAppTreeRunnable);
    }

    private static void expandAllSingleChildren(JTree tree, TreePath treePath) {
        TreeNode tNode = (TreeNode)treePath.getLastPathComponent();
        if (!tNode.isLeaf() && tNode.getChildCount() == 1) {
            TreeNode childNode = tNode.getChildAt(0);
            if (!childNode.isLeaf()) {
                treePath = treePath.pathByAddingChild(childNode);
                DirectoryDeleteActionHandler.expandAllSingleChildren(tree, treePath);
            } else {
                tree.expandPath(treePath);
            }
        } else {
            tree.expandPath(treePath);
        }
    }

    protected SimpleDeleteActionHandler.DialogTextConfig createDialogTextConfig() {
        return new SimpleDeleteActionHandler.DialogTextConfig().title(DialogsArb.getString(21)).header(MessageFormat.format(DialogsArb.getString(22), this.getNodes().get(0))).description(DialogsArb.getString(23)).showDetails(DialogsArb.getString(24)).hideDetails(DialogsArb.getString(25)).confirmTitle(DialogsArb.getString(27)).confirmMessage(DialogsArb.getString(28)).helpTopicId("f1_ideconfirmfolderdelete_html");
    }

    protected Component createDeleteDetailsComponent() {
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        this.m_detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return this.m_detailsPanel;
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
        this.deleteDetailsAvailable(false);
        this.setStatus(DialogsArb.getString(29), OracleIcons.getIcon((String)"throbber.gif"));
        this.buildWorkspaceContentsTree();
    }

    protected boolean delete(RelativeDirectoryContextFolder element) {
        if (!this.hasError()) {
            String relativePath = element.getRelativePath();
            URLPath urlPath = element.getRootDirectories();
            DeleteFileVisitor deleteFileVisitor = new DeleteFileVisitor();
            for (URL url : urlPath.asList()) {
                URL directoryUrl = URLFactory.newDirURL((URL)url, (String)relativePath);
                FileSystemModelUtils.deleteRecursively((URL[])new URL[]{directoryUrl}, (DeleteFileVisitor)deleteFileVisitor);
            }
            this.getNondeleted().addAll(deleteFileVisitor.getUndeleted());
            return true;
        }
        Assert.println((String)("Failed to delete folder " + element.getRelativePath() + " due to " + ((DefaultMutableTreeNode)this.m_errorTree.getModel().getRoot()).getUserObject()));
        return false;
    }
}

