/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.NumberTextFieldConfig;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;
import oracle.bali.xml.gui.base.inspector.editors.InspectorPropertyEditorSupport;
import oracle.bali.xml.model.XmlContext;

public abstract class NumberEditor
extends InspectorPropertyEditorSupport
implements PropertyEditor,
PropertyEditorFactory {
    private static final Border _sBorder = new EmptyBorder(0, 0, 2, 0);
    private PropertyChangeSupport _support;
    private Number _value;
    private NumberTextField _textField;
    private TextFieldEditor _editor;

    @Override
    public abstract String getJavaInitializationString();

    public abstract Class getDatatype();

    public abstract Number convertToNumber(String var1) throws NumberFormatException;

    public boolean isSigned() {
        return true;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            this._value = null;
        } else if (o instanceof String) {
            this.setAsText(o.toString());
        } else if (o instanceof Number) {
            this._value = (Number)o;
        } else {
            throw new IllegalArgumentException("invalid value " + o);
        }
        this.firePropertyChange("value", null, this._value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getAsText() {
        return this._value != null ? this._value.toString() : null;
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        if ("".equals(text)) {
            this.setValue(null);
            return;
        }
        try {
            Number n = text == null ? (Number)null : (Number)this.convertToNumber(text);
            this.setValue(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.getLocalizedMessage());
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object value) {
        this.setValue(value);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        return DisplayValueRenderer.getTableCellRenderer();
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._textField == null) {
            this._textField = new NumberTextField(){

                public Border getBorder() {
                    return _sBorder;
                }
            };
            this._textField.setLocale(editorLocale);
            this._textField.setDataType(this.getDatatype());
            this._textField.setSigned(this.isSigned());
            this._editor = new TextFieldEditor(this._textField);
        }
        this._textField.setLocale(editorLocale);
        return this._editor;
    }

    public boolean hasTearOffEditor() {
        return false;
    }

    public Component getTearOffEditor() {
        return null;
    }

    public boolean hasAdvancedEditor() {
        return false;
    }

    public Component getAdvancedEditor() {
        return null;
    }

    public EditorComponentInfo getEditorComponentInfo() {
        Locale locale = null;
        XmlContext xmlContext = this.getXmlContext();
        if (xmlContext != null) {
            locale = xmlContext.getLocale();
        }
        NumberTextFieldConfig ntfc = new NumberTextFieldConfig();
        ntfc.setLocale(locale);
        ntfc.setDataType(this.getDatatype());
        ntfc.setSigned(this.isSigned());
        return EditorUtils.createEditorComponentInfo((String)MappedEditorFactoryInfo.COMPONENT_CONFIG_INFO, (Object)ntfc);
    }

    protected Number getNumber() {
        return this._value;
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(name, oldValue, newValue);
        }
    }

    private class TextFieldEditor
    extends DefaultCellEditor {
        private TextFieldEditor(final NumberTextField field) {
            super((JTextField)field);
            field.removeActionListener((ActionListener)this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    field.setText(value != null ? value.toString() : null);
                }

                @Override
                public Object getCellEditorValue() {
                    return field.getText();
                }
            };
            field.addActionListener((ActionListener)this.delegate);
        }
    }
}

