/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

public class DB2TableBuilder
extends JdbcTableBuilder<Table> {
    public DB2TableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
    }

    @Override
    protected void buildUKs(final Table table) {
        final ArrayList arrayList = new ArrayList();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select constname, tabname from SYSCAT.TABCONST where type = 'U' and tabname = ? ", new Object[]{table.getName()});
        try {
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            UniqueConstraint uniqueConstraint = new UniqueConstraint(string, (Relation)table);
                            uniqueConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string, table.getID()));
                            arrayList.add(uniqueConstraint);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)table, sQLException);
                    }
                }
            });
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Unable to build unqiue constraints for table {0}: {1} ", new Object[]{table.getName(), dBException.getMessage()});
        }
        for (UniqueConstraint uniqueConstraint : arrayList) {
            this.getKeyColumns(uniqueConstraint, uniqueConstraint.getName(), table);
            if (uniqueConstraint.getColumnIDs().length > 0) {
                table.addConstraint((Constraint)uniqueConstraint);
                continue;
            }
            table.removeConstraint((Constraint)uniqueConstraint);
        }
    }

    @Override
    protected void buildFKs(final Table table) throws DBException {
        final String string = this.getNameForDriver(table.getName());
        String[] stringArray = this.getCatalogAndSchema(table.getSchema());
        QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select ky.PKTABLE_CAT, ky.PKTABLE_SCHEM, ky.PKTABLE_NAME, ky.PKCOLUMN_NAME, ky.FKTABLE_CAT, ky.FKTABLE_SCHEM, ky.FKTABLE_NAME, ky.FKCOLUMN_NAME, ky.KEY_SEQ, ky.UPDATE_RULE, ky.DELETE_RULE, ky.FK_NAME, ky.PK_NAME, ky.DEFERRABILITY from sysibm.sqlforeignkeys ky where ky.FKTABLE_SCHEM = ? and ky.FKTABLE_NAME = ? and ky.PKTABLE_NAME in ( select tb.table_name from sysibm.sqltables tb where tb.table_type = 'TABLE' and  tb.table_schem = ky.PKTABLE_SCHEM )", new Object[]{stringArray[1], string});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                DB2TableBuilder.this.buildFKsFromMetadata(resultSet, (Relation)table, string);
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Unable to build FKs for {0}: {1}", new String[]{string, dBException.getMessage()});
        }
    }

    private void getKeyColumns(final UniqueConstraint uniqueConstraint, String string, final Table table) {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select colname from syscat.keycoluse where constname = ?  and tabname = ?  and tabschema = ?  order by colseq", new Object[]{string, table, table.getSchema()});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet != null && resultSet.next()) {
                        String string = resultSet.getString(1);
                        Column column = table.getColumn(string);
                        if (column == null) continue;
                        uniqueConstraint.addColumn(column);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)uniqueConstraint, sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Unable to build UK columns for {0}: {1}", new String[]{string, dBException.getMessage()});
        }
    }

    @Override
    protected void buildCCs(final Table table) throws DBException {
        String string = this.getNameForDriver(table.getName());
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select constname, text from SYSCAT.CHECKS where tabschema = ? and tabname = ? ", new Object[]{table.getSchema(), table.getName()});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        CheckConstraint checkConstraint = (CheckConstraint)DB2TableBuilder.this.newObject(CheckConstraint.class, (DBObject)table, string);
                        checkConstraint.setCheckCondition(resultSet.getString(2));
                        checkConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string, table.getID()));
                        table.addConstraint((Constraint)checkConstraint);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Unable to build Check Constraints for {0}: {1}", new String[]{string, dBException.getMessage()});
        }
    }
}

