/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbySynonymBuilder;
import oracle.javatools.db.derby.DerbyTableBuilder;
import oracle.javatools.db.derby.DerbyViewBuilder;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public class DerbyDatabaseImpl
extends JdbcDDLDatabase
implements DerbyDatabase {
    protected DerbyDatabaseImpl(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    @Override
    protected boolean alwaysIncludeDefaultSchema() {
        return true;
    }

    @Override
    protected String queryCurrentSchemaName() throws DBException {
        QueryWrapper queryWrapper = new QueryWrapper((Database)this, "SELECT current schema FROM sys.sysschemas");
        return queryWrapper.executeSingleCellQuery();
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected void registerBuilders() {
        this.registerBuilder("TABLE", (DBObjectBuilder)new DerbyTableBuilder(this, this.getCatalog()));
        this.registerBuilder("VIEW", (DBObjectBuilder)new DerbyViewBuilder(this));
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new DerbySynonymBuilder(this));
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        String string;
        Throwable throwable = dBException.getCause();
        if (throwable instanceof SQLException && ("X0Y23".equals(string = ((SQLException)throwable).getSQLState()) || "X0Y25".equals(string))) {
            throw new CascadeRequiredException((DBObject)systemObject, ((SQLException)throwable).getMessage());
        }
        throw dBException;
    }

    public boolean isUnsupportedOperation(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return "XJZZZ".equals(string) || super.isUnsupportedOperation(sQLException);
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        return Boolean.TRUE.equals(super.isConnectionClosedImpl(sQLException, connection));
    }
}

