/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.informix.InformixDDLType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.util.ModelUtil;

final class InformixDDLGenerator
extends BundleDDLGenerator<InformixDDLType> {
    InformixDDLGenerator(Class<? extends InformixDatabase> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider, new String[]{"/oracle/javatools/db/informix/InformixDDL.properties"});
        this.registerTokens();
    }

    protected InformixDDLType getDDLType(String string) {
        return InformixDDLType.getDDLType(string);
    }

    protected void registerTokens() {
        this.registerTokenGenerator("quotedName", new QuotedNameGenerator());
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        if (string.equals("onDeleteAction")) {
            return Collections.singleton(FKConstraint.ReferentialAction.CASCADE);
        }
        return super.getAllowedPropertyValues(dBObject, dBObject2, string);
    }

    private static class QuotedNameGenerator
    extends TokenGenerator {
        private static final String TOKEN = "quotedName";

        private QuotedNameGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            String string = this.getName(tokenContext);
            boolean bl = false;
            DBObjectProvider dBObjectProvider = tokenContext.getProvider();
            if (dBObjectProvider instanceof InformixDatabaseImpl) {
                Connection connection = ((InformixDatabaseImpl)dBObjectProvider).getConnection();
                try {
                    String string2 = connection.getMetaData().getIdentifierQuoteString();
                    if (string2 != " ") {
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    String string3 = sQLException.getLocalizedMessage();
                }
            }
            if (string != null && bl) {
                tokenContext.append((Object)Character.valueOf('\"'));
                tokenContext.append((Object)string);
                tokenContext.append((Object)Character.valueOf('\"'));
            } else if (string != null) {
                tokenContext.append((Object)string);
            }
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("name".toString());
        }

        private String getName(TokenContext tokenContext) {
            String string = null;
            Object object = tokenContext.getObject();
            if (object instanceof DBObject) {
                string = (String)((DBObject)object).getProperty("name");
            }
            return string;
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return ModelUtil.hasLength((String)this.getName(tokenContext));
        }
    }
}

