/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.db.informix.InformixTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;

public class InformixViewBuilder
extends JdbcViewBuilder {
    private static final String VIEW_TEXT_QUERY = " select v.viewtext  from sysviews v join systables t on ( t.tabid = v.tabid )  where t.tabname = ? and t.owner = ?  order by v.seqno ";

    public InformixViewBuilder(InformixDatabaseImpl informixDatabaseImpl, String string) {
        super(informixDatabaseImpl, string);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery"})
    public void buildQuery(final View view) throws DBException {
        final StringBuffer stringBuffer = new StringBuffer();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), VIEW_TEXT_QUERY, new Object[]{view, view.getSchema()});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        stringBuffer.append(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)view, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        String string = stringBuffer.toString().trim();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        this.decodeQueryString(string, view);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(View view, Column column, DataType dataType, Long l, Long l2, String string) {
        Map<String, Object> map = super.createDataTypeAttributes(view, column, dataType, l, l2, string);
        if (dataType != null) {
            String string2 = dataType.getName();
            if ("VARCHAR".equals(string2) || "NVARCHAR".equals(string2)) {
                if (l != null) {
                    long l3 = l < 0L ? l + 65536L : l;
                    long l4 = l3 / 256L;
                    map.put("size", l3 - l4 * 256L);
                    map.put("reserve", l4);
                }
            } else if ("INTERVAL".equals(string2) || "DATETIME".equals(string2)) {
                if (l != null) {
                    int n = l.intValue() / 256;
                    int n2 = (l.intValue() - n * 256) / 16;
                    int n3 = l.intValue() - n * 256 - n2 * 16;
                    map.put("from", InformixTableBuilder.getTimeTypeName(n2));
                    map.put("to", InformixTableBuilder.getTimeTypeName(n3));
                    map.put("precision", n);
                    if (n3 > 10) {
                        map.put("scale", n3 - 10);
                    } else {
                        map.remove("scale");
                    }
                }
            } else if ("DECIMAL".equals(string2) && l2 != null && l2.equals(255L)) {
                map.remove("scale");
            }
        }
        return map;
    }

    @Override
    protected String getQuerySearchString() {
        return "CREATE VIEW <name ?.> [(<cols {^)}...>)] AS <select {^{WITH CHECK OPTION|WITH READ ONLY}}...> <check [WITH CHECK OPTION]> <readOnly [WITH READ ONLY]>";
    }

    @Override
    public boolean canBuildEditableObject() {
        return true;
    }
}

