/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.jdbc.DMDBuilder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public abstract class JdbcRelationBuilder<T extends Relation>
extends DMDBuilder<T> {
    protected JdbcRelationBuilder(JdbcDatabase jdbcDatabase, String string, String string2) {
        super(jdbcDatabase, string, string2);
    }

    @Deprecated
    protected T createRelation(Schema schema, String string) {
        return null;
    }

    protected final boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T t) throws DBException {
        Connection connection = this.getConnection();
        ResultSet resultSet = null;
        try {
            resultSet = this.getColumnsMetadata(t, connection);
            this.buildColumns(resultSet, t);
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        finally {
            this.close(resultSet);
        }
    }

    protected ResultSet getColumnsMetadata(T t, Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = this.getNameForDriver(t.getName());
        String[] stringArray = this.getCatalogAndSchema(t.getSchema());
        String string2 = databaseMetaData.getDatabaseProductName();
        ResultSet resultSet = "EXCEL".equals(string2) ? databaseMetaData.getColumns(stringArray[0], null, string, null) : databaseMetaData.getColumns(stringArray[0], stringArray[1], string, "%");
        return resultSet;
    }

    private void buildColumns(ResultSet resultSet, T t) throws SQLException, DBException {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        String string = this.getNameForDriver(t.getName());
        try {
            JdbcDatabase jdbcDatabase = this.getDatabase();
            int n = 0;
            while (resultSet.next()) {
                Object object;
                Object object2;
                Map<String, Object> map;
                String string2;
                if (string == null && !resultSet.getString(3).equals(t.getName())) continue;
                ++n;
                String string3 = resultSet.getString(4);
                Column column = (Column)this.newObject(Column.class, string3);
                column.setID((DBObjectID)new NameBasedID((DBObject)column, t.getID()));
                arrayList.add(column);
                column.setRelation(t);
                String string4 = resultSet.getString(6);
                if ((string4 == null || string4.length() == 0) && (string2 = resultSet.getString(5)).equals(4118)) {
                    string4 = "ROW";
                }
                string2 = jdbcDatabase.normaliseDataTypeName(string4);
                long l = resultSet.getLong(7);
                Long l2 = resultSet.wasNull() ? null : new Long(l);
                long l3 = resultSet.getLong(9);
                Long l4 = resultSet.wasNull() ? null : new Long(l3);
                DataType dataType = null;
                DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getDatabase(), (Schema)t.getSchema(), (String)string2);
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                }
                catch (DBException dBException) {
                    this.getLogger().warning(dBException.getMessage());
                }
                Map<String, Object> map2 = this.createDataTypeAttributes(t, column, dataType, l2, l4, string4);
                if (map2 != null && !map2.isEmpty()) {
                    map = dataType == null || dataType instanceof UserDataType ? map2 : dataType.createUsage(map2).getAttributeValues();
                    object2 = map.entrySet().iterator();
                    while (object2.hasNext()) {
                        object = (Map.Entry)object2.next();
                        dataTypeUsage.putAttributeValue((String)object.getKey(), object.getValue());
                    }
                }
                column.setDataTypeUsage(dataTypeUsage);
                map = resultSet.getString(12);
                if (ModelUtil.hasLength((String)((Object)map))) {
                    column.setProperty("Comment", (Object)map);
                }
                if (ModelUtil.hasLength((String)(object2 = resultSet.getString(13)))) {
                    column.setDefault((Object)jdbcDatabase.normaliseDefaultValue(dataType, (String)object2));
                }
                try {
                    object = resultSet.getString(18);
                    if (object != null) {
                        boolean bl = ((String)object).trim().equals("NO") || ((String)object).trim().equals("N");
                        column.setNotNull(bl);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.buildExtraColumnInformation(t, column, resultSet);
            }
            this.getLogger().fine(">>fillInColumns : " + n + " columns returned for " + t.getName());
            t.setColumns(arrayList.toArray(new Column[arrayList.size()]));
            this.addExtraColumnAttributes(t);
        }
        catch (SQLException sQLException) {
            this.checkUnsupportedOperation((DBObject)t, sQLException);
        }
    }

    protected void buildExtraColumnInformation(T t, Column column, ResultSet resultSet) throws SQLException {
    }

    protected void addExtraColumnAttributes(T t) throws SQLException, DBException {
    }

    @Deprecated
    protected DataTypeUsage getDataTypeUsage(T t, Column column, DataType dataType, Long l, Long l2, String string) {
        DataTypeUsage dataTypeUsage = null;
        Map<String, Object> map = this.createDataTypeAttributes(t, column, dataType, l, l2, string);
        dataTypeUsage = dataType.createUsage(map);
        return dataTypeUsage;
    }

    protected Map<String, Object> createDataTypeAttributes(T t, Column column, DataType dataType, Long l, Long l2, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JdbcDatabase jdbcDatabase = this.getDatabase();
        String string2 = jdbcDatabase.normaliseDataTypeName(string);
        DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)jdbcDatabase, (Schema)t.getSchema(), (String)string2);
        if (dataType != null) {
            hashMap.put("name", dataType.getName());
        }
        this.setAttributeValue("size", dataType, l, hashMap, dataTypeUsage);
        this.setAttributeValue("precision", dataType, l, hashMap, dataTypeUsage);
        this.setAttributeValue("scale", dataType, l2, hashMap, dataTypeUsage);
        this.addExtraDataTypeAttributeValues(hashMap, column.getName(), t);
        return hashMap;
    }

    private void setAttributeValue(String string, DataType dataType, Long l, Map<String, Object> map, DataTypeUsage dataTypeUsage) {
        String[] stringArray;
        DataTypeAttribute dataTypeAttribute;
        Object object = dataTypeUsage.getAttributeValue(string);
        if (dataType != null && object != null && (dataTypeAttribute = dataType.getDataTypeAttribute(string)) != null && dataTypeAttribute.getValueType() == 2 && (stringArray = dataTypeAttribute.getValues()) != null && stringArray.length > 0) {
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase((String)object)) continue;
                return;
            }
        }
        map.put(string, DataTypeHelper.getAttributeValue((Object)l, (DataType)dataType, (String)string));
    }

    protected void addExtraDataTypeAttributeValues(Map<String, Object> map, String string, T t) {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"}, depends={"columns"})
    public void fillInConstraints(T t) throws DBException {
        t.setConstraints(new Constraint[0]);
        this.buildPK(t);
        this.buildUKs(t);
        this.buildCCs(t);
        this.buildFKs(t);
    }

    protected ResultSet getPrimaryKeysMetadata(T t, Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = this.getNameForDriver(t.getName());
        String[] stringArray = this.getCatalogAndSchema(t.getSchema());
        return databaseMetaData.getPrimaryKeys(stringArray[0], stringArray[1], string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPK(T t) throws DBException {
        ResultSet resultSet;
        block8: {
            String string = this.getNameForDriver(t.getName());
            resultSet = null;
            try {
                String string2;
                resultSet = this.getPrimaryKeysMetadata(t, this.getConnection());
                TreeSet<ConCol> treeSet = new TreeSet<ConCol>();
                int n = 0;
                PKConstraint pKConstraint = null;
                while (resultSet.next()) {
                    String string3 = resultSet.getString(2);
                    String object = resultSet.getString(3);
                    if (string == null && !object.equals(t.getName())) continue;
                    string2 = resultSet.getString(4);
                    short s = resultSet.getShort(5);
                    if (pKConstraint == null) {
                        String string4 = resultSet.getString(6);
                        string4 = ModelUtil.hasLength((String)string4) ? string4 : this.makePKName(string3, object);
                        pKConstraint = new PKConstraint(string4, t);
                        pKConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string4, t.getID()));
                    }
                    treeSet.add(new ConCol(s, n++, string2));
                }
                if (pKConstraint == null) break block8;
                for (ConCol conCol : treeSet) {
                    string2 = t.getColumn(conCol.getColumnName());
                    if (string2 == null) continue;
                    string2.setNotNull(true);
                    pKConstraint.addColumn((Column)string2);
                }
                if (pKConstraint.getColumnIDs().length > 0) {
                    t.addConstraint(pKConstraint);
                    break block8;
                }
                t.removeConstraint(pKConstraint);
            }
            catch (SQLException sQLException) {
                try {
                    this.checkUnsupportedOperation((DBObject)t, sQLException);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
            }
        }
        this.close(resultSet);
    }

    protected void buildUKs(T t) throws DBException {
    }

    protected void buildCCs(T t) throws DBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildFKs(T t) throws DBException {
        String string = this.getNameForDriver(t.getName());
        ResultSet resultSet = null;
        try {
            resultSet = this.getForeignKeysMetadata(t);
            this.buildFKsFromMetadata(resultSet, t, string);
        }
        catch (SQLException sQLException) {
            if (!(t instanceof View)) {
                this.checkUnsupportedOperation((DBObject)t, sQLException);
            }
        }
        finally {
            this.close(resultSet);
        }
    }

    protected ResultSet getForeignKeysMetadata(T t) throws SQLException {
        String string = this.getNameForDriver(t.getName());
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        String[] stringArray = this.getCatalogAndSchema(t.getSchema());
        return databaseMetaData.getImportedKeys(stringArray[0], stringArray[1], string);
    }

    protected String makePKName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ModelUtil.hasLength((String)string)) {
            stringBuffer.append(string + '#');
        }
        stringBuffer.append(string2 + "#PK");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void buildFKsFromMetadata(ResultSet resultSet, T t, String string) throws DBException {
        Table table;
        int n;
        String string2;
        short s;
        Table table2;
        Object object;
        TreeSet<ConCol> treeSet;
        String string3;
        String string4 = this.isUseSchema() && t.getSchema() != null ? t.getSchema().getName() : null;
        HashMap<Object, Table> hashMap = new HashMap<Object, Table>();
        MultiMap multiMap = new MultiMap(TreeSet.class);
        boolean bl = false;
        try {
            int n2 = 0;
            TreeSet<Short> object3 = new TreeSet<Short>();
            while (resultSet.next()) {
                void var18_29;
                if (string == null && !resultSet.getString(7).equals(t.getName())) continue;
                String string5 = string3 = this.getDatabase().catalogIsSchema() ? resultSet.getString(1) : resultSet.getString(2);
                if (string3 == null) {
                    string3 = string4;
                }
                treeSet = resultSet.getString(3);
                object = resultSet.getString(4);
                String string6 = resultSet.getString(7);
                table2 = resultSet.getString(8);
                short s2 = resultSet.getShort(9);
                if (resultSet.wasNull() || object3.contains(s2)) {
                    bl = true;
                } else {
                    object3.add(s2);
                }
                s = resultSet.getShort(11);
                String string7 = resultSet.getString(12);
                String string8 = resultSet.getString(13);
                if (resultSet.wasNull() || !ModelUtil.hasLength((String)string8)) {
                    String string9 = this.makePKName(string3, (String)((Object)treeSet));
                }
                string2 = null;
                try {
                    string2 = this.getDatabase().getSchema(string3);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                n = resultSet.getShort(14);
                Object object2 = ModelUtil.hasLength((String)string7) ? string7 : treeSet + "." + (String)var18_29;
                table = (FKConstraint)hashMap.get(object2);
                if (table == null) {
                    table = new FKConstraint(string7, t);
                    NameBasedID nameBasedID = new NameBasedID((DBObject)table, t.getID());
                    table.setID((DBObjectID)nameBasedID);
                    NameBasedID nameBasedID2 = new NameBasedID("TABLE", string3, treeSet, (AbstractDBObjectProvider)this.getDatabase());
                    NameBasedID nameBasedID3 = new NameBasedID("CONSTRAINT", (String)var18_29, (DBObjectID)nameBasedID2);
                    table.setReferenceID((DBObjectID)nameBasedID3);
                    hashMap.put(object2, table);
                    FKConstraint.ReferentialAction referentialAction = this.getFkOnDeleteAction(s);
                    table.setOnDeleteAction(referentialAction);
                    Object object4 = n == 5 ? Constraint.DeferrableState.DEFER_INIT_DEFERRED : (n == 6 ? Constraint.DeferrableState.DEFER_INIT_IMMEDIATE : null);
                    table.setDeferrableState(object4);
                }
                multiMap.add(object2, (Object)new ConCol(s2, n2++, (String)table2, (String)object));
            }
        }
        catch (SQLException sQLException) {
            this.checkUnsupportedOperation((DBObject)t, sQLException);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            block21: {
                string3 = (FKConstraint)entry.getValue();
                treeSet = multiMap.get(entry.getKey());
                if (!this.trustReferencedConstraintInfo() || bl && treeSet.size() > 1) {
                    try {
                        void var13_22;
                        object = string3.getReferenceID();
                        UniqueConstraint uniqueConstraint = (UniqueConstraint)object.resolveID();
                        if (uniqueConstraint == null && object.getParent() != null && (table2 = (Table)object.getParent().resolveID()) != null) {
                            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)table2);
                        }
                        if (var13_22 == null) {
                            DBLog.getLogger((Object)((Object)this)).warning("Unable to recover unique key " + object + " referenced by foreign key " + DBUtil.getFullyQualifiedName((DBObject)string3));
                            break block21;
                        }
                        table2 = var13_22.getColumnIDs();
                        if (((DBObjectID[])table2).length != treeSet.size()) {
                            DBLog.getLogger((Object)((Object)this)).warning("Unable to reference unique key " + object + " from foreign key " + DBUtil.getFullyQualifiedName((DBObject)string3) + " because their column lists are different sizes.");
                            break block21;
                        }
                        TreeSet<ConCol> treeSet2 = treeSet;
                        treeSet = new TreeSet<ConCol>();
                        s = 0;
                        for (ConCol conCol : treeSet2) {
                            string2 = conCol.getReferencedColumnName();
                            n = -1;
                            for (int i = 0; i < ((Table)table2).length; ++i) {
                                table = table2[i];
                                if (!this.getDatabase().getDescriptor().areNamesEqual(string2, DBUtil.getDBObjectName((DBObjectID)table), "COLUMN", false)) continue;
                                n = i;
                                break;
                            }
                            if (n < 0) {
                                treeSet = treeSet2;
                                break;
                            }
                            treeSet.add(new ConCol((short)n, s++, conCol.getColumnName(), string2));
                        }
                    }
                    catch (DBException dBException) {
                        DBLog.getLogger((Object)((Object)this)).warning("Error checking " + string3.getName() + ": " + dBException.getMessage());
                    }
                }
            }
            for (ConCol conCol : treeSet) {
                string3.addColumn(t.getColumn(conCol.getColumnName()));
            }
            t.addConstraint((Constraint)string3);
        }
    }

    protected FKConstraint.ReferentialAction getFkOnDeleteAction(short s) {
        Object object = s == 1 ? FKConstraint.ReferentialAction.RESTRICT : (s == 0 ? FKConstraint.ReferentialAction.CASCADE : (s == 2 ? FKConstraint.ReferentialAction.SET_NULL : (s == 4 ? FKConstraint.ReferentialAction.SET_DEFAULT : (s == 3 ? FKConstraint.ReferentialAction.NO_ACTION : null))));
        return object;
    }

    protected boolean trustReferencedConstraintInfo() {
        return true;
    }

    private static class ConCol
    implements Comparable {
        private final short m_seq;
        private final int m_iteration;
        private final String m_colName;
        private final String m_refColName;

        ConCol(short s, int n, String string) {
            this(s, n, string, null);
        }

        ConCol(short s, int n, String string, String string2) {
            this.m_seq = s;
            this.m_iteration = n;
            this.m_colName = string;
            this.m_refColName = string2;
        }

        public String getColumnName() {
            return this.m_colName;
        }

        public String getReferencedColumnName() {
            return this.m_refColName;
        }

        public int compareTo(Object object) {
            ConCol conCol = (ConCol)object;
            int n = this.m_seq == conCol.m_seq ? this.m_iteration - conCol.m_iteration : this.m_seq - conCol.m_seq;
            return n;
        }
    }
}

