/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.GenericComparator;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.DBObjectRefsSAXHelper;
import oracle.javatools.db.marshal.DBObjectSAXHelper;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXException;

public class DBObject2XML
extends DBObjectXMLHandler {
    private static final String HEADER = "<?xml version = '1.0' encoding = 'UTF-8'?>\n";
    private static final String INDENT = "  ";
    private static final String NEWLINE = "\n";
    static final String COMPOSITE = "composite";
    static final String ENTRY = "entry";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String CLASS = "class";
    private Map<Class, Boolean> m_stringInfo;
    private Map<String, Class<? extends DBObject>> m_oldClzMappings;

    public DBObject2XML() {
        this(null);
    }

    public DBObject2XML(String string) {
        this(string, null);
    }

    public DBObject2XML(String string, Map<String, Class<? extends DBObject>> map) {
        super(string);
        this.m_oldClzMappings = map;
    }

    private Iterable<PropertyInfo> getBeanPropertyInfos(Object object, boolean bl) {
        PropertyCriteria propertyCriteria;
        if (bl) {
            propertyCriteria = new PropertyCriteria();
            propertyCriteria.addPredicate(propertyInfo -> !propertyInfo.isGetTransient() && !propertyInfo.isSetTransient());
        } else {
            propertyCriteria = PropertyCriteria.createEmptyCriteria();
        }
        propertyCriteria.setIncludeExtra(false);
        Map map = PropertyHelper.getPropertyInfos(object.getClass(), null, (PropertyCriteria)propertyCriteria);
        TreeSet<PropertyInfo> treeSet = new TreeSet<PropertyInfo>();
        treeSet.addAll(map.values());
        return treeSet;
    }

    protected boolean toStringConverterAvailable(Object object) {
        if (object == null) {
            return false;
        }
        return this.toStringConverterAvailable(object.getClass());
    }

    protected boolean toStringConverterAvailable(Class clazz) {
        if (this.m_stringInfo == null) {
            this.m_stringInfo = new HashMap<Class, Boolean>();
        } else if (this.m_stringInfo.containsKey(clazz)) {
            return this.m_stringInfo.get(clazz);
        }
        boolean bl = ToStringManager.converterAvailable((Class)clazz);
        this.m_stringInfo.put(clazz, bl);
        return bl;
    }

    public void write(List<? extends DBObject> list, Writer writer) throws IOException {
        writer.write(HEADER);
        if (list.size() > 1) {
            if (!(writer instanceof BufferedWriter)) {
                writer = new BufferedWriter(writer);
            }
            this.writeOpenTag(null, COMPOSITE, null, "", writer);
            writer.write(NEWLINE);
            for (DBObject dBObject : list) {
                this.writeObject(dBObject, INDENT, writer);
            }
            this.writeEndTag(COMPOSITE, "", writer);
            writer.flush();
        } else {
            this.writeObject(list.get(0), "", writer);
        }
    }

    private void writeObject(Object object, String string, Writer writer) throws IOException {
        String string2 = this.getDefaultTagName(object);
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.writeObject(object, string2, null, string, writer);
        writer.flush();
    }

    private String getDefaultTagName(Object object) {
        if (object instanceof DBObject) {
            return DBObject2XML.convertType(((DBObject)object).getType());
        }
        return object.getClass().getName();
    }

    private void writeObject(Object object, String string, Class clazz, String string2, Writer writer) throws IOException {
        this.writeObject(object, null, string, clazz, string2, writer);
    }

    private void writeObject(Object object, Object object2, String string, Class clazz, String string2, Writer writer) throws IOException {
        if (this.toStringConverterAvailable(object)) {
            String string3 = object instanceof String ? (String)object : ToStringManager.toString((Object)object);
            if ((string3 = DBObject2XML.encodeText(string3)) != null) {
                this.writeOpenTag(object, string, clazz, string2, writer);
                writer.write(string3);
                this.writeEndTag(string, "", writer);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object2 != null && string.equals("properties")) {
                for (PropertyInfo propertyInfo : this.getBeanPropertyInfos(object2, false)) {
                    arrayList.add(propertyInfo.getPropertyName());
                }
            }
            TreeMap treeMap = new TreeMap(new GenericComparator());
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                if (arrayList.contains(k)) continue;
                treeMap.put(k, entry.getValue());
            }
            if (treeMap.size() > 0) {
                this.writeOpenTag(object, string, clazz, string2, writer);
                writer.write(NEWLINE);
                this.writeEntries(treeMap, string2 + INDENT, writer);
                this.writeEndTag(string, string2, writer);
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (ModelUtil.hasNonNullElement((Object[])objectArray)) {
                this.writeOpenTag(object, string, clazz, string2, writer);
                writer.write(NEWLINE);
                for (int i = 0; i < objectArray.length; ++i) {
                    Class<?> clazz2 = clazz.getComponentType();
                    String string4 = string;
                    string4 = string4.equals("indexes") ? "index" : (string4.endsWith("s") ? string4.substring(0, string4.length() - 1) : string4 + "Item");
                    if (objectArray[i] == null) continue;
                    this.writeObject(objectArray[i], string4, clazz2, string2 + INDENT, writer);
                }
                this.writeEndTag(string, string2, writer);
            }
        } else if (object instanceof TemporaryObjectID) {
            TemporaryObjectID temporaryObjectID = (TemporaryObjectID)object;
            DBLog.logIllegalState((String)("Trying to save TemporaryObjectID of type " + temporaryObjectID.getType() + " to XML: " + temporaryObjectID.toString()));
        } else {
            this.writeOpenTag(object, string, clazz, string2, writer);
            writer.write(NEWLINE);
            this.writeProperties(object, string2 + INDENT, writer);
            this.writeEndTag(string, string2, writer);
        }
    }

    private void writeOpenTag(Object object, String string, Class clazz, String string2, Writer writer) throws IOException {
        writer.write(string2);
        writer.write("<");
        writer.write(string);
        if (clazz != null && clazz != Map.class && object != null && object.getClass() != ToStringManager.wrapPrimitive((Class)clazz)) {
            writer.write(" ");
            writer.write(CLASS);
            writer.write("=\"");
            writer.write(object.getClass().getName());
            writer.write("\"");
        }
        String string3 = this.getNamespace();
        if (!ModelUtil.hasLength((String)string2) && ModelUtil.hasLength((String)string3)) {
            writer.write(" xmlns=\"");
            writer.write(string3);
            writer.write("\"");
        }
        writer.write(">");
    }

    private void writeProperties(Object object, String string, Writer writer) throws IOException {
        for (PropertyInfo propertyInfo : this.getBeanPropertyInfos(object, true)) {
            Object object2;
            String string2 = propertyInfo.getPropertyName();
            Object object3 = propertyInfo.getPropertyValue(object);
            if (object3 == null) continue;
            if ("ID".equals(string2) && object3 instanceof BaseObjectID) {
                if (!(object3 instanceof IdentifierBasedID) || (object2 = ((IdentifierBasedID)object3).getIdentifier()) == null) continue;
                this.writeOpenTag(object3, "ID", DBObjectID.class, string, writer);
                writer.write(NEWLINE);
                this.writeObject(object2, "identifier", Object.class, string + INDENT, writer);
                this.writeEndTag("ID", string, writer);
                continue;
            }
            if ("schema".equals(string2)) {
                if (!(object3 instanceof Schema)) continue;
                object2 = ((Schema)object3).getName();
                this.writeOpenTag(object3, "schema", Schema.class, string, writer);
                writer.write(NEWLINE);
                this.writeObject(object2, "name", String.class, string + INDENT, writer);
                this.writeEndTag("schema", string, writer);
                continue;
            }
            this.writeObject(object3, object, string2, propertyInfo.getPropertyClass(), string, writer);
        }
    }

    private void writeEntries(Map<Object, Object> map, String string, Writer writer) throws IOException {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.writeOpenTag(null, ENTRY, null, string, writer);
            writer.write(NEWLINE);
            Object object = entry.getKey();
            if (object instanceof String) {
                String string2 = string + INDENT;
                this.writeOpenTag(null, KEY, null, string2, writer);
                writer.write((String)object);
                this.writeEndTag(KEY, "", writer);
                Object object2 = entry.getValue();
                if (object2 != null) {
                    this.writeObject(object2, VALUE, object2 instanceof Object[] ? Object[].class : Object.class, string2, writer);
                }
            } else {
                new UnsupportedOperationException("map keys must be strings").printStackTrace();
            }
            this.writeEndTag(ENTRY, string, writer);
        }
    }

    private void writeEndTag(String string, String string2, Writer writer) throws IOException {
        writer.write(string2);
        writer.write("</" + string + ">\n");
    }

    protected List<DBObject> readImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException {
        return this.read(reader, dBObjectProvider, false);
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        try {
            return this.read(reader, dBObjectProvider, true);
        }
        catch (IOException iOException) {
            Throwable throwable;
            Throwable throwable2 = iOException.getCause();
            if (throwable2 instanceof SAXException && (throwable = throwable2.getCause()) instanceof PartialParseUnsupportedException) {
                throw (PartialParseUnsupportedException)throwable;
            }
            throw iOException;
        }
    }

    private List<DBObject> read(Reader reader, DBObjectProvider dBObjectProvider, boolean bl) throws IOException {
        DBObjectSAXHelper dBObjectSAXHelper = new DBObjectSAXHelper(this.getNamespace(), bl, this);
        dBObjectSAXHelper.setProvider(dBObjectProvider);
        if (this.m_oldClzMappings != null) {
            dBObjectSAXHelper.setTypeMappings(this.m_oldClzMappings);
        }
        DBObject2XML.read(reader, dBObjectSAXHelper, bl);
        return dBObjectSAXHelper.getDBObjects();
    }

    static String convertType(String string) {
        boolean bl = DBObject2XML.isUpperCase(string);
        StringBuilder stringBuilder = new StringBuilder(bl ? string.toLowerCase() : string);
        if (!bl) {
            DBObject2XML.changeCase(stringBuilder, 0);
        }
        int n = stringBuilder.indexOf(" ");
        while (n > -1) {
            stringBuilder.deleteCharAt(n);
            DBObject2XML.changeCase(stringBuilder, n);
            n = stringBuilder.indexOf(" ", n);
        }
        return stringBuilder.toString();
    }

    private static boolean isUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLowerCase(c) || c == ' ') continue;
            return false;
        }
        return true;
    }

    private static void changeCase(StringBuilder stringBuilder, int n) {
        char c = stringBuilder.charAt(n);
        if (Character.isUpperCase(c)) {
            stringBuilder.setCharAt(n, Character.toLowerCase(c));
        } else {
            stringBuilder.setCharAt(n, Character.toUpperCase(c));
        }
    }

    private static boolean isNonValidXMLChar(char c) {
        return !(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }

    private static String encodeText(String string) {
        if (!ModelUtil.hasLength((String)string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (DBObject2XML.isNonValidXMLChar(c)) {
                stringBuilder = null;
                break;
            }
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("<![CDATA[");
            stringBuilder.append(string);
            stringBuilder.append("]]>");
        }
        return stringBuilder.toString();
    }

    protected void readIDsImpl(DBObjectHandler.UnmarshalledIDs unmarshalledIDs, Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        DBObjectRefsSAXHelper dBObjectRefsSAXHelper = new DBObjectRefsSAXHelper(this.getNamespace(), unmarshalledIDs, this.getIDClassPatterns(), this.getParsedProperties());
        dBObjectRefsSAXHelper.setProvider(dBObjectProvider);
        DBObject2XML.read(reader, dBObjectRefsSAXHelper, false);
        if (schema != null) {
            String string = schema.getName();
            for (DBObjectID dBObjectID : unmarshalledIDs.getObjectIDs()) {
                ((BaseObjectID)dBObjectID).setSchemaName(string);
            }
        }
    }

    protected Collection<String> getIDClassPatterns() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("oracle\\.javatools\\.db\\..*ID");
        return hashSet;
    }

    protected Collection<String> getParsedProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("queryString");
        return hashSet;
    }
}

