/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.marshal.BaseSAXHelper;
import oracle.javatools.db.marshal.DBObject2XML;
import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

class DBObjectSAXHelper
extends BaseSAXHelper {
    private static final String NULL = "null";
    private boolean m_idNameOnly;
    private final List<DBObject> m_objs = new ArrayList<DBObject>();
    private Map<Class, Map<String, PropertyInfo>> m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    private Map<String, Class<? extends DBObject>> m_types;
    private DBObject2XML m_parent;

    public DBObjectSAXHelper(String string, boolean bl, DBObject2XML dBObject2XML) {
        super(string);
        this.m_idNameOnly = bl;
        this.m_parent = dBObject2XML;
    }

    public List<DBObject> getDBObjects() {
        return this.m_objs;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object object) {
        Map map;
        Class<?> clazz = object.getClass();
        if (this.m_infos.containsKey(clazz)) {
            map = this.m_infos.get(clazz);
        } else {
            PropertyCriteria propertyCriteria = PropertyCriteria.createEmptyCriteria();
            propertyCriteria.setIncludeExtra(false);
            propertyCriteria.addPredicate(propertyInfo -> this.shouldReadProperty(clazz, (PropertyInfo)propertyInfo));
            map = PropertyHelper.getPropertyInfos(clazz, null, (PropertyCriteria)propertyCriteria);
            this.m_infos.put(clazz, map);
        }
        return map;
    }

    private boolean shouldReadProperty(Class<?> clazz, PropertyInfo propertyInfo) {
        String string;
        boolean bl = propertyInfo.isInternal() ? "name".equals(string = propertyInfo.getPropertyName()) || clazz.equals(CheckConstraint.class) && "checkConditionFragment".equals(string) || clazz.equals(IndexObject.class) && "expression".equals(string) : !propertyInfo.isGetTransient();
        return bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = ModelUtil.hasLength((String)string2) ? string2 : string3;
        this.clearChars();
        int n = this.getStackSize();
        if (n == 0) {
            this.checkNamespace(string);
            if (!"composite".equals(string2)) {
                Class clazz = this.getObjectClass(string4);
                this.m_objs.add((DBObject)this.createObject(clazz));
            } else if (this.m_idNameOnly) {
                throw new SAXException((Exception)new PartialParseUnsupportedException());
            }
        } else {
            Object t = this.getCurrentObject();
            if (t == NULL) {
                this.push(NULL, NULL);
            } else if (t instanceof Map) {
                this.push(new Object[2], string4);
            } else if (t instanceof Object[]) {
                if (string4.equals("key")) {
                    this.push("key", string4);
                } else if (string4.equals("value")) {
                    Class clazz = this.getAttributeClass(attributes);
                    if (clazz == null) {
                        this.push("value", string4);
                    } else if (this.m_parent.toStringConverterAvailable(clazz)) {
                        this.push(clazz, string4);
                    } else if (clazz.isArray()) {
                        ArrayList<Class> arrayList = new ArrayList<Class>();
                        arrayList.add(clazz);
                        this.push(arrayList, string4);
                    } else {
                        this.createObjectNoFail(clazz, string4);
                    }
                }
            } else if (t instanceof List) {
                Class<?> clazz = this.getAttributeClass(attributes);
                if (clazz == null) {
                    Class clazz2;
                    Object t2 = this.getCurrentParent();
                    if (t2 instanceof PropertyInfo && (clazz2 = ((PropertyInfo)t2).getPropertyClass()).isArray()) {
                        clazz = clazz2.getComponentType();
                    }
                    if (clazz == null) {
                        clazz = this.getObjectClass(string4);
                    }
                }
                if (this.m_parent.toStringConverterAvailable(clazz)) {
                    this.push(clazz, string4);
                } else {
                    this.createObjectNoFail(clazz, string4);
                }
            } else {
                PropertyInfo propertyInfo = this.getPropertyInfos(t).get(string4);
                if (propertyInfo == null) {
                    Map map = null;
                    if (t instanceof Copyable) {
                        map = PropertyHelper.getPropertyInfos(t.getClass(), null, null);
                    }
                    if (map != null && map.containsKey(string4)) {
                        this.getLogger().log(Level.FINE, "Ignoring property \"{0}\" as it is transient/deprecated.", string4);
                    } else {
                        this.getLogger().log(Level.INFO, "XML parse: Unknown property {0} on {1}", new Object[]{string4, t.getClass()});
                    }
                    this.push(NULL, string4);
                } else {
                    this.push(propertyInfo, string4);
                    Class clazz = propertyInfo.getPropertyClass();
                    if (clazz == Map.class) {
                        this.push(new HashMap(), string4);
                    } else if (clazz.isArray()) {
                        this.push(new ArrayList(), string4);
                    } else {
                        Class clazz3 = this.getAttributeClass(attributes);
                        if (clazz3 == null) {
                            clazz3 = clazz;
                        }
                        if (clazz != clazz3 && this.m_parent.toStringConverterAvailable(clazz3)) {
                            this.push(clazz3, string4);
                        } else if (!this.m_parent.toStringConverterAvailable(clazz3)) {
                            this.createObjectNoFail(clazz3, string4);
                        }
                    }
                }
            }
        }
    }

    private String getPropertyPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.getStackSize() - 1; i >= 0; --i) {
            Object t = this.getObject(i);
            if (!(t instanceof PropertyInfo)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, "/");
            }
            stringBuilder.insert(0, ((PropertyInfo)t).getPropertyName());
        }
        return stringBuilder.toString();
    }

    void setTypeMappings(Map<String, Class<? extends DBObject>> map) {
        this.initTypeMap(map);
    }

    private void initTypeMap(Map<String, Class<? extends DBObject>> map) {
        if (this.m_types == null) {
            this.m_types = new HashMap<String, Class<? extends DBObject>>();
            if (map != null) {
                this.registerMappings(map);
            }
            this.registerMappings(Metadata.getInstance().getDBObjectClasses());
        }
    }

    private void registerMappings(Map<String, Class<? extends DBObject>> map) {
        for (Map.Entry<String, Class<? extends DBObject>> entry : map.entrySet()) {
            String string = DBObject2XML.convertType(entry.getKey());
            if (this.m_types.containsKey(string)) continue;
            this.m_types.put(string, entry.getValue());
        }
    }

    private Class getObjectClass(String string) throws SAXNotRecognizedException {
        this.initTypeMap(null);
        Class<? extends DBObject> clazz = this.m_types.get(string);
        if (clazz == null) {
            throw new SAXNotRecognizedException("unknown object type " + string);
        }
        return clazz;
    }

    private void createObjectNoFail(Class clazz, String string) {
        try {
            this.createObject(clazz);
        }
        catch (SAXException sAXException) {
            this.logConversionError(sAXException);
            this.push(NULL, string);
        }
    }

    private Object createObject(Class clazz) throws SAXException {
        while (clazz.getAnnotation(Deprecated.class) != null && clazz.getDeclaredMethods().length == 0 && clazz.getDeclaredFields().length == 0) {
            clazz = clazz.getSuperclass();
        }
        try {
            Object t = clazz.newInstance();
            this.push(t, NULL);
            return t;
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception.getCause() instanceof Exception) {
                exception2 = (Exception)exception.getCause();
            }
            throw new SAXException(exception2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = string4 = ModelUtil.hasLength((String)string2) ? string2 : string3;
        if (this.hasChars() && (this.getStackSize() != 0 || !"composite".equals(string2))) {
            this.setCharactersValue();
        }
        this.clearChars();
        Object object = this.pop(string4);
        if (object == NULL) {
            if (this.getCurrentObject() instanceof PropertyInfo) {
                this.pop(string4);
            }
        } else if (!(object instanceof PropertyInfo) && object != "key" && object != "value") {
            if (object instanceof Class) {
                if (this.getCurrentObject() instanceof PropertyInfo) {
                    this.pop(string4);
                }
            } else if (object instanceof Object[]) {
                Map map = (Map)this.getCurrentObject();
                map.put(((Object[])object)[0], ((Object[])object)[1]);
            } else if (this.getStackSize() > 0) {
                Object t = this.getCurrentObject();
                if (t instanceof PropertyInfo) {
                    Object object2;
                    Class clazz;
                    PropertyInfo propertyInfo = (PropertyInfo)this.pop(string4);
                    if (object instanceof List) {
                        clazz = propertyInfo.getPropertyClass();
                        if (clazz.isArray()) {
                            object2 = Array.newInstance(clazz.getComponentType(), ((List)object).size());
                            object2 = ((List)object).toArray((Object[])object2);
                        } else {
                            object2 = object;
                        }
                    } else {
                        object2 = object;
                    }
                    clazz = this.getCurrentObject();
                    if (object2 instanceof Map && clazz instanceof AbstractDBObject && propertyInfo.getPropertyName().equals("properties")) {
                        for (Map.Entry entry : ((Map)object2).entrySet()) {
                            String string6 = (String)entry.getKey();
                            try {
                                if (string6.equals("ID")) continue;
                                ((DBObject)clazz).setProperty(string6, entry.getValue());
                            }
                            catch (Exception exception) {
                                this.logConversionError(exception);
                            }
                        }
                    } else {
                        try {
                            propertyInfo.setPropertyValue(clazz, object2);
                        }
                        catch (Exception exception) {
                            this.logConversionError(exception);
                        }
                    }
                } else if (t instanceof Object[]) {
                    List list;
                    Object e;
                    if (object instanceof List && (e = (list = (List)object).get(0)) instanceof Class) {
                        list.remove(0);
                        object = Array.newInstance(((Class)e).getComponentType(), list.size());
                        object = list.toArray((Object[])object);
                    }
                    ((Object[])t)[1] = object;
                } else if (t instanceof List) {
                    ((List)t).add(object);
                }
            }
        }
        this.checkObject();
    }

    private void setCharactersValue() {
        Object object;
        String string = this.getChars();
        Object t = this.getCurrentObject();
        Class clazz = null;
        if (t instanceof Class && (object = this.getCurrentParent()) instanceof PropertyInfo) {
            clazz = (Class)this.pop("?");
            t = object;
        }
        if (t instanceof PropertyInfo) {
            object = (PropertyInfo)t;
            Class clazz2 = clazz = clazz == null ? object.getPropertyClass() : clazz;
            if (this.m_parent.toStringConverterAvailable(clazz)) {
                try {
                    Object object2;
                    block23: {
                        object2 = null;
                        try {
                            object2 = this.fromString(string, clazz);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (clazz.isEnum()) {
                                Method method = clazz.getMethod("migrate", String.class);
                                if (method == null || !method.getReturnType().equals(clazz)) break block23;
                                try {
                                    object2 = method.invoke((Object)clazz, string);
                                }
                                catch (Exception exception) {
                                    throw illegalArgumentException;
                                }
                            }
                            throw illegalArgumentException;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            if (Number.class.isAssignableFrom(clazz) && object.isNumberUnlimited() && "UNLIMITED".equals(string)) {
                                object2 = object.getNumberUnlimitedValue();
                            }
                            throw unsupportedOperationException;
                        }
                    }
                    object.setPropertyValue(this.getCurrentParent(), object2);
                }
                catch (Exception exception) {
                    this.logConversionError(exception);
                }
            }
        } else if (t == "key") {
            ((Object[])this.getCurrentParent())[0] = string;
        } else if (t instanceof Class) {
            object = this.getCurrentParent();
            try {
                if (object instanceof Object[]) {
                    ((Object[])object)[1] = this.fromString(string, (Class)t);
                } else if (object instanceof List) {
                    String string2 = null;
                    this.push(this.fromString(string, (Class)this.pop(string2)), string2);
                }
            }
            catch (Exception exception) {
                this.logConversionError(exception);
            }
        } else if (t == "value") {
            ((Object[])this.getCurrentParent())[1] = string;
        }
    }

    private Object fromString(String string, Class clazz) {
        Class<?> clazz2 = null;
        if (clazz == Class.class) {
            try {
                clazz2 = this.findClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz2 = null;
            }
        } else {
            clazz2 = ToStringManager.fromString((String)string, (Class)clazz);
        }
        return clazz2;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    private void logConversionError(Exception exception) {
        String string = "Couldn't parse XML element: " + exception.getMessage();
        Logger logger = this.getLogger();
        logger.log(Level.FINE, string, exception);
        logger.warning(string);
    }

    private void checkObject() throws SAXException {
        DBObject dBObject;
        int n = this.m_objs.size();
        if (this.m_idNameOnly && n > 0 && ModelUtil.hasLength((String)(dBObject = this.m_objs.get(n - 1)).getName()) && dBObject.getID() != null) {
            throw new PartialParseCompleteException();
        }
    }
}

