/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.util.ModelUtil;

class DatabaseLinkBuilder
extends OracleDBObjectBuilder<DatabaseLink> {
    DatabaseLinkBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "DATABASE LINK");
    }

    public DatabaseLink createObject(String string, Schema schema, DBObjectID dBObjectID) {
        DatabaseLink databaseLink = (DatabaseLink)super.createObject(string, schema, dBObjectID);
        databaseLink.setPublic(this.getDatabase().isPublicSchema(schema));
        return databaseLink;
    }

    protected void fillInObject(DatabaseLink databaseLink) throws DBException {
        QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)databaseLink, this.getQuery(), databaseLink, databaseLink.getSchema());
        try {
            this.fillInObjectImpl(queryWrapper, databaseLink);
        }
        catch (DBException dBException) {
            if (dBException.getMessage().contains("ORA-31603")) {
                DBLog.getLogger((Object)((Object)this)).warning("Querying some database link properties with dbms_metadata failed permission check");
                QueryWrapper queryWrapper2 = this.getDatabase().newQueryWrapper((SystemObject)databaseLink, this.getBackupQuery(), databaseLink, databaseLink.getSchema());
                this.fillInObjectImpl(queryWrapper2, databaseLink);
            }
            throw dBException;
        }
    }

    private void fillInObjectImpl(final QueryWrapper queryWrapper, final DatabaseLink databaseLink) throws DBException {
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if ("CURRENT_USER".equals(string)) {
                            databaseLink.setConnectToUser(Boolean.valueOf(true));
                        } else if (ModelUtil.hasLength((String)string)) {
                            databaseLink.setConnectToUser(Boolean.valueOf(false));
                            databaseLink.setUsername(string);
                            databaseLink.setPasswordX(null);
                            databaseLink.setPasswordX(resultSet.getString(5));
                        }
                        String string2 = resultSet.getString(2);
                        databaseLink.setHost(string2);
                        String string3 = resultSet.getString(3);
                        databaseLink.setCreated(string3);
                        String string4 = resultSet.getString(4);
                        if (string4 != null) {
                            databaseLink.setShared(true);
                            databaseLink.setAuthentificationUsername(string4);
                            databaseLink.setAuthentificationPassword(null);
                            databaseLink.setAuthentificationPasswordX(resultSet.getString(6));
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)databaseLink, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        databaseLink.setPublic("PUBLIC".equals(databaseLink.getSchema().getName()));
    }

    private String getQuery() {
        if (this.getDatabase() instanceof Oracle10g) {
            return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHUSR>.*AUTHUSR>',1,1,'n'),'<\\/*AUTHUSR>',null) AUTHUSR,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<PASSWORDX>.*PASSWORDX>',1,1,'n'),'<\\/*PASSWORDX>',null) PASSWORDX,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHPWDX>.*AUTHPWDX>',1,1,'n'),'<\\/*AUTHPWDX>',null) AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
        }
        return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       NULL AUTHUSR,\n       NULL PASSWORDX,\n       NULL AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    }

    private String getBackupQuery() {
        return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_BACKUP_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       null AUTHUSR,\n       null PASSWORDX,\n       null AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    }
}

