/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.MultitenantContainerInfo;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.resource.APIBundle;

public class Oracle12c
extends Oracle11gR2 {
    private MultitenantContainerInfo m_containerInfo;

    Oracle12c(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, n);
    }

    @Override
    public MultitenantContainerInfo getMultitenantContainerInfo() {
        if (this.m_containerInfo == null) {
            QueryWrapper queryWrapper = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.CONTAINER_QUERY*/ SYS_CONTEXT('USERENV','CON_ID') id,SYS_CONTEXT('USERENV','CON_NAME') name FROM SYS.DUAL", new Object[0]);
            try {
                queryWrapper.executeQuery(resultSet -> this.processContainerResultSet(resultSet));
            }
            catch (DBException dBException) {
                this.getLogger().warning(APIBundle.format((String)"MT_CONTAINER_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
            }
        }
        return this.m_containerInfo;
    }

    private void processContainerResultSet(ResultSet resultSet) throws DBException, SQLException {
        if (resultSet.next()) {
            this.m_containerInfo = new MultitenantContainerInfo(resultSet.getInt(1), resultSet.getString(2));
        }
    }

    @Override
    public boolean supportsDatabaseChangeNotification() {
        MultitenantContainerInfo multitenantContainerInfo;
        boolean bl = super.supportsDatabaseChangeNotification();
        if (bl && (multitenantContainerInfo = this.getMultitenantContainerInfo()) != null) {
            bl = !multitenantContainerInfo.isPluggableDatabase();
        }
        return bl;
    }
}

