/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle11gR2XE;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.ora.lite.OracleDatabaseLiteDescriptor;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleDatabaseFactory
extends BaseDatabaseCreator {
    private static boolean s_autocommit = true;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";
    private static final DatabaseRegistry.DatabaseVersion[] s_versions;
    private static final DatabaseRegistry.DatabaseVersion[] s_liteVersions;

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database database) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = database instanceof OracleDatabaseLite ? new OracleDatabaseLiteDescriptor(database.getDatabaseVersion()) : (database instanceof OracleDatabase ? new OracleDatabaseDescriptor(database.getDatabaseVersion()) : null);
        return oracleDatabaseDescriptor;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(String string, int n) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = "Oracle Lite".equals(string) ? new OracleDatabaseLiteDescriptor(n) : ("Oracle Database".equals(string) ? new OracleDatabaseDescriptor(n) : null);
        return oracleDatabaseDescriptor;
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        OracleDatabaseDescriptor oracleDatabaseDescriptor = null;
        if (OracleDatabaseLite.class.isAssignableFrom(clazz)) {
            oracleDatabaseDescriptor = new OracleDatabaseLiteDescriptor(clazz);
        } else if (OracleDatabase.class.isAssignableFrom(clazz)) {
            oracleDatabaseDescriptor = new OracleDatabaseDescriptor(clazz);
        }
        return oracleDatabaseDescriptor;
    }

    public Database createDatabaseImpl(String string, String string2, Connection connection) {
        BaseOracleDatabase baseOracleDatabase = null;
        Tuple<String, Integer> tuple = OracleDatabaseFactory.getType(connection);
        if (tuple != null) {
            Integer n = (Integer)tuple.getSecond();
            if ("Oracle Lite".equals(tuple.getFirst())) {
                switch (n) {
                    case 101: {
                        baseOracleDatabase = new OracleLite(string, string2, connection, n);
                        break;
                    }
                    case 103: {
                        baseOracleDatabase = new OracleLite10gR3(string, string2, connection, n);
                    }
                }
            } else {
                switch (n) {
                    case 81: {
                        baseOracleDatabase = new Oracle8(string, string2, connection, n);
                        break;
                    }
                    case 82: {
                        baseOracleDatabase = new Oracle8i(string, string2, connection, n);
                        break;
                    }
                    case 91: {
                        baseOracleDatabase = new Oracle9i(string, string2, connection, n);
                        break;
                    }
                    case 92: {
                        baseOracleDatabase = new Oracle9iR2(string, string2, connection, n);
                        break;
                    }
                    case 100: {
                        baseOracleDatabase = new Oracle10g(string, string2, connection, n);
                        break;
                    }
                    case 102: {
                        baseOracleDatabase = new Oracle10gR2(string, string2, connection, n);
                        break;
                    }
                    case 101: {
                        baseOracleDatabase = new Oracle10gR2XE(string, string2, connection, n);
                        break;
                    }
                    case 110: {
                        baseOracleDatabase = new Oracle11g(string, string2, connection, n);
                        break;
                    }
                    case 112: {
                        baseOracleDatabase = new Oracle11gR2(string, string2, connection, n);
                        break;
                    }
                    case 111: {
                        baseOracleDatabase = new Oracle11gR2XE(string, string2, connection, n);
                        break;
                    }
                    case 120: 
                    case 12102: {
                        baseOracleDatabase = new Oracle12c(string, string2, connection, n);
                    }
                }
            }
        }
        if (baseOracleDatabase != null) {
            this.initDB((Database)baseOracleDatabase);
        }
        return baseOracleDatabase;
    }

    private void initDB(Database database) {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(database, APIBundle.get((String)"SET_AUTOCOMMIT"));
        try {
            connectionWrapper.run(new ConnectionWrapper.SQLRunnable(connectionWrapper){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(s_autocommit);
                }
            });
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)((Object)this)).warning(dBException.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean bl) {
        s_autocommit = bl;
    }

    public static boolean isDefaultAutocommit() {
        return s_autocommit;
    }

    public static boolean isOracleDatabase(Connection connection) {
        return OracleDatabaseFactory.getType(connection) != null;
    }

    private static boolean isExpressEdition(String string) {
        return string.indexOf("Express Edition") >= 0;
    }

    private static Tuple<String, Integer> getType(Connection connection) {
        Tuple tuple = null;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (ModelUtil.hasLength((String)string)) {
                    if (string.startsWith("Oracle Lite") || string.startsWith("Oracle9i Lite")) {
                        String string2 = databaseMetaData.getDatabaseProductVersion();
                        int[] nArray = OracleDatabaseFactory.getOracleMajorMinorVersion(string2);
                        int n = 101;
                        if (nArray != null && nArray.length > 1 && (nArray[0] > 10 || nArray[0] == 10 && nArray[1] >= 3)) {
                            n = 103;
                        }
                        tuple = new Tuple((Object)"Oracle Lite", (Object)n);
                    } else if (string.startsWith("Personal Oracle") || string.startsWith("Oracle") && !string.startsWith("Oracle Rdb") && !string.startsWith("Oracle Business Intelligence")) {
                        int n = 0;
                        String string3 = databaseMetaData.getDatabaseProductVersion();
                        int[] nArray = OracleDatabaseFactory.getOracleMajorMinorVersion(string3);
                        if (nArray != null && nArray.length >= 2) {
                            int n2 = nArray[0];
                            int n3 = nArray[1];
                            if (n2 < 8) {
                                n = 0;
                            } else if (n2 == 8) {
                                n = n3 >= 1 ? 82 : 81;
                            } else if (n2 == 9) {
                                n = n3 >= 2 ? 92 : 91;
                            } else if (n2 == 10) {
                                n = n3 < 2 ? 100 : (OracleDatabaseFactory.isExpressEdition(string3) ? 101 : 102);
                            } else if (n2 == 11) {
                                n = n3 < 2 ? 110 : (OracleDatabaseFactory.isExpressEdition(string3) ? 111 : 112);
                            } else if (n2 == 12) {
                                n = 120;
                                if (n3 > 1 || nArray.length >= 3 && nArray[2] > 0 || nArray.length >= 4 && nArray[3] > 1) {
                                    n = 12102;
                                }
                            } else {
                                n = 12102;
                            }
                        }
                        tuple = new Tuple((Object)"Oracle Database", (Object)n);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return tuple;
    }

    public static int[] getOracleMajorMinorVersion(String string) {
        int[] nArray = null;
        if (ModelUtil.hasLength((String)string)) {
            String string2;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(string);
            String string3 = string2 = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)string2)) {
                String[] stringArray = string2.split("\\.");
                nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        nArray[i] = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = null;
                        break;
                    }
                }
            }
        }
        return nArray;
    }

    public static void registerOracleDatabases() {
        DatabaseRegistry databaseRegistry = DatabaseRegistry.getInstance();
        databaseRegistry.registerDatabases("Oracle Lite", OracleDatabaseFactory.class.getName(), null, null, s_liteVersions);
        databaseRegistry.registerDatabases("Oracle Database", OracleDatabaseFactory.class.getName(), null, null, s_versions);
        Metadata metadata = Metadata.getInstance();
        metadata.registerBooleanProperty("OBJECT TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerBooleanProperty("NESTED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerBooleanProperty("PARTITIONED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        metadata.registerProperty("USER_PRIVS", String[].class, OracleDatabase.class, new Class[]{Schema.class});
        metadata.registerProperty("USER_ROLES", String[].class, OracleDatabase.class, new Class[]{Schema.class});
        ColumnSequenceProcessor.registerProcessorProperties(OracleDatabaseImpl.class);
    }

    static Class<? extends OracleDatabase> getDatabaseClass(int n) {
        Class<?> clazz = null;
        for (DatabaseRegistry.DatabaseVersion databaseVersion : s_versions) {
            if (n != databaseVersion.getVersion()) continue;
            try {
                ClassLoader classLoader = OracleDatabaseFactory.class.getClassLoader();
                clazz = classLoader.loadClass(databaseVersion.getDatabaseClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                DBLog.getLogger(OracleDatabaseFactory.class).severe(classNotFoundException.getMessage());
            }
            break;
        }
        return clazz;
    }

    static int getDatabaseVersion(Class<? extends OracleDatabase> clazz) {
        DatabaseRegistry.DatabaseVersion[] databaseVersionArray;
        int n = 0;
        for (DatabaseRegistry.DatabaseVersion databaseVersion : databaseVersionArray = OracleDatabaseLite.class.isAssignableFrom(clazz) ? s_liteVersions : s_versions) {
            if (!clazz.getName().equals(databaseVersion.getDatabaseClassName())) continue;
            n = databaseVersion.getVersion();
            break;
        }
        return n;
    }

    static {
        s_liteVersions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_LITE_10gR1"), "oracle.javatools.db.ora.OracleLite", true), new DatabaseRegistry.DatabaseVersion(103, APIBundle.get((String)"DB_ORACLE_LITE_10gR3"), "oracle.javatools.db.ora.OracleLite10gR3", true)};
        s_versions = new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(0, null, "oracle.javatools.db.ora.OracleDatabaseImpl"), new DatabaseRegistry.DatabaseVersion(81, null, "oracle.javatools.db.ora.Oracle8"), new DatabaseRegistry.DatabaseVersion(82, APIBundle.get((String)"DB_ORACLE_8i"), "oracle.javatools.db.ora.Oracle8i", true), new DatabaseRegistry.DatabaseVersion(91, null, "oracle.javatools.db.ora.Oracle9i"), new DatabaseRegistry.DatabaseVersion(92, APIBundle.get((String)"DB_ORACLE_9i2"), "oracle.javatools.db.ora.Oracle9iR2"), new DatabaseRegistry.DatabaseVersion(100, APIBundle.get((String)"DB_ORACLE_10g"), "oracle.javatools.db.ora.Oracle10g"), new DatabaseRegistry.DatabaseVersion(102, APIBundle.get((String)"DB_ORACLE_10gR2"), "oracle.javatools.db.ora.Oracle10gR2"), new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_10gR2XE"), "oracle.javatools.db.ora.Oracle10gR2XE"), new DatabaseRegistry.DatabaseVersion(110, APIBundle.get((String)"DB_ORACLE_11g"), "oracle.javatools.db.ora.Oracle11g"), new DatabaseRegistry.DatabaseVersion(112, APIBundle.get((String)"DB_ORACLE_11gR2"), "oracle.javatools.db.ora.Oracle11gR2"), new DatabaseRegistry.DatabaseVersion(111, APIBundle.get((String)"DB_ORACLE_11gR2XE"), "oracle.javatools.db.ora.Oracle11gR2XE"), new DatabaseRegistry.DatabaseVersion(120, APIBundle.get((String)"DB_ORACLE_12c"), "oracle.javatools.db.ora.Oracle12c"), new DatabaseRegistry.DatabaseVersion(12102, APIBundle.get((String)"DB_ORACLE_12cR102"), "oracle.javatools.db.ora.Oracle12c")};
    }
}

