/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.NumericDataType;

public class OracleNumberDataType
extends NumericDataType {
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", NumericDataType.MinMaxValue.FLOAT);

    public OracleNumberDataType() {
        this(65535);
    }

    public OracleNumberDataType(int n) {
        super(n, "NUMBER", "NUMBER[(<precision>[, <scale>])]", new DataTypeAttribute[]{new DataTypeAttribute("precision", "DATATYPE_ATTRIBUTE_LABEL_PRECISION", null, null, true, false), new DataTypeAttribute("scale", "DATATYPE_ATTRIBUTE_LABEL_SCALE", -84L, Long.valueOf(127L), Long.valueOf(0L), false)}, MIN_MAX_FLOAT);
        this.setSQLType(2);
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        String string = this.getName();
        String string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
        Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
        if (string2 != null) {
            string = string + '(' + string2 + (l == null ? "" : ", " + l) + ')';
        } else if (l != null) {
            string = string + "(*, " + l + ')';
        }
        return string;
    }
}

