/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleDDLSupport {
    private static final String BASE = "/oracle/javatools/db/ora/ddl/";
    private static final String ORACLE_DDL_COMMON = "/oracle/javatools/db/ora/ddl/OracleCommonDDL.properties";
    private static final String ORACLE_DDL_BASE = "/oracle/javatools/db/ora/ddl/OracleBaseDDL.properties";
    private static final String ORACLE_LITE_DDL = "/oracle/javatools/db/ora/ddl/OracleLiteDDL.properties";
    private static final String ORACLE_10g_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gDDL.properties";
    private static final String ORACLE_10gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2DDL.properties";
    private static final String ORACLE_10gR2XE_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2XEDDL.properties";
    private static final String ORACLE_9iR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle9iDDL.properties";
    private static final String ORACLE_11g_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gDDL.properties";
    private static final String ORACLE_11gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gR2DDL.properties";
    private static final String ORACLE_12c_DDL = "/oracle/javatools/db/ora/ddl/Oracle12cDDL.properties";
    private static final String ORACLE_12cR102_DDL = "/oracle/javatools/db/ora/ddl/Oracle12cR102DDL.properties";
    private String m_simpleDrop;
    private final Map<String, TokenGenerator> m_globals = new TreeMap<String, TokenGenerator>();

    private OracleDDLSupport() {
        this.m_globals.put("islobcol", new IsLOBColumnGenerator());
        this.m_globals.put("fkInRefPartition", new IsFKInRefPartition());
        this.m_globals.put("varraydef", new VarrayDefinitionGenerator());
        this.m_globals.put("lobdef", new LOBDefinitionGenerator());
        this.m_globals.put("lobcoldef", new PartitionLOBGenerator());
        this.m_globals.put("alterlobcoldef", new PartitionAlterLOBGenerator());
        this.m_globals.put("altermovelobcoldef", new PartitionAlterMoveLOBGenerator());
        this.m_globals.put("hastablespaces", new HasTablespacesGenerator());
        this.m_globals.put("hasPartitions", new HasPartitionsGenerator());
        this.m_globals.put("needOSPAlter", new NeedOSPAlterTokenGenerator());
        this.m_globals.put("needOSPMove", new NeedOSPMoveTokenGenerator());
        this.m_globals.put("needIPMod", new NeedIndexPartitionModTokenGenerator());
        this.m_globals.put("refreshDateExpressions", new RefreshDateExpressionsGenerator());
        this.m_globals.put("changedValues", new PartitionValuesChangedTokenGenerator());
        this.m_globals.put("handleWiths", new MatViewLogWithsGenerator());
        this.m_globals.put("handleAddWiths", new MatViewLogAddWithsGenerator());
        this.m_globals.put("handleTrgEvents", new TriggerEventsListGenerator());
        this.m_globals.put("handleTrgBaseObject", new TriggerBaseObjectGenerator());
        this.m_globals.put("getSyntaxFromSource", new SyntaxFromSourceGenerator());
        this.m_globals.put("codeExists", new CodeExistsTokenGenerator());
        this.m_globals.put("refOldAsExists", new TrgOldAsExistsTokenGenerator());
        this.m_globals.put("refNewAsExists", new TrgNewAsExistsTokenGenerator());
        this.m_globals.put("hostExists", new DBLinkHostExistsTokenGenerator());
        this.m_globals.put("schemaText", new XMLSchemaTextTokenGenerator());
        this.m_globals.put("needsRebuildIndexes", new NeedsRebuildIndexesModTokenGenerator());
        this.m_globals.put("needDropAndRecreateConstraint", new DropAndRecreateConTokenGenerator());
        this.m_globals.put("filePath", new FileSpecPathGenerator());
        this.m_globals.put("originalFilePath", new OldFileSpecPathGenerator());
        this.m_globals.put("PlSqlReference", new PlSqlReferenceGenerator());
        this.m_globals.put("renameNewIPIfChanged", new RenameNewIPIfChangedTokenGenerator());
        this.m_globals.put("addStorageToNewIP", new AddStorageToNewIPTokenGenerator());
        this.m_globals.put("needsTbspAlterForNewIP", new NeedsTbspAlterForNewIPTokenGenerator());
        this.m_globals.put("usingIndexName", new ConstraintIndexGenerator("usingIndexName"));
        this.m_globals.put("usingIndexInline", new ConstraintIndexGenerator("usingIndexInline"));
        this.m_globals.put("inConstraintDefintion", new ConstraintIndexGenerator("inConstraintDefintion"));
        this.m_globals.put("pkInCreateTable", new ConstraintIndexGenerator("pkInCreateTable"));
        this.m_globals.put("indexForConstraint", new ConstraintIndexGenerator("indexForConstraint"));
        this.m_globals.put("needToCreateOracleLiteIndex", new OracleLiteUniqueKeyIndexTokenGenerator());
        this.m_globals.put("mvConstraintsNeedsUsing", new MVConstraintsNeedsUsingTokenGenerator());
        this.m_globals.put("password", new PasswordGenerator("password"));
        this.m_globals.put("authentificationPassword", new PasswordGenerator("authentificationPassword"));
        this.m_globals.put("viewColumnsIfNeeded", new ViewColumnGenerator());
        this.m_globals.put("allAlterStatements", new AllAlterStatementsGenerator());
        this.m_globals.put("alterStatementDetail", new AlterStatementDetailGenerator());
    }

    String[] getBundles(Class<? extends OracleDatabase> clazz, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ORACLE_DDL_COMMON);
        if (OracleLite.class.isAssignableFrom(clazz)) {
            arrayList.add(ORACLE_LITE_DDL);
        } else {
            arrayList.add(ORACLE_DDL_BASE);
            if (n >= 92) {
                arrayList.add(ORACLE_9iR2_DDL);
                if (n >= 100) {
                    arrayList.add(ORACLE_10g_DDL);
                    if (n >= 102) {
                        arrayList.add(ORACLE_10gR2_DDL);
                        if (n >= 110) {
                            arrayList.add(ORACLE_11g_DDL);
                            if (n >= 112) {
                                arrayList.add(ORACLE_11gR2_DDL);
                                if (n >= 120) {
                                    arrayList.add(ORACLE_12c_DDL);
                                    if (n >= 12102) {
                                        arrayList.add(ORACLE_12cR102_DDL);
                                    }
                                }
                            }
                        }
                    }
                    if (n == 101 || n == 111) {
                        arrayList.add(ORACLE_10gR2XE_DDL);
                    }
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void includeOracleSyntax(TokenDDLGenerator tokenDDLGenerator, String string, boolean bl) {
        DatabaseDescriptor databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(Oracle11g.class);
        tokenDDLGenerator.includeSyntax(databaseDescriptor, string, bl);
    }

    public String getSimpleDropDDL() {
        if (this.m_simpleDrop == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(ORACLE_DDL_COMMON);
                Properties properties = new Properties();
                properties.load(inputStream);
                this.m_simpleDrop = properties.getProperty("SIMPLE_DROP");
            }
            catch (IOException iOException) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Couldn't open ddl properties: " + iOException.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.m_simpleDrop;
    }

    public Map<String, TokenGenerator> getGlobalTokenGenerators() {
        return Collections.unmodifiableMap(this.m_globals);
    }

    public static OracleDDLSupport getInstance() {
        DBCore dBCore = DBCore.getInstance();
        OracleDDLSupport oracleDDLSupport = (OracleDDLSupport)dBCore.get(OracleDDLSupport.class);
        if (oracleDDLSupport == null) {
            oracleDDLSupport = new OracleDDLSupport();
            dBCore.put((Object)oracleDDLSupport);
        }
        return oracleDDLSupport;
    }

    public static class PropertyFilter
    implements DifferenceFilter {
        HashSet<String> m_propsToFilter = new HashSet();

        public void addFilterProp(String string) {
            this.m_propsToFilter.add(string);
        }

        public boolean isFilteredProperty(Difference difference, String string) {
            if (string.indexOf("/") != -1) {
                string = string.substring(string.indexOf("/") + 1);
            }
            return this.m_propsToFilter.contains(string);
        }
    }

    private static class AlterStatementDetailGenerator
    extends TokenGenerator {
        public static final String TOKEN = "alterStatementDetail";

        private AlterStatementDetailGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            Object object = tokenContext.getObject();
            if (object instanceof Tuple) {
                PlSqlSearch plSqlSearch;
                Object object2 = ((Tuple)object).getFirst();
                Object object3 = ((Tuple)object).getSecond();
                if (object2 instanceof PlSqlToken && object3 instanceof PlSqlToken && (plSqlSearch = new PlSqlSearch("alter type ?. <stmt {?}...>")).matches((PlSqlToken)object2, (PlSqlToken)object3)) {
                    tokenContext.append((Object)plSqlSearch.getNamedMatch("stmt"));
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }
    }

    private static class AllAlterStatementsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "allAlterStatements";

        private AllAlterStatementsGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            Tuple[] tupleArray = null;
            if (tokenContext.getObject() instanceof Type) {
                List list = null;
                try {
                    PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)tokenContext.getObject()), (DBObjectProvider)tokenContext.getProvider());
                    if (plSqlParser != null) {
                        list = plSqlParser.getAlterStatements();
                    }
                }
                catch (CancelledException cancelledException) {
                    list = null;
                    DBLog.getLogger((Object)((Object)this)).fine(cancelledException.getMessage());
                }
                if (list != null && !list.isEmpty()) {
                    tupleArray = list.toArray(new Tuple[list.size()]);
                }
            }
            return tupleArray;
        }
    }

    private static class ViewColumnGenerator
    extends TokenGenerator {
        public static final String TOKEN = "viewColumnsIfNeeded";

        private ViewColumnGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            DBObjectProvider dBObjectProvider = tokenContext.getProvider();
            Object object = tokenContext.getObject();
            if (dBObjectProvider != null && object instanceof SQLQueryOwner && object instanceof Relation) {
                List list;
                Constraint[] constraintArray;
                SQLQueryBuilder sQLQueryBuilder;
                Relation relation = (Relation)object;
                SQLQuery sQLQuery = ((SQLQueryOwner)relation).getSQLQuery();
                if (sQLQuery != null && (sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)dBObjectProvider)) instanceof AbstractSQLQueryBuilder) {
                    constraintArray = (Constraint[])sQLQueryBuilder;
                    try {
                        list = constraintArray.getQueryColumnInfos();
                        boolean bl = false;
                        for (AbstractSQLQueryBuilder.QueryColumnInfo queryColumnInfo : list) {
                            if (queryColumnInfo.getName() != null || "*".equals(queryColumnInfo.getExpression())) continue;
                            bl = true;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        if (bl) {
                            int n = 0;
                            for (Column column : relation.getColumns()) {
                                if (n == 0) {
                                    stringBuilder.append("( ");
                                } else {
                                    stringBuilder.append("\n, ");
                                }
                                ++n;
                                String string = column.getName();
                                if (string == null) {
                                    bl = false;
                                    break;
                                }
                                stringBuilder.append(string);
                            }
                            if (n > 0) {
                                stringBuilder.append("\n)\n");
                            }
                        }
                        if (bl) {
                            tokenContext.append((Object)stringBuilder.toString());
                        }
                    }
                    catch (SQLQueryException sQLQueryException) {
                        // empty catch block
                    }
                }
                if (relation.getID() instanceof TemporaryObjectID && (sQLQueryBuilder = (Relation)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)relation.getID()))) instanceof SQLQueryOwner && (constraintArray = sQLQueryBuilder.getConstraints()) != null && constraintArray.length > 0) {
                    list = ((SQLQueryOwner)sQLQueryBuilder).getSQLQuery();
                    if (ModelUtil.areDifferent((Object)sQLQuery.getSQLText(), (Object)list.getSQLText())) {
                        relation.getColumns();
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("columns");
        }
    }

    private static class OracleLiteUniqueKeyIndexTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "needToCreateOracleLiteIndex";

        private OracleLiteUniqueKeyIndexTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            Difference difference;
            Table table;
            Index index;
            DBObjectProvider dBObjectProvider = tokenContext.getProvider();
            if (!"Oracle Lite".equals(dBObjectProvider.getDescriptor().getDatabaseType())) {
                throw new IllegalStateException("Token needToCreateOracleLiteIndex referenced in a non-Oracle Lite context.");
            }
            UniqueConstraint uniqueConstraint = null;
            boolean bl = true;
            if (tokenContext.getObject() instanceof Index) {
                index = (Index)tokenContext.getObject();
                table = index.getTable();
                if (table != null && (difference = (Constraint)DBUtil.findChildByName((DBObject)table, (String)"constraints", (String)index.getName(), (DBObjectProvider)dBObjectProvider)) instanceof UniqueConstraint) {
                    uniqueConstraint = (UniqueConstraint)difference;
                }
            } else {
                index = null;
                bl = false;
            }
            if (index != null) {
                table = tokenContext.findUpdateDifference((DBObject)index);
                difference = tokenContext.findUpdateDifference(uniqueConstraint);
                if (table != null && difference == null) {
                    uniqueConstraint = null;
                }
                if (ConstraintIndexHelper.isSystemGenerated(index) || ConstraintIndexHelper.indexDefaultForConstraint(index, uniqueConstraint, dBObjectProvider)) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    private static class ConstraintIndexGenerator
    extends TokenGenerator {
        public static final String TOKEN1 = "usingIndexName";
        public static final String TOKEN2 = "usingIndexInline";
        public static final String TOKEN3 = "inConstraintDefintion";
        public static final String TOKEN4 = "pkInCreateTable";
        public static final String TOKEN5 = "indexForConstraint";
        final String m_mode;

        public ConstraintIndexGenerator(String string) {
            this.m_mode = string;
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            DBObjectID dBObjectID;
            Table table;
            Index index;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            if (TOKEN1.equals(this.m_mode)) {
                bl5 = false;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = true;
            } else if (TOKEN2.equals(this.m_mode)) {
                bl5 = false;
                bl4 = false;
                bl3 = true;
                bl2 = false;
                bl = false;
            } else if (TOKEN3.equals(this.m_mode)) {
                bl5 = true;
                bl4 = true;
                bl3 = true;
                bl2 = false;
                bl = false;
            } else if (TOKEN4.equals(this.m_mode)) {
                bl5 = true;
                bl4 = true;
                bl3 = true;
                bl2 = true;
                bl = false;
            } else if (TOKEN5.equals(this.m_mode)) {
                bl5 = false;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
            } else {
                throw new IllegalStateException("Unknown mode " + this.m_mode);
            }
            UniqueConstraint uniqueConstraint = null;
            if (tokenContext.getObject() instanceof Index) {
                index = (Index)tokenContext.getObject();
                table = index.getTable();
                if (table != null) {
                    for (DBObjectID dBObjectID2 : table.getConstraints()) {
                        if (!(dBObjectID2 instanceof UniqueConstraint)) continue;
                        UniqueConstraint uniqueConstraint2 = (UniqueConstraint)dBObjectID2;
                        DBObjectID dBObjectID3 = uniqueConstraint2.getIndexID();
                        if (index.getID() == null || !index.getID().equals(dBObjectID3)) continue;
                        uniqueConstraint = uniqueConstraint2;
                        break;
                    }
                }
            } else if (tokenContext.getObject() instanceof UniqueConstraint) {
                Table table2;
                DBObject dBObject;
                table = null;
                uniqueConstraint = (UniqueConstraint)tokenContext.getObject();
                dBObjectID = uniqueConstraint.getIndexID();
                if (dBObjectID != null && uniqueConstraint.getParent() instanceof Table && (dBObject = (table2 = (Table)uniqueConstraint.getParent()).findOwnedObject(dBObjectID)) instanceof Index) {
                    table = (Index)dBObject;
                }
                index = table;
            } else {
                return false;
            }
            table = tokenContext.findUpdateDifference((DBObject)index);
            dBObjectID = tokenContext.findUpdateDifference((DBObject)uniqueConstraint);
            if (table != null && dBObjectID == null) {
                uniqueConstraint = null;
            }
            if (TOKEN5.equals(this.m_mode)) {
                return uniqueConstraint != null && index != null && index.getIndexType() == Index.IndexType.UNIQUE && ConstraintIndexHelper.isSystemGenerated(index);
            }
            if (!bl2 || uniqueConstraint.getClass() == PKConstraint.class) {
                if (index == null) {
                    return bl5;
                }
                if (uniqueConstraint != null) {
                    Table table3 = index.getTable();
                    if (uniqueConstraint.getClass() == PKConstraint.class && table3.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
                        return bl4;
                    }
                    if (ConstraintIndexHelper.indexDefaultForConstraint(index, uniqueConstraint, tokenContext.getProvider())) {
                        return bl4;
                    }
                    if (ConstraintIndexHelper.isSystemGenerated(index)) {
                        return bl3;
                    }
                }
            }
            return bl;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("indexID");
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return this.createPropertyMap(Collections.singleton("indexID"), null, null);
        }
    }

    private static final class IsFKInRefPartition
    extends TokenGenerator {
        public static final String TOKEN = "fkInRefPartition";

        private IsFKInRefPartition() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            boolean bl = false;
            Object object = tokenContext.getObject();
            if (object instanceof FKConstraint) {
                FKConstraint fKConstraint = (FKConstraint)object;
                Relation relation = fKConstraint.getRelation();
                OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)relation.getProperty("OracleTablePartitions");
                DBObjectID dBObjectID = null;
                if (oracleTablePartitions != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && (dBObjectID = oracleTablePartitions.getReferenceConstraintID()) != null && dBObjectID.equals(fKConstraint.getID())) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static class PlSqlReferenceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "PlSqlReference";

        private PlSqlReferenceGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof PlSqlReference) {
                PlSqlReference plSqlReference = (PlSqlReference)tokenContext.getObject();
                DBObjectProvider dBObjectProvider = tokenContext.getProvider();
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)plSqlReference, (DBObjectProvider)dBObjectProvider);
                }
                catch (DBException dBException) {
                    DBLog.getLogger(OracleDDLSupport.class).warning("Failed to build derived props: " + dBException.getMessage());
                }
                Schema schema = null;
                for (PlSqlReference plSqlReference2 = plSqlReference; plSqlReference2 != null; plSqlReference2 = plSqlReference2.getParent()) {
                    if (!(plSqlReference2 instanceof SchemaObject)) continue;
                    schema = ((SchemaObject)plSqlReference2).getSchema();
                    break;
                }
                tokenContext.append((Object)DataTypeHelper.getTypeStringFromRef((PlSqlReference)plSqlReference, schema, (DBObjectProvider)dBObjectProvider));
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }
    }

    private static class OldFileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "originalFilePath";

        private OldFileSpecPathGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof FileSpecification) {
                Difference difference = tokenContext.getDifference();
                FileSpecification fileSpecification = (FileSpecification)difference.getOriginalObject();
                String string = "/";
                if (fileSpecification.getDirectory() != null && fileSpecification.getDirectory().indexOf("\\") != -1) {
                    string = "\\";
                }
                if (fileSpecification.getDirectory() != null) {
                    tokenContext.append((Object)(fileSpecification.getDirectory() + string));
                }
                tokenContext.append((Object)fileSpecification.getName());
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("name", "directory");
        }
    }

    private static class FileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "filePath";

        private FileSpecPathGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof FileSpecification) {
                FileSpecification fileSpecification = (FileSpecification)tokenContext.getObject();
                String string = "/";
                if (fileSpecification.getDirectory() != null && fileSpecification.getDirectory().indexOf("\\") != -1) {
                    string = "\\";
                }
                if (ModelUtil.hasLength((String)fileSpecification.getDirectory())) {
                    tokenContext.append((Object)(fileSpecification.getDirectory() + string));
                }
                tokenContext.append((Object)fileSpecification.getName());
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("name", "directory");
        }
    }

    private static final class XMLSchemaTextTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schemaText";

        private XMLSchemaTextTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            XMLSchema xMLSchema;
            if (tokenContext.getObject() instanceof XMLSchema && (xMLSchema = (XMLSchema)tokenContext.getObject()).getSource() != null && xMLSchema.getSource().length() > 0) {
                tokenContext.append((Object)xMLSchema.getSource().replaceAll("'", "''"));
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("source");
        }
    }

    private static final class NeedsTbspAlterForNewIPTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "needsTbspAlterForNewIP";

        private NeedsTbspAlterForNewIPTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            boolean bl = false;
            if (tokenContext.getObject() instanceof IndexPartition) {
                IndexPartition indexPartition = (IndexPartition)tokenContext.getObject();
                OracleStorageProperties oracleStorageProperties = indexPartition.getSegmentAttributes();
                bl = oracleStorageProperties != null && oracleStorageProperties.getTablespaceID() != null;
            }
            return bl;
        }
    }

    private static final class AddStorageToNewIPTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "addStorageToNewIP";

        private AddStorageToNewIPTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            IndexPartition indexPartition;
            String string;
            if (tokenContext.getObject() instanceof IndexPartition && ModelUtil.hasLength((String)(string = this.buildAlterStatement(indexPartition = (IndexPartition)tokenContext.getObject())))) {
                tokenContext.append((Object)string);
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            boolean bl = false;
            if (tokenContext.getObject() instanceof IndexPartition) {
                IndexPartition indexPartition = (IndexPartition)tokenContext.getObject();
                String string = this.buildAlterStatement(indexPartition);
                bl = ModelUtil.hasLength((String)string);
            }
            return bl;
        }

        private void addAlter(StringBuffer stringBuffer, String string, Object object, Object object2, boolean bl) {
            if (object != object2) {
                if (bl) {
                    if (stringBuffer.indexOf("STORAGE") == -1) {
                        stringBuffer.append("\nSTORAGE\n(");
                    }
                    stringBuffer.append("\n  ");
                } else {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(object);
            }
        }

        private String buildAlterStatement(IndexPartition indexPartition) {
            OracleStorageProperties oracleStorageProperties = indexPartition.getSegmentAttributes();
            Boolean bl = indexPartition.getUseKeyCompression();
            StringBuffer stringBuffer = new StringBuffer();
            if (oracleStorageProperties != null) {
                this.addAlter(stringBuffer, "INITRANS", oracleStorageProperties.getInitrans(), null, false);
                this.addAlter(stringBuffer, "PCTUSED", oracleStorageProperties.getPercentUsed(), null, false);
                this.addAlter(stringBuffer, "INITIAL", oracleStorageProperties.getInitialExtent(), null, true);
                this.addAlter(stringBuffer, "NEXT", oracleStorageProperties.getNextExtent(), null, true);
                this.addAlter(stringBuffer, "MINEXTENTS", oracleStorageProperties.getMinExtent(), null, true);
                this.addAlter(stringBuffer, "MAXEXTENTS", oracleStorageProperties.getMaxExtent(), null, true);
                this.addAlter(stringBuffer, "PCTINCREASE", oracleStorageProperties.getPercentIncrease(), null, true);
                this.addAlter(stringBuffer, "FREELISTS", oracleStorageProperties.getFreelists(), null, true);
                this.addAlter(stringBuffer, "FREELIST GROUPS", oracleStorageProperties.getFreelistGroups(), null, true);
                this.addAlter(stringBuffer, "BUFFER_POOL", oracleStorageProperties.getBufferMode(), null, true);
                if (stringBuffer.indexOf("STORAGE") != -1) {
                    stringBuffer.append("\n)");
                }
            }
            if (bl != null) {
                if (bl == Boolean.TRUE) {
                    stringBuffer.append("\nCOMPRESS");
                } else {
                    stringBuffer.append("\nNOCOMPRESS");
                }
            }
            return stringBuffer.toString();
        }
    }

    private static final class RenameNewIPIfChangedTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "renameNewIPIfChanged";

        private RenameNewIPIfChangedTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof IndexPartition) {
                IndexPartition indexPartition = (IndexPartition)tokenContext.getObject();
                OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)indexPartition.getParent();
                Index index = (Index)DBUtil.findParentOfType((DBObject)indexPartition, Index.class);
                TablePartition tablePartition = LocalIndexPartitionHelper.getBaseTablePartition(indexPartition);
                if (tablePartition != null && !indexPartition.getName().equals(tablePartition.getName())) {
                    StringBuffer stringBuffer = new StringBuffer("ALTER INDEX ");
                    Schema schema = tokenContext.getDefaultSchema();
                    Schema schema2 = index.getSchema();
                    if (tokenContext.getOptions().isPrefixSchemaName() || schema != null && !DBUtil.areNamesAndTypesEqual((DBObject)schema, (DBObject)schema2)) {
                        stringBuffer.append(tokenContext.getExternalName(schema2.getName()));
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(tokenContext.getExternalName(index.getName()));
                    stringBuffer.append(" \nRENAME");
                    stringBuffer.append(oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION ? " SUBPARTITION " : " PARTITION ");
                    stringBuffer.append(tokenContext.getExternalName(tablePartition.getName()));
                    stringBuffer.append(" TO ");
                    stringBuffer.append(tokenContext.getExternalName(indexPartition.getName()));
                    tokenContext.append((Object)stringBuffer.toString());
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }
    }

    private static final class DBLinkHostExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hostExists";

        private DBLinkHostExistsTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof DatabaseLink) {
                DatabaseLink databaseLink = (DatabaseLink)tokenContext.getObject();
                String string = databaseLink.getHost();
                return string != null && !string.equals("");
            }
            return false;
        }
    }

    private static final class TrgNewAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refNewAsExists";

        private TrgNewAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)tokenContext.getObject();
                String string = trigger.getReferencingNewAs();
                return string != null && !string.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("referencingNewAs".toString());
        }
    }

    private static final class TrgOldAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refOldAsExists";

        private TrgOldAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)tokenContext.getObject();
                String string = trigger.getReferencingOldAs();
                return string != null && !string.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("referencingOldAs".toString());
        }
    }

    private static final class DropAndRecreateConTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needDropAndRecreateConstraint";

        private DropAndRecreateConTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Constraint) {
                Difference difference = tokenContext.getDifference();
                PropertyFilter propertyFilter = new PropertyFilter();
                propertyFilter.addFilterProp("enabled");
                propertyFilter.addFilterProp("indexID");
                propertyFilter.addFilterProp("name");
                propertyFilter.addFilterProp("indexID");
                Difference difference2 = difference.getFilteredDifference(new DifferenceFilter[]{propertyFilter});
                return !difference2.isSame();
            }
            return false;
        }
    }

    private static final class CodeExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "codeExists";

        private CodeExistsTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)tokenContext.getObject();
                String string = trigger.getCode();
                return string != null && !string.equals("");
            }
            return false;
        }
    }

    private static final class SyntaxFromSourceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getSyntaxFromSource";
        public static final String ALTER = "ALTER";

        private SyntaxFromSourceGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            String string;
            if (tokenContext.getObject() instanceof PlSqlSourceObject && ModelUtil.hasLength((String)(string = this.getSource(tokenContext)))) {
                PlSqlToken plSqlToken;
                PlSqlToken plSqlToken2;
                Object object;
                PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)tokenContext.getObject();
                String string2 = null;
                try {
                    object = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)tokenContext.getProvider());
                    if (object != null && (plSqlToken2 = object.getNameToken()) != null) {
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
                        int n = object.getEndOffsetOfObject();
                        plSqlToken = object.getTokenAtOffset(n);
                        string2 = plSqlToken2.getSource(false, (Token)plSqlToken);
                    }
                }
                catch (CancelledException cancelledException) {
                    DBLog.getLogger((Object)((Object)this)).warning("Parsing cancelled while building ddl. " + cancelledException.getMessage());
                    string2 = null;
                }
                if (string2 == null) {
                    object = PlSqlUtil.getTypeAndNameFromSource(string, tokenContext.getProvider().getDescriptor());
                    string2 = string.substring(((PlSqlUtil.TypeAndNameInfo)object).getNameEnd() + 1);
                }
                if (string2.startsWith(" ")) {
                    string2 = string2.substring(1);
                }
                if (tokenContext.getOptions().isPrefixSchemaName() && tokenContext.getObject() instanceof Trigger && ((object = (Trigger)tokenContext.getObject()).getBaseType() == Trigger.BaseType.TABLE || object.getBaseType() == Trigger.BaseType.VIEW) && (plSqlToken2 = new PlSqlSearch("on <baseObj ?.>")).isWithin(string2)) {
                    PlSqlToken plSqlToken3 = plSqlToken2.getNamedMatchStartToken("baseObj");
                    plSqlToken = plSqlToken2.getNamedMatchEndToken("baseObj");
                    if (plSqlToken3.getStart() == plSqlToken.getStart()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string2.substring(0, plSqlToken3.getStart()));
                        stringBuilder.append("\"");
                        stringBuilder.append(object.getSchema().getName());
                        stringBuilder.append("\".");
                        stringBuilder.append(string2.substring(plSqlToken3.getStart()));
                        string2 = stringBuilder.toString();
                    }
                }
                tokenContext.append((Object)string2);
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof PlSqlSourceObject) {
                String string = this.getSource(tokenContext);
                return string != null && !string.equals("");
            }
            return false;
        }

        private String getSource(TokenContext tokenContext) {
            String string = null;
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)tokenContext.getObject();
            string = plSqlSourceObject.getSource();
            return string;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("source");
        }
    }

    private static final class TriggerBaseObjectGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgBaseObject";

        private TriggerBaseObjectGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)tokenContext.getObject();
                DBObjectProvider dBObjectProvider = tokenContext.getProvider();
                tokenContext.append((Object)"ON ");
                if (trigger.getBaseType() == Trigger.BaseType.DATABASE) {
                    tokenContext.append((Object)"DATABASE");
                } else {
                    DBObjectID dBObjectID = trigger.getBaseObjectID();
                    String string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
                    if (trigger.getBaseType() == Trigger.BaseType.SCHEMA) {
                        tokenContext.append((Object)dBObjectProvider.getExternalName(string));
                        tokenContext.append((Object)".SCHEMA");
                    } else {
                        String string2;
                        String string3 = null;
                        if (dBObjectProvider instanceof Database) {
                            try {
                                string3 = ((Database)dBObjectProvider).getUserName();
                            }
                            catch (DBException dBException) {
                                string3 = null;
                            }
                        }
                        if (string3 == null) {
                            string3 = trigger.getSchema().getName();
                        }
                        if (ModelUtil.areDifferent((Object)string3, (Object)(string2 = DBUtil.getSchemaName((DBObjectID)dBObjectID)))) {
                            tokenContext.append((Object)dBObjectProvider.getExternalName(string2));
                            tokenContext.append((Object)".");
                        }
                        tokenContext.append((Object)dBObjectProvider.getExternalName(string));
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("baseObjectID");
        }
    }

    private static final class TriggerEventsListGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgEvents";

        private TriggerEventsListGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            Trigger trigger;
            boolean bl = true;
            if (tokenContext.getObject() instanceof Trigger && (trigger = (Trigger)tokenContext.getObject()).getEvents() != null && trigger.getEvents().length > 0) {
                for (String string : trigger.getEvents()) {
                    if (!bl) {
                        tokenContext.append((Object)" OR ");
                    }
                    tokenContext.append((Object)string);
                    DBObjectID[] dBObjectIDArray = trigger.getColumnIDs();
                    if ("UPDATE".equals(string) && dBObjectIDArray != null) {
                        for (int i = 0; i < dBObjectIDArray.length; ++i) {
                            tokenContext.append((Object)(i == 0 ? " OF " : ","));
                            tokenContext.append((Object)tokenContext.getProvider().getExternalName(DBUtil.getDBObjectName((DBObjectID)dBObjectIDArray[i])));
                        }
                    }
                    bl = false;
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("events".toString(), "columnIDs".toString());
        }
    }

    private static final class MatViewLogAddWithsGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "handleAddWiths";
        private Collection<String> m_props = new TreeSet<String>();

        private MatViewLogAddWithsGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof MaterializedViewLog) {
                HashSet<String> hashSet = new HashSet<String>();
                StringBuffer stringBuffer = new StringBuffer();
                String string = null;
                if (this.propHasChangedToValue(tokenContext, "objectIdLogged".toString(), true)) {
                    hashSet.add("OBJECT ID");
                }
                if (this.propHasChangedToValue(tokenContext, "primaryKeyLogged".toString(), true)) {
                    hashSet.add("PRIMARY KEY");
                }
                if (this.propHasChangedToValue(tokenContext, "rowidLogged".toString(), true)) {
                    hashSet.add("ROWID");
                }
                if (this.propHasChangedToValue(tokenContext, "sequenceLogged".toString(), true)) {
                    hashSet.add("SEQUENCE");
                }
                if (this.propHasChangedToValue(tokenContext, "newValues".toString(), true)) {
                    string = " INCLUDING NEW VALUES";
                } else if (this.propHasChangedToValue(tokenContext, "newValues".toString(), false)) {
                    string = " EXCLUDING NEW VALUES";
                }
                if (!hashSet.isEmpty() || stringBuffer.length() > 0 || string != null) {
                    boolean bl = false;
                    tokenContext.append((Object)"\nADD ");
                    for (String string2 : hashSet) {
                        if (bl) {
                            tokenContext.append((Object)", ");
                        }
                        tokenContext.append((Object)string2);
                        bl = true;
                    }
                    tokenContext.append((Object)stringBuffer);
                    if (string != null) {
                        tokenContext.append((Object)string);
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.createPropertyMap(this.m_props, null, null);
        }
    }

    private static final class MatViewLogWithsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleWiths";
        private Collection<String> m_props = null;

        private MatViewLogWithsGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof MaterializedViewLog) {
                boolean bl;
                DBObjectID[] dBObjectIDArray;
                MaterializedViewLog materializedViewLog = (MaterializedViewLog)tokenContext.getObject();
                HashSet<String> hashSet = new HashSet<String>();
                StringBuffer stringBuffer = new StringBuffer();
                if (Boolean.TRUE.equals(materializedViewLog.getObjectIdLogged())) {
                    hashSet.add("OBJECT ID");
                }
                if (Boolean.TRUE.equals(materializedViewLog.getPrimaryKeyLogged())) {
                    hashSet.add("PRIMARY KEY");
                }
                if (Boolean.TRUE.equals(materializedViewLog.getRowidLogged())) {
                    hashSet.add("ROWID");
                }
                if (Boolean.TRUE.equals(materializedViewLog.getSequenceLogged())) {
                    hashSet.add("SEQUENCE");
                }
                if ((dBObjectIDArray = materializedViewLog.getColumnIDs()) != null && dBObjectIDArray.length > 0) {
                    stringBuffer.append("(");
                    bl = false;
                    for (int i = 0; i < dBObjectIDArray.length; ++i) {
                        String string = dBObjectIDArray[i];
                        String string2 = DBUtil.getDBObjectName((DBObjectID)string);
                        if (bl) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(string2);
                        bl = true;
                    }
                    stringBuffer.append(")");
                }
                if (!hashSet.isEmpty() || stringBuffer.length() > 0) {
                    bl = false;
                    tokenContext.append((Object)"\nWITH ");
                    for (String string : hashSet) {
                        if (bl) {
                            tokenContext.append((Object)", ");
                        }
                        tokenContext.append((Object)string);
                        bl = true;
                    }
                    tokenContext.append((Object)stringBuffer);
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.m_props;
        }
    }

    private static final class PartitionValuesChangedTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "changedValues";

        private PartitionValuesChangedTokenGenerator() {
        }

        private boolean valuesHaveChanged(TokenContext tokenContext) {
            PropertyHelper propertyHelper = new PropertyHelper();
            Difference difference = tokenContext.getDifference();
            Object object = propertyHelper.getPropertyValue(tokenContext.getObject(), "values");
            Object object2 = propertyHelper.getPropertyValue(difference.getOriginalObject(), "values");
            if (object != null && object2 != null) {
                return !object.equals(object2);
            }
            return object2 == null && object != null || object2 != null && object == null;
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return this.valuesHaveChanged(tokenContext);
        }
    }

    private static final class PasswordGenerator
    extends TokenGenerator {
        public static final String TOKEN = "password";
        public static final String TOKEN2 = "authentificationPassword";
        private final String m_key;

        public PasswordGenerator(String string) {
            this.m_key = string;
        }

        public void generateToken(TokenContext tokenContext) {
            String string;
            String string2;
            DatabaseLink databaseLink = (DatabaseLink)tokenContext.getObject();
            if (TOKEN.equals(this.m_key)) {
                string2 = databaseLink.getUsername();
                string = databaseLink.getPassword();
            } else {
                string2 = databaseLink.getAuthentificationUsername();
                string = databaseLink.getAuthentificationPassword();
            }
            if (ModelUtil.hasLength((String)string)) {
                tokenContext.append((Object)string);
            } else if (tokenContext.getProvider() instanceof Database) {
                tokenContext.append((Object)"\"***\"");
            } else {
                StringBuilder stringBuilder = new StringBuilder("&");
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("_");
                }
                stringBuilder.append("PASSWORD");
                tokenContext.append((Object)stringBuilder.toString().toUpperCase().replace(" ", "_"));
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList(TOKEN, TOKEN2);
        }
    }

    private static final class RefreshDateExpressionsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refreshDateExpressions";

        private RefreshDateExpressionsGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof MaterializedView) {
                MaterializedView materializedView = (MaterializedView)tokenContext.getObject();
                StringBuilder stringBuilder = new StringBuilder();
                if (ModelUtil.hasLength((String)materializedView.getFirstRefresh())) {
                    stringBuilder.append("START WITH ");
                    stringBuilder.append(materializedView.getFirstRefresh());
                    stringBuilder.append(" ");
                }
                if (ModelUtil.hasLength((String)materializedView.getInterval())) {
                    stringBuilder.append("NEXT ");
                    stringBuilder.append(materializedView.getInterval());
                    stringBuilder.append(" ");
                }
                tokenContext.append((Object)stringBuilder.toString());
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("firstRefresh", "interval", "lastRefreshDate", "lastRefreshType", "nextRefreshDate", "staleness");
        }
    }

    private static final class MVConstraintsNeedsUsingTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "mvConstraintsNeedsUsing";

        private MVConstraintsNeedsUsingTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof MaterializedView) {
                boolean bl;
                MaterializedView materializedView = (MaterializedView)tokenContext.getObject();
                boolean bl2 = bl = tokenContext.getDifference() == null || tokenContext.getDifference().getOriginalObject() == null;
                if (bl && (materializedView.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL || materializedView.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.MASTER)) {
                    return false;
                }
                if (!bl && (this.propHasChanged(tokenContext, "rollbackSegmentType") || this.propHasChanged(tokenContext, "rollbackSegmentName"))) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class NeedsRebuildIndexesModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needsRebuildIndexes";

        private NeedsRebuildIndexesModTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"segmentAttributes", "logging"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"segmentAttributes", "initrans"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"segmentAttributes", "bufferMode"})) || this.propHasChanged(tokenContext, "percentFree") || this.propHasChanged(tokenContext, "percentUsed") || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}));
        }
    }

    private static final class NeedIndexPartitionModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needIPMod";

        private NeedIndexPartitionModTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return this.propHasChanged(tokenContext, "segmentAttributes/logging") || this.propHasChanged(tokenContext, "segmentAttributes/initrans") || this.propHasChanged(tokenContext, "segmentAttributes/initialExtent") || this.propHasChanged(tokenContext, "segmentAttributes/nextExtent") || this.propHasChanged(tokenContext, "segmentAttributes/minExtent") || this.propHasChanged(tokenContext, "segmentAttributes/maxExtent") || this.propHasChanged(tokenContext, "segmentAttributes/percentIncrease") || this.propHasChanged(tokenContext, "segmentAttributes/freelists") || this.propHasChanged(tokenContext, "useKeyCompression") || this.propHasChanged(tokenContext, "segmentAttributes/freelistGroups");
        }
    }

    private static final class NeedOSPMoveTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPMove";
        private TreeSet<String> m_props;

        private NeedOSPMoveTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            boolean bl;
            boolean bl2 = bl = this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "tablespaceID"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "initialExtent"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "nextExtent"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "maxExtent"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "percentIncrease"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "freelists"})) || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "freelistGroups"}));
            if (tokenContext.getObject() instanceof Table) {
                PropertyHelper propertyHelper = new PropertyHelper();
                Object object = propertyHelper.getPropertyValue(tokenContext.getObject(), "TableType");
                return bl || this.propHasChanged(tokenContext, Property.createPath((String[])new String[]{"OracleStorageProperties", "percentFree"})) && object.toString().equals(Table.TableType.INDEX_ORGANIZED);
            }
            return bl;
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            if (this.m_props == null) {
                this.m_props = new TreeSet();
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "initialExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "nextExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "maxExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "percentIncrease"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "freelists"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "freelistGroups"}));
            }
            return this.createPropertyMap(this.m_props, null, null);
        }
    }

    private static final class NeedOSPAlterTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPAlter";

        private NeedOSPAlterTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Table) {
                PropertyHelper propertyHelper = new PropertyHelper();
                Object object = propertyHelper.getPropertyValue(tokenContext.getObject(), "TableType");
                return this.propHasChanged(tokenContext, "OracleStorageProperties/logging") || this.propHasChanged(tokenContext, "OracleStorageProperties/percentUsed") || this.propHasChanged(tokenContext, "OracleStorageProperties/initrans") || this.propHasChanged(tokenContext, "OracleStorageProperties/maxtrans") || this.propHasChanged(tokenContext, "OracleStorageProperties/bufferMode") || this.propHasChanged(tokenContext, "OracleStorageProperties/percentFree") && !object.toString().equals("INDEX_ORGANIZED");
            }
            if (tokenContext.getObject() instanceof Index && ((Index)tokenContext.getObject()).getIndexType() != Index.IndexType.DOMAIN) {
                return this.propHasChanged(tokenContext, "OracleStorageProperties/logging") || this.propHasChanged(tokenContext, "OracleStorageProperties/percentUsed") || this.propHasChanged(tokenContext, "OracleStorageProperties/initrans") || this.propHasChanged(tokenContext, "OracleStorageProperties/maxtrans") || this.propHasChanged(tokenContext, "OracleStorageProperties/bufferMode") || this.propHasChanged(tokenContext, "OracleStorageProperties/percentFree");
            }
            return false;
        }
    }

    private static final class HasPartitionsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hasPartitions";

        private HasPartitionsGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Table) {
                OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)tokenContext.getObject()).getProperty("OracleTablePartitions");
                return oracleTablePartitions != null && oracleTablePartitions.getPartitions().length > 0;
            }
            return false;
        }
    }

    private static final class HasTablespacesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hastablespaces";

        private HasTablespacesGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof OracleTablePartitions) {
                OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)tokenContext.getObject();
                return oracleTablePartitions != null && oracleTablePartitions.getHashQuantityTablespaceIds().length > 0;
            }
            return false;
        }
    }

    private static final class IsLOBColumnGenerator
    extends TokenGenerator {
        public static final String TOKEN = "islobcol";

        private IsLOBColumnGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            boolean bl = false;
            Object object = tokenContext.getObject();
            if (object instanceof LOBDescriptor) {
                DBObjectID[] dBObjectIDArray;
                for (DBObjectID dBObjectID : dBObjectIDArray = ((LOBDescriptor)object).getColumns()) {
                    if (!LOBDescriptor.isLOBColumn((DBObjectID)dBObjectID, (DBObject)((LOBDescriptor)object))) continue;
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static final class PartitionAlterMoveLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "altermovelobcoldef";

        private PartitionAlterMoveLOBGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof LOBDescriptor) {
                DBObjectID[] dBObjectIDArray;
                LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
                for (DBObjectID dBObjectID : dBObjectIDArray = lOBDescriptor.getColumns()) {
                    this.addLOBDefinition(tokenContext, null, !LOBDescriptor.isLOBColumn((DBObjectID)dBObjectID, (DBObject)lOBDescriptor), false, DBUtil.getDBObjectName((DBObjectID)dBObjectID));
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
            DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
            return dBObjectIDArray != null && dBObjectIDArray.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("columns");
        }
    }

    private static final class PartitionAlterLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "alterlobcoldef";

        private PartitionAlterLOBGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof LOBDescriptor) {
                DBObjectID[] dBObjectIDArray;
                LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
                for (DBObjectID dBObjectID : dBObjectIDArray = lOBDescriptor.getColumns()) {
                    this.alterLOBDefinition(tokenContext, DBUtil.getDBObjectName((DBObjectID)dBObjectID), null, !LOBDescriptor.isLOBColumn((DBObjectID)dBObjectID, (DBObject)lOBDescriptor), false);
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
            DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
            return dBObjectIDArray != null && dBObjectIDArray.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("columns");
        }
    }

    private static final class PartitionLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobcoldef";

        private PartitionLOBGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof LOBDescriptor) {
                LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
                DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
                boolean bl = false;
                String[] stringArray = new String[dBObjectIDArray.length];
                for (int i = 0; i < dBObjectIDArray.length; ++i) {
                    stringArray[i] = DBUtil.getDBObjectName((DBObjectID)dBObjectIDArray[i]);
                    if (bl || LOBDescriptor.isLOBColumn((DBObjectID)dBObjectIDArray[i], (DBObject)lOBDescriptor)) continue;
                    bl = true;
                }
                this.addLOBDefinition(tokenContext, lOBDescriptor.getLOBSegName(), bl, true, stringArray);
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            LOBDescriptor lOBDescriptor = (LOBDescriptor)tokenContext.getObject();
            DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
            return dBObjectIDArray != null && dBObjectIDArray.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("LOBSegName", "columns");
        }
    }

    private static final class LOBDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobdef";

        private LOBDefinitionGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            OracleColumnProperties oracleColumnProperties;
            LOBDescriptor lOBDescriptor;
            DBObjectID[] dBObjectIDArray;
            if (tokenContext.getObject() instanceof OracleColumnProperties && ((dBObjectIDArray = (lOBDescriptor = (oracleColumnProperties = (OracleColumnProperties)tokenContext.getObject()).getLOBProperties()).getColumns()) == null || dBObjectIDArray.length == 0)) {
                this.addLOBDefinition(tokenContext, lOBDescriptor.getLOBSegName(), false, false, oracleColumnProperties.getParent().getName());
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("LOBProperties".toString());
        }
    }

    private static final class VarrayDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "varraydef";

        private VarrayDefinitionGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            OracleColumnProperties oracleColumnProperties;
            LOBDescriptor lOBDescriptor;
            DBObjectID[] dBObjectIDArray;
            if (tokenContext.getObject() instanceof OracleColumnProperties && ((dBObjectIDArray = (lOBDescriptor = (oracleColumnProperties = (OracleColumnProperties)tokenContext.getObject()).getVAProperties()).getColumns()) == null || dBObjectIDArray.length == 0)) {
                this.addLOBDefinition(tokenContext, lOBDescriptor.getLOBSegName(), true, false, oracleColumnProperties.getParent().getName());
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("VAProperties".toString());
        }
    }

    private static abstract class AlterTokenGenerator
    extends TokenGenerator {
        private AlterTokenGenerator() {
        }

        protected boolean propHasChanged(TokenContext tokenContext, String string) {
            Difference difference = null;
            try {
                PropertyHelper propertyHelper = new PropertyHelper();
                Difference difference2 = tokenContext.getDifference();
                if (difference2 == null) {
                    return false;
                }
                difference = propertyHelper.getChildDifference(difference2, string, true);
            }
            catch (MissingPropertyException missingPropertyException) {
                DBLog.getLogger((Object)((Object)this)).log(Level.FINER, missingPropertyException.getMessage());
            }
            return difference != null;
        }

        protected boolean propHasChangedToValue(TokenContext tokenContext, String string, Object object) {
            PropertyHelper propertyHelper = new PropertyHelper();
            Difference difference = tokenContext.getDifference();
            Object object2 = propertyHelper.getPropertyValue(difference.getUpdatedObject(), string);
            return this.propHasChanged(tokenContext, string) && object2.equals(object);
        }
    }

    private static abstract class LOBTokenGenerator
    extends TokenGenerator {
        private LOBTokenGenerator() {
        }

        void addLOBDefinition(TokenContext tokenContext, String string, boolean bl, boolean bl2, String ... stringArray) {
            if (bl) {
                tokenContext.append((Object)"\n");
                if (bl2) {
                    tokenContext.append((Object)"  ");
                }
                tokenContext.append((Object)"VARRAY ");
            } else {
                tokenContext.append((Object)"\n");
                if (bl2) {
                    tokenContext.append((Object)"  ");
                }
                tokenContext.append((Object)"LOB (");
            }
            boolean bl3 = true;
            for (String string2 : stringArray) {
                if (!bl3) {
                    tokenContext.append((Object)", ");
                }
                bl3 = false;
                tokenContext.append((Object)tokenContext.getExternalName(string2));
            }
            if (!bl) {
                tokenContext.append((Object)")");
            }
            tokenContext.append((Object)" STORE AS ");
            if (bl) {
                tokenContext.append((Object)"LOB ");
            }
            if (string != null) {
                tokenContext.append((Object)tokenContext.getExternalName(string));
            }
        }

        void alterLOBDefinition(TokenContext tokenContext, String string, String string2, boolean bl, boolean bl2) {
            if (bl) {
                tokenContext.append((Object)"\n");
                if (bl2) {
                    tokenContext.append((Object)"  ");
                }
                tokenContext.append((Object)"VARRAY ");
            } else {
                tokenContext.append((Object)"\n");
                if (bl2) {
                    tokenContext.append((Object)"  ");
                }
                tokenContext.append((Object)"LOB (");
            }
            tokenContext.append((Object)tokenContext.getExternalName(string));
            if (!bl) {
                tokenContext.append((Object)")");
            } else {
                tokenContext.append((Object)" STORE AS LOB ");
            }
        }
    }
}

