/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.property.Property;

public abstract class OMBStoragePropsBuilder<T extends DBObject>
extends OMBPropsStatementBuilder<T> {
    private final String m_base;

    OMBStoragePropsBuilder(T t, String string) {
        super(t);
        this.m_base = string;
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping(this.createFullPath("bufferMode"), "BUFFER_POOL");
        this.registerPropertyMapping(this.createFullPath("freelistGroups"), "FREELISTGROUPS");
        this.registerPropertyMapping(this.createFullPath("freelists"), "FREELISTS");
        this.registerPropertyMapping(this.createFullPath("initialExtent"), "INITIAL");
        this.registerPropertyMapping(this.createFullPath("initrans"), "INITRANS");
        this.registerPropertyMapping(this.createFullPath("maxtrans"), "MAXTRANS");
        this.registerPropertyMapping(this.createFullPath("logging"), "LOGGING_MODE");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("true", "LOGGING");
        hashMap.put("false", "NOLOGGING");
        this.registerSubstitutionValues("LOGGING_MODE", (HashMap)hashMap);
        this.registerPropertyMapping(this.createFullPath("maxExtent"), "MAXEXTENTS");
        this.registerPropertyMapping(this.createFullPath("minExtent"), "MINEXTENTS");
        this.registerPropertyMapping(this.createFullPath("nextExtent"), "NEXT");
        this.registerPropertyMapping(this.createFullPath("percentFree"), "PCTFREE");
        this.registerPropertyMapping(this.createFullPath("percentUsed"), "PCTUSED");
        this.registerPropertyMapping(this.createFullPath("percentIncrease"), "PCTINCREASE");
        String string = this.createFullPath("tablespaceID", "name");
        this.registerPropertyMapping(string, "TABLESPACE");
    }

    private String createFullPath(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.m_base);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return Property.createPath((String[])arrayList.toArray(new String[arrayList.size()]));
    }
}

