/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class DataMiningFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        DataMiningFunction dataMiningFunction = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "data_mining_function")) {
            SQLFragment sQLFragment;
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            String string = null;
            if (oracleSQLQueryBuilderHelper.isLeaf(list.get(0))) {
                string = oracleSQLQueryBuilderHelper.getContent(list.get(0));
            }
            if (string == null) {
                expressionContext.getQueryBuilder().throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{string})));
            }
            string = string.toUpperCase();
            int n = 2;
            String string2 = null;
            if (oracleSQLQueryBuilderHelper.isLeaf(list.get(n))) {
                string2 = oracleSQLQueryBuilderHelper.getContent(list.get(n));
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(++n), ".") && oracleSQLQueryBuilderHelper.isLeaf(list.get(++n))) {
                    string2 = string2 + "." + oracleSQLQueryBuilderHelper.getContent(list.get(n));
                    ++n;
                }
            }
            ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
            while (!oracleSQLQueryBuilderHelper.isRule(list.get(n), "cost_matrix_clause") && !oracleSQLQueryBuilderHelper.isRule(list.get(n), "mining_attribute_clause")) {
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), ",")) {
                    ++n;
                    continue;
                }
                sQLFragment = null;
                if (oracleSQLQueryBuilderHelper.isLeaf(list.get(n))) {
                    String string3 = oracleSQLQueryBuilderHelper.getContent(list.get(n));
                    sQLFragment = new SimpleSQLFragment(string3);
                } else {
                    sQLFragment = expressionContext.createFragment(list.get(n), expressionContext.getCreating());
                }
                arrayList.add(sQLFragment);
                ++n;
            }
            sQLFragment = null;
            boolean bl = false;
            if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "cost_matrix_clause")) {
                bl = true;
                sQLFragment = this.getCost(list.get(n), expressionContext);
                ++n;
            }
            SQLFragment[] sQLFragmentArray = null;
            if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "mining_attribute_clause")) {
                sQLFragmentArray = this.getMiningAttributes(string, list.get(n), expressionContext);
                ++n;
            }
            dataMiningFunction = new DataMiningFunction(string, (SQLFragment)new SimpleSQLFragment(string2), (SQLFragment[])sQLFragment, arrayList.toArray(new SQLFragment[arrayList.size()]), sQLFragmentArray);
        }
        return dataMiningFunction;
    }

    private SQLFragment[] getCost(ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        SQLFragment[] sQLFragmentArray = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        boolean bl = true;
        if (list.size() == 2 && oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "MODEL")) {
            sQLFragmentArray = new SQLFragment[]{new SimpleSQLFragment("MODEL")};
        } else if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "MODEL") && oracleSQLQueryBuilderHelper.isKeyword(list.get(2), "AUTO")) {
            sQLFragmentArray = new SQLFragment[]{new SimpleSQLFragment("AUTO")};
        } else {
            int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, ")");
            SQLFragment[] sQLFragmentArray2 = expressionContext.getArgList(null, list, 2, n);
            DataMiningFunction.DataMiningCostValues dataMiningCostValues = new DataMiningFunction.DataMiningCostValues(sQLFragmentArray2);
            ArrayList<DataMiningFunction.DataMiningCostValues> arrayList = new ArrayList<DataMiningFunction.DataMiningCostValues>();
            arrayList.add(dataMiningCostValues);
            int n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "VALUES") + 2;
            while (n2 != -1) {
                n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, n2, ")");
                SQLFragment[] sQLFragmentArray3 = expressionContext.getArgList(null, list, n2 + 1, n);
                dataMiningCostValues = new DataMiningFunction.DataMiningCostValues(sQLFragmentArray3);
                arrayList.add(dataMiningCostValues);
                n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, n, "(");
            }
            sQLFragmentArray = (SQLFragment[])arrayList.toArray(new DataMiningFunction.DataMiningCostValues[arrayList.size()]);
        }
        return sQLFragmentArray;
    }

    private SQLFragment[] getMiningAttributes(Object object, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        List<ParseNode> list = expressionContext.getHelper().getOrderedChildren(parseNode);
        SQLFragment[] sQLFragmentArray = expressionContext.getArgList(object, list, 1, list.size());
        return sQLFragmentArray;
    }
}

