/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;

public class SqlUsageUtil
implements SqlAliasExpander {
    private static final String RULE_TABLE_REFERENCE = "table_reference";
    private static final String RULE_INSERT_INTO_CLAUSE = "insert_into_clause";
    private static final String RULE_UPDATE = "update";
    private static final String RULE_UPDATE_SET_CLAUSE = "update_set_clause";
    private static final String ONLY = "only";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    static final String[] RESERVED_WORDS = new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    private OracleSQLQueryBuilderHelper m_helper;
    private String m_schema;

    public SQLUsage[] getUsages(String string, String string2) {
        return this.getUsagesImpl(string, string2, 0);
    }

    public SQLUsage[] getUsagesImpl(String string, String string2, int n) {
        this.m_schema = string2;
        ArrayList<SQLUsage> arrayList = new ArrayList<SQLUsage>();
        HashMap<String, BaseObjectID> hashMap = new HashMap<String, BaseObjectID>();
        this.m_helper = OracleSQLQueryBuilderHelper.getHelper(string);
        ParseNode parseNode = this.m_helper.getRaptorRoot();
        this.getKidsUsages(parseNode, arrayList, hashMap);
        this.replaceTableAliases(arrayList, hashMap);
        SQLUsage[] sQLUsageArray = arrayList.toArray(new SQLUsage[arrayList.size()]);
        if (n != 0) {
            for (SQLUsage sQLUsage : sQLUsageArray) {
                sQLUsage.m_startOffset = sQLUsage.m_startOffset + n;
                sQLUsage.m_endOffset = sQLUsage.m_endOffset + n;
            }
        }
        return sQLUsageArray;
    }

    private void getKidsUsages(ParseNode parseNode, List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!this.m_helper.isRule(parseNode, RULE_INSERT_INTO_CLAUSE)) break block6;
                        this.processInsertIntoClause(parseNode, list, hashMap);
                        break block7;
                    }
                    if (!this.m_helper.isRule(parseNode, RULE_UPDATE)) break block8;
                    this.processUpdate(parseNode, list, hashMap);
                    break block7;
                }
                if (!this.m_helper.isLeaf(parseNode)) break block9;
                String string = this.m_helper.getContent(parseNode);
                Character c = Character.valueOf(string.charAt(0));
                if ((!Character.isLetter(c.charValue()) || this.m_helper.isKeyword(parseNode, RESERVED_WORDS)) && '\"' != c.charValue()) break block7;
                DBObjectID dBObjectID = this.addUsage(list, parseNode, null);
                break block7;
            }
            if (this.m_helper.isRule(parseNode, RULE_TABLE_REFERENCE)) {
                this.processTableReference(parseNode, list, hashMap);
            } else {
                List<ParseNode> list2 = this.m_helper.getOrderedChildren(parseNode);
                if (this.m_helper.isDotSeperatedList(list2)) {
                    List<ParseNode> list3 = this.m_helper.getDotSeparatedList(list2);
                    DBObjectID dBObjectID = null;
                    for (ParseNode parseNode2 : list3) {
                        dBObjectID = this.addUsage(list, parseNode2, dBObjectID);
                    }
                } else {
                    for (ParseNode parseNode3 : list2) {
                        this.getKidsUsages(parseNode3, list, hashMap);
                    }
                }
            }
        }
    }

    private void processTableReference(ParseNode parseNode, List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        ParseNode parseNode2 = null;
        List<ParseNode> list2 = this.m_helper.getOrderedChildren(parseNode);
        if (list2.size() == 2 && this.m_helper.isLeaf(list2.get(1))) {
            parseNode2 = list2.get(1);
        }
        ParseNode parseNode3 = list2.get(0);
        this.processTableAndAlias(parseNode3, parseNode2, list, hashMap);
    }

    private DBObjectID processTableAndAlias(ParseNode parseNode, ParseNode parseNode2, List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        String string = null;
        BaseObjectID baseObjectID = null;
        if (parseNode2 != null && this.m_helper.isLeaf(parseNode2)) {
            string = this.m_helper.getContent(parseNode2);
        }
        if (this.m_helper.isLeaf(parseNode)) {
            baseObjectID = (BaseObjectID)this.addUsage(list, parseNode, null);
            if (string != null) {
                hashMap.put(string, baseObjectID);
            }
        } else {
            ArrayList<SQLUsage> arrayList = new ArrayList<SQLUsage>();
            HashMap<String, BaseObjectID> hashMap2 = new HashMap<String, BaseObjectID>();
            this.getKidsUsages(parseNode, arrayList, hashMap2);
            this.replaceTableAliases(arrayList, hashMap2);
            for (SQLUsage sQLUsage : arrayList) {
                list.add(sQLUsage);
            }
        }
        return baseObjectID;
    }

    private void replaceTableAliases(List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        for (SQLUsage sQLUsage : list) {
            if (sQLUsage.isAliasDone()) continue;
            BaseObjectID baseObjectID = (BaseObjectID)sQLUsage.getDbObjectID();
            BaseObjectID baseObjectID2 = this.getSecondParent(sQLUsage);
            String string = baseObjectID2 == null ? null : this.getOldestParentName((DBObjectID)baseObjectID2);
            if (string == null || !hashMap.containsKey(string)) continue;
            BaseObjectID baseObjectID3 = hashMap.get(string);
            if (string.equalsIgnoreCase(baseObjectID.getName())) {
                sQLUsage.setDbObjectID((DBObjectID)baseObjectID3);
            } else {
                baseObjectID2.setParent((DBObjectID)baseObjectID3);
            }
            sQLUsage.setAliasDone(true);
        }
    }

    private BaseObjectID getSecondParent(SQLUsage sQLUsage) {
        DBObjectID dBObjectID;
        for (DBObjectID dBObjectID2 = dBObjectID = sQLUsage.getDbObjectID(); dBObjectID2 != null && dBObjectID2.getParent() != null; dBObjectID2 = dBObjectID2.getParent()) {
            dBObjectID = dBObjectID2;
        }
        return (BaseObjectID)dBObjectID;
    }

    private String getOldestParentName(DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = dBObjectID;
        while (dBObjectID2.getParent() != null) {
            dBObjectID2 = dBObjectID2.getParent();
        }
        return ((BaseObjectID)dBObjectID2).getName();
    }

    private DBObjectID addUsage(List<SQLUsage> list, ParseNode parseNode, DBObjectID dBObjectID) {
        String string = this.m_helper.getContent(parseNode);
        int n = this.m_helper.getNodeStartOffset(parseNode);
        int n2 = this.m_helper.getNodeEndOffset(parseNode);
        ReferenceID referenceID = null;
        referenceID = dBObjectID == null ? new ReferenceID("UNSPECIFIED_TYPE", this.m_schema, string) : new ReferenceID("UNSPECIFIED_TYPE", dBObjectID, string, null, null);
        SQLUsage sQLUsage = new SQLUsage(n, n2, (DBObjectID)referenceID);
        list.add(sQLUsage);
        return referenceID;
    }

    private void processInsertIntoClause(ParseNode parseNode, List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        List<ParseNode> list2 = this.m_helper.getOrderedChildren(parseNode);
        ParseNode parseNode2 = list2.get(1);
        ParseNode parseNode3 = null;
        int n = 2;
        if (list2.size() > 2 && this.m_helper.isLeaf(list2.get(2)) && !this.m_helper.isKeyword(list2.get(2), LEFT_PAREN)) {
            parseNode3 = list2.get(2);
            n = 3;
        }
        DBObjectID dBObjectID = this.processTableAndAlias(parseNode2, parseNode3, list, hashMap);
        if (list2.size() > n && this.m_helper.isKeyword(list2.get(n), LEFT_PAREN) && this.m_helper.isKeyword(list2.get(list2.size() - 1), RIGHT_PAREN)) {
            int n2 = this.m_helper.getKeywordIndex(list2, LEFT_PAREN);
            List<ParseNode> list3 = list2.subList(n + 1, list2.size() - 1);
            List<List<ParseNode>> list4 = this.m_helper.getCommaSeparatedList(list3);
            for (List<ParseNode> list5 : list4) {
                this.addUsage(list, list5.get(0), dBObjectID);
            }
        }
    }

    private void processUpdate(ParseNode parseNode, List<SQLUsage> list, HashMap<String, BaseObjectID> hashMap) {
        List<ParseNode> list2 = this.m_helper.getOrderedChildren(parseNode);
        ParseNode parseNode2 = null;
        int n = 1;
        if (this.m_helper.isKeyword(list2.get(n), ONLY)) {
            parseNode2 = list2.get(n + 2);
            n += 4;
        } else {
            parseNode2 = list2.get(n);
            ++n;
        }
        if (this.m_helper.isLeaf(list2.get(n))) {
            ParseNode parseNode3 = list2.get(n);
            this.processTableAndAlias(parseNode2, parseNode3, list, hashMap);
            ++n;
        }
        while (n < list2.size()) {
            this.getKidsUsages(list2.get(n), list, hashMap);
            ++n;
        }
    }

    public Collection<SqlAliasExpander.Usage> getUsages(String string) {
        SQLUsage[] sQLUsageArray;
        ArrayList<SqlAliasExpander.Usage> arrayList = new ArrayList<SqlAliasExpander.Usage>();
        for (SQLUsage sQLUsage : sQLUsageArray = this.getUsagesImpl(string, null, 0)) {
            arrayList.add(sQLUsage);
        }
        return arrayList;
    }

    public Collection<SqlAliasExpander.Usage> getUsages(PlSqlToken plSqlToken, PlSqlToken plSqlToken2) {
        SQLUsage[] sQLUsageArray;
        String string = plSqlToken.getSource(false, (Token)plSqlToken2);
        ArrayList<SqlAliasExpander.Usage> arrayList = new ArrayList<SqlAliasExpander.Usage>();
        for (SQLUsage sQLUsage : sQLUsageArray = this.getUsagesImpl(string, null, plSqlToken.getStart())) {
            arrayList.add(sQLUsage);
        }
        return arrayList;
    }

    public void print(ParseNode parseNode, String string) {
        if (this.m_helper == null) {
            System.out.println("No usage statement to print");
            return;
        }
        if (parseNode == null) {
            parseNode = this.m_helper.getRaptorRoot();
            if (parseNode.topLevel != null) {
                System.out.println("\nThere were parse errors!\ntopLevel set size = " + parseNode.topLevel.size());
            }
            System.out.println("\n");
        }
        this.m_helper.print(parseNode, 0, "0", new PrintWriter(System.out, true));
    }

    public static class SQLUsage
    implements SqlAliasExpander.Usage {
        private boolean m_aliasDone;
        private int m_startOffset;
        private int m_endOffset;
        private DBObjectID m_dbObjectID;

        public SQLUsage() {
        }

        private SQLUsage(int n, int n2, DBObjectID dBObjectID) {
            this.m_startOffset = n;
            this.m_endOffset = n2;
            this.m_dbObjectID = dBObjectID;
        }

        public void setStartOffset(int n) {
            this.m_startOffset = n;
        }

        public int getStartOffset() {
            return this.m_startOffset;
        }

        public void setDbObjectID(DBObjectID dBObjectID) {
            this.m_dbObjectID = dBObjectID;
        }

        public DBObjectID getDbObjectID() {
            return this.m_dbObjectID;
        }

        public void setEndOffset(int n) {
            this.m_endOffset = n;
        }

        public int getEndOffset() {
            return this.m_endOffset;
        }

        private void setAliasDone(boolean bl) {
            this.m_aliasDone = bl;
        }

        private boolean isAliasDone() {
            return this.m_aliasDone;
        }

        public List<String> getTokens() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BaseObjectID baseObjectID = (BaseObjectID)this.m_dbObjectID; baseObjectID != null; baseObjectID = (BaseObjectID)baseObjectID.getParent()) {
                arrayList.add(0, baseObjectID.getName());
            }
            return arrayList;
        }
    }
}

