/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class IndexPartitionSXMLGenerator
extends SXMLFragmentGenerator {
    NameBasedID m_tableID = null;

    IndexPartitionSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        OracleIndexPartitions oracleIndexPartitions;
        DBObject dBObject = (DBObject)object;
        if (dBObject instanceof IndexPartition) {
            OracleIndexPartitions oracleIndexPartitions2 = ((IndexPartition)dBObject).getSubpartitions();
            if (oracleIndexPartitions2 != null) {
                this.createHashOrSubpartitionList(oracleIndexPartitions2, document, node, "SUBPARTITION_LIST", "TABLESPACE");
            }
        } else if (dBObject instanceof Index && (oracleIndexPartitions = (OracleIndexPartitions)dBObject.getProperty("OracleIndexPartitions")) != null) {
            OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
            this.findOrCreateNode(document, node, "TABLE_INDEX/INDEX_ATTRIBUTES");
            String string = partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING" : (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE ? "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING" : "TABLE_INDEX/LOCAL_PARTITIONING");
            Node node2 = this.findOrCreateNode(document, node, string);
            if (string.equals("TABLE_INDEX/LOCAL_PARTITIONING")) {
                if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                    this.createHashOrSubpartitionList(oracleIndexPartitions, document, node2, "PARTITION_LIST", "TABLESPACE");
                } else {
                    this.getParentGenerator().populateNode(node2, document, oracleIndexPartitions);
                }
            } else {
                this.processPropertyMapping(node2, document, oracleIndexPartitions, "COL_LIST//COL_LIST_ITEM/NAME", "globalPartitionColumns");
                if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                    Integer n = oracleIndexPartitions.getGlobalHashQuantity();
                    if (n != null && n > 0) {
                        Node node3 = this.findOrCreateNode(document, node2, "PARTITIONS_BY_QUANTITY/QUANTITY");
                        node3.appendChild(document.createTextNode(n.toString()));
                        String[] stringArray = oracleIndexPartitions.getTablespaces();
                        if (stringArray != null && stringArray.length > 0) {
                            Node node4 = this.findOrCreateNode(document, node2, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            for (int i = 0; i < stringArray.length; ++i) {
                                Node node5 = this.createNode(document, node4, "TABLESPACE");
                                node5.appendChild(document.createTextNode(stringArray[i]));
                            }
                        }
                    } else {
                        this.createHashOrSubpartitionList(oracleIndexPartitions, document, node2, "PARTITION_LIST", "TABLESPACE");
                    }
                } else {
                    this.getParentGenerator().populateNode(node2, document, oracleIndexPartitions);
                }
            }
        }
    }

    private void createHashOrSubpartitionList(OracleIndexPartitions oracleIndexPartitions, Document document, Node node, String string, String string2) {
        Node node2 = this.findOrCreateNode(document, node, string);
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        for (int i = 0; i < indexPartitionArray.length; ++i) {
            Node node3 = this.createNode(document, node2, string + "_ITEM");
            this.processPropertyMapping(node3, document, indexPartitionArray[i], "NAME", "name");
            this.processPropertyMapping(node3, document, indexPartitionArray[i], string2, "segmentAttributes/tablespaceID");
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        if (object instanceof IndexPartition) {
            if (this.nodeExists(node, "SUBPARTITION_LIST")) {
                OracleIndexPartitions oracleIndexPartitions = new OracleIndexPartitions();
                oracleIndexPartitions.setPartitionType(OracleIndexPartitions.PartitionType.SUBPARTITION);
                this.readHashOrSubpartitionList(oracleIndexPartitions, this.findNode(node, "SUBPARTITION_LIST"), "TABLESPACE");
                ((IndexPartition)object).setSubpartitions(oracleIndexPartitions);
            }
        } else if (object instanceof Index) {
            OracleIndexPartitions oracleIndexPartitions;
            Index index = (Index)object;
            OracleIndexPartitions.PartitionType partitionType = null;
            Node node2 = null;
            Node node3 = null;
            if (this.nodeExists(node, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING")) {
                partitionType = OracleIndexPartitions.PartitionType.GLOBAL_HASH;
                node2 = this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/COL_LIST");
                node3 = this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITION_LIST");
            } else if (this.nodeExists(node, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING")) {
                partitionType = OracleIndexPartitions.PartitionType.GLOBAL_RANGE;
                node2 = this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING/COL_LIST");
                node3 = this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING/PARTITION_LIST");
            } else if (this.nodeExists(node, "TABLE_INDEX/LOCAL_PARTITIONING")) {
                if (sXMLReader.getParentObject() != null && (oracleIndexPartitions = (OracleTablePartitions)sXMLReader.getParentObject().getProperty("OracleTablePartitions")) != null) {
                    if (oracleIndexPartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        partitionType = OracleIndexPartitions.PartitionType.LOCAL_HASH;
                    } else if (oracleIndexPartitions.getSubpartitionModel() != null) {
                        partitionType = OracleIndexPartitions.PartitionType.LOCAL_COMP;
                    }
                }
                if (partitionType == null) {
                    partitionType = OracleIndexPartitions.PartitionType.LOCAL_OTHER;
                }
                node3 = this.findNode(node, "TABLE_INDEX/LOCAL_PARTITIONING/PARTITION_LIST");
            }
            if (partitionType != null) {
                oracleIndexPartitions = new OracleIndexPartitions();
                index.setProperty("OracleIndexPartitions", (Object)oracleIndexPartitions);
                oracleIndexPartitions.setPartitionType(partitionType);
                if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                    sXMLReader.fillInObject(oracleIndexPartitions, this.findNode(node, "TABLE_INDEX/LOCAL_PARTITIONING"), null);
                } else if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                    this.readHashOrSubpartitionList(oracleIndexPartitions, node3, "TABLESPACE");
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    if (node2 != null) {
                        object4 = new SXMLFragmentGenerator.childXMLElementIterator(node2);
                        object3 = new ArrayList<NameBasedID>();
                        while (((SXMLFragmentGenerator.childXMLElementIterator)object4).hasNext()) {
                            object2 = ((SXMLFragmentGenerator.childXMLElementIterator)object4).next();
                            ((ArrayList)object3).add(this.getColID(node, this.nodeText((Node)object2, "NAME")));
                        }
                        oracleIndexPartitions.setGlobalPartitionColumns(((ArrayList)object3).toArray(new DBObjectID[((ArrayList)object3).size()]));
                    }
                    if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                        object4 = this.nodeText(node, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITIONS_BY_QUANTITY/QUANTITY");
                        if (object4 != null) {
                            oracleIndexPartitions.setGlobalHashQuantity(Integer.valueOf((String)object4));
                            object3 = this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/HASH_PARTITIONING/PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            if (object3 != null) {
                                object2 = new ArrayList();
                                SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator((Node)object3);
                                while (childXMLElementIterator2.hasNext()) {
                                    Node node4 = childXMLElementIterator2.next();
                                    if (!"TABLESPACE".equals(node4.getLocalName())) continue;
                                    ((ArrayList)object2).add(node4.getTextContent());
                                }
                                oracleIndexPartitions.setTablespaces(((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]));
                            }
                        } else {
                            this.readHashOrSubpartitionList(oracleIndexPartitions, node3, "TABLESPACE");
                        }
                    } else if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                        sXMLReader.fillInObject(oracleIndexPartitions, this.findNode(node, "TABLE_INDEX/GLOBAL_PARTITIONING/RANGE_PARTITIONING"), null);
                    }
                }
            }
        }
    }

    private void readHashOrSubpartitionList(OracleIndexPartitions oracleIndexPartitions, Node node, String string) {
        SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node);
        ArrayList<IndexPartition> arrayList = new ArrayList<IndexPartition>();
        while (childXMLElementIterator2.hasNext()) {
            Node node2 = childXMLElementIterator2.next();
            IndexPartition indexPartition = new IndexPartition(this.nodeText(node2, "NAME"), oracleIndexPartitions);
            String string2 = this.nodeText(node2, string);
            if (string2 != null) {
                OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
                NameBasedID nameBasedID = new NameBasedID("TABLESPACE", null, string2);
                oracleStorageProperties.setTablespaceID((DBObjectID)nameBasedID);
                indexPartition.setSegmentAttributes(oracleStorageProperties);
            }
            arrayList.add(indexPartition);
        }
        oracleIndexPartitions.setPartitions(arrayList.toArray(new IndexPartition[arrayList.size()]));
    }

    private NameBasedID getColID(Node node, String string) {
        if (this.m_tableID == null) {
            Node node2 = node;
            while (!"INDEX".equals(node.getLocalName())) {
                node2 = node2.getParentNode();
            }
            String string2 = this.nodeText(node2, "TABLE_INDEX/ON_TABLE/SCHEMA");
            String string3 = this.nodeText(node2, "TABLE_INDEX/ON_TABLE/NAME");
            this.m_tableID = new NameBasedID("TABLE", string2, string3);
        }
        return new NameBasedID("COLUMN", string, (DBObjectID)this.m_tableID);
    }
}

